/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.initialization;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.unidal.initialization.Module;
import org.unidal.initialization.ModuleContext;
import org.unidal.lookup.annotation.Named;

@Named(type=ModuleContext.class)
public class DefaultModuleContext
implements ModuleContext,
Contextualizable {
    private PlexusContainer m_container;
    private Map<String, Object> m_attributes = new HashMap<String, Object>();
    private Logger m_logger;

    public DefaultModuleContext() {
    }

    public DefaultModuleContext(PlexusContainer container) {
        this.m_container = container;
        this.setup();
    }

    public void contextualize(Context context) throws ContextException {
        this.m_container = (PlexusContainer)context.get((Object)"plexus");
        this.setup();
    }

    @Override
    public void error(String message) {
        this.m_logger.error(message);
    }

    @Override
    public void error(String message, Throwable e) {
        this.m_logger.error(message, e);
    }

    @Override
    public <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public <T> T getAttribute(String name, T defaultValue) {
        Object value = this.m_attributes.get(name);
        if (value != null) {
            return (T)value;
        }
        return defaultValue;
    }

    public PlexusContainer getContainer() {
        return this.m_container;
    }

    @Override
    public Module[] getModules(String ... names) {
        Module[] modules = new Module[names.length];
        int index = 0;
        for (String name : names) {
            modules[index++] = this.lookup(Module.class, name);
        }
        return modules;
    }

    @Override
    public void info(String message) {
        this.m_logger.info(message);
    }

    @Override
    public <T> T lookup(Class<T> role) {
        return this.lookup(role, null);
    }

    @Override
    public <T> T lookup(Class<T> role, String roleHint) {
        try {
            return (T)this.m_container.lookup(role, roleHint);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Unable to get component: " + role + ".", e);
        }
    }

    @Override
    public void release(Object component) {
        try {
            this.m_container.release(component);
        }
        catch (ComponentLifecycleException e) {
            throw new RuntimeException("Unable to release component: " + component + ".", e);
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.m_attributes.put(name, value);
    }

    private void setup() {
        try {
            LoggerManager loggerManager = (LoggerManager)this.m_container.lookup(LoggerManager.class);
            this.m_logger = loggerManager.getLoggerForComponent(PlexusContainer.class.getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get instance of Logger, please make sure the environment was setup correctly!", e);
        }
    }

    @Override
    public void warn(String message) {
        this.m_logger.warn(message);
    }
}

