/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.net.transport.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import org.codehaus.plexus.logging.Logger;
import org.unidal.lookup.logger.LoggerFactory;

public class ServerStateHandler
extends ChannelInboundHandlerAdapter
implements Cloneable {
    private Logger m_logger = LoggerFactory.getLogger(this.getClass());
    private String m_name;

    public ServerStateHandler(String name) {
        this.m_name = name;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        InetSocketAddress address = (InetSocketAddress)channel.remoteAddress();
        this.m_logger.info(String.format("%s client at %s:%s joined", this.m_name, address.getHostName(), address.getPort()));
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        InetSocketAddress address = (InetSocketAddress)channel.remoteAddress();
        this.m_logger.info(String.format("%s client at %s:%s left", this.m_name, address.getHostName(), address.getPort()));
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.channel().close();
        this.m_logger.error(cause.getMessage(), cause);
    }
}

