/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.zalando.logbook.BaseHttpRequest;
import org.zalando.logbook.ForwardingBaseHttpRequest;
import org.zalando.logbook.ForwardingRawHttpRequest;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.RawHttpRequest;

final class BodyReplacementRawHttpRequest
implements ForwardingRawHttpRequest {
    private final RawHttpRequest request;
    private final String replacement;

    public BodyReplacementRawHttpRequest(RawHttpRequest request, String replacement) {
        this.request = request;
        this.replacement = replacement;
    }

    public RawHttpRequest delegate() {
        return this.request;
    }

    public HttpRequest withBody() throws IOException {
        this.request.withoutBody();
        return new BodyReplacementHttpRequest(this.request, this.replacement);
    }

    private static final class BodyReplacementHttpRequest
    implements ForwardingBaseHttpRequest,
    HttpRequest {
        private final RawHttpRequest request;
        private final String body;

        public BodyReplacementHttpRequest(RawHttpRequest request, String body) {
            this.request = request;
            this.body = body;
        }

        public BaseHttpRequest delegate() {
            return this.request;
        }

        public byte[] getBody() throws IOException {
            return this.body.getBytes(StandardCharsets.UTF_8);
        }

        public String getBodyAsString() throws IOException {
            return this.body;
        }
    }
}

