/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PatternLike {
    PatternLike() {
    }

    static Predicate<String> compile(Pattern parser, String code, UnaryOperator<String> translator) {
        String pattern = PatternLike.toPattern(parser, code, translator);
        if (pattern.equals(code)) {
            return code::equals;
        }
        Pattern compile = Pattern.compile(pattern);
        return path -> compile.matcher((CharSequence)path).matches();
    }

    static String toPattern(Pattern parser, String code, String replacement) {
        return PatternLike.toPattern(parser, code, match -> replacement);
    }

    static String toPattern(Pattern parser, String code, UnaryOperator<String> translator) {
        Matcher matcher = parser.matcher(code);
        StringBuilder result = new StringBuilder();
        int end = 0;
        while (matcher.find()) {
            result.append(PatternLike.quote(code, end, matcher.start()));
            String match = matcher.group();
            result.append((String)translator.apply(match));
            end = matcher.end();
        }
        result.append(PatternLike.quote(code, end, code.length()));
        return result.toString();
    }

    private static String quote(String s, int start, int end) {
        if (start == end) {
            return "";
        }
        return Pattern.quote(s.substring(start, end));
    }
}

