/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.utils;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;

public class MapUtils {
    public static <K> Long getLong(Map<? super K, ?> map, K key, Long defaultValue) {
        Long answer = MapUtils.getLong(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static <K> long getLongValue(Map<? super K, ?> map, K key) {
        Long longObject = MapUtils.getLong(map, key);
        return longObject == null ? 0L : longObject;
    }

    public static <K> Long getLong(Map<? super K, ?> map, K key) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        return answer instanceof Long ? ((Long)answer).longValue() : answer.longValue();
    }

    public static <K> Number getNumber(Map<? super K, ?> map, K key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            if (answer instanceof Number) {
                return (Number)answer;
            }
            if (answer instanceof String) {
                try {
                    String text = (String)answer;
                    return NumberFormat.getInstance().parse(text);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

