/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.application;

import cloud.tianai.captcha.application.CaptchaImageType;
import cloud.tianai.captcha.application.ImageCaptchaApplication;
import cloud.tianai.captcha.application.ImageCaptchaProperties;
import cloud.tianai.captcha.application.vo.ImageCaptchaVO;
import cloud.tianai.captcha.cache.CacheStore;
import cloud.tianai.captcha.common.AnyMap;
import cloud.tianai.captcha.common.exception.ImageCaptchaException;
import cloud.tianai.captcha.common.response.ApiResponse;
import cloud.tianai.captcha.common.response.ApiResponseStatusConstant;
import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.generator.ImageCaptchaGenerator;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.impl.CacheImageCaptchaGenerator;
import cloud.tianai.captcha.interceptor.CaptchaInterceptor;
import cloud.tianai.captcha.interceptor.EmptyCaptchaInterceptor;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.validator.ImageCaptchaValidator;
import cloud.tianai.captcha.validator.common.model.dto.ImageCaptchaTrack;
import cloud.tianai.captcha.validator.common.model.dto.MatchParam;
import cloud.tianai.captcha.validator.impl.SimpleImageCaptchaValidator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultImageCaptchaApplication
implements ImageCaptchaApplication {
    private static final Logger log = LoggerFactory.getLogger(DefaultImageCaptchaApplication.class);
    private CaptchaInterceptor captchaInterceptor;
    private ImageCaptchaGenerator captchaGenerator;
    private ImageCaptchaValidator imageCaptchaValidator;
    private CacheStore cacheStore;
    private final ImageCaptchaProperties prop;
    private long defaultExpire = 20000L;
    public static final String ID_SPLIT = "_";

    public DefaultImageCaptchaApplication(ImageCaptchaGenerator captchaGenerator, ImageCaptchaValidator imageCaptchaValidator, CacheStore cacheStore, ImageCaptchaProperties prop, CaptchaInterceptor captchaInterceptor) {
        this.prop = prop;
        this.setImageCaptchaValidator(imageCaptchaValidator);
        this.setCacheStore(cacheStore);
        Long defaultExpire = prop.getExpire().get("default");
        if (defaultExpire != null && defaultExpire > 0L) {
            this.defaultExpire = defaultExpire;
        }
        this.captchaInterceptor = captchaInterceptor == null ? EmptyCaptchaInterceptor.INSTANCE : captchaInterceptor;
        captchaGenerator.setInterceptor(this.captchaInterceptor);
        if (prop.isLocalCacheEnabled()) {
            captchaGenerator = new CacheImageCaptchaGenerator(captchaGenerator, prop.getLocalCacheSize(), prop.getLocalCacheWaitTime(), prop.getLocalCachePeriod(), prop.getLocalCacheExpireTime());
        }
        captchaGenerator.init();
        this.setImageCaptchaGenerator(captchaGenerator);
    }

    @Override
    public ApiResponse<ImageCaptchaVO> generateCaptcha() {
        return this.generateCaptcha("SLIDER");
    }

    @Override
    public ApiResponse<ImageCaptchaVO> generateCaptcha(String type) {
        GenerateParam generateParam = new GenerateParam();
        generateParam.setType(type);
        return this.generateCaptcha(generateParam);
    }

    @Override
    public ApiResponse<ImageCaptchaVO> generateCaptcha(GenerateParam param) {
        ApiResponse<ImageCaptchaVO> captchaResponse = this.beforeGenerateCaptcha(param);
        if (captchaResponse != null) {
            return captchaResponse;
        }
        ImageCaptchaInfo imageCaptchaInfo = this.getImageCaptchaGenerator().generateCaptchaImage(param);
        captchaResponse = this.convertToCaptchaResponse(imageCaptchaInfo);
        this.afterGenerateCaptcha(imageCaptchaInfo, captchaResponse);
        return captchaResponse;
    }

    @Override
    public ApiResponse<ImageCaptchaVO> generateCaptcha(CaptchaImageType captchaImageType) {
        return this.generateCaptcha("SLIDER", captchaImageType);
    }

    @Override
    public ApiResponse<ImageCaptchaVO> generateCaptcha(String type, CaptchaImageType captchaImageType) {
        GenerateParam param = new GenerateParam();
        if (CaptchaImageType.WEBP.equals((Object)captchaImageType)) {
            param.setBackgroundFormatName("webp");
            param.setTemplateFormatName("webp");
        } else {
            param.setBackgroundFormatName("jpeg");
            param.setTemplateFormatName("png");
        }
        param.setType(type);
        return this.generateCaptcha(param);
    }

    public ApiResponse<ImageCaptchaVO> convertToCaptchaResponse(ImageCaptchaInfo imageCaptchaInfo) {
        if (imageCaptchaInfo == null) {
            throw new ImageCaptchaException("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u9a8c\u8bc1\u7801\u751f\u6210\u4e3a\u7a7a");
        }
        String id = this.generatorId(imageCaptchaInfo);
        ApiResponse<ImageCaptchaVO> response = this.beforeGenerateImageCaptchaValidData(imageCaptchaInfo);
        if (response != null) {
            return response;
        }
        AnyMap validData = this.getImageCaptchaValidator().generateImageCaptchaValidData(imageCaptchaInfo);
        this.afterGenerateImageCaptchaValidData(imageCaptchaInfo, validData);
        if (!CollectionUtils.isEmpty(validData)) {
            this.cacheVerification(id, imageCaptchaInfo.getType(), validData);
        }
        ImageCaptchaVO verificationVO = new ImageCaptchaVO();
        verificationVO.setType(imageCaptchaInfo.getType());
        verificationVO.setBackgroundImage(imageCaptchaInfo.getBackgroundImage());
        verificationVO.setTemplateImage(imageCaptchaInfo.getTemplateImage());
        verificationVO.setBackgroundImageTag(imageCaptchaInfo.getBackgroundImageTag());
        verificationVO.setTemplateImageTag(imageCaptchaInfo.getTemplateImageTag());
        verificationVO.setBackgroundImageWidth(imageCaptchaInfo.getBackgroundImageWidth());
        verificationVO.setBackgroundImageHeight(imageCaptchaInfo.getBackgroundImageHeight());
        verificationVO.setTemplateImageWidth(imageCaptchaInfo.getTemplateImageWidth());
        verificationVO.setTemplateImageHeight(imageCaptchaInfo.getTemplateImageHeight());
        verificationVO.setData(imageCaptchaInfo.getData() == null ? null : imageCaptchaInfo.getData().getViewData());
        verificationVO.setId(id);
        return ApiResponse.ofSuccess(verificationVO);
    }

    @Override
    public ApiResponse<?> matching(String id, MatchParam matchParam) {
        AnyMap validData = this.getVerification(id);
        if (validData == null) {
            return ApiResponse.ofMessage(ApiResponseStatusConstant.EXPIRED);
        }
        ApiResponse<?> response = this.beforeValid(id, matchParam, validData);
        if (!response.isSuccess()) {
            return response;
        }
        ApiResponse<?> basicValid = this.getImageCaptchaValidator().valid(matchParam.getTrack(), validData);
        response = this.afterValid(id, matchParam, validData, basicValid);
        if (!response.isSuccess()) {
            return response;
        }
        return basicValid;
    }

    @Override
    public ApiResponse<?> matching(String id, ImageCaptchaTrack track) {
        return this.matching(id, new MatchParam(track, null));
    }

    @Override
    public boolean matching(String id, Float percentage) {
        AnyMap cachePercentage = this.getVerification(id);
        if (cachePercentage == null) {
            return false;
        }
        ImageCaptchaValidator imageCaptchaValidator = this.getImageCaptchaValidator();
        if (!(imageCaptchaValidator instanceof SimpleImageCaptchaValidator)) {
            return false;
        }
        SimpleImageCaptchaValidator simpleImageCaptchaValidator = (SimpleImageCaptchaValidator)imageCaptchaValidator;
        Float oriPercentage = cachePercentage.getFloat("percentage");
        Float tolerant = cachePercentage.getFloat("tolerant", Float.valueOf(simpleImageCaptchaValidator.getDefaultTolerant()));
        return simpleImageCaptchaValidator.checkPercentage(percentage, oriPercentage, tolerant.floatValue());
    }

    @Override
    public String getCaptchaTypeById(String id) {
        String[] split = id.split(ID_SPLIT);
        if (split.length >= 2) {
            return split[0];
        }
        return null;
    }

    protected String generatorId(ImageCaptchaInfo imageCaptchaInfo) {
        return imageCaptchaInfo.getType() + ID_SPLIT + UUID.randomUUID().toString().replace("-", "");
    }

    protected AnyMap getVerification(String id) {
        return this.getCacheStore().getAndRemoveCache(this.getKey(id));
    }

    protected void cacheVerification(String id, String type, AnyMap validData) {
        Long expire = this.prop.getExpire().getOrDefault(type, this.defaultExpire);
        if (!this.getCacheStore().setCache(this.getKey(id), validData, expire, TimeUnit.MILLISECONDS)) {
            log.error("\u7f13\u5b58\u9a8c\u8bc1\u7801\u6570\u636e\u5931\u8d25\uff0c id={}, validData={}", (Object)id, (Object)validData);
            throw new ImageCaptchaException("\u7f13\u5b58\u9a8c\u8bc1\u7801\u6570\u636e\u5931\u8d25" + type);
        }
    }

    protected String getKey(String id) {
        return this.prop.getPrefix().concat(":").concat(id);
    }

    @Override
    public ImageCaptchaResourceManager getImageCaptchaResourceManager() {
        return this.getImageCaptchaGenerator().getImageResourceManager();
    }

    @Override
    public void setImageCaptchaValidator(ImageCaptchaValidator imageCaptchaValidator) {
        this.imageCaptchaValidator = imageCaptchaValidator;
    }

    @Override
    public void setImageCaptchaGenerator(ImageCaptchaGenerator imageCaptchaGenerator) {
        this.captchaGenerator = imageCaptchaGenerator;
    }

    @Override
    public CaptchaInterceptor getCaptchaInterceptor() {
        return this.captchaInterceptor;
    }

    @Override
    public void setCaptchaInterceptor(CaptchaInterceptor captchaInterceptor) {
        this.captchaInterceptor = captchaInterceptor;
        this.captchaGenerator.setInterceptor(captchaInterceptor);
    }

    @Override
    public void setCacheStore(CacheStore cacheStore) {
        this.cacheStore = cacheStore;
    }

    @Override
    public ImageCaptchaValidator getImageCaptchaValidator() {
        return this.imageCaptchaValidator;
    }

    @Override
    public ImageCaptchaGenerator getImageCaptchaGenerator() {
        return this.captchaGenerator;
    }

    @Override
    public CacheStore getCacheStore() {
        return this.cacheStore;
    }

    private void afterGenerateCaptcha(ImageCaptchaInfo imageCaptchaInfo, ApiResponse<ImageCaptchaVO> captchaResponse) {
        this.captchaInterceptor.afterGenerateCaptcha(this.captchaInterceptor.createContext(), imageCaptchaInfo.getType(), imageCaptchaInfo, captchaResponse);
    }

    private ApiResponse<ImageCaptchaVO> beforeGenerateCaptcha(GenerateParam param) {
        return this.captchaInterceptor.beforeGenerateCaptcha(this.captchaInterceptor.createContext(), param.getType(), param);
    }

    private ApiResponse<ImageCaptchaVO> beforeGenerateImageCaptchaValidData(ImageCaptchaInfo imageCaptchaInfo) {
        return this.captchaInterceptor.beforeGenerateImageCaptchaValidData(this.captchaInterceptor.createContext(), imageCaptchaInfo.getType(), imageCaptchaInfo);
    }

    private void afterGenerateImageCaptchaValidData(ImageCaptchaInfo imageCaptchaInfo, AnyMap validData) {
        this.captchaInterceptor.afterGenerateImageCaptchaValidData(this.captchaInterceptor.createContext(), imageCaptchaInfo.getType(), imageCaptchaInfo, validData);
    }

    private ApiResponse<?> beforeValid(String id, MatchParam matchParam, AnyMap validData) {
        return this.captchaInterceptor.beforeValid(this.captchaInterceptor.createContext(), this.getCaptchaTypeById(id), matchParam, validData);
    }

    private ApiResponse<?> afterValid(String id, MatchParam matchParam, AnyMap validData, ApiResponse<?> basicValid) {
        return this.captchaInterceptor.afterValid(this.captchaInterceptor.createContext(), this.getCaptchaTypeById(id), matchParam, validData, basicValid);
    }
}

