/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource;

import cloud.tianai.captcha.generator.common.FontWrapper;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontCache
implements ResourceStore {
    private static final Logger log = LoggerFactory.getLogger(FontCache.class);
    public static final String FONT_TYPE = "font";
    private final Map<String, FontWrapper> fontMap = new ConcurrentHashMap<String, FontWrapper>();
    private ResourceStore resourceStore;
    private ImageCaptchaResourceManager resourceManager;
    private int fontSize = 70;

    public FontCache(ResourceStore resourceStore) {
        this.resourceStore = resourceStore;
    }

    @Override
    public void init(ImageCaptchaResourceManager resourceManager) {
        this.resourceStore.init(resourceManager);
        this.resourceManager = resourceManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FontWrapper getFont(Resource resource) {
        try (InputStream stream = this.resourceManager.getResourceInputStream(resource);){
            Font font = Font.createFont(0, stream);
            FontWrapper fontWrapper = new FontWrapper(font, this.fontSize);
            return fontWrapper;
        }
        catch (FontFormatException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String calcId(Resource resource) {
        return resource.getType() + "_" + resource.getData();
    }

    @Override
    public List<Resource> randomGetResourceByTypeAndTag(String type, String tag, Integer quantity) {
        List<Resource> resources = this.resourceStore.randomGetResourceByTypeAndTag(type, tag, quantity);
        if (FONT_TYPE.equalsIgnoreCase(type)) {
            for (Resource resource : resources) {
                FontWrapper fontWrapper = this.fontMap.computeIfAbsent(this.calcId(resource), v -> this.getFont(resource));
                resource.setExtra(fontWrapper);
            }
        }
        return resources;
    }

    @Override
    public List<ResourceMap> randomGetTemplateByTypeAndTag(String type, String tag, Integer quantity) {
        return this.resourceStore.randomGetTemplateByTypeAndTag(type, tag, quantity);
    }

    @Override
    public ResourceStore getTarget() {
        return this.resourceStore;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getFontSize() {
        return this.fontSize;
    }
}

