/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import java.util.EnumSet;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.web.http.SessionRepositoryFilter;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={SessionRepositoryFilter.class})
@EnableConfigurationProperties(value={SessionProperties.class})
class SessionRepositoryFilterConfiguration {
    SessionRepositoryFilterConfiguration() {
    }

    @Bean
    DelegatingFilterProxyRegistrationBean sessionRepositoryFilterRegistration(SessionProperties sessionProperties, ListableBeanFactory beanFactory) {
        String[] targetBeanNames = beanFactory.getBeanNamesForType(SessionRepositoryFilter.class, false, false);
        Assert.state(targetBeanNames.length == 1, "Expected single SessionRepositoryFilter bean");
        DelegatingFilterProxyRegistrationBean registration = new DelegatingFilterProxyRegistrationBean(targetBeanNames[0], new ServletRegistrationBean[0]);
        registration.setDispatcherTypes(this.getDispatcherTypes(sessionProperties));
        registration.setOrder(sessionProperties.getServlet().getFilterOrder());
        return registration;
    }

    private EnumSet<DispatcherType> getDispatcherTypes(SessionProperties sessionProperties) {
        SessionProperties.Servlet servletProperties = sessionProperties.getServlet();
        if (servletProperties.getFilterDispatcherTypes() == null) {
            return null;
        }
        return servletProperties.getFilterDispatcherTypes().stream().map(type -> DispatcherType.valueOf(type.name())).collect(Collectors.toCollection(() -> EnumSet.noneOf(DispatcherType.class)));
    }
}

