/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.CodecDecoder;
import org.redisson.client.protocol.decoder.GeoDistanceDecoder;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.ByteBufferGeoResultsDecoder;
import org.redisson.spring.data.connection.DistanceConvertor;
import org.redisson.spring.data.connection.ObjectListReplayDecoder2;
import org.redisson.spring.data.connection.PointDecoder;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.ReactiveGeoCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.domain.geo.BoxShape;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.data.redis.domain.geo.RadiusShape;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveGeoCommands
extends RedissonBaseReactive
implements ReactiveGeoCommands {
    private static final RedisCommand<List<Object>> GEOHASH = new RedisCommand("GEOHASH", new ObjectListReplayDecoder());
    private final MultiDecoder<Map<Object, Object>> geoDecoder = new ListMultiDecoder2(new ObjectListReplayDecoder2(), new PointDecoder());
    private final MultiDecoder<GeoResults<RedisGeoCommands.GeoLocation<ByteBuffer>>> postitionDecoder = new ListMultiDecoder2(new ByteBufferGeoResultsDecoder(), new CodecDecoder(), new PointDecoder(), new ObjectListReplayDecoder());

    RedissonReactiveGeoCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveGeoCommands.GeoAddCommand, Long>> geoAdd(Publisher<ReactiveGeoCommands.GeoAddCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getGeoLocations(), "Locations must not be null!");
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(keyBuf);
            for (RedisGeoCommands.GeoLocation<ByteBuffer> location : command.getGeoLocations()) {
                args.add(location.getPoint().getX());
                args.add(location.getPoint().getY());
                args.add(RedissonReactiveGeoCommands.toByteArray((ByteBuffer)location.getName()));
            }
            Mono<Long> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.GEOADD, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveGeoCommands.GeoAddCommand, Long>((ReactiveGeoCommands.GeoAddCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoDistCommand, Distance>> geoDist(Publisher<ReactiveGeoCommands.GeoDistCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getFrom(), "From member must not be null!");
            Assert.notNull((Object)command.getTo(), "To member must not be null!");
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            byte[] fromBuf = RedissonReactiveGeoCommands.toByteArray(command.getFrom());
            byte[] toBuf = RedissonReactiveGeoCommands.toByteArray(command.getTo());
            Metric metric = RedisGeoCommands.DistanceUnit.METERS;
            if (command.getMetric().isPresent()) {
                metric = command.getMetric().get();
            }
            Mono<Distance> m = this.write(keyBuf, DoubleCodec.INSTANCE, new RedisCommand<Distance>("GEODIST", new DistanceConvertor(metric)), keyBuf, fromBuf, toBuf, metric.getAbbreviation());
            return m.map(v -> new ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoDistCommand, Distance>((ReactiveGeoCommands.GeoDistCommand)command, (Distance)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveGeoCommands.GeoHashCommand, String>> geoHash(Publisher<ReactiveGeoCommands.GeoHashCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getMembers(), "Members must not be null!");
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getMembers().size() + 1);
            args.add(keyBuf);
            args.addAll(command.getMembers().stream().map(buf -> RedissonReactiveGeoCommands.toByteArray(buf)).collect(Collectors.toList()));
            Mono<List> m = this.read(keyBuf, StringCodec.INSTANCE, GEOHASH, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.MultiValueResponse((ReactiveGeoCommands.GeoHashCommand)command, v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveGeoCommands.GeoPosCommand, Point>> geoPos(Publisher<ReactiveGeoCommands.GeoPosCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getMembers(), "Members must not be null!");
            RedisCommand<Map<Object, Object>> cmd = new RedisCommand<Map<Object, Object>>("GEOPOS", this.geoDecoder);
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getMembers().size() + 1);
            args.add(keyBuf);
            args.addAll(command.getMembers().stream().map(buf -> RedissonReactiveGeoCommands.toByteArray(buf)).collect(Collectors.toList()));
            Mono<List> m = this.read(keyBuf, StringCodec.INSTANCE, cmd, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.MultiValueResponse((ReactiveGeoCommands.GeoPosCommand)command, v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoRadiusCommand, Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>>> geoRadius(Publisher<ReactiveGeoCommands.GeoRadiusCommand> commands) {
        return this.execute(commands, command -> {
            RedisCommand<Object> cmd;
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getPoint(), "Point must not be null!");
            Assert.notNull((Object)command.getDistance(), "Distance must not be null!");
            RedisGeoCommands.GeoRadiusCommandArgs args = command.getArgs().orElse(RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs());
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(keyBuf);
            params.add(BigDecimal.valueOf(command.getPoint().getX()).toPlainString());
            params.add(BigDecimal.valueOf(command.getPoint().getY()).toPlainString());
            params.add(command.getDistance().getValue());
            params.add(command.getDistance().getMetric().getAbbreviation());
            if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
                cmd = new RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<ByteBuffer>>>("GEORADIUS_RO", this.postitionDecoder);
                params.add("WITHCOORD");
            } else {
                ListMultiDecoder2 distanceDecoder = new ListMultiDecoder2(new ByteBufferGeoResultsDecoder(command.getDistance().getMetric()), new GeoDistanceDecoder());
                cmd = new RedisCommand<Object>("GEORADIUS_RO", distanceDecoder);
                params.add("WITHDIST");
            }
            if (args.getLimit() != null) {
                params.add("COUNT");
                params.add(args.getLimit());
            }
            if (args.getSortDirection() != null) {
                params.add(args.getSortDirection().name());
            }
            Mono<GeoResults> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, cmd, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.CommandResponse((ReactiveGeoCommands.GeoRadiusCommand)command, Flux.fromIterable(v.getContent())));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoRadiusByMemberCommand, Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>>> geoRadiusByMember(Publisher<ReactiveGeoCommands.GeoRadiusByMemberCommand> commands) {
        return this.execute(commands, command -> {
            RedisCommand<Object> cmd;
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getMember(), "Member must not be null!");
            Assert.notNull((Object)command.getDistance(), "Distance must not be null!");
            RedisGeoCommands.GeoRadiusCommandArgs args = command.getArgs().orElse(RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs());
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            byte[] memberBuf = RedissonReactiveGeoCommands.toByteArray(command.getMember());
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(keyBuf);
            params.add(memberBuf);
            params.add(command.getDistance().getValue());
            params.add(command.getDistance().getMetric().getAbbreviation());
            if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
                cmd = new RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<ByteBuffer>>>("GEORADIUSBYMEMBER_RO", this.postitionDecoder);
                params.add("WITHCOORD");
            } else {
                ListMultiDecoder2 distanceDecoder = new ListMultiDecoder2(new ByteBufferGeoResultsDecoder(command.getDistance().getMetric()), new GeoDistanceDecoder());
                cmd = new RedisCommand<Object>("GEORADIUSBYMEMBER_RO", distanceDecoder);
                params.add("WITHDIST");
            }
            if (args.getLimit() != null) {
                params.add("COUNT");
                params.add(args.getLimit());
            }
            if (args.getSortDirection() != null) {
                params.add(args.getSortDirection().name());
            }
            Mono<GeoResults> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, cmd, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.CommandResponse((ReactiveGeoCommands.GeoRadiusByMemberCommand)command, Flux.fromIterable(v.getContent())));
        });
    }

    private String convert(double longitude) {
        return BigDecimal.valueOf(longitude).toPlainString();
    }

    private ByteBuf encode(Object value) {
        return this.executorService.encode(ByteArrayCodec.INSTANCE, value);
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoSearchCommand, Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>>> geoSearch(Publisher<ReactiveGeoCommands.GeoSearchCommand> commands) {
        return this.execute(commands, command -> {
            RedisCommand<Object> cmd;
            GeoShape shape;
            GeoReference ref;
            Assert.notNull(command.getArgs(), "Args must not be null!");
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getShape(), "Shape must not be null!");
            Assert.notNull(command.getReference(), "Reference must not be null!");
            ArrayList<Object> commandParams = new ArrayList<Object>();
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            commandParams.add(keyBuf);
            if (command.getReference() instanceof GeoReference.GeoCoordinateReference) {
                ref = (GeoReference.GeoCoordinateReference)command.getReference();
                commandParams.add("FROMLONLAT");
                commandParams.add(this.convert(((GeoReference.GeoCoordinateReference)ref).getLongitude()));
                commandParams.add(this.convert(((GeoReference.GeoCoordinateReference)ref).getLatitude()));
            } else if (command.getReference() instanceof GeoReference.GeoMemberReference) {
                ref = (GeoReference.GeoMemberReference)command.getReference();
                commandParams.add("FROMMEMBER");
                commandParams.add(this.encode(((GeoReference.GeoMemberReference)ref).getMember()));
            }
            if (command.getShape() instanceof RadiusShape) {
                commandParams.add("BYRADIUS");
                shape = (RadiusShape)command.getShape();
                commandParams.add(((RadiusShape)shape).getRadius().getValue());
                commandParams.add(this.convert(((RadiusShape)shape).getMetric()).getAbbreviation());
            } else if (command.getShape() instanceof BoxShape) {
                shape = (BoxShape)command.getShape();
                commandParams.add("BYBOX");
                commandParams.add(((BoxShape)shape).getBoundingBox().getWidth().getValue());
                commandParams.add(((BoxShape)shape).getBoundingBox().getHeight().getValue());
                commandParams.add(this.convert(((BoxShape)shape).getMetric()).getAbbreviation());
            }
            RedisGeoCommands.GeoSearchCommandArgs args = command.getArgs().orElse(RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
            if (args.hasSortDirection()) {
                commandParams.add((Object)args.getSortDirection());
            }
            if (args.getLimit() != null) {
                commandParams.add("COUNT");
                commandParams.add(args.getLimit());
                if (args.hasAnyLimit()) {
                    commandParams.add("ANY");
                }
            }
            if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
                cmd = new RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<ByteBuffer>>>("GEOSEARCH", this.postitionDecoder);
                commandParams.add("WITHCOORD");
            } else {
                ListMultiDecoder2 distanceDecoder = new ListMultiDecoder2(new ByteBufferGeoResultsDecoder(command.getShape().getMetric()), new GeoDistanceDecoder());
                cmd = new RedisCommand<Object>("GEOSEARCH", distanceDecoder);
                commandParams.add("WITHDIST");
            }
            Mono<GeoResults> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, cmd, commandParams.toArray());
            return m.map(v -> new ReactiveRedisConnection.CommandResponse((ReactiveGeoCommands.GeoSearchCommand)command, Flux.fromIterable(v.getContent())));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveGeoCommands.GeoSearchStoreCommand, Long>> geoSearchStore(Publisher<ReactiveGeoCommands.GeoSearchStoreCommand> commands) {
        return this.execute(commands, command -> {
            GeoShape shape;
            GeoReference ref;
            Assert.notNull(command.getArgs(), "Args must not be null!");
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDestKey(), "DestKey must not be null!");
            Assert.notNull((Object)command.getShape(), "Shape must not be null!");
            Assert.notNull(command.getReference(), "Reference must not be null!");
            ArrayList<Object> commandParams = new ArrayList<Object>();
            byte[] destKeyBuf = RedissonReactiveGeoCommands.toByteArray(command.getDestKey());
            commandParams.add(destKeyBuf);
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            commandParams.add(keyBuf);
            if (command.getReference() instanceof GeoReference.GeoCoordinateReference) {
                ref = (GeoReference.GeoCoordinateReference)command.getReference();
                commandParams.add("FROMLONLAT");
                commandParams.add(this.convert(((GeoReference.GeoCoordinateReference)ref).getLongitude()));
                commandParams.add(this.convert(((GeoReference.GeoCoordinateReference)ref).getLatitude()));
            } else if (command.getReference() instanceof GeoReference.GeoMemberReference) {
                ref = (GeoReference.GeoMemberReference)command.getReference();
                commandParams.add("FROMMEMBER");
                commandParams.add(this.encode(((GeoReference.GeoMemberReference)ref).getMember()));
            }
            if (command.getShape() instanceof RadiusShape) {
                shape = (RadiusShape)command.getShape();
                commandParams.add("BYRADIUS");
                commandParams.add(((RadiusShape)shape).getRadius().getValue());
                commandParams.add(this.convert(((RadiusShape)shape).getMetric()).getAbbreviation());
            } else if (command.getShape() instanceof BoxShape) {
                shape = (BoxShape)command.getShape();
                commandParams.add("BYBOX");
                commandParams.add(((BoxShape)shape).getBoundingBox().getWidth().getValue());
                commandParams.add(((BoxShape)shape).getBoundingBox().getHeight().getValue());
                commandParams.add(this.convert(((BoxShape)shape).getMetric()).getAbbreviation());
            }
            RedisGeoCommands.GeoSearchStoreCommandArgs args = command.getArgs().orElse(RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
            if (args.hasSortDirection()) {
                commandParams.add((Object)args.getSortDirection());
            }
            if (args.getLimit() != null) {
                commandParams.add("COUNT");
                commandParams.add(args.getLimit());
                if (args.hasAnyLimit()) {
                    commandParams.add("ANY");
                }
            }
            if (args.isStoreDistance()) {
                commandParams.add("STOREDIST");
            }
            Mono<Long> m = this.write(keyBuf, LongCodec.INSTANCE, RedisCommands.GEOSEARCHSTORE_STORE, commandParams.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveGeoCommands.GeoSearchStoreCommand, Long>((ReactiveGeoCommands.GeoSearchStoreCommand)command, (Long)v));
        });
    }

    private Metric convert(Metric metric) {
        if (metric == Metrics.NEUTRAL) {
            return RedisGeoCommands.DistanceUnit.METERS;
        }
        return metric;
    }
}

