/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.RedissonKeysReactive;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveKeyCommands
extends RedissonBaseReactive
implements ReactiveKeyCommands {
    private static final RedisStrictCommand<DataType> TYPE = new RedisStrictCommand<DataType>("TYPE", new Convertor<DataType>(){

        @Override
        public DataType convert(Object obj) {
            return DataType.fromCode(obj.toString());
        }
    });
    static final RedisStrictCommand<String> RENAME = new RedisStrictCommand("RENAME");
    private static final RedisStrictCommand<Boolean> EXPIRE = new RedisStrictCommand<Boolean>("EXPIRE", new BooleanReplayConvertor());
    private static final RedisStrictCommand<Boolean> EXPIREAT = new RedisStrictCommand<Boolean>("EXPIREAT", new BooleanReplayConvertor());
    private static final RedisStrictCommand<Long> TTL = new RedisStrictCommand("TTL");
    private static final RedisStrictCommand<ValueEncoding> OBJECT_ENCODING = new RedisStrictCommand<ValueEncoding>("OBJECT", "ENCODING", new Convertor<ValueEncoding>(){

        @Override
        public ValueEncoding convert(Object obj) {
            return ValueEncoding.of((String)obj);
        }
    });
    private static final RedisStrictCommand<Long> OBJECT_IDLETIME = new RedisStrictCommand("OBJECT", "IDLETIME");
    private static final RedisStrictCommand<Long> OBJECT_REFCOUNT = new RedisStrictCommand("OBJECT", "REFCOUNT");

    public RedissonReactiveKeyCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> exists(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        return this.execute(keys, key -> {
            Assert.notNull((Object)key.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(key.getKey());
            Mono<Boolean> m = this.read(keyBuf, StringCodec.INSTANCE, RedisCommands.EXISTS, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)key, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>> type(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        return this.execute(keys, key -> {
            Assert.notNull((Object)key.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(key.getKey());
            Mono<DataType> m = this.read(keyBuf, StringCodec.INSTANCE, TYPE, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>((ReactiveRedisConnection.KeyCommand)key, (DataType)((Object)((Object)v))));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<Collection<ByteBuffer>, Long>> touch(Publisher<Collection<ByteBuffer>> keys) {
        return this.execute(keys, coll -> {
            Assert.notNull(coll, "Collection must not be null!");
            Object[] params = coll.stream().map(buf -> RedissonReactiveKeyCommands.toByteArray(buf)).toArray(Object[]::new);
            Mono<Long> m = this.write(null, StringCodec.INSTANCE, RedisCommands.TOUCH_LONG, params);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<Collection, Long>((Collection)coll, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ByteBuffer, ByteBuffer>> keys(Publisher<ByteBuffer> patterns) {
        return this.execute(patterns, pattern -> {
            Assert.notNull(pattern, "Pattern must not be null!");
            Mono<List> m = this.read(null, StringCodec.INSTANCE, RedisCommands.KEYS, new Object[]{RedissonReactiveKeyCommands.toByteArray(pattern)});
            return m.map(v -> {
                List values = v.stream().map(t -> ByteBuffer.wrap(t.getBytes())).collect(Collectors.toList());
                return new ReactiveRedisConnection.MultiValueResponse((ByteBuffer)pattern, values);
            });
        });
    }

    @Override
    public Flux<ByteBuffer> scan(ScanOptions options) {
        RedissonKeysReactive reactive = new RedissonKeysReactive(this.executorService);
        return reactive.getKeysByPattern(options.getPattern(), options.getCount().intValue()).map(t -> ByteBuffer.wrap(t.getBytes()));
    }

    @Override
    public Mono<ByteBuffer> randomKey() {
        return this.executorService.reactive(() -> this.executorService.readRandomAsync(ByteArrayCodec.INSTANCE, RedisCommands.RANDOM_KEY, new Object[0]));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> rename(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getNewKey(), "New name must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            byte[] newKeyBuf = RedissonReactiveKeyCommands.toByteArray(command.getNewKey());
            Mono<String> m = this.write(keyBuf, StringCodec.INSTANCE, RENAME, keyBuf, newKeyBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, true));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> renameNX(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getNewKey(), "New name must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            byte[] newKeyBuf = RedissonReactiveKeyCommands.toByteArray(command.getNewKey());
            Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.RENAMENX, keyBuf, newKeyBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> del(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        Flux<ReactiveRedisConnection.KeyCommand> s = Flux.from(keys);
        return s.concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono<Long> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.DEL, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mDel(Publisher<List<ByteBuffer>> keys) {
        return this.execute(keys, coll -> {
            Assert.notNull(coll, "List must not be null!");
            Object[] params = coll.stream().map(buf -> RedissonReactiveKeyCommands.toByteArray(buf)).toArray(Object[]::new);
            Mono<Long> m = this.write(null, StringCodec.INSTANCE, RedisCommands.DEL, params);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<List, Long>((List)coll, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> unlink(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        return this.execute(keys, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono<Long> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.UNLINK, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mUnlink(Publisher<List<ByteBuffer>> keys) {
        return this.execute(keys, coll -> {
            Assert.notNull(coll, "List must not be null!");
            Object[] params = coll.stream().map(buf -> RedissonReactiveKeyCommands.toByteArray(buf)).toArray(Object[]::new);
            Mono<Long> m = this.write(null, StringCodec.INSTANCE, RedisCommands.UNLINK, params);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<List, Long>((List)coll, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>> expire(Publisher<ReactiveKeyCommands.ExpireCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, EXPIRE, keyBuf, command.getTimeout().getSeconds());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>((ReactiveKeyCommands.ExpireCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>> pExpire(Publisher<ReactiveKeyCommands.ExpireCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.PEXPIRE, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>((ReactiveKeyCommands.ExpireCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>> expireAt(Publisher<ReactiveKeyCommands.ExpireAtCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, EXPIREAT, keyBuf, command.getExpireAt().getEpochSecond());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>((ReactiveKeyCommands.ExpireAtCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>> pExpireAt(Publisher<ReactiveKeyCommands.ExpireAtCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.PEXPIREAT, keyBuf, command.getExpireAt().toEpochMilli());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>((ReactiveKeyCommands.ExpireAtCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> persist(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.PERSIST, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> ttl(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono<Long> m = this.read(keyBuf, StringCodec.INSTANCE, TTL, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> pTtl(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono<Long> m = this.read(keyBuf, StringCodec.INSTANCE, RedisCommands.PTTL, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.MoveCommand>> move(Publisher<ReactiveKeyCommands.MoveCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDatabase(), "Database must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.MOVE, keyBuf, command.getDatabase());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.MoveCommand>((ReactiveKeyCommands.MoveCommand)command, (Boolean)v));
        });
    }

    @Override
    public Mono<ValueEncoding> encodingOf(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null!");
        byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(key);
        return this.read(keyBuf, StringCodec.INSTANCE, OBJECT_ENCODING, new Object[]{keyBuf});
    }

    @Override
    public Mono<Duration> idletime(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null!");
        byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(key);
        Mono<Long> m = this.read(keyBuf, StringCodec.INSTANCE, OBJECT_IDLETIME, new Object[]{keyBuf});
        return m.map(Duration::ofSeconds);
    }

    @Override
    public Mono<Long> refcount(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null!");
        byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(key);
        return this.read(keyBuf, StringCodec.INSTANCE, OBJECT_REFCOUNT, new Object[]{keyBuf});
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.CopyCommand>> copy(Publisher<ReactiveKeyCommands.CopyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getTarget(), "Target must not be null!");
            ArrayList<Object> params = new ArrayList<Object>();
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            params.add(keyBuf);
            byte[] targetBuf = RedissonReactiveKeyCommands.toByteArray(command.getTarget());
            params.add(targetBuf);
            if (command.getDatabase() != null) {
                params.add("DB");
                params.add(command.getDatabase());
            }
            Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.COPY, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.CopyCommand>((ReactiveKeyCommands.CopyCommand)command, (Boolean)v));
        });
    }
}

