/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class RedisSocketConfiguration
implements RedisConfiguration,
RedisConfiguration.DomainSocketConfiguration {
    private static final String DEFAULT_SOCKET = "/tmp/redis.sock";
    private String socket = "/tmp/redis.sock";
    private int database;
    @Nullable
    private String username = null;
    private RedisPassword password = RedisPassword.none();

    public RedisSocketConfiguration() {
    }

    public RedisSocketConfiguration(String socket) {
        Assert.hasText(socket, "Socket path must not be null nor empty!");
        this.socket = socket;
    }

    @Override
    public String getSocket() {
        return this.socket;
    }

    @Override
    public void setSocket(String socket) {
        Assert.hasText(socket, "Socket must not be null nor empty!");
        this.socket = socket;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(int index) {
        Assert.isTrue(index >= 0, () -> String.format("Invalid DB index '%s' (a positive index required)", index));
        this.database = index;
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    public RedisPassword getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, "RedisPassword must not be null!");
        this.password = password;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisSocketConfiguration)) {
            return false;
        }
        RedisSocketConfiguration that = (RedisSocketConfiguration)o;
        if (this.database != that.database) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.socket, that.socket)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.username, that.username)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.password, that.password);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.socket);
        result = 31 * result + this.database;
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.username);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.password);
        return result;
    }
}

