/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.StreamConverters;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.params.XAddParams;

class JedisClusterStreamCommands
implements RedisStreamCommands {
    private final JedisClusterConnection connection;

    JedisClusterStreamCommands(JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long xAck(byte[] key, String group, RecordId ... recordIds) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.hasText(group, "Group name must not be null or empty!");
        Assert.notNull((Object)recordIds, "recordIds must not be null!");
        try {
            return this.connection.getCluster().xack(key, JedisConverters.toBytes(group), StreamConverters.entryIdsToBytes(Arrays.asList(recordIds)));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record, RedisStreamCommands.XAddOptions options) {
        Assert.notNull(record, "Record must not be null!");
        Assert.notNull(record.getStream(), "Stream must not be null!");
        XAddParams params = StreamConverters.toXAddParams(record, options);
        try {
            return RecordId.of(JedisConverters.toString(this.connection.getCluster().xadd((byte[])record.getStream(), (Map)record.getValue(), params)));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<RecordId> xClaimJustId(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        throw new UnsupportedOperationException("JedisCluster does not support xClaimJustId.");
    }

    @Override
    public List<ByteRecord> xClaim(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)group, "Group must not be null!");
        Assert.notNull((Object)newOwner, "NewOwner must not be null!");
        long minIdleTime = options.getMinIdleTime() == null ? -1L : options.getMinIdleTime().toMillis();
        int retryCount = options.getRetryCount() == null ? -1 : options.getRetryCount().intValue();
        long unixTime = options.getUnixTime() == null ? -1L : options.getUnixTime().toEpochMilli();
        try {
            return StreamConverters.convertToByteRecord(key, this.connection.getCluster().xclaim(key, JedisConverters.toBytes(group), JedisConverters.toBytes(newOwner), minIdleTime, unixTime, retryCount, options.isForce(), StreamConverters.entryIdsToBytes(options.getIds())));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long xDel(byte[] key, RecordId ... recordIds) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)recordIds, "recordIds must not be null!");
        try {
            return this.connection.getCluster().xdel(key, StreamConverters.entryIdsToBytes(Arrays.asList(recordIds)));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset) {
        return this.xGroupCreate(key, groupName, readOffset, false);
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset, boolean mkStream) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.hasText(groupName, "Group name must not be null or empty!");
        Assert.notNull((Object)readOffset, "ReadOffset must not be null!");
        try {
            return this.connection.getCluster().xgroupCreate(key, JedisConverters.toBytes(groupName), JedisConverters.toBytes(readOffset.getOffset()), mkStream);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean xGroupDelConsumer(byte[] key, Consumer consumer) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)consumer, "Consumer must not be null!");
        try {
            return this.connection.getCluster().xgroupDelConsumer(key, JedisConverters.toBytes(consumer.getGroup()), JedisConverters.toBytes(consumer.getName())) != 0L;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean xGroupDestroy(byte[] key, String groupName) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.hasText(groupName, "Group name must not be null or empty!");
        try {
            return this.connection.getCluster().xgroupDestroy(key, JedisConverters.toBytes(groupName)) != 0L;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public StreamInfo.XInfoStream xInfo(byte[] key) {
        throw new UnsupportedOperationException("JedisCluster does not support XINFO.");
    }

    @Override
    public StreamInfo.XInfoGroups xInfoGroups(byte[] key) {
        throw new UnsupportedOperationException("JedisCluster does not support XINFO.");
    }

    @Override
    public StreamInfo.XInfoConsumers xInfoConsumers(byte[] key, String groupName) {
        throw new UnsupportedOperationException("JedisCluster does not support XINFO.");
    }

    @Override
    public Long xLen(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().xlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public PendingMessagesSummary xPending(byte[] key, String groupName) {
        throw new UnsupportedOperationException("Jedis does not support returning PendingMessagesSummary.");
    }

    @Override
    public PendingMessages xPending(byte[] key, String groupName, RedisStreamCommands.XPendingOptions options) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)groupName, "GroupName must not be null!");
        Range<String> range = options.getRange();
        byte[] group = JedisConverters.toBytes(groupName);
        try {
            List response = this.connection.getCluster().xpending(key, group, JedisConverters.toBytes(StreamConverters.getLowerValue(range)), JedisConverters.toBytes(StreamConverters.getUpperValue(range)), options.getCount().intValue(), JedisConverters.toBytes(options.getConsumerName()));
            return StreamConverters.toPendingMessages(groupName, range, (List)BuilderFactory.STREAM_PENDING_ENTRY_LIST.build((Object)response));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRange(byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(range, "Range must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        int count = limit.isUnlimited() ? Integer.MAX_VALUE : limit.getCount();
        try {
            return StreamConverters.convertToByteRecord(key, this.connection.getCluster().xrange(key, JedisConverters.toBytes(StreamConverters.getLowerValue(range)), JedisConverters.toBytes(StreamConverters.getUpperValue(range)), count));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRead(StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, "StreamReadOptions must not be null!");
        Assert.notNull(streams, "StreamOffsets must not be null!");
        long block = readOptions.getBlock() == null ? -1L : readOptions.getBlock();
        int count = readOptions.getCount() != null ? readOptions.getCount().intValue() : Integer.MAX_VALUE;
        try {
            List xread = this.connection.getCluster().xread(count, block, StreamConverters.toStreamOffsets(streams));
            if (xread == null) {
                return Collections.emptyList();
            }
            return StreamConverters.convertToByteRecords(xread);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xReadGroup(Consumer consumer, StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)consumer, "Consumer must not be null!");
        Assert.notNull((Object)readOptions, "StreamReadOptions must not be null!");
        Assert.notNull(streams, "StreamOffsets must not be null!");
        long block = readOptions.getBlock() == null ? -1L : readOptions.getBlock();
        int count = readOptions.getCount() == null ? -1 : readOptions.getCount().intValue();
        try {
            List xread = this.connection.getCluster().xreadGroup(JedisConverters.toBytes(consumer.getGroup()), JedisConverters.toBytes(consumer.getName()), count, block, readOptions.isNoack(), StreamConverters.toStreamOffsets(streams));
            if (xread == null) {
                return Collections.emptyList();
            }
            return StreamConverters.convertToByteRecords(xread);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRevRange(byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(range, "Range must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        int count = limit.isUnlimited() ? Integer.MAX_VALUE : limit.getCount();
        try {
            return StreamConverters.convertToByteRecord(key, this.connection.getCluster().xrevrange(key, JedisConverters.toBytes(StreamConverters.getUpperValue(range)), JedisConverters.toBytes(StreamConverters.getLowerValue(range)), count));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long xTrim(byte[] key, long count) {
        return this.xTrim(key, count, false);
    }

    @Override
    public Long xTrim(byte[] key, long count, boolean approximateTrimming) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().xtrim(key, count, approximateTrimming);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

