/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.KeyValue;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanStream;
import io.lettuce.core.api.reactive.RedisHashReactiveCommands;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveHashCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveHashCommands
implements ReactiveHashCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveHashCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, "Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HSetCommand>> hSet(Publisher<ReactiveHashCommands.HSetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Mono result;
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getFieldValueMap(), "FieldValueMap must not be null!");
            if (command.getFieldValueMap().size() == 1) {
                Map.Entry<ByteBuffer, ByteBuffer> entry = command.getFieldValueMap().entrySet().iterator().next();
                result = command.isUpsert() ? cmd.hset((Object)command.getKey(), (Object)entry.getKey(), (Object)entry.getValue()) : cmd.hsetnx((Object)command.getKey(), (Object)entry.getKey(), (Object)entry.getValue());
            } else {
                Map<ByteBuffer, ByteBuffer> entries = command.getFieldValueMap();
                result = cmd.hmset((Object)command.getKey(), entries).map(Converters::stringToBoolean);
            }
            return result.map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HSetCommand>((ReactiveHashCommands.HSetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveHashCommands.HGetCommand, ByteBuffer>> hMGet(Publisher<ReactiveHashCommands.HGetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Mono<List<List>> result;
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getFields(), "Fields must not be null!");
            if (command.getFields().size() == 1) {
                ByteBuffer key = command.getFields().iterator().next();
                result = cmd.hget((Object)command.getKey(), (Object)key.duplicate()).map(value -> KeyValue.fromNullable((Object)key, (Object)value)).defaultIfEmpty(KeyValue.empty((Object)key)).map(Collections::singletonList);
            } else {
                result = cmd.hmget((Object)command.getKey(), (Object[])command.getFields().stream().toArray(ByteBuffer[]::new)).collectList();
            }
            return result.map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveHashCommands.HGetCommand)command, value.stream().map(keyValue -> (ByteBuffer)keyValue.getValueOrElse(null)).collect(Collectors.toList())));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HExistsCommand>> hExists(Publisher<ReactiveHashCommands.HExistsCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getName(), "Name must not be null!");
            return cmd.hexists((Object)command.getKey(), (Object)command.getField()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HExistsCommand>((ReactiveHashCommands.HExistsCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HDelCommand, Long>> hDel(Publisher<ReactiveHashCommands.HDelCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getFields(), "Fields must not be null!");
            return cmd.hdel((Object)command.getKey(), (Object[])command.getFields().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HDelCommand, Long>((ReactiveHashCommands.HDelCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> hLen(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Command.getKey() must not be null!");
            return cmd.hlen((Object)command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveHashCommands.HRandFieldCommand, Flux<ByteBuffer>>> hRandField(Publisher<ReactiveHashCommands.HRandFieldCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notNull((Object)command.getKey(), "Command.getKey() must not be null!");
            return new ReactiveRedisConnection.CommandResponse<ReactiveHashCommands.HRandFieldCommand, Flux>((ReactiveHashCommands.HRandFieldCommand)command, cmd.hrandfield((Object)command.getKey(), command.getCount()));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveHashCommands.HRandFieldCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hRandFieldWithValues(Publisher<ReactiveHashCommands.HRandFieldCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notNull((Object)command.getKey(), "Command.getKey() must not be null!");
            Flux flux = cmd.hrandfieldWithvalues((Object)command.getKey(), command.getCount()).handle((it, sink) -> {
                if (it.isEmpty()) {
                    return;
                }
                sink.next(Converters.entryOf(it.getKey(), it.getValue()));
            });
            return new ReactiveRedisConnection.CommandResponse((ReactiveHashCommands.HRandFieldCommand)command, flux);
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hKeys(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Flux result = cmd.hkeys((Object)command.getKey());
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux>((ReactiveRedisConnection.KeyCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hVals(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Flux result = cmd.hvals((Object)command.getKey());
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux>((ReactiveRedisConnection.KeyCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hGetAll(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Flux result = cmd.hgetall((Object)command.getKey());
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry>>((ReactiveRedisConnection.KeyCommand)command, result.map(LettuceReactiveHashCommands::toEntry)));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getOptions(), "ScanOptions must not be null!");
            Flux result = ScanStream.hscan((RedisHashReactiveCommands)cmd, (Object)command.getKey(), (ScanArgs)LettuceConverters.toScanArgs(command.getOptions()));
            Flux<Map.Entry> entryFlux = result.map(it -> new Map.Entry<ByteBuffer, ByteBuffer>(){

                @Override
                public ByteBuffer getKey() {
                    return (ByteBuffer)it.getKey();
                }

                @Override
                public ByteBuffer getValue() {
                    return (ByteBuffer)it.getValue();
                }

                @Override
                public ByteBuffer setValue(ByteBuffer value) {
                    throw new UnsupportedOperationException("Cannot set value for entry in cursor.");
                }
            });
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyScanCommand, Flux<Map.Entry>>((ReactiveRedisConnection.KeyScanCommand)command, entryFlux));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HStrLenCommand, Long>> hStrLen(Publisher<ReactiveHashCommands.HStrLenCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getField(), "Field must not be null!");
            return cmd.hstrlen((Object)command.getKey(), (Object)command.getField()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HStrLenCommand, Long>((ReactiveHashCommands.HStrLenCommand)command, (Long)value));
        }));
    }

    private static Map.Entry<ByteBuffer, ByteBuffer> toEntry(final KeyValue<ByteBuffer, ByteBuffer> kv) {
        return new Map.Entry<ByteBuffer, ByteBuffer>(){

            @Override
            public ByteBuffer getKey() {
                return (ByteBuffer)kv.getKey();
            }

            @Override
            public ByteBuffer getValue() {
                return (ByteBuffer)kv.getValue();
            }

            @Override
            public ByteBuffer setValue(ByteBuffer value) {
                throw new UnsupportedOperationException("Cannot set value for entry");
            }
        };
    }
}

