/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RecordId {
    private static final String GENERATE_ID = "*";
    private static final String DELIMITER = "-";
    private static final RecordId AUTOGENERATED = new RecordId("*"){

        @Override
        public Long getSequence() {
            return null;
        }

        @Override
        public Long getTimestamp() {
            return null;
        }

        @Override
        public boolean shouldBeAutoGenerated() {
            return true;
        }
    };
    private final String raw;

    private RecordId(String raw) {
        this.raw = raw;
    }

    public static RecordId of(@Nullable String value) {
        if (value == null || GENERATE_ID.equals(value)) {
            return RecordId.autoGenerate();
        }
        Assert.isTrue(value.contains(DELIMITER), "Invalid id format. Please use the 'millisecondsTime-sequenceNumber' format.");
        return new RecordId(value);
    }

    public static RecordId of(long millisecondsTime, long sequenceNumber) {
        return RecordId.of(millisecondsTime + DELIMITER + sequenceNumber);
    }

    public static RecordId autoGenerate() {
        return AUTOGENERATED;
    }

    @Nullable
    public Long getTimestamp() {
        return this.value(0);
    }

    @Nullable
    public Long getSequence() {
        return this.value(1);
    }

    public boolean shouldBeAutoGenerated() {
        return false;
    }

    public String getValue() {
        return this.raw;
    }

    public String toString() {
        return this.raw;
    }

    private Long value(int index) {
        return NumberUtils.parseNumber(StringUtils.split(this.raw, DELIMITER)[index], Long.class);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordId recordId = (RecordId)o;
        return ObjectUtils.nullSafeEquals(this.raw, recordId.raw);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.raw);
    }
}

