/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface ValueOperations<K, V> {
    public void set(K var1, V var2);

    public void set(K var1, V var2, long var3, TimeUnit var5);

    default public void set(K key, V value, Duration timeout) {
        Assert.notNull((Object)timeout, "Timeout must not be null!");
        if (TimeoutUtils.hasMillis(timeout)) {
            this.set(key, value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        } else {
            this.set(key, value, timeout.getSeconds(), TimeUnit.SECONDS);
        }
    }

    @Nullable
    public Boolean setIfAbsent(K var1, V var2);

    @Nullable
    public Boolean setIfAbsent(K var1, V var2, long var3, TimeUnit var5);

    @Nullable
    default public Boolean setIfAbsent(K key, V value, Duration timeout) {
        Assert.notNull((Object)timeout, "Timeout must not be null!");
        if (TimeoutUtils.hasMillis(timeout)) {
            return this.setIfAbsent(key, value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return this.setIfAbsent(key, value, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    @Nullable
    public Boolean setIfPresent(K var1, V var2);

    @Nullable
    public Boolean setIfPresent(K var1, V var2, long var3, TimeUnit var5);

    @Nullable
    default public Boolean setIfPresent(K key, V value, Duration timeout) {
        Assert.notNull((Object)timeout, "Timeout must not be null!");
        if (TimeoutUtils.hasMillis(timeout)) {
            return this.setIfPresent(key, value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return this.setIfPresent(key, value, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    public void multiSet(Map<? extends K, ? extends V> var1);

    @Nullable
    public Boolean multiSetIfAbsent(Map<? extends K, ? extends V> var1);

    @Nullable
    public V get(Object var1);

    @Nullable
    public V getAndDelete(K var1);

    @Nullable
    public V getAndExpire(K var1, long var2, TimeUnit var4);

    @Nullable
    public V getAndExpire(K var1, Duration var2);

    @Nullable
    public V getAndPersist(K var1);

    @Nullable
    public V getAndSet(K var1, V var2);

    @Nullable
    public List<V> multiGet(Collection<K> var1);

    @Nullable
    public Long increment(K var1);

    @Nullable
    public Long increment(K var1, long var2);

    @Nullable
    public Double increment(K var1, double var2);

    @Nullable
    public Long decrement(K var1);

    @Nullable
    public Long decrement(K var1, long var2);

    @Nullable
    public Integer append(K var1, String var2);

    @Nullable
    public String get(K var1, long var2, long var4);

    public void set(K var1, V var2, long var3);

    @Nullable
    public Long size(K var1);

    @Nullable
    public Boolean setBit(K var1, long var2, boolean var4);

    @Nullable
    public Boolean getBit(K var1, long var2);

    @Nullable
    public List<Long> bitField(K var1, BitFieldSubCommands var2);

    public RedisOperations<K, V> getOperations();
}

