/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaSsoConfig;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.sso.SaSsoConsts;
import cn.dev33.satoken.sso.SaSsoUtil;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;

public class SaSsoHandle {
    public static Object serverRequest() {
        SaRequest req = SaHolder.getRequest();
        SaSsoConfig cfg = SaManager.getConfig().getSso();
        if (req.isPath(SaSsoConsts.Api.ssoAuth)) {
            return SaSsoHandle.ssoAuth();
        }
        if (req.isPath(SaSsoConsts.Api.ssoDoLogin)) {
            return SaSsoHandle.ssoDoLogin();
        }
        if (req.isPath(SaSsoConsts.Api.ssoCheckTicket) && cfg.isHttp.booleanValue()) {
            return SaSsoHandle.ssoCheckTicket();
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogout) && cfg.isSlo.booleanValue() && !req.hasParam(SaSsoConsts.ParamName.loginId)) {
            return SaSsoHandle.ssoServerLogoutType1();
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogout) && cfg.isHttp.booleanValue() && cfg.isSlo.booleanValue() && req.hasParam(SaSsoConsts.ParamName.loginId)) {
            return SaSsoHandle.ssoServerLogout();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public static Object ssoAuth() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoConfig cfg = SaManager.getConfig().getSso();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        if (!stpLogic.isLogin()) {
            return cfg.notLoginView.get();
        }
        String mode = req.getParam(SaSsoConsts.ParamName.mode, "");
        if (mode.equals("simple")) {
            String redirect = req.getParam(SaSsoConsts.ParamName.redirect);
            SaSsoUtil.checkRedirectUrl(redirect);
            return res.redirect(redirect);
        }
        String redirectUrl = SaSsoUtil.buildRedirectUrl(stpLogic.getLoginId(), req.getParam(SaSsoConsts.ParamName.redirect));
        return res.redirect(redirectUrl);
    }

    public static Object ssoDoLogin() {
        SaRequest req = SaHolder.getRequest();
        SaSsoConfig cfg = SaManager.getConfig().getSso();
        return cfg.doLoginHandle.apply(req.getParam(SaSsoConsts.ParamName.name), req.getParam(SaSsoConsts.ParamName.pwd));
    }

    public static Object ssoCheckTicket() {
        SaRequest req = SaHolder.getRequest();
        String ticket = req.getParam(SaSsoConsts.ParamName.ticket);
        String sloCallback = req.getParam(SaSsoConsts.ParamName.ssoLogoutCall);
        Object loginId = SaSsoUtil.checkTicket(ticket);
        SaSsoUtil.registerSloCallbackUrl(loginId, sloCallback);
        return loginId;
    }

    public static Object ssoServerLogoutType1() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        stpLogic.logout();
        return SaSsoHandle.ssoLogoutBack(req, res);
    }

    public static Object ssoServerLogout() {
        SaRequest req = SaHolder.getRequest();
        SaSsoConfig cfg = SaManager.getConfig().getSso();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        String loginId = req.getParam(SaSsoConsts.ParamName.loginId);
        String secretkey = req.getParam(SaSsoConsts.ParamName.secretkey);
        SaSsoUtil.checkSecretkey(secretkey);
        SaSsoUtil.forEachSloUrl(loginId, url -> cfg.sendHttp.apply(url));
        stpLogic.logout(loginId);
        return "ok";
    }

    public static Object clientRequest() {
        SaRequest req = SaHolder.getRequest();
        SaSsoConfig cfg = SaManager.getConfig().getSso();
        if (req.isPath(SaSsoConsts.Api.ssoLogin)) {
            return SaSsoHandle.ssoLogin();
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogout) && cfg.isSlo.booleanValue() && !cfg.isHttp.booleanValue()) {
            return SaSsoHandle.ssoLogoutType2();
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogout) && cfg.isSlo.booleanValue() && cfg.isHttp.booleanValue()) {
            return SaSsoHandle.ssoLogoutType3();
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogoutCall) && cfg.isSlo.booleanValue() && cfg.isHttp.booleanValue()) {
            return SaSsoHandle.ssoLogoutCall();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public static Object ssoLogin() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoConfig cfg = SaManager.getConfig().getSso();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        String back = req.getParam(SaSsoConsts.ParamName.back, "/");
        String ticket = req.getParam(SaSsoConsts.ParamName.ticket);
        if (stpLogic.isLogin()) {
            return res.redirect(back);
        }
        if (ticket == null) {
            String serverAuthUrl = SaSsoUtil.buildServerAuthUrl(SaHolder.getRequest().getUrl(), back);
            return res.redirect(serverAuthUrl);
        }
        Object loginId = SaSsoHandle.checkTicket(ticket, SaSsoConsts.Api.ssoLogin);
        if (cfg.ticketResultHandle != null) {
            return cfg.ticketResultHandle.apply(loginId, back);
        }
        if (loginId != null) {
            stpLogic.login(loginId);
            return res.redirect(back);
        }
        throw new SaTokenException("\u65e0\u6548ticket\uff1a" + ticket);
    }

    public static Object ssoLogoutType2() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        stpLogic.logout();
        return SaSsoHandle.ssoLogoutBack(req, res);
    }

    public static Object ssoLogoutType3() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoConfig cfg = SaManager.getConfig().getSso();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        if (!stpLogic.isLogin()) {
            return SaResult.ok();
        }
        String url = SaSsoUtil.buildSloUrl(stpLogic.getLoginId());
        String body = String.valueOf(cfg.sendHttp.apply(url));
        if (!"ok".equals(body)) {
            return SaResult.error("\u5355\u70b9\u6ce8\u9500\u5931\u8d25");
        }
        return SaSsoHandle.ssoLogoutBack(req, res);
    }

    public static Object ssoLogoutCall() {
        SaRequest req = SaHolder.getRequest();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        String loginId = req.getParam(SaSsoConsts.ParamName.loginId);
        String secretkey = req.getParam(SaSsoConsts.ParamName.secretkey);
        SaSsoUtil.checkSecretkey(secretkey);
        stpLogic.logoutByTokenValue(stpLogic.getTokenValueByLoginId(loginId));
        return "ok";
    }

    public static Object ssoLogoutBack(SaRequest req, SaResponse res) {
        String back = req.getParam(SaSsoConsts.ParamName.back);
        if (SaFoxUtil.isNotEmpty(back)) {
            if (back.equals("self")) {
                return "<script>if(document.referrer != location.href){ location.replace(document.referrer || '/'); }</script>";
            }
            return res.redirect(back);
        }
        return SaResult.ok("\u5355\u70b9\u6ce8\u9500\u6210\u529f");
    }

    public static Object checkTicket(String ticket, String currUri) {
        SaSsoConfig cfg = SaManager.getConfig().getSso();
        if (cfg.isHttp.booleanValue()) {
            String checkUrl;
            Object body;
            String ssoLogoutCall = null;
            if (cfg.isSlo.booleanValue()) {
                ssoLogoutCall = SaHolder.getRequest().getUrl().replace(currUri, SaSsoConsts.Api.ssoLogoutCall);
            }
            return SaFoxUtil.isEmpty(body = cfg.sendHttp.apply(checkUrl = SaSsoUtil.buildCheckTicketUrl(ticket, ssoLogoutCall))) ? null : body;
        }
        return SaSsoUtil.checkTicket(ticket);
    }
}

