/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.clone.CloneSupport;
import cn.hutool.core.collection.ArrayIter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;

public class Tuple
extends CloneSupport<Tuple>
implements Iterable<Object>,
Serializable {
    private static final long serialVersionUID = -7689304393482182157L;
    private final Object[] members;
    private int hashCode;
    private boolean cacheHash;

    public Tuple(Object ... members) {
        this.members = members;
    }

    public <T> T get(int index) {
        return (T)this.members[index];
    }

    public Object[] getMembers() {
        return this.members;
    }

    public Tuple setCacheHash(boolean cacheHash) {
        this.cacheHash = cacheHash;
        return this;
    }

    public int hashCode() {
        if (this.cacheHash && 0 != this.hashCode) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode(this.members);
        if (this.cacheHash) {
            this.hashCode = result;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return false != Arrays.deepEquals(this.members, other.members);
    }

    public String toString() {
        return Arrays.toString(this.members);
    }

    @Override
    public Iterator<Object> iterator() {
        return new ArrayIter<Object>(this.members);
    }
}

