/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.auth;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.AuthServiceApi;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.expander.AuthConfigExpander;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordStoredEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordTransferEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginResponse;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.jwt.api.context.JwtContext;
import cn.stylefeng.roses.kernel.jwt.api.exception.enums.JwtExceptionEnum;
import cn.stylefeng.roses.kernel.jwt.api.pojo.payload.DefaultJwtPayload;
import cn.stylefeng.roses.kernel.message.api.expander.WebSocketConfigExpander;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import cn.stylefeng.roses.kernel.system.LoginLogServiceApi;
import cn.stylefeng.roses.kernel.system.UserServiceApi;
import cn.stylefeng.roses.kernel.system.enums.UserStatusEnum;
import cn.stylefeng.roses.kernel.system.expander.SystemConfigExpander;
import cn.stylefeng.roses.kernel.system.pojo.user.UserLoginInfoDTO;
import cn.stylefeng.roses.kernel.validator.CaptchaApi;
import cn.stylefeng.roses.kernel.validator.exception.enums.ValidatorExceptionEnum;
import io.jsonwebtoken.JwtException;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthServiceApi {
    private static final Object SESSION_OPERATE_LOCK = new Object();
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private PasswordStoredEncryptApi passwordStoredEncryptApi;
    @Resource
    private PasswordTransferEncryptApi passwordTransferEncryptApi;
    @Resource
    private LoginLogServiceApi loginLogServiceApi;
    @Resource
    private CaptchaApi captchaApi;

    public LoginResponse login(LoginRequest loginRequest) {
        return this.loginAction(loginRequest, true);
    }

    public LoginResponse loginWithUserName(String username) {
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setAccount(username);
        return this.loginAction(new LoginRequest(), false);
    }

    public void logout() {
        String token = LoginContext.me().getToken();
        if (StrUtil.isNotEmpty((CharSequence)token)) {
            this.loginLogServiceApi.loginOutSuccess(LoginContext.me().getLoginUser().getUserId());
        }
        this.logoutWithToken(token);
        this.sessionManagerApi.destroySessionCookie();
    }

    public void logoutWithToken(String token) {
        this.sessionManagerApi.removeSession(token);
    }

    public void validateToken(String token) throws AuthException {
        try {
            JwtContext.me().validateTokenWithException(token);
            LoginUser session = this.sessionManagerApi.getSession(token);
            if (session == null) {
                throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.AUTH_EXPIRED_ERROR);
            }
        }
        catch (cn.stylefeng.roses.kernel.jwt.api.exception.JwtException jwtException) {
            if (JwtExceptionEnum.JWT_EXPIRED_ERROR.getErrorCode().equals(jwtException.getErrorCode())) {
                throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.AUTH_EXPIRED_ERROR);
            }
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_PARSE_ERROR);
        }
        catch (JwtException jwtSelfException) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_PARSE_ERROR);
        }
    }

    public void checkAuth(String token, String requestUrl) {
        if (StrUtil.isEmpty((CharSequence)token)) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_GET_ERROR);
        }
        this.validateToken(token);
        DefaultJwtPayload defaultPayload = JwtContext.me().getDefaultPayload(token);
        Boolean rememberMe = defaultPayload.getRememberMe();
        LoginUser loginUser = this.sessionManagerApi.getSession(token);
        if (rememberMe.booleanValue() && loginUser == null) {
            UserLoginInfoDTO userLoginInfo = this.userServiceApi.getUserLoginInfo(defaultPayload.getAccount());
            this.sessionManagerApi.createSession(token, userLoginInfo.getLoginUser());
        }
        if (loginUser == null) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.AUTH_EXPIRED_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginResponse loginAction(LoginRequest loginRequest, Boolean validatePassword) {
        Boolean checkResult;
        if (validatePassword.booleanValue()) {
            if (loginRequest == null || StrUtil.hasBlank((CharSequence[])new CharSequence[]{loginRequest.getAccount(), loginRequest.getPassword()})) {
                throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.PARAM_EMPTY);
            }
        } else if (loginRequest == null || StrUtil.hasBlank((CharSequence[])new CharSequence[]{loginRequest.getAccount()})) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.ACCOUNT_IS_BLANK);
        }
        if (SystemConfigExpander.getCaptchaOpen().booleanValue()) {
            String verKey = loginRequest.getVerKey();
            String verCode = loginRequest.getVerCode();
            if (StrUtil.isEmpty((CharSequence)verKey) || StrUtil.isEmpty((CharSequence)verCode)) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.CAPTCHA_EMPTY);
            }
            if (!this.captchaApi.validateCaptcha(verKey, verCode)) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.CAPTCHA_ERROR);
            }
        }
        UserLoginInfoDTO userValidateInfo = this.userServiceApi.getUserLoginInfo(loginRequest.getAccount());
        if (validatePassword.booleanValue() && !(checkResult = this.passwordStoredEncryptApi.checkPassword(loginRequest.getPassword(), userValidateInfo.getUserPasswordHexed())).booleanValue()) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.USERNAME_PASSWORD_ERROR);
        }
        if (!UserStatusEnum.ENABLE.getCode().equals(userValidateInfo.getUserStatus())) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.USER_STATUS_ERROR, new Object[]{UserStatusEnum.getCodeMessage((Integer)userValidateInfo.getUserStatus())});
        }
        LoginUser loginUser = userValidateInfo.getLoginUser();
        DefaultJwtPayload defaultJwtPayload = new DefaultJwtPayload(loginUser.getUserId(), loginUser.getAccount(), loginRequest.getRememberMe().booleanValue());
        String jwtToken = JwtContext.me().generateTokenDefaultPayload(defaultJwtPayload);
        Object object = SESSION_OPERATE_LOCK;
        synchronized (object) {
            loginUser.setWsUrl(WebSocketConfigExpander.getWebSocketWsUrl());
            this.sessionManagerApi.createSession(jwtToken, loginUser);
            if (AuthConfigExpander.getSingleAccountLoginFlag()) {
                this.sessionManagerApi.removeSessionExcludeToken(jwtToken);
            }
        }
        String ip = HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest());
        this.userServiceApi.updateUserLoginInfo(loginUser.getUserId(), new Date(), ip);
        this.loginLogServiceApi.loginSuccess(loginUser.getUserId());
        return new LoginResponse(loginUser, jwtToken, defaultJwtPayload.getExpirationDate());
    }
}

