/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.auth;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.LoginUserApi;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.expander.AuthConfigExpander;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class LoginUserImpl
implements LoginUserApi {
    @Resource
    private SessionManagerApi sessionManagerApi;

    public String getToken() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        String parameterToken = request.getParameter(AuthConfigExpander.getAuthTokenParamName());
        if (StrUtil.isNotBlank((CharSequence)parameterToken)) {
            return parameterToken;
        }
        String authToken = request.getHeader(AuthConfigExpander.getAuthTokenHeaderName());
        if (StrUtil.isNotBlank((CharSequence)authToken)) {
            return authToken;
        }
        if (AuthConfigExpander.getSessionAddToCookie().booleanValue()) {
            String sessionCookieName = AuthConfigExpander.getSessionCookieName();
            Cookie[] cookies = request.getCookies();
            if (cookies != null && cookies.length > 0) {
                for (Cookie cookie : cookies) {
                    if (!sessionCookieName.equals(cookie.getName()) || !StrUtil.isNotBlank((CharSequence)cookie.getValue())) continue;
                    return cookie.getValue();
                }
            }
        }
        throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_GET_ERROR);
    }

    public LoginUser getLoginUser() throws AuthException {
        String token = this.getToken();
        LoginUser session = this.sessionManagerApi.getSession(token);
        if (session == null) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_GET_ERROR);
        }
        return session;
    }

    public LoginUser getLoginUserNullable() {
        String token = null;
        try {
            token = this.getToken();
        }
        catch (Exception e) {
            return null;
        }
        return this.sessionManagerApi.getSession(token);
    }

    public boolean getSuperAdminFlag() {
        LoginUser loginUser = this.getLoginUser();
        return loginUser.getSuperAdmin();
    }

    public boolean hasLogin() {
        String token = null;
        try {
            token = this.getToken();
        }
        catch (Exception e) {
            return false;
        }
        return this.sessionManagerApi.haveSession(token);
    }

    public boolean haveButton(String buttonCode) {
        LoginUser loginUser = this.getLoginUser();
        if (loginUser.getButtonCodes() == null) {
            return false;
        }
        return loginUser.getButtonCodes().contains(buttonCode);
    }
}

