/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.config.modular.listener;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.handler.EntityListHandler;
import cn.hutool.db.handler.RsHandler;
import cn.hutool.db.sql.SqlExecutor;
import cn.stylefeng.roses.kernel.config.ConfigContainer;
import cn.stylefeng.roses.kernel.config.api.ConfigApi;
import cn.stylefeng.roses.kernel.config.api.context.ConfigContext;
import cn.stylefeng.roses.kernel.config.api.exception.ConfigException;
import cn.stylefeng.roses.kernel.config.api.exception.enums.ConfigExceptionEnum;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class ConfigInitListener
implements ApplicationListener<ApplicationContextInitializedEvent>,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ConfigInitListener.class);
    private static final String CONFIG_LIST_SQL = "select config_code, config_value from sys_config where status_flag = ? and del_flag = ?";

    public int getOrder() {
        return -2147483548;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onApplicationEvent(ApplicationContextInitializedEvent applicationContextInitializedEvent) {
        ConfigurableApplicationContext applicationContext = applicationContextInitializedEvent.getApplicationContext();
        if (applicationContext instanceof AnnotationConfigApplicationContext) {
            return;
        }
        ConfigContext.setConfigApi((ConfigApi)new ConfigContainer());
        ConfigurableEnvironment environment = applicationContextInitializedEvent.getApplicationContext().getEnvironment();
        String dataSourceUrl = environment.getProperty("spring.datasource.url");
        String dataSourceUsername = environment.getProperty("spring.datasource.username");
        String dataSourcePassword = environment.getProperty("spring.datasource.password");
        if (ObjectUtil.hasEmpty((Object[])new Object[]{dataSourceUrl, dataSourceUsername, dataSourcePassword})) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.APP_DB_CONFIG_ERROR);
        }
        Connection conn = null;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            assert (dataSourceUrl != null);
            conn = DriverManager.getConnection(dataSourceUrl, dataSourceUsername, dataSourcePassword);
            List entityList = (List)SqlExecutor.query((Connection)conn, (String)CONFIG_LIST_SQL, (RsHandler)new EntityListHandler(), (Object[])new Object[]{StatusEnum.ENABLE.getCode(), YesOrNotEnum.N.getCode()});
            if (ObjectUtil.isNotEmpty((Object)entityList)) {
                entityList.forEach(sysConfig -> ConfigContext.me().putConfig(sysConfig.getStr("config_code"), (Object)sysConfig.getStr("config_value")));
            }
        }
        catch (ClassNotFoundException e) {
            try {
                log.error("\u521d\u59cb\u5316\u7cfb\u7edf\u914d\u7f6e\u8868\u5931\u8d25\uff0c\u627e\u4e0d\u5230com.mysql.cj.jdbc.Driver\u7c7b", (Throwable)e);
                throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CLASS_NOT_FOUND_ERROR);
                catch (SQLException sqlException) {
                    log.error("\u521d\u59cb\u5316\u7cfb\u7edf\u914d\u7f6e\u8868\u5931\u8d25\uff0c\u6267\u884c\u67e5\u8be2\u8bed\u53e5\u5931\u8d25", (Throwable)sqlException);
                    throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_SQL_EXE_ERROR);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close((Object[])new Object[]{conn});
                throw throwable;
            }
        }
        DbUtil.close((Object[])new Object[]{conn});
    }
}

