/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.config.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.config.api.context.ConfigContext;
import cn.stylefeng.roses.kernel.config.api.exception.ConfigException;
import cn.stylefeng.roses.kernel.config.api.exception.enums.ConfigExceptionEnum;
import cn.stylefeng.roses.kernel.config.modular.entity.SysConfig;
import cn.stylefeng.roses.kernel.config.modular.mapper.SysConfigMapper;
import cn.stylefeng.roses.kernel.config.modular.param.SysConfigParam;
import cn.stylefeng.roses.kernel.config.modular.service.SysConfigService;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysConfigServiceImpl
extends ServiceImpl<SysConfigMapper, SysConfig>
implements SysConfigService {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = new SysConfig();
        BeanUtil.copyProperties((Object)((Object)sysConfigParam), (Object)((Object)sysConfig), (String[])new String[0]);
        sysConfig.setStatusFlag(StatusEnum.ENABLE.getCode());
        this.save((Object)sysConfig);
        ConfigContext.me().putConfig(sysConfigParam.getConfigCode(), (Object)sysConfigParam.getConfigValue());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = this.querySysConfig(sysConfigParam);
        if (sysConfig == null) {
            String userTip = StrUtil.format((CharSequence)ConfigExceptionEnum.CONFIG_NOT_EXIST.getUserTip(), (Object[])new Object[]{"id: " + sysConfigParam.getConfigId()});
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_NOT_EXIST, userTip);
        }
        if (YesOrNotEnum.Y.getCode().equals(sysConfig.getSysFlag())) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_SYS_CAN_NOT_DELETE);
        }
        sysConfig.setStatusFlag(StatusEnum.DISABLE.getCode());
        sysConfig.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)sysConfig);
        ConfigContext.me().deleteConfig(sysConfigParam.getConfigCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = this.querySysConfig(sysConfigParam);
        BeanUtil.copyProperties((Object)((Object)sysConfigParam), (Object)((Object)sysConfig), (String[])new String[0]);
        sysConfig.setStatusFlag(null);
        this.updateById((Object)sysConfig);
        ConfigContext.me().putConfig(sysConfigParam.getConfigCode(), (Object)sysConfigParam.getConfigValue());
    }

    @Override
    public SysConfig detail(SysConfigParam sysConfigParam) {
        return this.querySysConfig(sysConfigParam);
    }

    @Override
    public PageResult<SysConfig> findPage(SysConfigParam sysConfigParam) {
        LambdaQueryWrapper<SysConfig> wrapper = this.createWrapper(sysConfigParam);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<SysConfig> findList(SysConfigParam sysConfigParam) {
        LambdaQueryWrapper<SysConfig> wrapper = this.createWrapper(sysConfigParam);
        return this.list((Wrapper)wrapper);
    }

    private SysConfig querySysConfig(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = (SysConfig)((Object)this.getById(sysConfigParam.getConfigId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysConfig)) || sysConfig.getDelFlag().equals(YesOrNotEnum.Y.getCode())) {
            String userTip = StrUtil.format((CharSequence)ConfigExceptionEnum.CONFIG_NOT_EXIST.getUserTip(), (Object[])new Object[]{"id: " + sysConfigParam.getConfigId()});
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_NOT_EXIST, userTip);
        }
        return sysConfig;
    }

    private LambdaQueryWrapper<SysConfig> createWrapper(SysConfigParam sysConfigParam) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(SysConfig::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        queryWrapper.orderByDesc(SysConfig::getGroupCode);
        if (ObjectUtil.isEmpty((Object)((Object)sysConfigParam))) {
            return queryWrapper;
        }
        String configName = sysConfigParam.getConfigName();
        String configCode = sysConfigParam.getConfigCode();
        String groupCode = sysConfigParam.getGroupCode();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)configName), SysConfig::getConfigName, (Object)configName);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)configCode), SysConfig::getConfigCode, (Object)configCode);
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)groupCode), SysConfig::getGroupCode, (Object)groupCode);
        return queryWrapper;
    }
}

