/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dict.modular.controller;

import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDict;
import cn.stylefeng.roses.kernel.dict.modular.pojo.TreeDictInfo;
import cn.stylefeng.roses.kernel.dict.modular.pojo.request.DictRequest;
import cn.stylefeng.roses.kernel.dict.modular.service.DictService;
import cn.stylefeng.roses.kernel.resource.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.resource.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.resource.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u5b57\u5178\u8be6\u60c5\u7ba1\u7406")
public class DictController {
    @Resource
    private DictService dictService;

    @PostResource(name="\u6dfb\u52a0\u5b57\u5178", path={"/dict/addDict"}, requiredPermission=false)
    public ResponseData addDict(@RequestBody @Validated(value={BaseRequest.add.class}) DictRequest dictRequest) {
        this.dictService.add(dictRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u5220\u9664\u5b57\u5178", path={"/dict/deleteDict"}, requiredPermission=false)
    public ResponseData deleteDict(@RequestBody @Validated(value={BaseRequest.delete.class}) DictRequest dictRequest) {
        this.dictService.del(dictRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u4fee\u6539\u5b57\u5178", path={"/dict/updateDict"}, requiredPermission=false)
    public ResponseData updateDict(@RequestBody @Validated(value={BaseRequest.edit.class}) DictRequest dictRequest) {
        this.dictService.edit(dictRequest);
        return new SuccessResponseData();
    }

    @GetResource(name="\u83b7\u53d6\u5b57\u5178\u8be6\u60c5", path={"/dict/getDictDetail"}, requiredPermission=false)
    public ResponseData getDictDetail(@RequestParam(value="dictId") Long dictId) {
        SysDict detail = this.dictService.detail(dictId);
        return new SuccessResponseData((Object)detail);
    }

    @GetResource(name="\u83b7\u53d6\u5b57\u5178\u5217\u8868", path={"/dict/getDictList"}, requiredPermission=false)
    public ResponseData getDictList(DictRequest dictRequest) {
        List<SysDict> sysDictList = this.dictService.findList(dictRequest);
        return new SuccessResponseData(sysDictList);
    }

    @GetResource(name="\u83b7\u53d6\u5b57\u5178\u5217\u8868", path={"/dict/getDictListPage"}, requiredPermission=false)
    public ResponseData getDictListPage(DictRequest dictRequest) {
        PageResult<SysDict> page = this.dictService.findPage(dictRequest);
        return new SuccessResponseData(page);
    }

    @GetResource(name="\u83b7\u53d6\u5b57\u5178\u5217\u8868(\u6392\u9664\u4e0b\u7ea7)", path={"/dict/getDictListExcludeSub"}, requiredPermission=false)
    public ResponseData getDictListExcludeSub(@RequestParam(value="dictId", required=false) Long dictId) {
        List<SysDict> sysDictList = this.dictService.getDictListExcludeSub(dictId);
        return new SuccessResponseData(sysDictList);
    }

    @GetResource(name="\u83b7\u53d6\u6811\u5f62\u5b57\u5178\u5217\u8868", path={"/dict/getDictTreeList"}, requiredPermission=false)
    public ResponseData getDictTreeList(@Validated(value={DictRequest.treeList.class}) DictRequest dictRequest) {
        List<TreeDictInfo> treeDictList = this.dictService.getTreeDictList(dictRequest);
        return new SuccessResponseData(treeDictList);
    }

    @GetResource(name="code\u6821\u9a8c", path={"/dict/validateCodeAvailable"}, requiredPermission=false)
    public ResponseData validateCodeAvailable(@Validated(value={DictRequest.validateAvailable.class}) DictRequest dictRequest) {
        boolean flag = this.dictService.validateCodeAvailable(dictRequest);
        return new SuccessResponseData((Object)flag);
    }

    @GetResource(name="\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u5206\u7ec4\u5b57\u5178\u5217\u8868", path={"/dict/getConfigGroupPage"}, requiredPermission=false)
    public ResponseData getConfigGroupPage(DictRequest dictRequest) {
        dictRequest.setDictTypeCode("config_group");
        PageResult<SysDict> page = this.dictService.findPage(dictRequest);
        return new SuccessResponseData(page);
    }

    @GetResource(name="\u83b7\u53d6\u591a\u8bed\u8a00\u5b57\u5178\u5217\u8868", path={"/dict/getLanguagesPage"}, requiredPermission=false)
    public ResponseData getLanguagesPage(DictRequest dictRequest) {
        dictRequest.setDictTypeCode("languages");
        PageResult<SysDict> page = this.dictService.findPage(dictRequest);
        return new SuccessResponseData(page);
    }
}

