/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dict.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dict.api.constants.DictConstants;
import cn.stylefeng.roses.kernel.dict.api.exception.DictException;
import cn.stylefeng.roses.kernel.dict.api.exception.enums.DictExceptionEnum;
import cn.stylefeng.roses.kernel.dict.api.pojo.dict.request.ParentIdsUpdateRequest;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDict;
import cn.stylefeng.roses.kernel.dict.modular.mapper.DictMapper;
import cn.stylefeng.roses.kernel.dict.modular.pojo.TreeDictInfo;
import cn.stylefeng.roses.kernel.dict.modular.pojo.request.DictRequest;
import cn.stylefeng.roses.kernel.dict.modular.service.DictService;
import cn.stylefeng.roses.kernel.pinyin.api.PinYinApi;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictServiceImpl
extends ServiceImpl<DictMapper, SysDict>
implements DictService {
    private static final Logger log = LoggerFactory.getLogger(DictServiceImpl.class);
    @Resource
    private PinYinApi pinYinApi;
    @Resource
    private DictMapper dictMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(DictRequest dictRequest) {
        if (dictRequest.getDictParentId() == null) {
            dictRequest.setDictParentId(DictConstants.DEFAULT_DICT_PARENT_ID);
        } else if (!DictConstants.DEFAULT_DICT_PARENT_ID.equals(dictRequest.getDictParentId())) {
            DictRequest tempParam = new DictRequest();
            tempParam.setDictId(dictRequest.getDictParentId());
            this.querySysDict(tempParam);
        }
        this.setPids(dictRequest);
        SysDict sysDict = new SysDict();
        BeanUtil.copyProperties((Object)((Object)dictRequest), (Object)((Object)sysDict), (String[])new String[0]);
        sysDict.setDictId(null);
        sysDict.setStatusFlag(StatusEnum.ENABLE.getCode());
        sysDict.setDelFlag(YesOrNotEnum.N.getCode());
        sysDict.setDictNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(sysDict.getDictName()));
        ((DictMapper)this.baseMapper).insert((Object)sysDict);
    }

    @Override
    public void del(DictRequest dictRequest) {
        this.dictMapper.deleteSub(dictRequest.getDictId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(DictRequest dictRequest) {
        SysDict oldSysDict = this.querySysDict(dictRequest);
        dictRequest.setDictTypeCode(null);
        dictRequest.setDictCode(null);
        this.setPids(dictRequest);
        if (!oldSysDict.getDictParentId().equals(dictRequest.getDictParentId())) {
            this.updateSubPids(dictRequest, oldSysDict);
        }
        BeanUtil.copyProperties((Object)((Object)dictRequest), (Object)((Object)oldSysDict), (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
        oldSysDict.setDictNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(oldSysDict.getDictName()));
        this.updateById((Object)oldSysDict);
    }

    @Override
    public SysDict detail(Long dictId) {
        SysDict dict = ((DictMapper)this.baseMapper).detail(dictId);
        if (dict.getDictParentId().equals(TreeConstants.DEFAULT_PARENT_ID)) {
            dict.setParentName("\u9876\u7ea7");
        } else {
            SysDict parentDict = (SysDict)((Object)this.getById(dict.getDictParentId()));
            dict.setParentName(ObjectUtil.isNotEmpty((Object)((Object)parentDict)) ? parentDict.getDictName() : "");
        }
        return dict;
    }

    @Override
    public List<SysDict> findList(DictRequest dictRequest) {
        if (dictRequest == null) {
            dictRequest = new DictRequest();
        }
        return ((DictMapper)this.baseMapper).findPage(null, dictRequest);
    }

    @Override
    public PageResult<SysDict> findPage(DictRequest dictRequest) {
        if (dictRequest == null) {
            dictRequest = new DictRequest();
        }
        Page page = PageFactory.defaultPage();
        List<SysDict> list = ((DictMapper)this.baseMapper).findPage((Page<SysDict>)page, dictRequest);
        page.setRecords(list);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<SysDict> getDictListExcludeSub(Long dictId) {
        if (dictId != null) {
            return this.dictMapper.getDictListExcludeSub(dictId);
        }
        return this.list();
    }

    @Override
    public List<TreeDictInfo> getTreeDictList(DictRequest dictRequest) {
        List<SysDict> sysDictList = this.findList(dictRequest);
        if (sysDictList == null || sysDictList.isEmpty()) {
            return new ArrayList<TreeDictInfo>();
        }
        ArrayList<TreeDictInfo> treeDictInfos = new ArrayList<TreeDictInfo>();
        for (SysDict sysDict : sysDictList) {
            TreeDictInfo treeDictInfo = new TreeDictInfo();
            treeDictInfo.setDictId(sysDict.getDictId());
            treeDictInfo.setDictCode(sysDict.getDictCode());
            treeDictInfo.setDictParentId(sysDict.getDictParentId());
            treeDictInfo.setDictName(sysDict.getDictName());
            treeDictInfos.add(treeDictInfo);
        }
        return new DefaultTreeBuildFactory().doTreeBuild(treeDictInfos);
    }

    @Override
    public boolean validateCodeAvailable(DictRequest dictRequest) {
        int codeCount;
        LambdaQueryWrapper codeRepeatWrapper = new LambdaQueryWrapper();
        codeRepeatWrapper.eq(SysDict::getDictCode, (Object)dictRequest.getDictCode());
        if (ObjectUtil.isNotEmpty((Object)dictRequest.getDictId())) {
            codeRepeatWrapper.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.ne(SysDict::getDictId, (Object)dictRequest.getDictId());
            });
        }
        return (codeCount = ((DictMapper)this.baseMapper).selectCount((Wrapper)codeRepeatWrapper).intValue()) <= 0;
    }

    public String getDictName(String dictTypeCode, String dictCode) {
        LambdaQueryWrapper sysDictLambdaQueryWrapper = new LambdaQueryWrapper();
        sysDictLambdaQueryWrapper.eq(SysDict::getDictTypeCode, (Object)dictTypeCode);
        sysDictLambdaQueryWrapper.eq(SysDict::getDictCode, (Object)dictCode);
        sysDictLambdaQueryWrapper.ne(SysDict::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        List list = this.list((Wrapper)sysDictLambdaQueryWrapper);
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() > 1) {
            log.error(DictExceptionEnum.DICT_CODE_REPEAT.getUserTip(), (Object)"", (Object)dictCode);
            return "";
        }
        String dictName = ((SysDict)((Object)list.get(0))).getDictName();
        if (dictName != null) {
            return dictName;
        }
        return "";
    }

    public List<SimpleDict> getDictDetailsByDictTypeCode(String dictTypeCode) {
        DictRequest dictRequest = new DictRequest();
        dictRequest.setDictTypeCode(dictTypeCode);
        LambdaQueryWrapper<SysDict> wrapper = this.createWrapper(dictRequest);
        List dictList = this.list((Wrapper)wrapper);
        if (dictList.isEmpty()) {
            return new ArrayList<SimpleDict>();
        }
        ArrayList<SimpleDict> simpleDictList = new ArrayList<SimpleDict>();
        for (SysDict sysDict : dictList) {
            SimpleDict simpleDict = new SimpleDict();
            simpleDict.setCode(sysDict.getDictCode());
            simpleDict.setName(sysDict.getDictName());
            simpleDictList.add(simpleDict);
        }
        return simpleDictList;
    }

    public void deleteByDictId(Long dictId) {
        this.removeById(dictId);
    }

    private static ParentIdsUpdateRequest createParenIdsUpdateRequest(String newParentIds, String oldParentIds) {
        ParentIdsUpdateRequest parentIdsUpdateRequest = new ParentIdsUpdateRequest();
        parentIdsUpdateRequest.setNewParentIds(newParentIds);
        parentIdsUpdateRequest.setOldParentIds(oldParentIds);
        parentIdsUpdateRequest.setUpdateTime(new Date());
        parentIdsUpdateRequest.setUpdateUser(LoginContext.me().getLoginUser().getUserId());
        return parentIdsUpdateRequest;
    }

    private void updateSubPids(DictRequest dictRequest, SysDict oldSysDict) {
        String beReplacedRegex = oldSysDict.getDictPids() + "[" + oldSysDict.getDictId() + "]" + ",";
        String newReplace = dictRequest.getDictPids();
        ParentIdsUpdateRequest parentIdsUpdateRequest = DictServiceImpl.createParenIdsUpdateRequest(newReplace, beReplacedRegex);
        this.dictMapper.updateSubPids(parentIdsUpdateRequest);
    }

    private void setPids(DictRequest dictRequest) {
        Long dictParentId = dictRequest.getDictParentId();
        if (DictConstants.DEFAULT_DICT_PARENT_ID.equals(dictParentId)) {
            String pids = "[" + DictConstants.DEFAULT_DICT_PARENT_ID + "]" + ",";
            dictRequest.setDictPids(pids);
        } else {
            SysDict parentSysDict = (SysDict)((Object)this.dictMapper.selectById(dictParentId));
            if (parentSysDict != null) {
                String pids = parentSysDict.getDictPids() + "[" + dictRequest.getDictParentId() + "]" + ",";
                dictRequest.setDictPids(pids);
            }
        }
    }

    private SysDict querySysDict(DictRequest dictRequest) {
        SysDict sysDict = (SysDict)((Object)this.getById(dictRequest.getDictId()));
        if (ObjectUtil.isNull((Object)((Object)sysDict))) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.DICT_NOT_EXISTED, new Object[]{dictRequest.getDictId()});
        }
        return sysDict;
    }

    private LambdaQueryWrapper<SysDict> createWrapper(DictRequest dictRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)dictRequest.getDictTypeCode()), SysDict::getDictTypeCode, (Object)dictRequest.getDictTypeCode());
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)dictRequest.getDictCode()), SysDict::getDictCode, (Object)dictRequest.getDictCode());
        queryWrapper.like(StrUtil.isNotBlank((CharSequence)dictRequest.getDictName()), SysDict::getDictName, (Object)dictRequest.getDictName());
        queryWrapper.ne(SysDict::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        return queryWrapper;
    }
}

