/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dict.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dict.api.enums.DictTypeClassEnum;
import cn.stylefeng.roses.kernel.dict.api.exception.DictException;
import cn.stylefeng.roses.kernel.dict.api.exception.enums.DictExceptionEnum;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDict;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDictType;
import cn.stylefeng.roses.kernel.dict.modular.mapper.DictTypeMapper;
import cn.stylefeng.roses.kernel.dict.modular.pojo.request.DictTypeRequest;
import cn.stylefeng.roses.kernel.dict.modular.service.DictService;
import cn.stylefeng.roses.kernel.dict.modular.service.DictTypeService;
import cn.stylefeng.roses.kernel.pinyin.api.PinYinApi;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictTypeServiceImpl
extends ServiceImpl<DictTypeMapper, SysDictType>
implements DictTypeService {
    @Resource
    private DictService dictService;
    @Resource
    private PinYinApi pinYinApi;

    @Override
    public void add(DictTypeRequest dictTypeRequest) {
        this.validateSystemTypeClassOperate(dictTypeRequest);
        SysDictType sysDictType = new SysDictType();
        BeanUtil.copyProperties((Object)((Object)dictTypeRequest), (Object)((Object)sysDictType), (String[])new String[0]);
        sysDictType.setStatusFlag(StatusEnum.ENABLE.getCode());
        sysDictType.setDelFlag(YesOrNotEnum.N.getCode());
        sysDictType.setDictTypeNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(sysDictType.getDictTypeName()));
        ((DictTypeMapper)this.baseMapper).insert((Object)sysDictType);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(DictTypeRequest dictTypeRequest) {
        this.validateSystemTypeClassOperate(dictTypeRequest);
        SysDictType oldSysDictType = this.querySysDictType(dictTypeRequest);
        oldSysDictType.setDelFlag(YesOrNotEnum.Y.getCode());
        ((DictTypeMapper)this.baseMapper).updateById((Object)oldSysDictType);
        LambdaUpdateWrapper lambdaQueryWrapper = new LambdaUpdateWrapper();
        lambdaQueryWrapper.eq(SysDict::getDictTypeCode, (Object)oldSysDictType.getDictTypeCode());
        lambdaQueryWrapper.set(SysDict::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        this.dictService.update((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public void edit(DictTypeRequest dictTypeRequest) {
        this.validateSystemTypeClassOperate(dictTypeRequest);
        SysDictType oldSysDictType = this.querySysDictType(dictTypeRequest);
        BeanUtil.copyProperties((Object)((Object)dictTypeRequest), (Object)((Object)oldSysDictType), (String[])new String[0]);
        oldSysDictType.setDictTypeCode(null);
        oldSysDictType.setDictTypeNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(oldSysDictType.getDictTypeName()));
        this.updateById((Object)oldSysDictType);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editStatus(DictTypeRequest dictTypeRequest) {
        this.validateSystemTypeClassOperate(dictTypeRequest);
        SysDictType oldSysDictType = this.querySysDictType(dictTypeRequest);
        oldSysDictType.setStatusFlag(dictTypeRequest.getStatusFlag());
        LambdaUpdateWrapper lambdaQueryWrapper = new LambdaUpdateWrapper();
        lambdaQueryWrapper.eq(SysDict::getDictTypeCode, (Object)oldSysDictType.getDictTypeCode());
        lambdaQueryWrapper.eq(SysDict::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        lambdaQueryWrapper.set(SysDict::getStatusFlag, (Object)dictTypeRequest.getStatusFlag());
        this.dictService.update((Wrapper)lambdaQueryWrapper);
        this.updateById((Object)oldSysDictType);
    }

    @Override
    public SysDictType detail(DictTypeRequest dictTypeRequest) {
        List<SysDictType> list = this.findList(dictTypeRequest);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<SysDictType> findList(DictTypeRequest dictTypeRequest) {
        LambdaQueryWrapper<SysDictType> queryWrapper = this.createWrapper(dictTypeRequest);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public PageResult<SysDictType> findPage(DictTypeRequest dictTypeRequest) {
        LambdaQueryWrapper<SysDictType> queryWrapper = this.createWrapper(dictTypeRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)queryWrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public boolean validateCodeAvailable(DictTypeRequest dictTypeRequest) {
        Integer selectCount;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysDictType::getDictTypeCode, (Object)dictTypeRequest.getDictTypeCode());
        if (ObjectUtil.isNotEmpty((Object)dictTypeRequest.getDictTypeId())) {
            wrapper.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.ne(SysDictType::getDictTypeId, (Object)dictTypeRequest.getDictTypeId());
            });
        }
        return (selectCount = ((DictTypeMapper)this.baseMapper).selectCount((Wrapper)wrapper)) <= 0;
    }

    private void validateSystemTypeClassOperate(DictTypeRequest dictTypeRequest) {
        if (DictTypeClassEnum.SYSTEM_TYPE.getCode().equals(dictTypeRequest.getDictTypeClass()) && !LoginContext.me().getSuperAdminFlag()) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.SYSTEM_DICT_NOT_ALLOW_OPERATION);
        }
    }

    private SysDictType querySysDictType(DictTypeRequest dictTypeRequest) {
        SysDictType sysDictType = (SysDictType)((Object)this.getById(dictTypeRequest.getDictTypeId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysDictType))) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.DICT_TYPE_NOT_EXISTED, new Object[]{dictTypeRequest.getDictTypeId()});
        }
        return sysDictType;
    }

    private LambdaQueryWrapper<SysDictType> createWrapper(DictTypeRequest translationRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysDictType::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        if (ObjectUtil.isEmpty((Object)((Object)translationRequest))) {
            return queryWrapper;
        }
        Long dictTypeId = translationRequest.getDictTypeId();
        String dictTypeCode = translationRequest.getDictTypeCode();
        String dictTypeName = translationRequest.getDictTypeName();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)dictTypeId), SysDictType::getDictTypeId, (Object)dictTypeId);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)dictTypeCode), SysDictType::getDictTypeCode, (Object)dictTypeCode);
        queryWrapper.like(ObjectUtil.isNotNull((Object)dictTypeName), SysDictType::getDictTypeName, (Object)dictTypeName);
        return queryWrapper;
    }
}

