/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.db.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.exception.LogException;
import cn.stylefeng.roses.kernel.log.api.exception.enums.LogExceptionEnum;
import cn.stylefeng.roses.kernel.log.api.pojo.manage.LogManagerRequest;
import cn.stylefeng.roses.kernel.log.db.entity.SysLog;
import cn.stylefeng.roses.kernel.log.db.mapper.SysLogMapper;
import cn.stylefeng.roses.kernel.log.db.service.SysLogService;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysLogServiceImpl
extends ServiceImpl<SysLogMapper, SysLog>
implements SysLogService {
    @Override
    public void add(LogManagerRequest logManagerRequest) {
        SysLog sysLog = new SysLog();
        BeanUtil.copyProperties((Object)logManagerRequest, (Object)((Object)sysLog), (String[])new String[0]);
        this.save((Object)sysLog);
    }

    @Override
    public void del(LogManagerRequest logManagerRequest) {
        SysLog sysLog = this.querySysLogById(logManagerRequest);
        this.removeById(sysLog.getLogId());
    }

    @Override
    public void delAll(LogManagerRequest logManagerRequest) {
        this.remove(null);
    }

    @Override
    public SysLog detail(LogManagerRequest logManagerRequest) {
        LambdaQueryWrapper<SysLog> queryWrapper = this.createWrapper(logManagerRequest);
        return (SysLog)((Object)this.getOne((Wrapper)queryWrapper, false));
    }

    @Override
    public List<SysLog> findList(LogManagerRequest logManagerRequest) {
        LambdaQueryWrapper<SysLog> wrapper = this.createWrapper(logManagerRequest);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public PageResult<SysLog> findPage(LogManagerRequest logManagerRequest) {
        LambdaQueryWrapper<SysLog> wrapper = this.createWrapper(logManagerRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    private SysLog querySysLogById(LogManagerRequest logManagerRequest) {
        SysLog sysLog = (SysLog)((Object)this.getById(logManagerRequest.getLogId()));
        if (sysLog == null) {
            throw new LogException((AbstractExceptionEnum)LogExceptionEnum.LOG_NOT_EXISTED, new Object[]{logManagerRequest.getLogId()});
        }
        return sysLog;
    }

    private LambdaQueryWrapper<SysLog> createWrapper(LogManagerRequest logManagerRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        if (ObjectUtil.isEmpty((Object)logManagerRequest)) {
            return queryWrapper;
        }
        String beginDateTime = logManagerRequest.getBeginDateTime();
        String endDateTime = logManagerRequest.getEndDateTime();
        String name = logManagerRequest.getLogName();
        String appName = logManagerRequest.getAppName();
        String serverIp = logManagerRequest.getServerIp();
        Long userId = logManagerRequest.getUserId();
        String clientIp = logManagerRequest.getClientIp();
        String url = logManagerRequest.getRequestUrl();
        queryWrapper.between(!StrUtil.isAllBlank((CharSequence[])new CharSequence[]{beginDateTime, endDateTime}), BaseEntity::getCreateTime, (Object)beginDateTime, (Object)endDateTime);
        queryWrapper.eq(StrUtil.isNotEmpty((CharSequence)name), SysLog::getLogName, (Object)name);
        queryWrapper.eq(StrUtil.isNotEmpty((CharSequence)appName), SysLog::getAppName, (Object)appName);
        queryWrapper.eq(StrUtil.isNotEmpty((CharSequence)serverIp), SysLog::getServerIp, (Object)serverIp);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userId), SysLog::getUserId, (Object)userId);
        queryWrapper.eq(StrUtil.isNotEmpty((CharSequence)clientIp), SysLog::getClientIp, (Object)clientIp);
        queryWrapper.eq(StrUtil.isNotEmpty((CharSequence)url), SysLog::getRequestUrl, (Object)url);
        return queryWrapper;
    }
}

