/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.message.db;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.message.api.MessageApi;
import cn.stylefeng.roses.kernel.message.api.WebsocketApi;
import cn.stylefeng.roses.kernel.message.api.enums.MessageReadFlagEnum;
import cn.stylefeng.roses.kernel.message.api.exception.MessageException;
import cn.stylefeng.roses.kernel.message.api.exception.enums.MessageExceptionEnum;
import cn.stylefeng.roses.kernel.message.api.pojo.request.MessageRequest;
import cn.stylefeng.roses.kernel.message.api.pojo.request.MessageSendRequest;
import cn.stylefeng.roses.kernel.message.api.pojo.response.MessageResponse;
import cn.stylefeng.roses.kernel.message.db.entity.SysMessage;
import cn.stylefeng.roses.kernel.message.db.service.SysMessageService;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.UserServiceApi;
import cn.stylefeng.roses.kernel.system.pojo.user.request.SysUserRequest;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageDbServiceImpl
implements MessageApi {
    private static final Logger log = LoggerFactory.getLogger(MessageDbServiceImpl.class);
    @Resource
    private WebsocketApi websocketApi;
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private SysMessageService sysMessageService;

    @Transactional(rollbackFor={Exception.class})
    public void sendMessage(MessageSendRequest messageSendRequest) {
        List userIds;
        String receiveUserIds = messageSendRequest.getReceiveUserIds();
        LoginUser loginUser = LoginContext.me().getLoginUser();
        ArrayList sendMsgList = new ArrayList();
        if ("all".equals(receiveUserIds)) {
            userIds = this.userServiceApi.queryAllUserIdList(new SysUserRequest());
        } else {
            String[] userIdArr = receiveUserIds.split(",");
            userIds = Convert.toList(Long.class, (Object)userIdArr);
        }
        if (userIds == null || userIds.isEmpty()) {
            throw new MessageException((AbstractExceptionEnum)MessageExceptionEnum.ERROR_RECEIVE_USER_IDS);
        }
        HashSet userIdSet = new HashSet(userIds);
        SysMessage sysMessage = new SysMessage();
        BeanUtil.copyProperties((Object)messageSendRequest, (Object)((Object)sysMessage), (String[])new String[0]);
        sysMessage.setReadFlag(MessageReadFlagEnum.UNREAD.getCode());
        sysMessage.setSendUserId(loginUser.getUserId());
        userIdSet.forEach(userId -> {
            if (this.userServiceApi.userExist(userId).booleanValue()) {
                sysMessage.setReceiveUserId((Long)userId);
                sendMsgList.add(sysMessage);
            }
        });
        this.websocketApi.sendWebSocketMessage((List)ListUtil.toList(userIdSet), messageSendRequest);
        this.sysMessageService.saveBatch(sendMsgList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateReadFlag(MessageRequest messageRequest) {
        Long messageId = messageRequest.getMessageId();
        SysMessage sysMessage = (SysMessage)((Object)this.sysMessageService.getById(messageId));
        Optional.ofNullable(sysMessage).ifPresent(msg -> {
            msg.setReadFlag(messageRequest.getReadFlag());
            this.sysMessageService.updateById(msg);
        });
    }

    public void allMessageReadFlag() {
        LoginUser loginUser = LoginContext.me().getLoginUser();
        Long userId = loginUser.getUserId();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(SysMessage::getReadFlag, (Object)MessageReadFlagEnum.READ.getCode())).eq(SysMessage::getReadFlag, (Object)MessageReadFlagEnum.UNREAD.getCode())).eq(SysMessage::getReceiveUserId, (Object)userId)).set(SysMessage::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        this.sysMessageService.update((Wrapper)updateWrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchReadFlagByMessageIds(String messageIds, MessageReadFlagEnum flagEnum) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.inSql(SysMessage::getMessageId, messageIds)).set(SysMessage::getReadFlag, (Object)flagEnum.getCode());
        this.sysMessageService.update((Wrapper)updateWrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByMessageId(Long messageId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.eq(SysMessage::getMessageId, (Object)messageId)).set(SysMessage::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        this.sysMessageService.update((Wrapper)updateWrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchDeleteByMessageIds(String messageIds) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.inSql(SysMessage::getMessageId, messageIds)).set(SysMessage::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        this.sysMessageService.update((Wrapper)updateWrapper);
    }

    public MessageResponse messageDetail(MessageRequest messageRequest) {
        SysMessage sysMessage = (SysMessage)((Object)this.sysMessageService.getById(messageRequest.getMessageId()));
        Optional.ofNullable(sysMessage).ifPresent(msg -> {
            if (MessageReadFlagEnum.UNREAD.getCode().equals(sysMessage.getReadFlag())) {
                msg.setReadFlag(MessageReadFlagEnum.READ.getCode());
                this.sysMessageService.updateById(msg);
            }
        });
        MessageResponse messageResponse = new MessageResponse();
        BeanUtil.copyProperties((Object)((Object)sysMessage), (Object)messageResponse, (String[])new String[0]);
        return messageResponse;
    }

    public PageResult<MessageResponse> queryPage(MessageRequest messageRequest) {
        PageResult<SysMessage> pageResult = this.sysMessageService.findPage(messageRequest);
        PageResult result = new PageResult();
        List messageList = pageResult.getRows();
        List resultList = messageList.stream().map(msg -> {
            MessageResponse response = new MessageResponse();
            BeanUtil.copyProperties((Object)msg, (Object)response, (String[])new String[0]);
            return response;
        }).collect(Collectors.toList());
        BeanUtil.copyProperties(pageResult, (Object)result, (String[])new String[0]);
        result.setRows(resultList);
        return result;
    }

    public List<MessageResponse> queryList(MessageRequest messageRequest) {
        List<SysMessage> messageList = this.sysMessageService.findList(messageRequest);
        List<MessageResponse> resultList = messageList.stream().map(msg -> {
            MessageResponse response = new MessageResponse();
            BeanUtil.copyProperties((Object)msg, (Object)response, (String[])new String[0]);
            return response;
        }).collect(Collectors.toList());
        return resultList;
    }

    public PageResult<MessageResponse> queryPageCurrentUser(MessageRequest messageRequest) {
        if (ObjectUtil.isEmpty((Object)messageRequest)) {
            messageRequest = new MessageRequest();
        }
        LoginUser loginUser = LoginContext.me().getLoginUser();
        messageRequest.setReceiveUserId(loginUser.getUserId());
        return this.queryPage(messageRequest);
    }

    public List<MessageResponse> queryListCurrentUser(MessageRequest messageRequest) {
        if (ObjectUtil.isEmpty((Object)messageRequest)) {
            messageRequest = new MessageRequest();
        }
        LoginUser loginUser = LoginContext.me().getLoginUser();
        messageRequest.setReceiveUserId(loginUser.getUserId());
        return this.queryList(messageRequest);
    }

    public Integer queryCount(MessageRequest messageRequest) {
        return this.sysMessageService.findCount(messageRequest);
    }

    public Integer queryCountCurrentUser(MessageRequest messageRequest) {
        if (ObjectUtil.isEmpty((Object)messageRequest)) {
            messageRequest = new MessageRequest();
        }
        LoginUser loginUser = LoginContext.me().getLoginUser();
        messageRequest.setReceiveUserId(loginUser.getUserId());
        return this.queryCount(messageRequest);
    }
}

