/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.message.websocket;

import cn.hutool.core.bean.BeanUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.message.api.WebsocketApi;
import cn.stylefeng.roses.kernel.message.api.enums.MessageReadFlagEnum;
import cn.stylefeng.roses.kernel.message.api.pojo.request.MessageSendRequest;
import cn.stylefeng.roses.kernel.message.api.pojo.response.MessageResponse;
import cn.stylefeng.roses.kernel.message.websocket.manager.WebSocketManager;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WebSocketServiceImpl
implements WebsocketApi {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServiceImpl.class);
    public static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public void sendWebSocketMessage(List<Long> userIdList, MessageSendRequest messageSendRequest) {
        LoginUser loginUser = LoginContext.me().getLoginUser();
        try {
            MessageResponse sysMessage = new MessageResponse();
            BeanUtil.copyProperties((Object)messageSendRequest, (Object)sysMessage, (String[])new String[0]);
            sysMessage.setReadFlag(MessageReadFlagEnum.UNREAD.getCode());
            sysMessage.setSendUserId(loginUser.getUserId());
            String msgInfo = MAPPER.writeValueAsString((Object)sysMessage);
            for (Long userId : userIdList) {
                WebSocketManager.sendMessage(userId, msgInfo);
            }
        }
        catch (JsonProcessingException e) {
            log.error("\u53d1\u9001websocket\u5f02\u5e38", (Throwable)e);
        }
    }
}

