/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.message.websocket.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;
import org.springframework.util.CollectionUtils;

public class WebSocketManager {
    private static final ConcurrentHashMap<Long, List<Session>> userIdSessionMap = new ConcurrentHashMap();

    public static void add(Long userId, Session session) {
        userIdSessionMap.computeIfAbsent(userId, v -> new ArrayList()).add(session);
    }

    public static List<Session> getSessionByUserId(Long userId) {
        return userIdSessionMap.get(userId);
    }

    public static void removeSession(Long userId, Session session) {
        if (session == null) {
            return;
        }
        List<Session> webSessoin = userIdSessionMap.get(userId);
        if (webSessoin == null || CollectionUtils.isEmpty(webSessoin)) {
            return;
        }
        webSessoin.remove(session);
    }

    public static Set<Long> getUserList() {
        return userIdSessionMap.keySet();
    }

    public static void sendMessage(Long userId, String message) {
        List<Session> sessionList = WebSocketManager.getSessionByUserId(userId);
        if (!CollectionUtils.isEmpty(sessionList)) {
            for (Session userSession : sessionList) {
                userSession.getAsyncRemote().sendText(message);
            }
        }
    }

    public static void sendMessageToAll(String message) {
        for (Long userId : WebSocketManager.getUserList()) {
            WebSocketManager.sendMessage(userId, message);
        }
    }
}

