/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.message.websocket.server;

import cn.stylefeng.roses.kernel.message.websocket.manager.WebSocketManager;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/message/websocket/{userId}")
public class WebSocketEndpoint {
    private static final Logger log = LoggerFactory.getLogger(WebSocketEndpoint.class);

    @OnOpen
    public void onOpen(@PathParam(value="userId") Long userId, Session session) {
        WebSocketManager.add(userId, session);
        session.getAsyncRemote().sendText("WebSocket\u8fde\u63a5\u6210\u529f");
    }

    @OnClose
    public void onClose(@PathParam(value="userId") Long userId, Session session) {
        WebSocketManager.removeSession(userId, session);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        log.debug("\u6765\u81ea\u5ba2\u6237\u7aef\u7684\u6d88\u606f:" + message);
    }

    @OnError
    public void onError(Session session, Throwable error) {
        log.error("WebSocket\u53d1\u751f\u9519\u8bef");
        if (log.isDebugEnabled()) {
            error.printStackTrace();
        }
    }
}

