/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.resource.api.util;

import cn.hutool.core.collection.CollectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;

public class MethodReflectUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodReflectUtil.class);

    public static List<Annotation> getMethodFirstParamAnnotations(Method method) {
        if (method == null) {
            return null;
        }
        if (method.getParameterCount() <= 0) {
            return null;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length == 0) {
            return null;
        }
        Object[] resultAnnotations = parameterAnnotations[0];
        if (resultAnnotations == null || resultAnnotations.length == 0) {
            return null;
        }
        return CollectionUtil.toList((Object[])resultAnnotations);
    }

    public static Set<String> getMethodValidateGroup(Method method) {
        List<Annotation> methodFirstParamAnnotations = MethodReflectUtil.getMethodFirstParamAnnotations(method);
        if (methodFirstParamAnnotations == null) {
            return null;
        }
        try {
            for (Annotation annotation : methodFirstParamAnnotations) {
                Class[] result;
                Method validateGroupMethod;
                Object invoke;
                if (!Validated.class.equals(annotation.annotationType()) || (invoke = (validateGroupMethod = annotation.annotationType().getMethod("value", new Class[0])).invoke((Object)annotation, new Object[0])) == null || (result = (Class[])invoke).length <= 0) continue;
                HashSet<String> groupClassNames = new HashSet<String>();
                for (Class groupClass : result) {
                    groupClassNames.add(groupClass.getSimpleName());
                }
                return groupClassNames;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("\u83b7\u53d6\u65b9\u6cd5\u4e0a\u7684\u6821\u9a8c\u5206\u7ec4\u51fa\u9519\uff01", (Throwable)e);
        }
        return null;
    }

    public static Class<?> getMethodFirstParamClass(Method method) {
        if (method == null) {
            return null;
        }
        if (method.getParameterCount() <= 0) {
            return null;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 0) {
            return parameterTypes[0];
        }
        return null;
    }

    public static Class<?> getMethodReturnClass(Method method) {
        if (method == null) {
            return null;
        }
        return method.getReturnType();
    }
}

