/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sms.modular.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.sms.api.SmsSenderApi;
import cn.stylefeng.roses.kernel.sms.api.exception.SmsException;
import cn.stylefeng.roses.kernel.sms.api.exception.enums.SmsExceptionEnum;
import cn.stylefeng.roses.kernel.sms.api.expander.SmsConfigExpander;
import cn.stylefeng.roses.kernel.sms.modular.entity.SysSms;
import cn.stylefeng.roses.kernel.sms.modular.enums.SmsSendStatusEnum;
import cn.stylefeng.roses.kernel.sms.modular.enums.SmsTypeEnum;
import cn.stylefeng.roses.kernel.sms.modular.mapper.SysSmsMapper;
import cn.stylefeng.roses.kernel.sms.modular.param.SysSmsInfoParam;
import cn.stylefeng.roses.kernel.sms.modular.param.SysSmsSendParam;
import cn.stylefeng.roses.kernel.sms.modular.param.SysSmsVerifyParam;
import cn.stylefeng.roses.kernel.sms.modular.service.SysSmsInfoService;
import cn.stylefeng.roses.kernel.system.exception.SystemModularException;
import cn.stylefeng.roses.kernel.validator.CaptchaApi;
import cn.stylefeng.roses.kernel.validator.exception.enums.ValidatorExceptionEnum;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysSmsInfoServiceImpl
extends ServiceImpl<SysSmsMapper, SysSms>
implements SysSmsInfoService {
    private static final Logger log = LoggerFactory.getLogger(SysSmsInfoServiceImpl.class);
    @Resource
    private SmsSenderApi smsSenderApi;
    @Resource
    private CaptchaApi captchaApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sendShortMessage(SysSmsSendParam sysSmsSendParam) {
        String validateCode;
        String verKey = sysSmsSendParam.getVerKey();
        String verCode = sysSmsSendParam.getVerCode();
        if (StrUtil.isEmpty((CharSequence)verKey) || StrUtil.isEmpty((CharSequence)verCode)) {
            throw new SystemModularException((AbstractExceptionEnum)ValidatorExceptionEnum.CAPTCHA_EMPTY);
        }
        if (!this.captchaApi.validateCaptcha(verKey, verCode)) {
            throw new SystemModularException((AbstractExceptionEnum)ValidatorExceptionEnum.CAPTCHA_ERROR);
        }
        HashMap params = sysSmsSendParam.getParams();
        if (SmsTypeEnum.MESSAGE.equals((Object)sysSmsSendParam.getSmsTypeEnum())) {
            this.smsSenderApi.sendSms(sysSmsSendParam.getPhone(), sysSmsSendParam.getTemplateCode(), params);
        }
        if (params != null && params.get("code") != null) {
            validateCode = params.get("code").toString();
        } else {
            validateCode = RandomUtil.randomNumbers((int)6);
            if (params == null) {
                params = CollectionUtil.newHashMap();
            }
            params.put("code", validateCode);
        }
        Long smsId = this.saveSmsInfo(sysSmsSendParam, validateCode);
        log.info("\u5f00\u59cb\u53d1\u9001\u77ed\u4fe1\uff1a\u53d1\u9001\u7684\u7535\u8bdd\u53f7\u7801= " + sysSmsSendParam.getPhone() + ",\u53d1\u9001\u7684\u6a21\u677f\u53f7=" + sysSmsSendParam.getTemplateCode() + "\uff0c\u53d1\u9001\u7684\u53c2\u6570\u662f\uff1a" + JSON.toJSONString((Object)params));
        this.smsSenderApi.sendSms(sysSmsSendParam.getPhone(), sysSmsSendParam.getTemplateCode(), (Map)params);
        this.updateSmsInfo(smsId, SmsSendStatusEnum.SUCCESS);
        return true;
    }

    @Override
    public Long saveSmsInfo(SysSmsSendParam sysSmsSendParam, String validateCode) {
        Date nowDate = new Date();
        Integer invalidedSeconds = SmsConfigExpander.getSmsValidateExpiredSeconds();
        long invalidateTime = nowDate.getTime() + (long)(invalidedSeconds * 1000);
        Date invalidate = new Date(invalidateTime);
        SysSms sysSms = new SysSms();
        sysSms.setCreateTime(nowDate);
        sysSms.setInvalidTime(invalidate);
        sysSms.setPhone(sysSmsSendParam.getPhone());
        sysSms.setStatusFlag(SmsSendStatusEnum.WAITING.getCode());
        sysSms.setSource(sysSmsSendParam.getSmsSendSourceEnum().getCode());
        sysSms.setTemplateCode(sysSmsSendParam.getTemplateCode());
        sysSms.setValidateCode(validateCode);
        this.save(sysSms);
        log.info("\u53d1\u9001\u77ed\u4fe1\uff0c\u5b58\u50a8\u77ed\u4fe1\u5230\u6570\u636e\u5e93\uff0c\u6570\u636e\u4e3a\uff1a" + JSON.toJSONString((Object)sysSms));
        return sysSms.getSmsId();
    }

    @Override
    public void updateSmsInfo(Long smsId, SmsSendStatusEnum smsSendStatusEnum) {
        SysSms sysSms = (SysSms)this.getById(smsId);
        sysSms.setStatusFlag(smsSendStatusEnum.getCode());
        this.updateById(sysSms);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void validateSmsInfo(SysSmsVerifyParam sysSmsVerifyParam) {
        LambdaQueryWrapper smsQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)smsQueryWrapper.eq(SysSms::getPhone, (Object)sysSmsVerifyParam.getPhone())).and(f -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)f.eq(SysSms::getSource, (Object)sysSmsVerifyParam.getSmsSendSourceEnum().getCode());
        })).and(f -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)f.eq(SysSms::getTemplateCode, (Object)sysSmsVerifyParam.getTemplateCode());
        });
        smsQueryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List sysSmsList = this.list((Wrapper)smsQueryWrapper);
        log.info("\u9a8c\u8bc1\u77ed\u4fe1Provider\u63a5\u53e3\uff0c\u67e5\u8be2\u5230sms\u8bb0\u5f55\uff1a" + JSON.toJSONString((Object)sysSmsList));
        if (ObjectUtil.isEmpty((Object)sysSmsList)) {
            throw new SmsException((AbstractExceptionEnum)SmsExceptionEnum.SMS_VALIDATE_ERROR_NOT_EXISTED_RECORD);
        }
        SysSms sysSms = (SysSms)sysSmsList.get(0);
        if (SmsSendStatusEnum.INVALID.getCode().equals(sysSms.getStatusFlag())) {
            throw new SmsException((AbstractExceptionEnum)SmsExceptionEnum.SMS_VALIDATE_ERROR_INVALIDATE_STATUS);
        }
        if (!sysSmsVerifyParam.getCode().equals(sysSms.getValidateCode())) {
            throw new SmsException((AbstractExceptionEnum)SmsExceptionEnum.SMS_VALIDATE_ERROR_INVALIDATE_CODE);
        }
        Date invalidTime = sysSms.getInvalidTime();
        if (ObjectUtil.isEmpty((Object)invalidTime) || new Date().after(invalidTime)) {
            throw new SmsException((AbstractExceptionEnum)SmsExceptionEnum.SMS_VALIDATE_ERROR_INVALIDATE_TIME);
        }
        sysSms.setStatusFlag(SmsSendStatusEnum.INVALID.getCode());
        this.updateById(sysSms);
    }

    @Override
    public PageResult<SysSms> page(SysSmsInfoParam sysSmsInfoParam) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isNotNull((Object)((Object)sysSmsInfoParam))) {
            if (ObjectUtil.isNotEmpty((Object)sysSmsInfoParam.getPhone())) {
                queryWrapper.like(SysSms::getPhone, (Object)sysSmsInfoParam.getPhone());
            }
            if (ObjectUtil.isNotEmpty((Object)sysSmsInfoParam.getStatusFlag())) {
                queryWrapper.eq(SysSms::getStatusFlag, (Object)sysSmsInfoParam.getStatusFlag());
            }
            if (ObjectUtil.isNotEmpty((Object)sysSmsInfoParam.getSource())) {
                queryWrapper.eq(SysSms::getSource, (Object)sysSmsInfoParam.getSource());
            }
        }
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)queryWrapper);
        return PageResultFactory.createPageResult((Page)page);
    }
}

