/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.organization.service;

import cn.stylefeng.roses.kernel.auth.api.enums.DataScopeTypeEnum;
import cn.stylefeng.roses.kernel.db.api.DbOperatorApi;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.DataScopeApi;
import cn.stylefeng.roses.kernel.system.RoleServiceApi;
import cn.stylefeng.roses.kernel.system.UserOrgServiceApi;
import cn.stylefeng.roses.kernel.system.UserServiceApi;
import cn.stylefeng.roses.kernel.system.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.exception.enums.organization.DataScopeExceptionEnum;
import cn.stylefeng.roses.kernel.system.pojo.organization.DataScopeDTO;
import cn.stylefeng.roses.kernel.system.pojo.role.dto.SysRoleDTO;
import cn.stylefeng.roses.kernel.system.pojo.user.SysUserOrgDTO;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DataScopeService
implements DataScopeApi {
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private RoleServiceApi roleServiceApi;
    @Resource
    private UserOrgServiceApi userOrgServiceApi;
    @Resource
    private DbOperatorApi dbOperatorApi;

    public DataScopeDTO getDataScope(Long userId, List<SysRoleDTO> sysRoles) {
        Long organizationId;
        DataScopeDTO dataScopeResponse = new DataScopeDTO();
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> organizationIds = new HashSet<Long>();
        if (userId == null) {
            throw new SystemModularException((AbstractExceptionEnum)DataScopeExceptionEnum.USER_ID_EMPTY_ERROR, new Object[]{userId});
        }
        SysUserOrgDTO sysUserOrgResponse = this.userOrgServiceApi.getUserOrgInfo(userId);
        Set dataScopeTypeEnums = sysRoles.stream().map(SysRoleDTO::getDataScopeTypeEnum).collect(Collectors.toSet());
        dataScopeResponse.setDataScopeTypeEnums(dataScopeTypeEnums);
        if (dataScopeTypeEnums.contains(DataScopeTypeEnum.ALL)) {
            return dataScopeResponse;
        }
        if (dataScopeTypeEnums.contains(DataScopeTypeEnum.DEFINE)) {
            List roleIds = sysRoles.stream().map(SysRoleDTO::getRoleId).collect(Collectors.toList());
            List orgIds = this.roleServiceApi.getRoleDataScopes(roleIds);
            organizationIds.addAll(orgIds);
        }
        if (dataScopeTypeEnums.contains(DataScopeTypeEnum.DEPT_WITH_CHILD)) {
            organizationId = sysUserOrgResponse.getOrgId();
            Set subOrgIds = this.dbOperatorApi.findSubListByParentId("hr_organization", "org_pids", "org_id", organizationId);
            organizationIds.add(organizationId);
            organizationIds.addAll(subOrgIds);
        }
        if (dataScopeTypeEnums.contains(DataScopeTypeEnum.DEPT)) {
            organizationId = sysUserOrgResponse.getOrgId();
            organizationIds.add(organizationId);
        }
        if (dataScopeTypeEnums.contains(DataScopeTypeEnum.SELF)) {
            userIds.add(userId);
        }
        List userBindDataScope = this.userServiceApi.getUserBindDataScope(userId);
        organizationIds.addAll(userBindDataScope);
        dataScopeResponse.setUserIds(userIds);
        dataScopeResponse.setOrganizationIds(organizationIds);
        return dataScopeResponse;
    }
}

