/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.role.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.role.modular.entity.SysRoleDataScope;
import cn.stylefeng.roses.kernel.role.modular.mapper.SysRoleDataScopeMapper;
import cn.stylefeng.roses.kernel.role.modular.service.SysRoleDataScopeService;
import cn.stylefeng.roses.kernel.system.RoleDataScopeServiceApi;
import cn.stylefeng.roses.kernel.system.pojo.role.request.SysRoleDataScopeRequest;
import cn.stylefeng.roses.kernel.system.pojo.role.request.SysRoleRequest;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SysRoleDataScopeServiceImpl
extends ServiceImpl<SysRoleDataScopeMapper, SysRoleDataScope>
implements SysRoleDataScopeService,
RoleDataScopeServiceApi {
    @Override
    public void grantDataScope(SysRoleRequest sysRoleParam) {
        Long roleId = sysRoleParam.getRoleId();
        this.delByRoleId(roleId);
        if (ObjectUtil.isNotEmpty((Object)sysRoleParam.getGrantOrgIdList())) {
            ArrayList sysRoleDataScopeList = CollUtil.newArrayList((Object[])new SysRoleDataScope[0]);
            sysRoleParam.getGrantOrgIdList().forEach(orgId -> {
                SysRoleDataScope sysRoleDataScope = new SysRoleDataScope();
                sysRoleDataScope.setRoleId(roleId);
                sysRoleDataScope.setOrganizationId((Long)orgId);
                sysRoleDataScopeList.add(sysRoleDataScope);
            });
            this.saveBatch(sysRoleDataScopeList);
        }
    }

    @Override
    public List<Long> getRoleDataScopeIdList(List<Long> roleIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleDataScope::getRoleId, roleIdList);
        return this.list((Wrapper)queryWrapper).stream().map(SysRoleDataScope::getOrganizationId).collect(Collectors.toList());
    }

    @Override
    public void add(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        SysRoleDataScope sysRoleDataScope = new SysRoleDataScope();
        BeanUtil.copyProperties((Object)sysRoleDataScopeRequest, (Object)((Object)sysRoleDataScope), (String[])new String[0]);
        this.save((Object)sysRoleDataScope);
    }

    @Override
    public void del(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        SysRoleDataScope sysRoleDataScope = this.querySysRoleDataScopeById(sysRoleDataScopeRequest);
        this.removeById(sysRoleDataScope.getRoleDataScopeId());
    }

    @Override
    public void delByRoleId(Long roleId) {
        SysRoleDataScopeRequest sysRoleDataScopeRequest = new SysRoleDataScopeRequest();
        sysRoleDataScopeRequest.setRoleId(roleId);
        this.remove((Wrapper)this.createQueryWrapper(sysRoleDataScopeRequest));
    }

    public void delByOrgIds(Set<Long> orgIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleDataScope::getOrganizationId, orgIds);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void edit(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        SysRoleDataScope sysRoleDataScope = this.querySysRoleDataScopeById(sysRoleDataScopeRequest);
        BeanUtil.copyProperties((Object)sysRoleDataScopeRequest, (Object)((Object)sysRoleDataScope), (String[])new String[0]);
        this.updateById((Object)sysRoleDataScope);
    }

    @Override
    public SysRoleDataScope detail(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        return (SysRoleDataScope)((Object)this.getOne((Wrapper)this.createQueryWrapper(sysRoleDataScopeRequest), false));
    }

    @Override
    public List<SysRoleDataScope> findList(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        return this.list((Wrapper)this.createQueryWrapper(sysRoleDataScopeRequest));
    }

    private SysRoleDataScope querySysRoleDataScopeById(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        return (SysRoleDataScope)((Object)this.getById(sysRoleDataScopeRequest.getRoleDataScopeId()));
    }

    private LambdaQueryWrapper<SysRoleDataScope> createQueryWrapper(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)sysRoleDataScopeRequest.getRoleDataScopeId()), SysRoleDataScope::getRoleDataScopeId, (Object)sysRoleDataScopeRequest.getRoleDataScopeId());
        queryWrapper.eq(ObjectUtil.isNotNull((Object)sysRoleDataScopeRequest.getRoleId()), SysRoleDataScope::getRoleId, (Object)sysRoleDataScopeRequest.getRoleId());
        queryWrapper.eq(ObjectUtil.isNotNull((Object)sysRoleDataScopeRequest.getOrganizationId()), SysRoleDataScope::getOrganizationId, (Object)sysRoleDataScopeRequest.getOrganizationId());
        return queryWrapper;
    }
}

