/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.role.modular.service.impl;

import cn.stylefeng.roses.kernel.role.modular.entity.SysRoleResource;
import cn.stylefeng.roses.kernel.role.modular.mapper.SysRoleResourceMapper;
import cn.stylefeng.roses.kernel.role.modular.service.SysRoleResourceService;
import cn.stylefeng.roses.kernel.system.pojo.role.request.SysRoleRequest;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleResourceServiceImpl
extends ServiceImpl<SysRoleResourceMapper, SysRoleResource>
implements SysRoleResourceService {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grantResource(SysRoleRequest sysRoleRequest) {
        Long roleId = sysRoleRequest.getRoleId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleResource::getRoleId, (Object)roleId);
        this.remove((Wrapper)queryWrapper);
        List grantResourceList = sysRoleRequest.getGrantResourceList();
        ArrayList<SysRoleResource> sysRoleResources = new ArrayList<SysRoleResource>();
        for (String resourceId : grantResourceList) {
            SysRoleResource sysRoleMenu = new SysRoleResource();
            sysRoleMenu.setRoleId(roleId);
            sysRoleMenu.setResourceCode(resourceId);
            sysRoleResources.add(sysRoleMenu);
        }
        this.saveBatch(sysRoleResources);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRoleResourceListByResourceIds(List<Long> resourceIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleResource::getResourceCode, resourceIds);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRoleResourceListByRoleId(Long roleId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleResource::getRoleId, (Object)roleId);
        this.remove((Wrapper)queryWrapper);
    }
}

