/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.role.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.enums.DataScopeTypeEnum;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleRoleInfo;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.role.modular.entity.SysRole;
import cn.stylefeng.roses.kernel.role.modular.entity.SysRoleDataScope;
import cn.stylefeng.roses.kernel.role.modular.entity.SysRoleMenu;
import cn.stylefeng.roses.kernel.role.modular.entity.SysRoleMenuButton;
import cn.stylefeng.roses.kernel.role.modular.entity.SysRoleResource;
import cn.stylefeng.roses.kernel.role.modular.mapper.SysRoleMapper;
import cn.stylefeng.roses.kernel.role.modular.service.SysRoleDataScopeService;
import cn.stylefeng.roses.kernel.role.modular.service.SysRoleMenuButtonService;
import cn.stylefeng.roses.kernel.role.modular.service.SysRoleMenuService;
import cn.stylefeng.roses.kernel.role.modular.service.SysRoleResourceService;
import cn.stylefeng.roses.kernel.role.modular.service.SysRoleService;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.system.UserServiceApi;
import cn.stylefeng.roses.kernel.system.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.exception.enums.role.SysRoleExceptionEnum;
import cn.stylefeng.roses.kernel.system.pojo.role.dto.SysRoleDTO;
import cn.stylefeng.roses.kernel.system.pojo.role.dto.SysRoleMenuButtonDTO;
import cn.stylefeng.roses.kernel.system.pojo.role.dto.SysRoleMenuDTO;
import cn.stylefeng.roses.kernel.system.pojo.role.dto.SysRoleResourceDTO;
import cn.stylefeng.roses.kernel.system.pojo.role.request.SysRoleMenuButtonRequest;
import cn.stylefeng.roses.kernel.system.pojo.role.request.SysRoleRequest;
import cn.stylefeng.roses.kernel.system.util.DataScopeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleServiceImpl
extends ServiceImpl<SysRoleMapper, SysRole>
implements SysRoleService {
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private SysRoleResourceService sysRoleResourceService;
    @Resource
    private SysRoleDataScopeService sysRoleDataScopeService;
    @Resource
    private SysRoleMenuService roleMenuService;
    @Resource
    private SysRoleMenuButtonService sysRoleMenuButtonService;

    @Override
    public void add(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = new SysRole();
        BeanUtil.copyProperties((Object)sysRoleRequest, (Object)((Object)sysRole), (String[])new String[0]);
        sysRole.setStatusFlag(StatusEnum.ENABLE.getCode());
        sysRole.setRoleSystemFlag(YesOrNotEnum.N.getCode());
        sysRole.setDataScopeType(DataScopeTypeEnum.SELF.getCode());
        this.save((Object)sysRole);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        if (YesOrNotEnum.Y.getCode().equals(sysRole.getRoleSystemFlag())) {
            throw new ServiceException((AbstractExceptionEnum)SysRoleExceptionEnum.SYSTEM_ROLE_CANT_DELETE);
        }
        sysRole.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)sysRole);
        Long roleId = sysRole.getRoleId();
        this.sysRoleDataScopeService.delByRoleId(roleId);
        this.userServiceApi.deleteUserRoleListByRoleId(roleId);
        this.sysRoleResourceService.deleteRoleResourceListByRoleId(roleId);
    }

    @Override
    public void edit(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        BeanUtil.copyProperties((Object)sysRoleRequest, (Object)((Object)sysRole), (String[])new String[0]);
        sysRole.setStatusFlag(null);
        this.updateById((Object)sysRole);
    }

    @Override
    public SysRoleDTO detail(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        SysRoleDTO roleResponse = new SysRoleDTO();
        BeanUtil.copyProperties((Object)((Object)sysRole), (Object)roleResponse, (String[])new String[0]);
        roleResponse.setDataScopeTypeEnum(DataScopeTypeEnum.codeToEnum((Integer)sysRole.getDataScopeType()));
        return roleResponse;
    }

    @Override
    public PageResult<SysRole> findPage(SysRoleRequest sysRoleRequest) {
        LambdaQueryWrapper<SysRole> wrapper = this.createWrapper(sysRoleRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public List<SimpleDict> findList(SysRoleRequest sysRoleParam) {
        ArrayList dictList = CollectionUtil.newArrayList((Object[])new SimpleDict[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isNotNull((Object)sysRoleParam) && ObjectUtil.isNotEmpty((Object)sysRoleParam.getRoleName())) {
            queryWrapper.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(SysRole::getRoleName, (Object)sysRoleParam.getRoleName())).or()).like(SysRole::getRoleCode, (Object)sysRoleParam.getRoleName());
            });
        }
        queryWrapper.eq(SysRole::getStatusFlag, (Object)StatusEnum.ENABLE.getCode());
        queryWrapper.orderByAsc(SysRole::getRoleSort);
        this.list((Wrapper)queryWrapper).forEach(sysRole -> {
            SimpleDict simpleDict = new SimpleDict();
            simpleDict.setId(sysRole.getRoleId());
            simpleDict.setName(sysRole.getRoleName() + "[" + sysRole.getRoleCode() + "]");
            dictList.add(simpleDict);
        });
        return dictList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grantMenuAndButton(SysRoleRequest sysRoleMenuButtonRequest) {
        List menuButtonList;
        LambdaQueryWrapper sysRoleMenuLqw = new LambdaQueryWrapper();
        sysRoleMenuLqw.eq(SysRoleMenu::getRoleId, (Object)sysRoleMenuButtonRequest.getRoleId());
        this.roleMenuService.remove((Wrapper)sysRoleMenuLqw);
        LambdaQueryWrapper menuButtonLqw = new LambdaQueryWrapper();
        menuButtonLqw.eq(SysRoleMenuButton::getRoleId, (Object)sysRoleMenuButtonRequest.getRoleId());
        this.sysRoleMenuButtonService.remove((Wrapper)menuButtonLqw);
        List menuIdList = sysRoleMenuButtonRequest.getGrantMenuIdList();
        if (ObjectUtil.isNotEmpty((Object)menuIdList)) {
            ArrayList<SysRoleMenu> sysRoleMenus = new ArrayList<SysRoleMenu>();
            for (Long menuId : menuIdList) {
                SysRoleMenu item = new SysRoleMenu();
                item.setRoleId(sysRoleMenuButtonRequest.getRoleId());
                item.setMenuId(menuId);
                sysRoleMenus.add(item);
            }
            this.roleMenuService.saveBatch(sysRoleMenus);
        }
        if (ObjectUtil.isNotEmpty((Object)(menuButtonList = sysRoleMenuButtonRequest.getGrantMenuButtonIdList()))) {
            ArrayList<SysRoleMenuButton> sysRoleMenuButtons = new ArrayList<SysRoleMenuButton>();
            for (SysRoleMenuButtonRequest menuButton : menuButtonList) {
                SysRoleMenuButton item = new SysRoleMenuButton();
                item.setRoleId(sysRoleMenuButtonRequest.getRoleId());
                item.setButtonId(menuButton.getButtonId());
                item.setButtonCode(menuButton.getButtonCode());
                sysRoleMenuButtons.add(item);
            }
            this.sysRoleMenuButtonService.saveBatch(sysRoleMenuButtons);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grantDataScope(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        boolean superAdmin = LoginContext.me().getSuperAdminFlag();
        Integer dataScopeType = sysRoleRequest.getDataScopeType();
        DataScopeTypeEnum dataScopeTypeEnum = DataScopeTypeEnum.codeToEnum((Integer)dataScopeType);
        if (!superAdmin) {
            if (DataScopeTypeEnum.ALL.equals((Object)dataScopeTypeEnum)) {
                throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.ONLY_SUPER_ERROR);
            }
            if (DataScopeTypeEnum.DEFINE.getCode().equals(dataScopeType)) {
                if (ObjectUtil.isEmpty((Object)sysRoleRequest.getGrantOrgIdList())) {
                    throw new SystemModularException((AbstractExceptionEnum)SysRoleExceptionEnum.PLEASE_FILL_DATA_SCOPE);
                }
                for (Long orgId : sysRoleRequest.getGrantOrgIdList()) {
                    DataScopeUtil.quickValidateDataScope((Long)orgId);
                }
            }
        }
        sysRole.setDataScopeType(sysRoleRequest.getDataScopeType());
        this.updateById((Object)sysRole);
        this.sysRoleDataScopeService.grantDataScope(sysRoleRequest);
    }

    @Override
    public List<SimpleDict> dropDown() {
        ArrayList dictList = CollectionUtil.newArrayList((Object[])new SimpleDict[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (!LoginContext.me().getSuperAdminFlag()) {
            List roles = LoginContext.me().getLoginUser().getSimpleRoleInfoList();
            Set loginUserRoleIds = roles.stream().map(SimpleRoleInfo::getRoleId).collect(Collectors.toSet());
            if (ObjectUtil.isEmpty(loginUserRoleIds)) {
                return dictList;
            }
            queryWrapper.in(SysRole::getRoleId, loginUserRoleIds);
        }
        ((LambdaQueryWrapper)queryWrapper.eq(SysRole::getStatusFlag, (Object)StatusEnum.ENABLE.getCode())).eq(SysRole::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        this.list((Wrapper)queryWrapper).forEach(sysRole -> {
            SimpleDict simpleDict = new SimpleDict();
            simpleDict.setId(sysRole.getRoleId());
            simpleDict.setCode(sysRole.getRoleCode());
            simpleDict.setName(sysRole.getRoleName());
            dictList.add(simpleDict);
        });
        return dictList;
    }

    @Override
    public List<Long> getRoleDataScope(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        return this.sysRoleDataScopeService.getRoleDataScopeIdList(CollectionUtil.newArrayList((Object[])new Long[]{sysRole.getRoleId()}));
    }

    public List<SysRoleDTO> getRolesByIds(List<Long> roleIds) {
        ArrayList<SysRoleDTO> sysRoleResponses = new ArrayList<SysRoleDTO>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRole::getRoleId, roleIds);
        List sysRoles = this.list((Wrapper)queryWrapper);
        if (!sysRoles.isEmpty()) {
            for (SysRole sysRole : sysRoles) {
                SysRoleDTO sysRoleResponse = new SysRoleDTO();
                BeanUtil.copyProperties((Object)((Object)sysRole), (Object)sysRoleResponse, (String[])new String[0]);
                sysRoleResponse.setDataScopeTypeEnum(DataScopeTypeEnum.codeToEnum((Integer)sysRole.getDataScopeType()));
                sysRoleResponses.add(sysRoleResponse);
            }
        }
        return sysRoleResponses;
    }

    public List<Long> getRoleDataScopes(List<Long> roleIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleDataScope::getRoleId, roleIds);
        List list = this.sysRoleDataScopeService.list((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            return list.stream().map(SysRoleDataScope::getOrganizationId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    public List<Long> getMenuIdsByRoleIds(List<Long> roleIds) {
        if (roleIds == null || roleIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleMenu::getRoleId, roleIds);
        queryWrapper.select(new SFunction[]{SysRoleMenu::getMenuId});
        List roleMenus = this.roleMenuService.list((Wrapper)queryWrapper);
        if (roleMenus == null || roleMenus.isEmpty()) {
            return new ArrayList<Long>();
        }
        return roleMenus.stream().map(SysRoleMenu::getMenuId).collect(Collectors.toList());
    }

    public List<String> getRoleResourceCodeList(List<Long> roleIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{SysRoleResource::getResourceCode});
        queryWrapper.in(SysRoleResource::getRoleId, roleIdList);
        List sysRoleResources = this.sysRoleResourceService.list((Wrapper)queryWrapper);
        return sysRoleResources.parallelStream().map(SysRoleResource::getResourceCode).collect(Collectors.toList());
    }

    public List<SysRoleResourceDTO> getRoleResourceList(List<Long> roleIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleResource::getRoleId, roleIdList);
        List sysRoleResources = this.sysRoleResourceService.list((Wrapper)queryWrapper);
        return sysRoleResources.parallelStream().map(item -> (SysRoleResourceDTO)BeanUtil.copyProperties((Object)item, SysRoleResourceDTO.class, (String[])new String[0])).collect(Collectors.toList());
    }

    public Set<String> getRoleButtonCodes(List<Long> roleIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleMenuButton::getRoleId, roleIdList);
        queryWrapper.select(new SFunction[]{SysRoleMenuButton::getButtonCode});
        List list = this.sysRoleMenuButtonService.list((Wrapper)queryWrapper);
        return list.stream().map(SysRoleMenuButton::getButtonCode).collect(Collectors.toSet());
    }

    public List<SysRoleMenuDTO> getRoleMenuList(List<Long> roleIdList) {
        LambdaQueryWrapper sysRoleMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuLambdaQueryWrapper.in(SysRoleMenu::getRoleId, roleIdList);
        List roleMenus = this.roleMenuService.list((Wrapper)sysRoleMenuLambdaQueryWrapper);
        return roleMenus.parallelStream().map(item -> (SysRoleMenuDTO)BeanUtil.copyProperties((Object)item, SysRoleMenuDTO.class, (String[])new String[0])).collect(Collectors.toList());
    }

    public List<SysRoleMenuButtonDTO> getRoleMenuButtonList(List<Long> roleIdList) {
        LambdaQueryWrapper sysRoleMenuButtonLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuButtonLambdaQueryWrapper.in(SysRoleMenuButton::getRoleId, roleIdList);
        List sysRoleMenuButtons = this.sysRoleMenuButtonService.list((Wrapper)sysRoleMenuButtonLambdaQueryWrapper);
        return sysRoleMenuButtons.parallelStream().map(item -> (SysRoleMenuButtonDTO)BeanUtil.copyProperties((Object)item, SysRoleMenuButtonDTO.class, (String[])new String[0])).collect(Collectors.toList());
    }

    private SysRole querySysRole(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = (SysRole)((Object)this.getById(sysRoleRequest.getRoleId()));
        if (ObjectUtil.isNull((Object)((Object)sysRole))) {
            throw new SystemModularException((AbstractExceptionEnum)SysRoleExceptionEnum.ROLE_NOT_EXIST);
        }
        return sysRole;
    }

    private LambdaQueryWrapper<SysRole> createWrapper(SysRoleRequest sysRoleRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRole::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        queryWrapper.orderByAsc(SysRole::getRoleSort);
        if (ObjectUtil.isEmpty((Object)sysRoleRequest)) {
            return queryWrapper;
        }
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)sysRoleRequest.getRoleName()), SysRole::getRoleName, (Object)sysRoleRequest.getRoleName());
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)sysRoleRequest.getRoleCode()), SysRole::getRoleCode, (Object)sysRoleRequest.getRoleCode());
        return queryWrapper;
    }
}

