/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.endpoints.DictionaryResponse;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FlushSyncedResponse
extends DictionaryResponse<String, ShardStatistics> {
    private final ShardStatistics shards;
    public static final JsonpDeserializer<FlushSyncedResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FlushSyncedResponse::setupFlushSyncedResponseDeserializer);

    private FlushSyncedResponse(Builder builder) {
        super(builder);
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
    }

    public static FlushSyncedResponse of(Function<Builder, ObjectBuilder<FlushSyncedResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
    }

    protected static void setupFlushSyncedResponseDeserializer(ObjectDeserializer<Builder> op) {
        DictionaryResponse.setupDictionaryResponseDeserializer(op, JsonpDeserializer.stringDeserializer(), ShardStatistics._DESERIALIZER);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
    }

    public static class Builder
    extends DictionaryResponse.AbstractBuilder<String, ShardStatistics, Builder>
    implements ObjectBuilder<FlushSyncedResponse> {
        private ShardStatistics shards;

        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FlushSyncedResponse build() {
            this._checkSingleUse();
            super.tKeySerializer(null);
            super.tValueSerializer(null);
            return new FlushSyncedResponse(this);
        }
    }
}

