/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.EmptyObject;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class GetServiceCredentialsResponse
implements JsonpSerializable {
    private final String serviceAccount;
    private final String nodeName;
    private final int count;
    private final Map<String, EmptyObject> tokens;
    private final Map<String, EmptyObject> fileTokens;
    public static final JsonpDeserializer<GetServiceCredentialsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetServiceCredentialsResponse::setupGetServiceCredentialsResponseDeserializer);

    private GetServiceCredentialsResponse(Builder builder) {
        this.serviceAccount = ApiTypeHelper.requireNonNull(builder.serviceAccount, this, "serviceAccount");
        this.nodeName = ApiTypeHelper.requireNonNull(builder.nodeName, this, "nodeName");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.tokens = ApiTypeHelper.unmodifiableRequired(builder.tokens, (Object)this, "tokens");
        this.fileTokens = ApiTypeHelper.unmodifiableRequired(builder.fileTokens, (Object)this, "fileTokens");
    }

    public static GetServiceCredentialsResponse of(Function<Builder, ObjectBuilder<GetServiceCredentialsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String serviceAccount() {
        return this.serviceAccount;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final int count() {
        return this.count;
    }

    public final Map<String, EmptyObject> tokens() {
        return this.tokens;
    }

    public final Map<String, EmptyObject> fileTokens() {
        return this.fileTokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("service_account");
        generator.write(this.serviceAccount);
        generator.writeKey("node_name");
        generator.write(this.nodeName);
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.tokens)) {
            generator.writeKey("tokens");
            generator.writeStartObject();
            for (Map.Entry<String, EmptyObject> item0 : this.tokens.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.fileTokens)) {
            generator.writeKey("file_tokens");
            generator.writeStartObject();
            for (Map.Entry<String, EmptyObject> item0 : this.fileTokens.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetServiceCredentialsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::serviceAccount, JsonpDeserializer.stringDeserializer(), "service_account");
        op.add(Builder::nodeName, JsonpDeserializer.stringDeserializer(), "node_name");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::tokens, JsonpDeserializer.stringMapDeserializer(EmptyObject._DESERIALIZER), "tokens");
        op.add(Builder::fileTokens, JsonpDeserializer.stringMapDeserializer(EmptyObject._DESERIALIZER), "file_tokens");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetServiceCredentialsResponse> {
        private String serviceAccount;
        private String nodeName;
        private Integer count;
        private Map<String, EmptyObject> tokens;
        private Map<String, EmptyObject> fileTokens;

        public final Builder serviceAccount(String value) {
            this.serviceAccount = value;
            return this;
        }

        public final Builder nodeName(String value) {
            this.nodeName = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder tokens(Map<String, EmptyObject> map) {
            this.tokens = Builder._mapPutAll(this.tokens, map);
            return this;
        }

        public final Builder tokens(String key, EmptyObject value) {
            this.tokens = Builder._mapPut(this.tokens, key, value);
            return this;
        }

        public final Builder tokens(String key, Function<EmptyObject.Builder, ObjectBuilder<EmptyObject>> fn) {
            return this.tokens(key, fn.apply(new EmptyObject.Builder()).build());
        }

        public final Builder fileTokens(Map<String, EmptyObject> map) {
            this.fileTokens = Builder._mapPutAll(this.fileTokens, map);
            return this;
        }

        public final Builder fileTokens(String key, EmptyObject value) {
            this.fileTokens = Builder._mapPut(this.fileTokens, key, value);
            return this;
        }

        public final Builder fileTokens(String key, Function<EmptyObject.Builder, ObjectBuilder<EmptyObject>> fn) {
            return this.fileTokens(key, fn.apply(new EmptyObject.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetServiceCredentialsResponse build() {
            this._checkSingleUse();
            return new GetServiceCredentialsResponse(this);
        }
    }
}

