/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetServiceAccountsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetServiceAccountsRequest
extends RequestBase {
    @Nullable
    private final String namespace;
    @Nullable
    private final String service;
    public static final Endpoint<GetServiceAccountsRequest, GetServiceAccountsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetServiceAccountsRequest, GetServiceAccountsResponse>("es/security.get_service_accounts", request -> "GET", request -> {
        boolean _service = true;
        int _namespace = 2;
        int propsSet = 0;
        if (request.service() != null) {
            propsSet |= 1;
        }
        if (request.namespace() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            return buf.toString();
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetServiceAccountsResponse._DESERIALIZER);

    private GetServiceAccountsRequest(Builder builder) {
        this.namespace = builder.namespace;
        this.service = builder.service;
    }

    public static GetServiceAccountsRequest of(Function<Builder, ObjectBuilder<GetServiceAccountsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String namespace() {
        return this.namespace;
    }

    @Nullable
    public final String service() {
        return this.service;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetServiceAccountsRequest> {
        @Nullable
        private String namespace;
        @Nullable
        private String service;

        public final Builder namespace(@Nullable String value) {
            this.namespace = value;
            return this;
        }

        public final Builder service(@Nullable String value) {
            this.service = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetServiceAccountsRequest build() {
            this._checkSingleUse();
            return new GetServiceAccountsRequest(this);
        }
    }
}

