/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JSONPath {
    JSONReader.Context readerContext;
    JSONWriter.Context writerContext;
    final String path;

    JSONPath(String path) {
        this.path = path;
    }

    public boolean isPrevious() {
        return false;
    }

    public final String toString() {
        return this.path;
    }

    public static Object extract(String json, String path) {
        return JSONPath.of(path).extract(JSONReader.of(json));
    }

    public static Object eval(Object rootObject, String path) {
        return JSONPath.of(path).eval(rootObject);
    }

    public static void set(Object rootObject, String path, Object value) {
        JSONPath.of(path).set(rootObject, value);
    }

    public static Map<String, Object> paths(Object javaObject) {
        IdentityHashMap<Object, String> values = new IdentityHashMap<Object, String>();
        HashMap<String, Object> paths = new HashMap<String, Object>();
        JSONPath.of("").paths(values, paths, "/", javaObject);
        return paths;
    }

    void paths(Map<Object, String> values, Map<String, Object> paths, String parent, Object javaObject) {
        if (javaObject == null) {
            return;
        }
        String p = values.put(javaObject, parent);
        if (p != null) {
            boolean basicType;
            Class<?> type = javaObject.getClass();
            boolean bl = basicType = type == String.class || type == Boolean.class || type == Character.class || type == UUID.class || type.isEnum() || javaObject instanceof Number || javaObject instanceof Date;
            if (!basicType) {
                return;
            }
        }
        paths.put(parent, javaObject);
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            for (Map.Entry entryObj : map.entrySet()) {
                Map.Entry entry = entryObj;
                Object key = entry.getKey();
                if (!(key instanceof String)) continue;
                String path = parent.equals("/") ? "/" + key : parent + "/" + key;
                this.paths(values, paths, path, entry.getValue());
            }
            return;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            int i = 0;
            for (Object item : collection) {
                String path = parent.equals("/") ? "/" + i : parent + "/" + i;
                this.paths(values, paths, path, item);
                ++i;
            }
            return;
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(javaObject, i);
                String path = parent.equals("/") ? "/" + i : parent + "/" + i;
                this.paths(values, paths, path, item);
            }
            return;
        }
        if (ObjectWriterProvider.isPrimitiveOrEnum(clazz)) {
            return;
        }
        ObjectWriter<?> serializer = this.getWriterContext().getObjectWriter(clazz);
        if (serializer instanceof ObjectWriterAdapter) {
            ObjectWriterAdapter javaBeanSerializer = (ObjectWriterAdapter)serializer;
            try {
                Map<String, Object> fieldValues = javaBeanSerializer.toMap(javaObject);
                for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
                    String key = entry.getKey();
                    if (!(key instanceof String)) continue;
                    String path = parent.equals("/") ? "/" + key : parent + "/" + key;
                    this.paths(values, paths, path, entry.getValue());
                }
            }
            catch (Exception e) {
                throw new JSONException("toJSON error", e);
            }
            return;
        }
    }

    public abstract boolean isRef();

    public void arrayAdd(Object root, Object ... values) {
        Object result = this.eval(root);
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            for (Object value : values) {
                collection.add(value);
            }
            return;
        }
    }

    public abstract boolean contains(Object var1);

    public abstract Object eval(Object var1);

    public abstract Object extract(JSONReader var1);

    public abstract String extractScalar(JSONReader var1);

    public JSONReader.Context getReaderContext() {
        if (this.readerContext == null) {
            this.readerContext = JSONFactory.createReadContext();
        }
        return this.readerContext;
    }

    public JSONPath setReaderContext(JSONReader.Context context) {
        this.readerContext = context;
        return this;
    }

    public JSONWriter.Context getWriterContext() {
        if (this.writerContext == null) {
            this.writerContext = JSONFactory.createWriteContext();
        }
        return this.writerContext;
    }

    public JSONPath setWriterContext(JSONWriter.Context writerContext) {
        this.writerContext = writerContext;
        return this;
    }

    public abstract void set(Object var1, Object var2);

    public abstract void setInt(Object var1, int var2);

    public abstract void setLong(Object var1, long var2);

    public abstract boolean remove(Object var1);

    public void extract(JSONReader jsonReader, ValueConsumer consumer) {
        Object object = this.extract(jsonReader);
        if (object == null) {
            consumer.acceptNull();
            return;
        }
        if (object instanceof Number) {
            consumer.accept((Number)object);
            return;
        }
        if (object instanceof String) {
            consumer.accept((String)object);
            return;
        }
        if (object instanceof Boolean) {
            consumer.accept((Boolean)object);
            return;
        }
        if (object instanceof Map) {
            consumer.accept((Map)object);
            return;
        }
        if (object instanceof List) {
            consumer.accept((List)object);
            return;
        }
        throw new JSONException("TODO : " + object.getClass());
    }

    public void extractScalar(JSONReader jsonReader, ValueConsumer consumer) {
        String object = this.extractScalar(jsonReader);
        if (object == null) {
            consumer.acceptNull();
            return;
        }
        String str = object.toString();
        consumer.accept(str);
    }

    public Long extractInt64(JSONReader jsonReader) {
        long value = this.extractInt64Value(jsonReader);
        if (jsonReader.wasNull) {
            return null;
        }
        return value;
    }

    public long extractInt64Value(JSONReader jsonReader) {
        Object object = this.extract(jsonReader);
        if (object == null) {
            jsonReader.wasNull = true;
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(object.getClass(), Long.TYPE);
        if (typeConvert == null) {
            throw new JSONException("can not convert to long : " + object);
        }
        Object converted = typeConvert.apply(object);
        return (Long)converted;
    }

    public Integer extractInt32(JSONReader jsonReader) {
        int intValue = this.extractInt32Value(jsonReader);
        if (jsonReader.wasNull) {
            return null;
        }
        return intValue;
    }

    public int extractInt32Value(JSONReader jsonReader) {
        Object object = this.extract(jsonReader);
        if (object == null) {
            jsonReader.wasNull = true;
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(object.getClass(), Integer.TYPE);
        if (typeConvert == null) {
            throw new JSONException("can not convert to int : " + object);
        }
        Object converted = typeConvert.apply(object);
        return (Integer)converted;
    }

    public static JSONPath of(String path) {
        if (path.equals("#-1")) {
            return PreviousPath.INSTANCE;
        }
        JSONReader jsonReader = JSONReader.of(path);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        while (jsonReader.current() != '\u001a') {
            Segment segment;
            char ch;
            String name;
            if (jsonReader.current() == '$') {
                Segment segment2;
                jsonReader.next();
                if (jsonReader.current() != '.') continue;
                jsonReader.next();
                if (jsonReader.current() == '*') {
                    jsonReader.next();
                    segments.add(AllSegment.INSTANCE);
                    continue;
                }
                if (jsonReader.current() == '.') {
                    jsonReader.next();
                    long hashCode = jsonReader.readFieldNameHashCodeUnquote();
                    String name2 = jsonReader.getFieldName();
                    segments.add(new CycleNameSegment(name2, hashCode));
                    continue;
                }
                long hashCode = jsonReader.readFieldNameHashCodeUnquote();
                String name3 = jsonReader.getFieldName();
                if (jsonReader.ch == '(') {
                    switch (name3) {
                        case "length": 
                        case "size": {
                            segment2 = LengthSegment.INSTANCE;
                            break;
                        }
                        case "keys": {
                            segment2 = KeysSegment.INSTANCE;
                            break;
                        }
                        case "min": {
                            segment2 = MinSegment.INSTANCE;
                            break;
                        }
                        case "max": {
                            segment2 = MaxSegment.INSTANCE;
                            break;
                        }
                        case "type": {
                            segment2 = TypeSegment.INSTANCE;
                            break;
                        }
                        case "floor": {
                            segment2 = FloorSegment.INSTANCE;
                            break;
                        }
                        default: {
                            throw new JSONException("not support syntax, path : " + path);
                        }
                    }
                    jsonReader.next();
                    if (jsonReader.ch != ')') {
                        throw new JSONException("not support syntax, path : " + path);
                    }
                } else {
                    segment2 = new NameSegment(name3, hashCode);
                }
                segments.add(segment2);
                continue;
            }
            if (jsonReader.current() == '.') {
                Segment segment3;
                jsonReader.next();
                if (jsonReader.current() == '*') {
                    jsonReader.next();
                    segments.add(AllSegment.INSTANCE);
                    continue;
                }
                if (jsonReader.current() == '.') {
                    jsonReader.next();
                    long hashCode = jsonReader.readFieldNameHashCodeUnquote();
                    String name4 = jsonReader.getFieldName();
                    segments.add(new CycleNameSegment(name4, hashCode));
                    continue;
                }
                boolean isNum = jsonReader.isNumber();
                long hashCode = jsonReader.readFieldNameHashCodeUnquote();
                name = jsonReader.getFieldName();
                if (isNum) {
                    if (name.length() > 9) {
                        isNum = false;
                    } else {
                        for (int i = 0; i < name.length(); ++i) {
                            char ch2 = name.charAt(i);
                            if (ch2 >= '0' && ch2 <= '9') continue;
                            isNum = false;
                            break;
                        }
                    }
                }
                if (isNum) {
                    try {
                        int index = Integer.parseInt(name);
                        segments.add(IndexSegment.of(index));
                        continue;
                    }
                    catch (NumberFormatException index) {
                        // empty catch block
                    }
                }
                if (jsonReader.ch == '(') {
                    switch (name) {
                        case "length": 
                        case "size": {
                            segment3 = LengthSegment.INSTANCE;
                            break;
                        }
                        case "keys": {
                            segment3 = KeysSegment.INSTANCE;
                            break;
                        }
                        case "min": {
                            segment3 = MinSegment.INSTANCE;
                            break;
                        }
                        case "max": {
                            segment3 = MaxSegment.INSTANCE;
                            break;
                        }
                        case "type": {
                            segment3 = TypeSegment.INSTANCE;
                            break;
                        }
                        case "floor": {
                            segment3 = FloorSegment.INSTANCE;
                            break;
                        }
                        default: {
                            throw new JSONException("not support syntax, path : " + path);
                        }
                    }
                    jsonReader.next();
                    if (jsonReader.ch != ')') {
                        throw new JSONException("not support syntax, path : " + path);
                    }
                } else {
                    segment3 = new NameSegment(name, hashCode);
                }
                segments.add(segment3);
                continue;
            }
            if (jsonReader.ch == '[') {
                jsonReader.next();
                do {
                    switch (jsonReader.ch) {
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            Segment segment4;
                            int index = jsonReader.readInt32Value();
                            if (jsonReader.ch == ':') {
                                jsonReader.next();
                                if (jsonReader.ch == ']') {
                                    segment4 = new RangeIndexSegment(index, index >= 0 ? Integer.MAX_VALUE : 0);
                                } else {
                                    int end = jsonReader.readInt32Value();
                                    segment4 = new RangeIndexSegment(index, end);
                                }
                            } else if (jsonReader.isNumber()) {
                                ArrayList<Integer> list = new ArrayList<Integer>();
                                list.add(index);
                                while (jsonReader.isNumber()) {
                                    index = jsonReader.readInt32Value();
                                    list.add(index);
                                }
                                int[] indics = new int[list.size()];
                                for (int i = 0; i < list.size(); ++i) {
                                    indics[i] = (Integer)list.get(i);
                                }
                                segment4 = new MultiIndexSegment(indics);
                            } else {
                                segment4 = IndexSegment.of(index);
                            }
                            segments.add(segment4);
                            break;
                        }
                        case '*': {
                            jsonReader.next();
                            segments.add(AllSegment.INSTANCE);
                            break;
                        }
                        case ':': {
                            jsonReader.next();
                            int end = jsonReader.ch == ']' ? 0 : jsonReader.readInt32Value();
                            Segment segment4 = end > 0 ? new RangeIndexSegment(0, end) : new RangeIndexSegment(Integer.MIN_VALUE, end);
                            segments.add(segment4);
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            String name5 = jsonReader.readString();
                            if (jsonReader.current() == ']') {
                                segments.add(new NameSegment(name5, Fnv.hashCode64(name5)));
                                break;
                            }
                            if (jsonReader.isString()) {
                                ArrayList<String> names = new ArrayList<String>();
                                names.add(name5);
                                do {
                                    names.add(jsonReader.readString());
                                } while (jsonReader.isString());
                                String[] nameArray = new String[names.size()];
                                names.toArray(nameArray);
                                segments.add(new MultiNameSegment(nameArray));
                                break;
                            }
                            throw new JSONException("TODO : " + jsonReader.current());
                        }
                        case '?': {
                            jsonReader.next();
                            segments.add(JSONPath.parseFilter(jsonReader));
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.current());
                        }
                    }
                } while (jsonReader.ch != ']' && jsonReader.ch != '\u001a');
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    continue;
                }
            }
            if (!((ch = jsonReader.ch) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && ch != '_') break;
            long hashCode = jsonReader.readFieldNameHashCodeUnquote();
            name = jsonReader.getFieldName();
            if (jsonReader.ch == '(') {
                switch (name) {
                    case "length": 
                    case "size": {
                        segment = LengthSegment.INSTANCE;
                        break;
                    }
                    case "keys": {
                        segment = KeysSegment.INSTANCE;
                        break;
                    }
                    case "min": {
                        segment = MinSegment.INSTANCE;
                        break;
                    }
                    case "max": {
                        segment = MaxSegment.INSTANCE;
                        break;
                    }
                    case "type": {
                        segment = TypeSegment.INSTANCE;
                        break;
                    }
                    case "floor": {
                        segment = FloorSegment.INSTANCE;
                        break;
                    }
                    default: {
                        throw new JSONException("not support syntax, path : " + path);
                    }
                }
                jsonReader.next();
                if (jsonReader.ch != ')') {
                    throw new JSONException("not support syntax, path : " + path);
                }
            } else {
                segment = new NameSegment(name, hashCode);
            }
            segments.add(segment);
        }
        if (segments.size() == 1) {
            Segment segment = (Segment)segments.get(0);
            if (segment instanceof NameSegment) {
                return new SingleNamePath(path, (NameSegment)segment);
            }
            return new SingleSegmentPath(segment, path);
        }
        return new MultiSegmentPath(path, segments);
    }

    static Segment parseFilter(JSONReader jsonReader) {
        boolean parentheses = jsonReader.nextIfMatch('(');
        if (jsonReader.ch == '@') {
            jsonReader.next();
            if (jsonReader.ch != '.') {
                Number number;
                Operator operator = JSONPath.parseOperator(jsonReader);
                NameIntOpSegment segment = null;
                if (jsonReader.isNumber() && ((number = jsonReader.readNumber()) instanceof Integer || number instanceof Long)) {
                    segment = new NameIntOpSegment(null, 0L, null, operator, number.longValue());
                }
                if (segment != null) {
                    if (parentheses && !jsonReader.nextIfMatch(')')) {
                        throw new JSONException("syntax error, " + jsonReader.ch);
                    }
                    return segment;
                }
                throw new JSONException("syntax error, " + jsonReader.ch);
            }
            jsonReader.next();
            long hashCode = jsonReader.readFieldNameHashCodeUnquote();
            String fieldName = jsonReader.getFieldName();
            if (parentheses && jsonReader.nextIfMatch(')')) {
                NameExistsFilter segment = new NameExistsFilter(fieldName, hashCode);
                return segment;
            }
            Function function = null;
            if (jsonReader.ch == '(') {
                jsonReader.next();
                if (!jsonReader.nextIfMatch(')')) {
                    throw new JSONException("syntax error, function " + fieldName);
                }
                switch (fieldName) {
                    case "type": {
                        fieldName = null;
                        hashCode = 0L;
                        function = TypeFunction.INSTANCE;
                        break;
                    }
                    case "size": {
                        fieldName = null;
                        hashCode = 0L;
                        function = SizeFunction.INSTANCE;
                        break;
                    }
                    default: {
                        throw new JSONException("syntax error, function not support " + fieldName);
                    }
                }
            }
            Operator operator = JSONPath.parseOperator(jsonReader);
            switch (operator) {
                case REG_MATCH: 
                case RLIKE: 
                case NOT_RLIKE: {
                    boolean ignoreCase;
                    String regex;
                    if (jsonReader.isString()) {
                        regex = jsonReader.readString();
                        ignoreCase = false;
                    } else {
                        regex = jsonReader.readPattern();
                        ignoreCase = jsonReader.nextIfMatch('i');
                    }
                    Pattern pattern = ignoreCase ? Pattern.compile(regex, 2) : Pattern.compile(regex);
                    NameRLikeSegment segment = new NameRLikeSegment(fieldName, hashCode, pattern, operator == Operator.NOT_RLIKE);
                    if (!jsonReader.nextIfMatch(')')) {
                        throw new JSONException("syntax error, " + jsonReader.ch);
                    }
                    return segment;
                }
                case IN: 
                case NOT_IN: {
                    NameFilter segment;
                    if (jsonReader.ch != '(') {
                        throw new JSONException("syntax error, " + jsonReader.ch);
                    }
                    jsonReader.next();
                    if (jsonReader.isString()) {
                        ArrayList<String> list = new ArrayList<String>();
                        while (jsonReader.isString()) {
                            list.add(jsonReader.readString());
                        }
                        String[] strArray = new String[list.size()];
                        list.toArray(strArray);
                        segment = new NameStringInSegment(fieldName, hashCode, strArray, operator == Operator.NOT_IN);
                    } else if (jsonReader.isNumber()) {
                        ArrayList<Number> list = new ArrayList<Number>();
                        while (jsonReader.isNumber()) {
                            list.add(jsonReader.readNumber());
                        }
                        long[] values = new long[list.size()];
                        for (int i = 0; i < list.size(); ++i) {
                            values[i] = ((Number)list.get(i)).longValue();
                        }
                        segment = new NameIntInSegment(fieldName, hashCode, function, values, operator == Operator.NOT_IN);
                    } else {
                        throw new JSONException("syntax error, " + jsonReader.ch);
                    }
                    if (!jsonReader.nextIfMatch(')')) {
                        throw new JSONException("syntax error, " + jsonReader.ch);
                    }
                    if (!jsonReader.nextIfMatch(')')) {
                        throw new JSONException("syntax error, " + jsonReader.ch);
                    }
                    return segment;
                }
                case BETWEEN: 
                case NOT_BETWEEN: {
                    Number begin;
                    if (jsonReader.isNumber()) {
                        begin = jsonReader.readNumber();
                        String and = jsonReader.readFieldNameUnquote();
                        if (!"and".equalsIgnoreCase(and)) {
                            throw new JSONException("syntax error, " + and);
                        }
                    } else {
                        throw new JSONException("syntax error, " + jsonReader.ch);
                    }
                    Number end = jsonReader.readNumber();
                    boolean beginInt = begin instanceof Byte || begin instanceof Short || begin instanceof Integer || begin instanceof Long;
                    boolean endInt = end instanceof Byte || end instanceof Short || end instanceof Integer || end instanceof Long;
                    NameIntBetweenSegment segment = new NameIntBetweenSegment(fieldName, hashCode, begin.longValue(), end.longValue(), operator == Operator.NOT_BETWEEN);
                    if (parentheses && !jsonReader.nextIfMatch(')')) {
                        throw new JSONException("syntax error, " + jsonReader.ch);
                    }
                    return segment;
                }
            }
            Segment segment = null;
            switch (jsonReader.ch) {
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    Number number = jsonReader.readNumber();
                    if (number instanceof Integer || number instanceof Long) {
                        segment = new NameIntOpSegment(fieldName, hashCode, function, operator, number.longValue());
                        break;
                    }
                    if (number instanceof BigDecimal) {
                        segment = new NameDecimalOpSegment(fieldName, hashCode, operator, (BigDecimal)number);
                        break;
                    }
                    throw new JSONException("TODO : " + number);
                }
                case '\"': 
                case '\'': {
                    String strVal = jsonReader.readString();
                    int p0 = strVal.indexOf(37);
                    if (p0 == -1) {
                        if (operator == Operator.LIKE) {
                            operator = Operator.EQ;
                        } else if (operator == Operator.NOT_LIKE) {
                            operator = Operator.NE;
                        }
                    }
                    if (operator == Operator.LIKE || operator == Operator.NOT_LIKE) {
                        String[] items = strVal.split("%");
                        String startsWithValue = null;
                        String endsWithValue = null;
                        String[] containsValues = null;
                        if (p0 == 0) {
                            if (strVal.charAt(strVal.length() - 1) == '%') {
                                containsValues = new String[items.length - 1];
                                System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                            } else {
                                endsWithValue = items[items.length - 1];
                                if (items.length > 2) {
                                    containsValues = new String[items.length - 2];
                                    System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                                }
                            }
                        } else if (strVal.charAt(strVal.length() - 1) == '%') {
                            if (items.length == 1) {
                                startsWithValue = items[0];
                            } else {
                                containsValues = items;
                            }
                        } else if (items.length == 1) {
                            startsWithValue = items[0];
                        } else if (items.length == 2) {
                            startsWithValue = items[0];
                            endsWithValue = items[1];
                        } else {
                            startsWithValue = items[0];
                            endsWithValue = items[items.length - 1];
                            containsValues = new String[items.length - 2];
                            System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                        }
                        segment = new NameMatchFilter(fieldName, hashCode, startsWithValue, endsWithValue, containsValues, operator == Operator.NOT_LIKE);
                        break;
                    }
                    segment = new NameStringOpSegment(fieldName, hashCode, function, operator, strVal);
                    break;
                }
                case 't': {
                    String ident = jsonReader.readFieldNameUnquote();
                    if (!ident.equalsIgnoreCase("true")) break;
                    segment = new NameIntOpSegment(fieldName, hashCode, function, operator, 1L);
                    break;
                }
                case 'f': {
                    String ident = jsonReader.readFieldNameUnquote();
                    if (!ident.equalsIgnoreCase("false")) break;
                    segment = new NameIntOpSegment(fieldName, hashCode, function, operator, 0L);
                    break;
                }
                default: {
                    throw new JSONException("TODO : " + jsonReader.ch);
                }
            }
            if (jsonReader.ch == '&' || jsonReader.ch == '|' || jsonReader.ch == 'a' || jsonReader.ch == 'o') {
                segment = JSONPath.parseFilterRest(segment, jsonReader);
            }
            if (parentheses && !jsonReader.nextIfMatch(')')) {
                throw new JSONException("TODO : " + jsonReader.ch);
            }
            return segment;
        }
        throw new JSONException("TODO : " + jsonReader.ch);
    }

    static Segment parseFilterRest(Segment segment, JSONReader jsonReader) {
        boolean and;
        switch (jsonReader.ch) {
            case '&': {
                jsonReader.next();
                if (!jsonReader.nextIfMatch('&')) {
                    throw new JSONException("syntx error, " + jsonReader.ch);
                }
                and = true;
                break;
            }
            case '|': {
                jsonReader.next();
                if (!jsonReader.nextIfMatch('|')) {
                    throw new JSONException("syntx error, " + jsonReader.ch);
                }
                and = false;
                break;
            }
            case 'A': 
            case 'a': {
                String fieldName = jsonReader.readFieldNameUnquote();
                if (!fieldName.equalsIgnoreCase("and")) {
                    throw new JSONException("syntax error : " + fieldName);
                }
                and = true;
                break;
            }
            case 'O': 
            case 'o': {
                String fieldName = jsonReader.readFieldNameUnquote();
                if (!fieldName.equalsIgnoreCase("or")) {
                    throw new JSONException("syntax error : " + fieldName);
                }
                and = false;
                break;
            }
            default: {
                throw new JSONException("TODO : " + jsonReader.ch);
            }
        }
        Segment right = JSONPath.parseFilter(jsonReader);
        if (segment instanceof GroupFilter) {
            GroupFilter group = (GroupFilter)segment;
            if (group.and == and) {
                group.filters.add((FilterSegment)right);
                return group;
            }
        }
        ArrayList<FilterSegment> filters = new ArrayList<FilterSegment>();
        filters.add((FilterSegment)segment);
        filters.add((FilterSegment)right);
        return new GroupFilter(filters, and);
    }

    static Operator parseOperator(JSONReader jsonReader) {
        Operator operator;
        switch (jsonReader.ch) {
            case '<': {
                jsonReader.next();
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = Operator.LE;
                    break;
                }
                if (jsonReader.ch == '>') {
                    jsonReader.next();
                    operator = Operator.NE;
                    break;
                }
                operator = Operator.LT;
                break;
            }
            case '=': {
                jsonReader.next();
                if (jsonReader.ch == '~') {
                    jsonReader.next();
                    operator = Operator.REG_MATCH;
                    break;
                }
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = Operator.EQ;
                    break;
                }
                operator = Operator.EQ;
                break;
            }
            case '!': {
                jsonReader.next();
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = Operator.NE;
                    break;
                }
                throw new JSONException("not support operator : !" + jsonReader.ch);
            }
            case '>': {
                jsonReader.next();
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = Operator.GE;
                    break;
                }
                operator = Operator.GT;
                break;
            }
            case 'L': 
            case 'l': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if (fieldName.equalsIgnoreCase("like")) {
                    operator = Operator.LIKE;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'N': 
            case 'n': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if (fieldName.equalsIgnoreCase("nin")) {
                    operator = Operator.NOT_IN;
                    break;
                }
                if (!fieldName.equalsIgnoreCase("not")) {
                    throw new JSONException("not support operator : " + fieldName);
                }
                jsonReader.readFieldNameHashCodeUnquote();
                fieldName = jsonReader.getFieldName();
                if (fieldName.equalsIgnoreCase("like")) {
                    operator = Operator.NOT_LIKE;
                    break;
                }
                if (fieldName.equalsIgnoreCase("rlike")) {
                    operator = Operator.NOT_RLIKE;
                    break;
                }
                if (fieldName.equalsIgnoreCase("in")) {
                    operator = Operator.NOT_IN;
                    break;
                }
                if (fieldName.equalsIgnoreCase("between")) {
                    operator = Operator.NOT_BETWEEN;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'I': 
            case 'i': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if (fieldName.equalsIgnoreCase("in")) {
                    operator = Operator.IN;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'R': 
            case 'r': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if (fieldName.equalsIgnoreCase("rlike")) {
                    operator = Operator.RLIKE;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'B': 
            case 'b': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if (fieldName.equalsIgnoreCase("between")) {
                    operator = Operator.BETWEEN;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            default: {
                jsonReader.readFieldNameHashCodeUnquote();
                throw new JSONException("not support operator : " + jsonReader.getFieldName());
            }
        }
        return operator;
    }

    static String type(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Collection) {
            return "array";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof String || value instanceof UUID || value instanceof Enum) {
            return "string";
        }
        return "object";
    }

    static final class AllSegment
    extends Segment {
        static final AllSegment INSTANCE = new AllSegment();

        @Override
        public void eval(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(map.size());
                for (Object value : map.values()) {
                    if (value instanceof Collection) {
                        array.addAll((Collection)value);
                        continue;
                    }
                    array.add(value);
                }
                context.value = array;
                context.eval = true;
                return;
            }
            if (object instanceof Collection) {
                context.value = object;
                context.eval = true;
                return;
            }
            ObjectWriterProvider provider = context.path.getWriterContext().getProvider();
            ObjectWriter objectWriter = provider.getObjectWriter(object.getClass());
            List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
            int size = fieldWriters.size();
            JSONArray array = new JSONArray(size);
            for (int i = 0; i < size; ++i) {
                Object fieldValue = fieldWriters.get(i).getFieldValue(object);
                array.add(fieldValue);
            }
            context.value = array;
            context.eval = true;
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            if (ctx.parent != null && ctx.parent.eval) {
                this.eval(ctx);
                return;
            }
            JSONArray values = new JSONArray();
            if (jsonReader.isJSONB()) {
                if (jsonReader.nextIfMatch((byte)-90)) {
                    int i = 0;
                    while (!jsonReader.nextIfMatch((byte)-91)) {
                        if (jsonReader.skipName()) {
                            Object val = jsonReader.readAny();
                            if (val instanceof Collection) {
                                values.addAll((Collection)val);
                            } else {
                                values.add(val);
                            }
                        }
                        ++i;
                    }
                    ctx.value = values;
                    return;
                }
                if (jsonReader.isArray() && ctx.next != null) {
                    return;
                }
                throw new JSONException("TODO");
            }
            if (jsonReader.nextIfMatch('{')) {
                block10: while (true) {
                    Object val;
                    if (jsonReader.ch == '}') {
                        jsonReader.next();
                        break;
                    }
                    jsonReader.skipName();
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        case ']': {
                            jsonReader.next();
                            break block10;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    if (val instanceof Collection) {
                        values.addAll((Collection)val);
                    } else {
                        values.add(val);
                    }
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                ctx.value = values;
                return;
            }
            if (jsonReader.ch != '[' || ctx.next == null) {
                throw new JSONException("TODO");
            }
        }
    }

    static final class MultiNameSegment
    extends Segment {
        final String[] names;
        final long[] nameHashCodes;

        public MultiNameSegment(String[] names) {
            this.names = names;
            this.nameHashCodes = new long[names.length];
            for (int i = 0; i < names.length; ++i) {
                this.nameHashCodes[i] = Fnv.hashCode64(names[i]);
            }
        }

        @Override
        public void eval(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                context.value = new JSONArray(((Map)object).values());
                return;
            }
            if (object instanceof Collection) {
                context.value = object;
                return;
            }
            ObjectWriterProvider provider = context.path.getWriterContext().getProvider();
            ObjectWriter objectWriter = provider.getObjectWriter(object.getClass());
            JSONArray array = new JSONArray(this.names.length);
            for (int i = 0; i < this.names.length; ++i) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCodes[i]);
                Object fieldValue = null;
                if (fieldWriter != null) {
                    fieldValue = fieldWriter.getFieldValue(object);
                }
                array.add(fieldValue);
            }
            context.value = array;
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
        }
    }

    static final class MultiIndexSegment
    extends Segment {
        final int[] indexes;

        public MultiIndexSegment(int[] indexes) {
            Arrays.sort(indexes);
            this.indexes = indexes;
        }

        @Override
        public void eval(Context ctx) {
            Object object = ctx.parent == null ? ctx.root : ctx.parent.value;
            JSONArray result = new JSONArray();
            if (object instanceof List) {
                List list = (List)object;
                for (int i = 0; i < list.size(); ++i) {
                    boolean match;
                    boolean bl = match = Arrays.binarySearch(this.indexes, i) >= 0 || Arrays.binarySearch(this.indexes, i - list.size()) >= 0;
                    if (!match) continue;
                    result.add(list.get(i));
                }
                ctx.value = result;
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                for (int i = 0; i < array.length; ++i) {
                    boolean match;
                    boolean bl = match = Arrays.binarySearch(this.indexes, i) >= 0 || Arrays.binarySearch(this.indexes, i - array.length) >= 0;
                    if (!match) continue;
                    result.add(array[i]);
                }
                ctx.value = result;
                return;
            }
            throw new JSONException("TODO");
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            if (ctx.parent != null && ctx.parent.current instanceof CycleNameSegment && ctx.next == null) {
                this.eval(ctx);
                return;
            }
            if (jsonReader.isJSONB()) {
                JSONArray array = new JSONArray();
                int itemCnt = jsonReader.startArray();
                for (int i = 0; i < itemCnt; ++i) {
                    boolean match;
                    boolean bl = match = Arrays.binarySearch(this.indexes, i) >= 0;
                    if (!match) {
                        jsonReader.skipValue();
                        continue;
                    }
                    array.add(jsonReader.readAny());
                }
                ctx.value = array;
                return;
            }
            JSONArray array = new JSONArray();
            jsonReader.next();
            int i = 0;
            while (jsonReader.ch != '\u001a') {
                boolean match;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                boolean bl = match = Arrays.binarySearch(this.indexes, i) >= 0;
                if (!match) {
                    jsonReader.skipValue();
                    if (jsonReader.ch == ',') {
                        jsonReader.next();
                    }
                } else {
                    Object val;
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    array.add(val);
                }
                ++i;
            }
            ctx.value = array;
        }
    }

    static final class RangeIndexSegment
    extends Segment {
        final int begin;
        final int end;

        public RangeIndexSegment(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        @Override
        public void eval(Context ctx) {
            Object object = ctx.parent == null ? ctx.root : ctx.parent.value;
            JSONArray result = new JSONArray();
            if (object instanceof List) {
                List list = (List)object;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    boolean match;
                    if (this.begin >= 0) {
                        match = i >= this.begin && i < this.end;
                    } else {
                        int ni = i - size;
                        boolean bl = match = ni >= this.begin && ni < this.end;
                    }
                    if (!match) continue;
                    result.add(list.get(i));
                }
                ctx.value = result;
                ctx.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                for (int i = 0; i < array.length; ++i) {
                    boolean match;
                    boolean bl = match = i >= this.begin && i <= this.end || i - array.length > this.begin && i - array.length <= this.end;
                    if (!match) continue;
                    result.add(array[i]);
                }
                ctx.value = result;
                ctx.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            if (ctx.parent != null && (ctx.parent.eval || ctx.parent.current instanceof CycleNameSegment && ctx.next == null)) {
                this.eval(ctx);
                return;
            }
            if (jsonReader.isJSONB()) {
                int i;
                JSONArray array = new JSONArray();
                int itemCnt = jsonReader.startArray();
                for (i = 0; i < itemCnt; ++i) {
                    boolean match;
                    boolean bl = match = this.begin < 0 || i >= this.begin && i < this.end;
                    if (!match) {
                        jsonReader.skipValue();
                        continue;
                    }
                    array.add(jsonReader.readAny());
                }
                if (this.begin < 0) {
                    int size = array.size();
                    for (i = size - 1; i >= 0; --i) {
                        int ni = i - size;
                        if (ni >= this.begin && ni < this.end) continue;
                        array.remove(i);
                    }
                }
                ctx.value = array;
                ctx.eval = true;
                return;
            }
            JSONArray array = new JSONArray();
            jsonReader.next();
            int i = 0;
            while (jsonReader.ch != '\u001a') {
                boolean match;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                boolean bl = match = this.begin < 0 || i >= this.begin && i < this.end;
                if (!match) {
                    jsonReader.skipValue();
                    if (jsonReader.ch == ',') {
                        jsonReader.next();
                    }
                } else {
                    Object val;
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    array.add(val);
                }
                ++i;
            }
            if (this.begin < 0) {
                int size = array.size();
                for (int i2 = size - 1; i2 >= 0; --i2) {
                    int ni = i2 - size;
                    if (ni >= this.begin && ni < this.end) continue;
                    array.remove(i2);
                }
            }
            ctx.value = array;
            ctx.eval = true;
        }
    }

    static final class IndexSegment
    extends Segment {
        static final IndexSegment ZERO = new IndexSegment(0);
        static final IndexSegment ONE = new IndexSegment(1);
        static final IndexSegment TWO = new IndexSegment(2);
        final int index;

        public IndexSegment(int index) {
            this.index = index;
        }

        static IndexSegment of(int index) {
            if (index == 0) {
                return ZERO;
            }
            if (index == 1) {
                return ONE;
            }
            if (index == 2) {
                return TWO;
            }
            return new IndexSegment(index);
        }

        @Override
        public void eval(Context ctx) {
            Object object;
            Object object2 = object = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (object == null) {
                ctx.eval = true;
                return;
            }
            if (object instanceof List) {
                List list = (List)object;
                if (this.index >= 0) {
                    if (this.index < list.size()) {
                        ctx.value = list.get(this.index);
                    }
                } else {
                    int itemIndex = list.size() + this.index;
                    if (itemIndex >= 0) {
                        ctx.value = list.get(itemIndex);
                    }
                }
                ctx.eval = true;
                return;
            }
            if (object instanceof SortedSet || object instanceof LinkedHashSet || this.index == 0 && object instanceof Collection && ((Collection)object).size() == 1) {
                Collection collection = (Collection)object;
                int i = 0;
                for (Object item : collection) {
                    if (i == this.index) {
                        ctx.value = item;
                        break;
                    }
                    ++i;
                }
                ctx.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                if (this.index >= 0) {
                    if (this.index < array.length) {
                        ctx.value = array[this.index];
                    }
                } else {
                    int itemIndex = array.length + this.index;
                    if (itemIndex >= 0) {
                        ctx.value = array[itemIndex];
                    }
                }
                ctx.eval = true;
                return;
            }
            Class<?> objectClass = object.getClass();
            if (objectClass.isArray()) {
                int length = Array.getLength(object);
                if (this.index >= 0) {
                    if (this.index < length) {
                        ctx.value = Array.get(object, this.index);
                    }
                } else {
                    int itemIndex = length + this.index;
                    if (itemIndex >= 0) {
                        ctx.value = Array.get(object, itemIndex);
                    }
                }
                ctx.eval = true;
                return;
            }
            if (Map.class.isAssignableFrom(objectClass)) {
                Map map = (Map)object;
                Object value = map.get(this.index);
                if (value == null) {
                    value = map.get(Integer.toString(this.index));
                }
                if (value == null) {
                    if (map.size() == 1 || map instanceof LinkedHashMap || map instanceof SortedMap) {
                        Iterator it = map.entrySet().iterator();
                        for (int i = 0; i <= this.index && i < map.size() && it.hasNext(); ++i) {
                            Map.Entry entry = it.next();
                            Object entryKey = entry.getKey();
                            Object entryValue = entry.getValue();
                            if (entryKey instanceof Long) {
                                if (!entryKey.equals(this.index)) continue;
                                value = entryValue;
                                break;
                            }
                            if (i != this.index) continue;
                            value = entryValue;
                        }
                    } else {
                        Iterator it = map.entrySet().iterator();
                        for (int i = 0; i <= this.index && i < map.size() && it.hasNext(); ++i) {
                            Map.Entry entry = it.next();
                            Object entryKey = entry.getKey();
                            Object entryValue = entry.getValue();
                            if (!(entryKey instanceof Long) || !entryKey.equals(this.index)) continue;
                            value = entryValue;
                            break;
                        }
                    }
                }
                ctx.value = value;
                ctx.eval = true;
                return;
            }
            throw new JSONException("jsonpath not support operate : " + ctx.path + ", objectClass" + objectClass.getName());
        }

        @Override
        public void set(Context ctx, Object value) {
            Object object;
            Object object2 = object = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                if (this.index >= 0) {
                    if (this.index < list.size()) {
                        list.set(this.index, value);
                    }
                } else {
                    int itemIndex = list.size() + this.index;
                    if (itemIndex >= 0) {
                        list.set(itemIndex, value);
                    }
                }
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                if (this.index >= 0) {
                    array[this.index] = value;
                } else {
                    array[array.length + this.index] = value;
                }
                return;
            }
            if (object != null && object.getClass().isArray()) {
                int length = Array.getLength(object);
                if (this.index >= 0) {
                    if (this.index < length) {
                        Array.set(object, this.index, value);
                    }
                } else {
                    int arrayIndex = length + this.index;
                    if (arrayIndex >= 0) {
                        Array.set(object, arrayIndex, value);
                    }
                }
                return;
            }
            throw new JSONException("UnsupportedOperation");
        }

        @Override
        public void setInt(Context ctx, int value) {
            Object object;
            Object object2 = object = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (object instanceof int[]) {
                int[] array = (int[])object;
                if (this.index >= 0) {
                    if (this.index < array.length) {
                        array[this.index] = value;
                    }
                } else {
                    int arrayIndex = array.length + this.index;
                    if (arrayIndex >= 0) {
                        array[arrayIndex] = value;
                    }
                }
                return;
            }
            if (object instanceof long[]) {
                long[] array = (long[])object;
                if (this.index >= 0) {
                    if (this.index < array.length) {
                        array[this.index] = value;
                    }
                } else {
                    int arrayIndex = array.length + this.index;
                    if (arrayIndex >= 0) {
                        array[arrayIndex] = value;
                    }
                }
                return;
            }
            this.set(ctx, value);
        }

        @Override
        public void setLong(Context ctx, long value) {
            Object object;
            Object object2 = object = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (object instanceof int[]) {
                int[] array = (int[])object;
                if (this.index >= 0) {
                    if (this.index < array.length) {
                        array[this.index] = (int)value;
                    }
                } else {
                    int arrayIndex = array.length + this.index;
                    if (arrayIndex >= 0) {
                        array[arrayIndex] = (int)value;
                    }
                }
                return;
            }
            if (object instanceof long[]) {
                long[] array = (long[])object;
                if (this.index >= 0) {
                    if (this.index < array.length) {
                        array[this.index] = value;
                    }
                } else {
                    int arrayIndex = array.length + this.index;
                    if (arrayIndex >= 0) {
                        array[arrayIndex] = value;
                    }
                }
                return;
            }
            this.set(ctx, value);
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            if (ctx.parent != null && (ctx.parent.eval || ctx.parent.current instanceof CycleNameSegment && ctx.next == null)) {
                this.eval(ctx);
                return;
            }
            if (jsonReader.isJSONB()) {
                int itemCnt = jsonReader.startArray();
                for (int i = 0; i < itemCnt; ++i) {
                    boolean match;
                    boolean bl = match = this.index == i;
                    if (match) {
                        if ((jsonReader.isArray() || jsonReader.isObject()) && ctx.next != null) break;
                        ctx.value = jsonReader.readAny();
                        ctx.eval = true;
                        break;
                    }
                    jsonReader.skipValue();
                }
                return;
            }
            jsonReader.next();
            int i = 0;
            block9: while (jsonReader.ch != '\u001a') {
                boolean match;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                boolean bl = match = this.index == i;
                if (!match) {
                    jsonReader.skipValue();
                    if (jsonReader.ch == ',') {
                        jsonReader.next();
                    }
                } else {
                    Map<String, Object> val;
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            if (ctx.next != null && !(ctx.next instanceof EvalSegment)) break block9;
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            if (ctx.next != null && !(ctx.next instanceof EvalSegment)) break block9;
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    ctx.value = val;
                }
                ++i;
            }
        }

        public String toString() {
            int size = this.index < 0 ? IOUtils.stringSize(-this.index) + 1 : IOUtils.stringSize(this.index);
            byte[] bytes = new byte[size + 2];
            bytes[0] = 91;
            IOUtils.getChars(this.index, bytes.length - 1, bytes);
            bytes[bytes.length - 1] = 93;
            String str = JDKUtils.UNSAFE_ASCII_CREATOR != null ? JDKUtils.UNSAFE_ASCII_CREATOR.apply(bytes) : new String(bytes, StandardCharsets.US_ASCII);
            return str;
        }
    }

    static final class CycleNameSegment
    extends Segment {
        final String name;
        final long nameHashCode;

        public CycleNameSegment(String name, long nameHashCode) {
            this.name = name;
            this.nameHashCode = nameHashCode;
        }

        public String toString() {
            return ".." + this.name;
        }

        @Override
        public boolean remove(Context context) {
            this.set(context, null);
            context.eval = true;
            return true;
        }

        @Override
        public void eval(Context context) {
            ObjectWriter<?> objectWriter;
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray values = new JSONArray();
            MapLoop action = new MapLoop(context, values);
            if (object instanceof Map) {
                Map map = (Map)object;
                map.forEach(action);
            } else if (object instanceof Collection) {
                ((Collection)object).forEach(action);
            } else if (object != null && (objectWriter = context.path.getWriterContext().getObjectWriter(object.getClass())) instanceof ObjectWriterAdapter) {
                action.accept(object);
            }
            context.value = values.size() == 1 && values.get(0) instanceof Collection ? values.get(0) : values;
            context.eval = true;
        }

        @Override
        public void set(Context context, Object value) {
            Object object = context.parent == null ? context.root : context.parent.value;
            LoopSet action = new LoopSet(context, value);
            action.accept(object);
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            JSONArray values = new JSONArray();
            this.accept(jsonReader, ctx, values);
            ctx.value = values;
            ctx.eval = true;
        }

        public void accept(JSONReader jsonReader, Context ctx, List<Object> values) {
            if (jsonReader.isJSONB()) {
                if (jsonReader.nextIfMatch((byte)-90)) {
                    int i = 0;
                    while (!jsonReader.nextIfMatch((byte)-91)) {
                        long nameHashCode = jsonReader.readFieldNameHashCode();
                        if (nameHashCode != 0L) {
                            boolean match;
                            boolean bl = match = nameHashCode == this.nameHashCode;
                            if (match) {
                                if (jsonReader.isArray()) {
                                    values.addAll(jsonReader.readArray());
                                } else {
                                    values.add(jsonReader.readAny());
                                }
                            } else if (jsonReader.isObject() || jsonReader.isArray()) {
                                this.accept(jsonReader, ctx, values);
                            } else {
                                jsonReader.skipValue();
                            }
                        }
                        ++i;
                    }
                    return;
                }
                if (jsonReader.isArray()) {
                    int itemCnt = jsonReader.startArray();
                    for (int i = 0; i < itemCnt; ++i) {
                        if (jsonReader.isObject() || jsonReader.isArray()) {
                            this.accept(jsonReader, ctx, values);
                            continue;
                        }
                        jsonReader.skipValue();
                    }
                } else {
                    jsonReader.skipValue();
                }
                return;
            }
            if (jsonReader.ch == '{') {
                jsonReader.next();
                block9: while (true) {
                    Object val;
                    if (jsonReader.ch == '}') break;
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean match = nameHashCode == this.nameHashCode;
                    char ch = jsonReader.ch;
                    if (!match && ch != '{' && ch != '[') {
                        jsonReader.skipValue();
                        continue;
                    }
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': 
                        case '{': {
                            if (match) {
                                val = ch == '[' ? jsonReader.readArray() : jsonReader.readObject();
                                break;
                            }
                            this.accept(jsonReader, ctx, values);
                            continue block9;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    if (val instanceof Collection) {
                        values.addAll((Collection)val);
                    } else {
                        values.add(val);
                    }
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                jsonReader.next();
                if (jsonReader.ch == ',') {
                    jsonReader.next();
                }
            } else if (jsonReader.ch == '[') {
                block35: {
                    jsonReader.next();
                    do {
                        if (jsonReader.ch == ']') {
                            jsonReader.next();
                            break block35;
                        }
                        if (jsonReader.ch == '{' || jsonReader.ch == '[') {
                            this.accept(jsonReader, ctx, values);
                            continue;
                        }
                        jsonReader.skipValue();
                    } while (jsonReader.ch != ',');
                    jsonReader.next();
                }
                if (jsonReader.ch == ',') {
                    jsonReader.next();
                }
            } else {
                jsonReader.skipValue();
            }
        }

        class LoopSet {
            final Context context;
            final Object value;

            public LoopSet(Context context, Object value) {
                this.context = context;
                this.value = value;
            }

            public void accept(Object object) {
                if (object instanceof Map) {
                    for (Map.Entry entry : ((Map)object).entrySet()) {
                        if (CycleNameSegment.this.name.equals(entry.getKey())) {
                            entry.setValue(this.value);
                            this.context.eval = true;
                            continue;
                        }
                        Object entryValue = entry.getValue();
                        if (entryValue == null) continue;
                        this.accept(entryValue);
                    }
                } else if (object instanceof Collection) {
                    for (Object e : (List)object) {
                        this.accept(e);
                    }
                } else {
                    FieldReader fieldReader;
                    Class<?> entryValueClass = object.getClass();
                    ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(entryValueClass);
                    if (objectReader instanceof ObjectReaderBean && (fieldReader = objectReader.getFieldReader(CycleNameSegment.this.nameHashCode)) != null) {
                        fieldReader.accept(object, this.value);
                        this.context.eval = true;
                        return;
                    }
                    ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(entryValueClass);
                    List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
                    for (FieldWriter fieldWriter : fieldWriters) {
                        Object fieldValue = fieldWriter.getFieldValue(object);
                        this.accept(fieldValue);
                    }
                }
            }
        }

        class MapLoop
        implements BiConsumer,
        Consumer {
            final Context context;
            final List values;

            public MapLoop(Context context, List values) {
                this.context = context;
                this.values = values;
            }

            public void accept(Object key, Object value) {
                if (CycleNameSegment.this.name.equals(key)) {
                    this.values.add(value);
                    return;
                }
                if (value instanceof Map) {
                    ((Map)value).forEach(this);
                } else if (value instanceof List) {
                    ((List)value).forEach(this);
                }
            }

            public void accept(Object value) {
                if (value == null) {
                    return;
                }
                if (value instanceof Map) {
                    ((Map)value).forEach(this);
                } else if (value instanceof List) {
                    ((List)value).forEach(this);
                } else {
                    ObjectWriter<?> objectWriter = this.context.path.getWriterContext().getObjectWriter(value.getClass());
                    if (objectWriter instanceof ObjectWriterAdapter) {
                        FieldWriter fieldWriter = objectWriter.getFieldWriter(CycleNameSegment.this.nameHashCode);
                        if (fieldWriter != null) {
                            Object fieldValue = fieldWriter.getFieldValue(value);
                            if (fieldValue != null) {
                                this.values.add(fieldValue);
                            }
                            return;
                        }
                        for (int i = 0; i < objectWriter.getFieldWriters().size(); ++i) {
                            fieldWriter = objectWriter.getFieldWriters().get(i);
                            Object fieldValue = fieldWriter.getFieldValue(value);
                            this.accept(fieldValue);
                        }
                        return;
                    }
                    this.values.add(value);
                }
            }
        }
    }

    static final class NameSegment
    extends Segment {
        static final long HASH_NAME = Fnv.hashCode64("name");
        static final long HASH_ORDINAL = Fnv.hashCode64("ordinal");
        final String name;
        final long nameHashCode;

        public NameSegment(String name, long nameHashCode) {
            this.name = name;
            this.nameHashCode = nameHashCode;
        }

        @Override
        public boolean remove(Context context) {
            this.set(context, null);
            context.eval = true;
            return true;
        }

        @Override
        public boolean contains(Context ctx) {
            FieldWriter fieldWriter;
            ObjectWriter<?> objectWriter;
            Object object;
            Object object2 = object = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (object == null) {
                return false;
            }
            if (object instanceof Map) {
                return ((Map)object).get(this.name) != null;
            }
            if (object instanceof Collection) {
                for (Object item : (Collection)object) {
                    FieldWriter fieldWriter2;
                    if (item == null) continue;
                    if (item instanceof Map && ((Map)item).get(this.name) != null) {
                        return true;
                    }
                    ObjectWriter<?> objectWriter2 = ctx.path.getWriterContext().getObjectWriter(item.getClass());
                    if (!(objectWriter2 instanceof ObjectWriterAdapter) || (fieldWriter2 = objectWriter2.getFieldWriter(this.nameHashCode)) == null || fieldWriter2.getFieldValue(item) == null) continue;
                    return true;
                }
                return false;
            }
            if (object instanceof Object[]) {
                Object[] array;
                for (Object item : array = (Object[])object) {
                    FieldWriter fieldWriter3;
                    if (item == null) continue;
                    if (item instanceof Map && ((Map)item).get(this.name) != null) {
                        return true;
                    }
                    ObjectWriter<?> objectWriter3 = ctx.path.getWriterContext().getObjectWriter(item.getClass());
                    if (!(objectWriter3 instanceof ObjectWriterAdapter) || (fieldWriter3 = objectWriter3.getFieldWriter(this.nameHashCode)) == null || fieldWriter3.getFieldValue(item) == null) continue;
                    return true;
                }
            }
            if ((objectWriter = ctx.path.getWriterContext().getObjectWriter(object.getClass())) instanceof ObjectWriterAdapter && (fieldWriter = objectWriter.getFieldWriter(this.nameHashCode)) != null) {
                return fieldWriter.getFieldValue(object) != null;
            }
            return false;
        }

        @Override
        public void eval(Context ctx) {
            String str;
            Object object;
            Object object2 = object = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (object == null) {
                return;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                Object value = map.get(this.name);
                if (value == null) {
                    boolean isNum = IOUtils.isNumber(this.name);
                    Long longValue = null;
                    for (Map.Entry entry : map.entrySet()) {
                        Object entryKey = entry.getKey();
                        if (entryKey instanceof Enum && ((Enum)entryKey).name().equals(this.name)) {
                            value = entry.getValue();
                            break;
                        }
                        if (!(entryKey instanceof Long)) continue;
                        if (longValue == null && isNum) {
                            longValue = Long.parseLong(this.name);
                        }
                        if (!entryKey.equals(longValue)) continue;
                        value = entry.getValue();
                        break;
                    }
                }
                ctx.value = value;
                return;
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int size = collection.size();
                Collection values = null;
                for (Object item : collection) {
                    if (!(item instanceof Map)) continue;
                    Object val = ((Map)item).get(this.name);
                    if (val instanceof Collection) {
                        if (size == 1) {
                            values = (Collection)val;
                            continue;
                        }
                        if (values == null) {
                            values = new JSONArray(size);
                        }
                        values.addAll((Collection)val);
                        continue;
                    }
                    if (values == null) {
                        values = new JSONArray(size);
                    }
                    values.add(val);
                }
                ctx.value = values;
                return;
            }
            JSONWriter.Context writerContext = ctx.path.getWriterContext();
            ObjectWriter<?> objectWriter = writerContext.getObjectWriter(object.getClass());
            if (objectWriter instanceof ObjectWriterAdapter) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
                if (fieldWriter != null) {
                    ctx.value = fieldWriter.getFieldValue(object);
                }
                return;
            }
            if (this.nameHashCode == HASH_NAME && object instanceof Enum) {
                ctx.value = ((Enum)object).name();
                return;
            }
            if (this.nameHashCode == HASH_ORDINAL && object instanceof Enum) {
                ctx.value = ((Enum)object).ordinal();
                return;
            }
            if (object instanceof String && !(str = (String)object).isEmpty() && str.charAt(0) == '{') {
                ctx.value = JSONPath.of("$." + this.name).extract(JSONReader.of(str));
                return;
            }
            throw new JSONException("not support : " + object.getClass());
        }

        @Override
        public void set(Context context, Object value) {
            Function typeConvert;
            Class fieldClass;
            Class<?> valueClass;
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                ((Map)object).put(this.name, value);
                return;
            }
            ObjectReaderProvider provider = context.path.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(object.getClass());
            FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
            if (fieldReader == null) {
                return;
            }
            if (value != null && (valueClass = value.getClass()) != (fieldClass = fieldReader.getFieldClass()) && (typeConvert = provider.getTypeConvert(valueClass, fieldClass)) != null) {
                value = typeConvert.apply(value);
            }
            fieldReader.accept(object, value);
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            block45: {
                block47: {
                    Map<String, Object> val;
                    if (ctx.parent != null && (ctx.parent.eval || ctx.parent.current instanceof FilterSegment)) {
                        this.eval(ctx);
                        return;
                    }
                    if (jsonReader.isJSONB()) {
                        if (jsonReader.nextIfObjectStart()) {
                            int i = 0;
                            while (!jsonReader.nextIfObjectEnd()) {
                                long nameHashCode = jsonReader.readFieldNameHashCode();
                                if (nameHashCode != 0L) {
                                    boolean match;
                                    boolean bl = match = nameHashCode == this.nameHashCode;
                                    if (!match) {
                                        jsonReader.skipValue();
                                    } else {
                                        if ((jsonReader.isArray() || jsonReader.isObject()) && ctx.next != null) break;
                                        ctx.value = jsonReader.readAny();
                                        ctx.eval = true;
                                        break;
                                    }
                                }
                                ++i;
                            }
                            return;
                        }
                        if (jsonReader.isArray() && ctx.parent != null && ctx.parent.current instanceof AllSegment) {
                            JSONArray values = new JSONArray();
                            int itemCnt = jsonReader.startArray();
                            block17: for (int i = 0; i < itemCnt; ++i) {
                                if (jsonReader.nextIfMatch((byte)-90)) {
                                    int j = 0;
                                    while (!jsonReader.nextIfMatch((byte)-91)) {
                                        boolean match;
                                        long nameHashCode = jsonReader.readFieldNameHashCode();
                                        boolean bl = match = nameHashCode == this.nameHashCode;
                                        if (!match) {
                                            jsonReader.skipValue();
                                        } else {
                                            if ((jsonReader.isArray() || jsonReader.isObject()) && ctx.next != null) continue block17;
                                            values.add(jsonReader.readAny());
                                        }
                                        ++j;
                                    }
                                    continue;
                                }
                                jsonReader.skipValue();
                            }
                            ctx.value = values;
                            ctx.eval = true;
                            return;
                        }
                        throw new JSONException("TODO");
                    }
                    if (!jsonReader.nextIfObjectStart()) break block47;
                    if (jsonReader.ch == '}') {
                        jsonReader.next();
                    }
                    while (true) {
                        boolean match;
                        if (jsonReader.nextIfObjectEnd()) {
                            jsonReader.next();
                            break block45;
                        }
                        long nameHashCode = jsonReader.readFieldNameHashCode();
                        boolean bl = match = nameHashCode == this.nameHashCode;
                        if (match) break;
                        jsonReader.skipValue();
                        if (jsonReader.ch != ',') continue;
                        jsonReader.next();
                    }
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            if (ctx.next == null || ctx.next instanceof EvalSegment) {
                                val = jsonReader.readArray();
                                break;
                            }
                            break block45;
                        }
                        case '{': {
                            if (ctx.next == null || ctx.next instanceof EvalSegment) {
                                val = jsonReader.readObject();
                                break;
                            }
                            break block45;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    ctx.value = val;
                    break block45;
                }
                if (jsonReader.ch == '[' && ctx.parent != null && ctx.parent.current instanceof AllSegment) {
                    jsonReader.next();
                    JSONArray values = new JSONArray();
                    int i = 0;
                    while (jsonReader.ch != '\u001a') {
                        block46: {
                            if (jsonReader.ch == ']') {
                                jsonReader.next();
                                break;
                            }
                            if (jsonReader.ch == '{') {
                                jsonReader.next();
                                while (true) {
                                    Map<String, Object> val;
                                    boolean match;
                                    if (jsonReader.ch == '}') {
                                        jsonReader.next();
                                        break block46;
                                    }
                                    long nameHashCode = jsonReader.readFieldNameHashCode();
                                    boolean bl = match = nameHashCode == this.nameHashCode;
                                    if (!match) {
                                        jsonReader.skipValue();
                                        if (jsonReader.ch != ',') continue;
                                        jsonReader.next();
                                        continue;
                                    }
                                    switch (jsonReader.ch) {
                                        case '+': 
                                        case '-': 
                                        case '.': 
                                        case '0': 
                                        case '1': 
                                        case '2': 
                                        case '3': 
                                        case '4': 
                                        case '5': 
                                        case '6': 
                                        case '7': 
                                        case '8': 
                                        case '9': {
                                            jsonReader.readNumber0();
                                            val = jsonReader.getNumber();
                                            break;
                                        }
                                        case '[': {
                                            if (ctx.next == null) {
                                                val = jsonReader.readArray();
                                                break;
                                            }
                                            break block46;
                                        }
                                        case '{': {
                                            if (ctx.next == null) {
                                                val = jsonReader.readObject();
                                                break;
                                            }
                                            break block46;
                                        }
                                        case '\"': 
                                        case '\'': {
                                            val = jsonReader.readString();
                                            break;
                                        }
                                        case 'f': 
                                        case 't': {
                                            val = jsonReader.readBoolValue();
                                            break;
                                        }
                                        case 'n': {
                                            jsonReader.readNull();
                                            val = null;
                                            break;
                                        }
                                        default: {
                                            throw new JSONException("TODO : " + jsonReader.ch);
                                        }
                                    }
                                    values.add(val);
                                }
                            }
                            jsonReader.skipValue();
                        }
                        if (jsonReader.ch == ',') {
                            jsonReader.next();
                        }
                        ++i;
                    }
                    ctx.value = values;
                    return;
                }
                if (jsonReader.ch == '\u001a') {
                    return;
                }
            }
        }

        public String toString() {
            return this.name;
        }
    }

    static final class MaxSegment
    extends Segment
    implements EvalSegment {
        static final MaxSegment INSTANCE = new MaxSegment();

        MaxSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            this.eval(ctx);
        }

        @Override
        public void eval(Context ctx) {
            Object value;
            Object object = value = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (value == null) {
                return;
            }
            Object max = null;
            if (value instanceof Collection) {
                for (Object next : (Collection)value) {
                    if (next == null) continue;
                    if (max == null) {
                        max = next;
                        continue;
                    }
                    if (TypeUtils.compare(max, next) >= 0) continue;
                    max = next;
                }
            } else if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                for (int i = 0; i < array.length; ++i) {
                    Object item = array[i];
                    if (item == null) continue;
                    if (max == null) {
                        max = item;
                        continue;
                    }
                    if (TypeUtils.compare(max, item) >= 0) continue;
                    max = item;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            ctx.value = max;
            ctx.eval = true;
        }
    }

    static final class MinSegment
    extends Segment
    implements EvalSegment {
        static final MinSegment INSTANCE = new MinSegment();

        MinSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            this.eval(ctx);
        }

        @Override
        public void eval(Context ctx) {
            Object value;
            Object object = value = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (value == null) {
                return;
            }
            Object min = null;
            if (value instanceof Collection) {
                for (Object next : (Collection)value) {
                    if (next == null) continue;
                    if (min == null) {
                        min = next;
                        continue;
                    }
                    if (TypeUtils.compare(min, next) <= 0) continue;
                    min = next;
                }
            } else if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                for (int i = 0; i < array.length; ++i) {
                    Object item = array[i];
                    if (item == null) continue;
                    if (min == null) {
                        min = item;
                        continue;
                    }
                    if (TypeUtils.compare(min, item) <= 0) continue;
                    min = item;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            ctx.value = min;
            ctx.eval = true;
        }
    }

    static final class TypeSegment
    extends Segment
    implements EvalSegment {
        static final TypeSegment INSTANCE = new TypeSegment();

        TypeSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            if (ctx.parent == null) {
                ctx.root = jsonReader.readAny();
                ctx.eval = true;
            }
            this.eval(ctx);
        }

        @Override
        public void eval(Context ctx) {
            Object value = ctx.parent == null ? ctx.root : ctx.parent.value;
            ctx.value = JSONPath.type(value);
        }
    }

    static final class FloorSegment
    extends Segment
    implements EvalSegment {
        static final FloorSegment INSTANCE = new FloorSegment();

        FloorSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            if (ctx.parent == null) {
                ctx.root = jsonReader.readAny();
                ctx.eval = true;
            }
            this.eval(ctx);
        }

        @Override
        public void eval(Context ctx) {
            Object value;
            Object object = value = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (value instanceof Double) {
                value = Math.floor((Double)value);
            } else if (value instanceof Float) {
                value = Math.floor(((Float)value).floatValue());
            } else if (value instanceof BigDecimal) {
                value = ((BigDecimal)value).setScale(0, RoundingMode.FLOOR);
            }
            if (value instanceof List) {
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (item instanceof Double) {
                        list.set(i, Math.floor((Double)item));
                        continue;
                    }
                    if (item instanceof Float) {
                        list.set(i, Math.floor(((Float)item).floatValue()));
                        continue;
                    }
                    if (!(item instanceof BigDecimal)) continue;
                    list.set(i, ((BigDecimal)item).setScale(0, RoundingMode.FLOOR));
                }
            }
            ctx.value = value;
        }
    }

    static final class LengthSegment
    extends Segment
    implements EvalSegment {
        static final LengthSegment INSTANCE = new LengthSegment();

        LengthSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            if (ctx.parent == null) {
                ctx.root = jsonReader.readAny();
                ctx.eval = true;
            }
            this.eval(ctx);
        }

        @Override
        public void eval(Context ctx) {
            Object value;
            Object object = value = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (value == null) {
                return;
            }
            if (value instanceof Collection) {
                ctx.value = ((Collection)value).size();
            } else if (value.getClass().isArray()) {
                ctx.value = Array.getLength(value);
            } else if (value instanceof Map) {
                ctx.value = ((Map)value).size();
            } else if (value instanceof String) {
                ctx.value = ((String)value).length();
            }
        }
    }

    static final class KeysSegment
    extends Segment
    implements EvalSegment {
        static final KeysSegment INSTANCE = new KeysSegment();

        KeysSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            if (jsonReader.isObject()) {
                jsonReader.next();
                JSONArray array = new JSONArray();
                while (!jsonReader.nextIfObjectEnd()) {
                    String fieldName = jsonReader.readFieldName();
                    array.add(fieldName);
                    jsonReader.skipValue();
                }
                ctx.value = array;
            }
        }

        @Override
        public void eval(Context ctx) {
            Object object;
            Object object2 = object = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (object instanceof Map) {
                ctx.value = new JSONArray((Collection)((Map)object).keySet());
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static abstract class Segment {
        Segment() {
        }

        public abstract void accept(JSONReader var1, Context var2);

        public abstract void eval(Context var1);

        public boolean contains(Context context) {
            this.eval(context);
            return context.value != null;
        }

        public boolean remove(Context context) {
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        public void set(Context context, Object value) {
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        public void setInt(Context context, int value) {
            this.set(context, value);
        }

        public void setLong(Context context, long value) {
            this.set(context, value);
        }
    }

    static final class Context {
        final JSONPath path;
        final Context parent;
        final Segment current;
        final Segment next;
        Object root;
        Object value;
        boolean eval = false;

        Context(JSONPath path, Context parent, Segment current, Segment next) {
            this.path = path;
            this.current = current;
            this.next = next;
            this.parent = parent;
        }
    }

    static final class MultiSegmentPath
    extends JSONPath {
        final List<Segment> segments;
        final boolean ref;

        private MultiSegmentPath(String path, List<Segment> segments) {
            super(path);
            this.segments = segments;
            boolean ref = true;
            for (int i = 0; i < segments.size(); ++i) {
                Segment segment = segments.get(i);
                if (segment instanceof IndexSegment || segment instanceof NameSegment) continue;
                ref = false;
                break;
            }
            this.ref = ref;
        }

        @Override
        public boolean remove(Object root) {
            Context ctx = null;
            int size = this.segments.size();
            if (size == 0) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                ctx = new Context(this, ctx, segment, nextSegment);
                if (i == 0) {
                    ctx.root = root;
                }
                if (i == size - 1) {
                    return segment.remove(ctx);
                }
                segment.eval(ctx);
                if (ctx.value != null) continue;
                return false;
            }
            return false;
        }

        @Override
        public boolean contains(Object root) {
            Context ctx = null;
            int size = this.segments.size();
            if (size == 0) {
                return root != null;
            }
            for (int i = 0; i < size; ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                ctx = new Context(this, ctx, segment, nextSegment);
                if (i == 0) {
                    ctx.root = root;
                }
                if (i == size - 1) {
                    return segment.contains(ctx);
                }
                segment.eval(ctx);
            }
            return false;
        }

        @Override
        public boolean isRef() {
            return this.ref;
        }

        @Override
        public Object eval(Object root) {
            Context ctx = null;
            int size = this.segments.size();
            if (size == 0) {
                return root;
            }
            for (int i = 0; i < size; ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                ctx = new Context(this, ctx, segment, nextSegment);
                if (i == 0) {
                    ctx.root = root;
                }
                segment.eval(ctx);
            }
            return ctx.value;
        }

        @Override
        public void set(Object root, Object value) {
            Context ctx = null;
            int size = this.segments.size();
            for (int i = 0; i < size - 1; ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                ctx = new Context(this, ctx, segment, nextSegment);
                if (i == 0) {
                    ctx.root = root;
                }
                segment.eval(ctx);
            }
            ctx = new Context(this, ctx, this.segments.get(0), null);
            ctx.root = root;
            Segment segment = this.segments.get(size - 1);
            segment.set(ctx, value);
        }

        @Override
        public void setInt(Object rootObject, int value) {
            this.set(rootObject, value);
        }

        @Override
        public void setLong(Object rootObject, long value) {
            this.set(rootObject, value);
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            if (jsonReader == null) {
                return null;
            }
            Context ctx = null;
            for (int i = 0; i < this.segments.size(); ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < this.segments.size()) {
                    nextSegment = this.segments.get(nextIndex);
                }
                ctx = new Context(this, ctx, segment, nextSegment);
                segment.accept(jsonReader, ctx);
            }
            return ctx.value;
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            Context ctx = null;
            for (int i = 0; i < this.segments.size(); ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < this.segments.size()) {
                    nextSegment = this.segments.get(nextIndex);
                }
                ctx = new Context(this, ctx, segment, nextSegment);
                segment.accept(jsonReader, ctx);
            }
            return JSON.toJSONString(ctx.value);
        }
    }

    static final class SingleSegmentPath
    extends JSONPath {
        final Segment segment;
        final boolean ref;

        public SingleSegmentPath(Segment segment, String path) {
            super(path);
            this.segment = segment;
            this.ref = segment instanceof IndexSegment || segment instanceof NameSegment;
        }

        @Override
        public boolean remove(Object root) {
            Context ctx = new Context(this, null, this.segment, null);
            ctx.root = root;
            return this.segment.remove(ctx);
        }

        @Override
        public boolean contains(Object root) {
            Context ctx = new Context(this, null, this.segment, null);
            ctx.root = root;
            return this.segment.contains(ctx);
        }

        @Override
        public boolean isRef() {
            return this.ref;
        }

        @Override
        public Object eval(Object root) {
            Context ctx = new Context(this, null, this.segment, null);
            ctx.root = root;
            this.segment.eval(ctx);
            return ctx.value;
        }

        @Override
        public void set(Object root, Object value) {
            Context ctx = new Context(this, null, this.segment, null);
            ctx.root = root;
            this.segment.set(ctx, value);
        }

        @Override
        public void setInt(Object root, int value) {
            Context ctx = new Context(this, null, this.segment, null);
            ctx.root = root;
            this.segment.setInt(ctx, value);
        }

        @Override
        public void setLong(Object root, long value) {
            Context ctx = new Context(this, null, this.segment, null);
            ctx.root = root;
            this.segment.setLong(ctx, value);
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            Context ctx = new Context(this, null, this.segment, null);
            this.segment.accept(jsonReader, ctx);
            return ctx.value;
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            Context ctx = new Context(this, null, this.segment, null);
            this.segment.accept(jsonReader, ctx);
            return JSON.toJSONString(ctx.value);
        }
    }

    static final class SingleNamePath
    extends JSONPath {
        final long nameHashCode;
        final String name;

        public SingleNamePath(String path, NameSegment segment) {
            super(path);
            this.name = segment.name;
            this.nameHashCode = segment.nameHashCode;
        }

        @Override
        public Object eval(Object root) {
            if (root instanceof Map) {
                Map map = (Map)root;
                Object value = map.get(this.name);
                if (value == null) {
                    boolean isNum = IOUtils.isNumber(this.name);
                    Long longValue = null;
                    for (Map.Entry entry : map.entrySet()) {
                        Object entryKey = entry.getKey();
                        if (entryKey instanceof Enum && ((Enum)entryKey).name().equals(this.name)) {
                            value = entry.getValue();
                            break;
                        }
                        if (!(entryKey instanceof Long)) continue;
                        if (longValue == null && isNum) {
                            longValue = Long.parseLong(this.name);
                        }
                        if (!entryKey.equals(longValue)) continue;
                        value = entry.getValue();
                        break;
                    }
                }
                return value;
            }
            JSONWriter.Context writerContext = this.getWriterContext();
            ObjectWriter<?> objectWriter = writerContext.getObjectWriter(root.getClass());
            if (objectWriter == null) {
                return null;
            }
            FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
            if (fieldWriter == null) {
                return null;
            }
            return fieldWriter.getFieldValue(root);
        }

        @Override
        public boolean remove(Object root) {
            if (root == null) {
                return false;
            }
            if (root instanceof Map) {
                return ((Map)root).remove(this.name) != null;
            }
            ObjectReaderProvider provider = this.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(root.getClass());
            if (objectReader == null) {
                return false;
            }
            FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
            if (fieldReader == null) {
                return false;
            }
            try {
                fieldReader.accept(root, null);
            }
            catch (Exception ignored) {
                return false;
            }
            return true;
        }

        @Override
        public boolean isRef() {
            return true;
        }

        @Override
        public boolean contains(Object root) {
            if (root instanceof Map) {
                return ((Map)root).get(this.name) != null;
            }
            ObjectWriterProvider provider = this.getWriterContext().getProvider();
            ObjectWriter objectWriter = provider.getObjectWriter(root.getClass());
            if (objectWriter == null) {
                return false;
            }
            FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
            if (fieldWriter == null) {
                return false;
            }
            return fieldWriter.getFieldValue(root) != null;
        }

        @Override
        public void set(Object rootObject, Object value) {
            Function typeConvert;
            Class fieldClass;
            Class<?> valueClass;
            if (rootObject instanceof Map) {
                ((Map)rootObject).put(this.name, value);
                return;
            }
            ObjectReaderProvider provider = this.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(rootObject.getClass());
            FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
            if (value != null && (valueClass = value.getClass()) != (fieldClass = fieldReader.getFieldClass()) && (typeConvert = provider.getTypeConvert(valueClass, fieldClass)) != null) {
                value = typeConvert.apply(value);
            }
            fieldReader.accept(rootObject, value);
        }

        @Override
        public void setInt(Object rootObject, int value) {
            if (rootObject instanceof Map) {
                ((Map)rootObject).put(this.name, value);
                return;
            }
            ObjectReaderProvider provider = this.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(rootObject.getClass());
            objectReader.setFieldValue(rootObject, this.name, this.nameHashCode, value);
        }

        @Override
        public void setLong(Object rootObject, long value) {
            if (rootObject instanceof Map) {
                ((Map)rootObject).put(this.name, value);
                return;
            }
            ObjectReaderProvider provider = this.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(rootObject.getClass());
            objectReader.setFieldValue(rootObject, this.name, this.nameHashCode, value);
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            if (jsonReader.isJSONB()) {
                if (jsonReader.isObject()) {
                    jsonReader.nextIfObjectStart();
                    while (!jsonReader.nextIfObjectEnd()) {
                        boolean match;
                        long nameHashCode = jsonReader.readFieldNameHashCode();
                        if (nameHashCode == 0L) continue;
                        boolean bl = match = nameHashCode == this.nameHashCode;
                        if (!(match || jsonReader.isObject() || jsonReader.isArray())) {
                            jsonReader.skipValue();
                            continue;
                        }
                        if (jsonReader.isNumber()) {
                            return jsonReader.readNumber();
                        }
                        throw new JSONException("TODO");
                    }
                }
                return null;
            }
            if (jsonReader.nextIfObjectStart()) {
                while (!jsonReader.nextIfObjectEnd()) {
                    Object val;
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean match = nameHashCode == this.nameHashCode;
                    char ch = jsonReader.ch;
                    if (!match && ch != '{' && ch != '[') {
                        jsonReader.skipValue();
                        continue;
                    }
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            return jsonReader.readNumber();
                        }
                        case '[': {
                            return jsonReader.readArray();
                        }
                        case '{': {
                            return jsonReader.readObject();
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    return val;
                }
            }
            return null;
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            block11: {
                if (jsonReader.nextIfObjectStart()) {
                    Object val;
                    while (true) {
                        if (jsonReader.ch == '}') {
                            jsonReader.next();
                            break block11;
                        }
                        long nameHashCode = jsonReader.readFieldNameHashCode();
                        boolean match = nameHashCode == this.nameHashCode;
                        char ch = jsonReader.ch;
                        if (match || ch == '{' || ch == '[') break;
                        jsonReader.skipValue();
                    }
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            val = jsonReader.readNumber();
                            break;
                        }
                        case '[': {
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    return JSON.toJSONString(val);
                }
            }
            return null;
        }

        @Override
        public long extractInt64Value(JSONReader jsonReader) {
            if (jsonReader.nextIfObjectStart()) {
                while (true) {
                    boolean match;
                    if (jsonReader.ch == '}') {
                        jsonReader.wasNull = true;
                        return 0L;
                    }
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean bl = match = nameHashCode == this.nameHashCode;
                    if (match) break;
                    jsonReader.skipValue();
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return jsonReader.readInt64Value();
                    }
                    case '[': 
                    case '{': {
                        Map<String, Object> object = jsonReader.readObject();
                        return jsonReader.toLong(object);
                    }
                    case '\"': 
                    case '\'': {
                        String str = jsonReader.readString();
                        return Long.parseLong(str);
                    }
                    case 'f': 
                    case 't': {
                        boolean booleanValue = jsonReader.readBoolValue();
                        return booleanValue ? 1L : 0L;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        jsonReader.wasNull = true;
                        return 0L;
                    }
                    case ']': {
                        jsonReader.next();
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
            }
            jsonReader.wasNull = true;
            return 0L;
        }

        @Override
        public int extractInt32Value(JSONReader jsonReader) {
            if (jsonReader.nextIfObjectStart()) {
                while (true) {
                    boolean match;
                    if (jsonReader.ch == '}') {
                        jsonReader.wasNull = true;
                        return 0;
                    }
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean bl = match = nameHashCode == this.nameHashCode;
                    if (match) break;
                    jsonReader.skipValue();
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return jsonReader.readInt32Value();
                    }
                    case '\"': 
                    case '\'': {
                        String str = jsonReader.readString();
                        return Integer.parseInt(str);
                    }
                    case 'f': 
                    case 't': {
                        boolean booleanValue = jsonReader.readBoolValue();
                        return booleanValue ? 1 : 0;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        jsonReader.wasNull = true;
                        return 0;
                    }
                    case ']': {
                        jsonReader.next();
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
            }
            jsonReader.wasNull = true;
            return 0;
        }

        @Override
        public void extractScalar(JSONReader jsonReader, ValueConsumer consumer) {
            if (jsonReader.nextIfObjectStart()) {
                while (true) {
                    boolean match;
                    if (jsonReader.ch == '}') {
                        consumer.acceptNull();
                        return;
                    }
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean bl = match = nameHashCode == this.nameHashCode;
                    if (match) break;
                    jsonReader.skipValue();
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        jsonReader.readNumber(consumer, false);
                        return;
                    }
                    case '[': {
                        List array = jsonReader.readArray();
                        consumer.accept(array);
                        return;
                    }
                    case '{': {
                        Map<String, Object> object = jsonReader.readObject();
                        consumer.accept(object);
                        return;
                    }
                    case '\"': 
                    case '\'': {
                        jsonReader.readString(consumer, false);
                        return;
                    }
                    case 'f': 
                    case 't': {
                        consumer.accept(jsonReader.readBoolValue());
                        return;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        consumer.acceptNull();
                        return;
                    }
                    case ']': {
                        jsonReader.next();
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
            }
            consumer.acceptNull();
        }

        @Override
        public void extract(JSONReader jsonReader, ValueConsumer consumer) {
            if (jsonReader.nextIfObjectStart()) {
                while (true) {
                    boolean match;
                    if (jsonReader.ch == '}') {
                        consumer.acceptNull();
                        return;
                    }
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean bl = match = nameHashCode == this.nameHashCode;
                    if (match) break;
                    jsonReader.skipValue();
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        jsonReader.readNumber(consumer, true);
                        return;
                    }
                    case '[': {
                        List array = jsonReader.readArray();
                        consumer.accept(array);
                        return;
                    }
                    case '{': {
                        Map<String, Object> object = jsonReader.readObject();
                        consumer.accept(object);
                        return;
                    }
                    case '\"': 
                    case '\'': {
                        jsonReader.readString(consumer, true);
                        return;
                    }
                    case 'f': 
                    case 't': {
                        consumer.accept(jsonReader.readBoolValue());
                        return;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        consumer.acceptNull();
                        return;
                    }
                }
                throw new JSONException("TODO : " + jsonReader.ch);
            }
            consumer.acceptNull();
        }
    }

    static final class PreviousPath
    extends JSONPath {
        static final PreviousPath INSTANCE = new PreviousPath("#-1");

        PreviousPath(String path) {
            super(path);
        }

        @Override
        public boolean isRef() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPrevious() {
            return true;
        }

        @Override
        public boolean contains(Object rootObject) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object eval(Object rootObject) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object rootObject, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setInt(Object rootObject, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLong(Object rootObject, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object rootObject) {
            throw new UnsupportedOperationException();
        }
    }

    static final class NameExistsFilter
    extends FilterSegment {
        final String name;
        final long nameHashCode;

        public NameExistsFilter(String name, long nameHashCode) {
            this.name = name;
            this.nameHashCode = nameHashCode;
        }

        @Override
        public void eval(Context ctx) {
            Object object = ctx.parent == null ? ctx.root : ctx.parent.value;
            JSONArray array = new JSONArray();
            if (object instanceof List) {
                List list = (List)object;
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (!(item instanceof Map) || !((Map)item).containsKey(this.name)) continue;
                    array.add(item);
                }
                ctx.value = array;
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            this.eval(ctx);
        }

        public String toString() {
            return '?' + this.name;
        }

        @Override
        public boolean apply(Context ctx, Object object) {
            throw new UnsupportedOperationException();
        }
    }

    static final class NameMatchFilter
    extends NameFilter {
        final String startsWithValue;
        final String endsWithValue;
        final String[] containsValues;
        final int minLength;
        final boolean not;

        public NameMatchFilter(String fieldName, long fieldNameNameHash, String startsWithValue, String endsWithValue, String[] containsValues, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.startsWithValue = startsWithValue;
            this.endsWithValue = endsWithValue;
            this.containsValues = containsValues;
            this.not = not;
            int len = 0;
            if (startsWithValue != null) {
                len += startsWithValue.length();
            }
            if (endsWithValue != null) {
                len += endsWithValue.length();
            }
            if (containsValues != null) {
                for (String item : containsValues) {
                    len += item.length();
                }
            }
            this.minLength = len;
        }

        @Override
        boolean apply(Object arg) {
            if (!(arg instanceof String)) {
                return false;
            }
            String fieldValue = (String)arg;
            if (fieldValue.length() < this.minLength) {
                return this.not;
            }
            int start = 0;
            if (this.startsWithValue != null) {
                if (!fieldValue.startsWith(this.startsWithValue)) {
                    return this.not;
                }
                start += this.startsWithValue.length();
            }
            if (this.containsValues != null) {
                for (String containsValue : this.containsValues) {
                    int index = fieldValue.indexOf(containsValue, start);
                    if (index == -1) {
                        return this.not;
                    }
                    start = index + containsValue.length();
                }
            }
            if (this.endsWithValue != null && !fieldValue.endsWith(this.endsWithValue)) {
                return this.not;
            }
            return !this.not;
        }
    }

    static final class NameStringInSegment
    extends NameFilter {
        private final String[] values;
        private final boolean not;

        public NameStringInSegment(String fieldName, long fieldNameNameHash, String[] values, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.values = values;
            this.not = not;
        }

        @Override
        public boolean apply(Object fieldValue) {
            for (String value : this.values) {
                if (value == fieldValue) {
                    return !this.not;
                }
                if (value == null || !value.equals(fieldValue)) continue;
                return !this.not;
            }
            return this.not;
        }
    }

    static final class NameStringOpSegment
    extends NameFilter {
        final Operator operator;
        final String value;

        public NameStringOpSegment(String fieldName, long fieldNameNameHash, Function expr, Operator operator, String value) {
            super(fieldName, fieldNameNameHash, expr);
            this.operator = operator;
            this.value = value;
        }

        @Override
        public boolean apply(Object fieldValue) {
            if (!(fieldValue instanceof String)) {
                return false;
            }
            int cmp = ((String)fieldValue).compareTo(this.value);
            switch (this.operator) {
                case LT: {
                    return cmp < 0;
                }
                case LE: {
                    return cmp <= 0;
                }
                case EQ: {
                    return cmp == 0;
                }
                case NE: {
                    return cmp != 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GE: {
                    return cmp >= 0;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static abstract class NameFilter
    extends FilterSegment {
        final String fieldName;
        final long fieldNameNameHash;
        final Function funtion;

        public NameFilter(String fieldName, long fieldNameNameHash) {
            this.fieldName = fieldName;
            this.fieldNameNameHash = fieldNameNameHash;
            this.funtion = null;
        }

        public NameFilter(String fieldName, long fieldNameNameHash, Function funtion) {
            this.fieldName = fieldName;
            this.fieldNameNameHash = fieldNameNameHash;
            this.funtion = funtion;
        }

        abstract boolean apply(Object var1);

        @Override
        public final void accept(JSONReader jsonReader, Context ctx) {
            if (ctx.parent == null) {
                ctx.root = jsonReader.readAny();
            }
            this.eval(ctx);
        }

        @Override
        public boolean remove(Context ctx) {
            Object object;
            Object object2 = object = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                for (int i = list.size() - 1; i >= 0; --i) {
                    Object item = list.get(i);
                    if (!this.apply(ctx, item)) continue;
                    list.remove(i);
                }
                return true;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        @Override
        public final void eval(Context ctx) {
            Object object;
            Object object2 = object = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                JSONArray array = new JSONArray(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (!this.apply(ctx, item)) continue;
                    array.add(item);
                }
                ctx.value = array;
                ctx.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] list = (Object[])object;
                JSONArray array = new JSONArray(list.length);
                for (int i = 0; i < list.length; ++i) {
                    Object item = list[i];
                    if (!this.apply(ctx, item)) continue;
                    array.add(item);
                }
                ctx.value = array;
                ctx.eval = true;
                return;
            }
            if (this.apply(ctx, object)) {
                ctx.value = object;
                ctx.eval = true;
            }
        }

        @Override
        public final boolean apply(Context ctx, Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Map) {
                Object fieldValue;
                Object object2 = fieldValue = this.fieldName == null ? object : ((Map)object).get(this.fieldName);
                if (fieldValue == null) {
                    return false;
                }
                if (this.funtion != null) {
                    fieldValue = this.funtion.apply(fieldValue);
                }
                return this.apply(fieldValue);
            }
            ObjectWriter<?> objectWriter = ctx.path.getWriterContext().getObjectWriter(object.getClass());
            if (objectWriter instanceof ObjectWriterAdapter) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.fieldNameNameHash);
                Object fieldValue = fieldWriter.getFieldValue(object);
                if (this.funtion != null) {
                    fieldValue = this.funtion.apply(fieldValue);
                }
                return this.apply(fieldValue);
            }
            if (this.funtion != null) {
                Object fieldValue = this.funtion.apply(object);
                return this.apply(fieldValue);
            }
            if (this.fieldName == null) {
                return this.apply(object);
            }
            return false;
        }
    }

    static final class SizeFunction
    implements Function {
        static final SizeFunction INSTANCE = new SizeFunction();

        SizeFunction() {
        }

        public Object apply(Object value) {
            if (value == null) {
                return -1;
            }
            if (value instanceof Collection) {
                return ((Collection)value).size();
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value);
            }
            if (value instanceof Map) {
                return ((Map)value).size();
            }
            return -1;
        }
    }

    static final class TypeFunction
    implements Function {
        static final TypeFunction INSTANCE = new TypeFunction();

        TypeFunction() {
        }

        public Object apply(Object object) {
            return JSONPath.type(object);
        }
    }

    static final class NameIntBetweenSegment
    extends NameFilter {
        private final long begin;
        private final long end;
        private final boolean not;

        public NameIntBetweenSegment(String fieldName, long fieldNameNameHash, long begin, long end, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.begin = begin;
            this.end = end;
            this.not = not;
        }

        @Override
        public boolean apply(Object fieldValue) {
            if (fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long) {
                long fieldValueLong = ((Number)fieldValue).longValue();
                if (fieldValueLong >= this.begin && fieldValueLong <= this.end) {
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof Float || fieldValue instanceof Double) {
                double fieldValueDouble = ((Number)fieldValue).doubleValue();
                if (fieldValueDouble >= (double)this.begin && fieldValueDouble <= (double)this.end) {
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)fieldValue;
                int cmpBegin = decimal.compareTo(BigDecimal.valueOf(this.begin));
                int cmpEnd = decimal.compareTo(BigDecimal.valueOf(this.end));
                if (cmpBegin >= 0 && cmpEnd <= 0) {
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigInteger) {
                BigInteger bigiInt = (BigInteger)fieldValue;
                int cmpBegin = bigiInt.compareTo(BigInteger.valueOf(this.begin));
                int cmpEnd = bigiInt.compareTo(BigInteger.valueOf(this.end));
                if (cmpBegin >= 0 && cmpEnd <= 0) {
                    return !this.not;
                }
                return this.not;
            }
            return this.not;
        }
    }

    static final class NameIntInSegment
    extends NameFilter {
        private final long[] values;
        private final boolean not;

        public NameIntInSegment(String fieldName, long fieldNameNameHash, Function expr, long[] values, boolean not) {
            super(fieldName, fieldNameNameHash, expr);
            this.values = values;
            this.not = not;
        }

        @Override
        public boolean apply(Object fieldValue) {
            if (fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long) {
                long fieldValueLong = ((Number)fieldValue).longValue();
                for (long value : this.values) {
                    if (value != fieldValueLong) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof Float || fieldValue instanceof Double) {
                double fieldValueDouble = ((Number)fieldValue).doubleValue();
                for (long value : this.values) {
                    if ((double)value != fieldValueDouble) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)fieldValue;
                long longValue = decimal.longValue();
                for (long value : this.values) {
                    if (value != longValue || !decimal.equals(BigDecimal.valueOf(value))) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigInteger) {
                BigInteger bigiInt = (BigInteger)fieldValue;
                long longValue = bigiInt.longValue();
                for (long value : this.values) {
                    if (value != longValue || !bigiInt.equals(BigInteger.valueOf(value))) continue;
                    return !this.not;
                }
                return this.not;
            }
            return this.not;
        }
    }

    static final class GroupFilter
    extends Segment
    implements EvalSegment {
        final boolean and;
        final List<FilterSegment> filters;

        public GroupFilter(List<FilterSegment> filters, boolean and) {
            this.and = and;
            this.filters = filters;
        }

        @Override
        public void accept(JSONReader jsonReader, Context ctx) {
            if (ctx.parent == null) {
                ctx.root = jsonReader.readAny();
            }
            this.eval(ctx);
        }

        @Override
        public void eval(Context ctx) {
            Object object;
            Object object2 = object = ctx.parent == null ? ctx.root : ctx.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                JSONArray array = new JSONArray(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    boolean match = this.and;
                    for (FilterSegment filter : this.filters) {
                        boolean result = filter.apply(ctx, item);
                        if (this.and) {
                            if (result) continue;
                            match = false;
                            break;
                        }
                        if (!result) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                    array.add(item);
                }
                ctx.value = array;
                ctx.eval = true;
                return;
            }
            boolean match = this.and;
            for (FilterSegment filter : this.filters) {
                boolean result = filter.apply(ctx, object);
                if (this.and) {
                    if (result) continue;
                    match = false;
                    break;
                }
                if (!result) continue;
                match = true;
                break;
            }
            if (match) {
                ctx.value = object;
            }
            ctx.eval = true;
        }
    }

    static final class NameRLikeSegment
    extends NameFilter {
        final Pattern pattern;
        final boolean not;

        public NameRLikeSegment(String fieldName, long fieldNameNameHash, Pattern pattern, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.pattern = pattern;
            this.not = not;
        }

        @Override
        boolean apply(Object fieldValue) {
            String strPropertyValue = fieldValue.toString();
            Matcher m = this.pattern.matcher(strPropertyValue);
            boolean match = m.matches();
            if (this.not) {
                match = !match;
            }
            return match;
        }
    }

    static final class NameDecimalOpSegment
    extends NameFilter {
        final Operator operator;
        final BigDecimal value;

        public NameDecimalOpSegment(String name, long nameHashCode, Operator operator, BigDecimal value) {
            super(name, nameHashCode);
            this.operator = operator;
            this.value = value;
        }

        @Override
        public boolean apply(Object fieldValue) {
            BigDecimal fieldValueDecimal;
            if (fieldValue == null) {
                return false;
            }
            if (fieldValue instanceof Boolean) {
                fieldValueDecimal = (Boolean)fieldValue != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long) {
                fieldValueDecimal = BigDecimal.valueOf(((Number)fieldValue).longValue());
            } else if (fieldValue instanceof BigDecimal) {
                fieldValueDecimal = (BigDecimal)fieldValue;
            } else if (fieldValue instanceof BigInteger) {
                fieldValueDecimal = new BigDecimal((BigInteger)fieldValue);
            } else {
                throw new UnsupportedOperationException();
            }
            int cmp = fieldValueDecimal.compareTo(this.value);
            switch (this.operator) {
                case LT: {
                    return cmp < 0;
                }
                case LE: {
                    return cmp <= 0;
                }
                case EQ: {
                    return cmp == 0;
                }
                case NE: {
                    return cmp != 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GE: {
                    return cmp >= 0;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static final class NameIntOpSegment
    extends NameFilter {
        final Operator operator;
        final long value;

        public NameIntOpSegment(String name, long nameHashCode, Function expr, Operator operator, long value) {
            super(name, nameHashCode, expr);
            this.operator = operator;
            this.value = value;
        }

        @Override
        public boolean apply(Object fieldValue) {
            int cmp;
            boolean objInt;
            boolean bl = objInt = fieldValue instanceof Boolean || fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long;
            if (objInt) {
                long fieldValueInt = fieldValue instanceof Boolean ? ((Boolean)fieldValue != false ? 1L : 0L) : ((Number)fieldValue).longValue();
                switch (this.operator) {
                    case LT: {
                        return fieldValueInt < this.value;
                    }
                    case LE: {
                        return fieldValueInt <= this.value;
                    }
                    case EQ: {
                        return fieldValueInt == this.value;
                    }
                    case NE: {
                        return fieldValueInt != this.value;
                    }
                    case GT: {
                        return fieldValueInt > this.value;
                    }
                    case GE: {
                        return fieldValueInt >= this.value;
                    }
                }
                throw new UnsupportedOperationException();
            }
            if (fieldValue instanceof BigDecimal) {
                cmp = ((BigDecimal)fieldValue).compareTo(BigDecimal.valueOf(this.value));
            } else if (fieldValue instanceof BigInteger) {
                cmp = ((BigInteger)fieldValue).compareTo(BigInteger.valueOf(this.value));
            } else if (fieldValue instanceof Float) {
                cmp = ((Float)fieldValue).compareTo(Float.valueOf(this.value));
            } else if (fieldValue instanceof Double) {
                cmp = ((Double)fieldValue).compareTo(Double.valueOf(this.value));
            } else {
                throw new UnsupportedOperationException();
            }
            switch (this.operator) {
                case LT: {
                    return cmp < 0;
                }
                case LE: {
                    return cmp <= 0;
                }
                case EQ: {
                    return cmp == 0;
                }
                case NE: {
                    return cmp != 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GE: {
                    return cmp >= 0;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static interface EvalSegment {
    }

    static abstract class FilterSegment
    extends Segment
    implements EvalSegment {
        FilterSegment() {
        }

        abstract boolean apply(Context var1, Object var2);
    }

    static enum Operator {
        EQ,
        NE,
        GT,
        GE,
        LT,
        LE,
        LIKE,
        NOT_LIKE,
        RLIKE,
        NOT_RLIKE,
        IN,
        NOT_IN,
        BETWEEN,
        NOT_BETWEEN,
        AND,
        OR,
        REG_MATCH;

    }
}

