/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.util.BeanUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class TypeReference<T> {
    protected final Type type;
    final Class<? super T> rawType;
    final int hashCode;

    protected TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.rawType = BeanUtils.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    TypeReference(Type type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = BeanUtils.canonicalize(type);
        this.rawType = BeanUtils.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    public Type getType() {
        return this.type;
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public static TypeReference<?> get(Type type) {
        return new TypeReference(type);
    }
}

