/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.asm;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.asm.ByteVector;
import com.alibaba.fastjson2.asm.Edge;
import com.alibaba.fastjson2.asm.Frame;
import com.alibaba.fastjson2.asm.Label;
import com.alibaba.fastjson2.asm.Symbol;
import com.alibaba.fastjson2.asm.SymbolTable;
import com.alibaba.fastjson2.asm.Type;

public final class MethodWriter {
    protected MethodWriter mv;
    private final SymbolTable symbolTable;
    private final int accessFlags;
    private final int nameIndex;
    private final String name;
    private final int descriptorIndex;
    private final String descriptor;
    private int maxStack;
    private int maxLocals;
    private final ByteVector code = new ByteVector();
    private int stackMapTableNumberOfEntries;
    private ByteVector stackMapTableEntries;
    private Label firstBasicBlock;
    private Label lastBasicBlock;
    private Label currentBasicBlock;
    private int[] previousFrame;
    private int[] currentFrame;
    private boolean hasAsmInstructions;
    private int lastBytecodeOffset;

    MethodWriter(SymbolTable symbolTable, int access, String name, String descriptor) {
        this.symbolTable = symbolTable;
        this.accessFlags = "<init>".equals(name) ? access | 0x40000 : access;
        this.nameIndex = symbolTable.addConstantUtf8(name);
        this.name = name;
        this.descriptorIndex = symbolTable.addConstantUtf8(descriptor);
        this.descriptor = descriptor;
        int argumentsSize = Type.getArgumentsAndReturnSizes(descriptor) >> 2;
        if ((access & 8) != 0) {
            --argumentsSize;
        }
        this.maxLocals = argumentsSize;
        this.firstBasicBlock = new Label();
        this.visitLabel(this.firstBasicBlock);
    }

    boolean hasFrames() {
        return this.stackMapTableNumberOfEntries > 0;
    }

    boolean hasAsmInstructions() {
        return this.hasAsmInstructions;
    }

    public void visitInsn(int opcode) {
        this.lastBytecodeOffset = this.code.length;
        this.code.putByte(opcode);
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.frame.execute(opcode, 0, null, null);
            if (opcode >= 172 && opcode <= 177 || opcode == 191) {
                this.endCurrentBasicBlockWithNoSuccessor();
            }
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        this.lastBytecodeOffset = this.code.length;
        if (opcode == 17) {
            this.code.put12(opcode, operand);
        } else {
            this.code.put11(opcode, operand);
        }
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.frame.execute(opcode, operand, null, null);
        }
    }

    public void visitVarInsn(int opcode, int var) {
        int currentMaxLocals;
        this.lastBytecodeOffset = this.code.length;
        if (var < 4 && opcode != 169) {
            int optimizedOpcode = opcode < 54 ? 26 + (opcode - 21 << 2) + var : 59 + (opcode - 54 << 2) + var;
            this.code.putByte(optimizedOpcode);
        } else if (var >= 256) {
            this.code.putByte(196).put12(opcode, var);
        } else {
            this.code.put11(opcode, var);
        }
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.frame.execute(opcode, var, null, null);
        }
        if ((currentMaxLocals = opcode == 22 || opcode == 24 || opcode == 55 || opcode == 57 ? var + 2 : var + 1) > this.maxLocals) {
            this.maxLocals = currentMaxLocals;
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        this.lastBytecodeOffset = this.code.length;
        Symbol typeSymbol = this.symbolTable.addConstantClass(type);
        this.code.put12(opcode, typeSymbol.index);
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.frame.execute(opcode, this.lastBytecodeOffset, typeSymbol, this.symbolTable);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.lastBytecodeOffset = this.code.length;
        Symbol fieldrefSymbol = this.symbolTable.addConstantFieldref(owner, name, descriptor);
        this.code.put12(opcode, fieldrefSymbol.index);
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.frame.execute(opcode, 0, fieldrefSymbol, this.symbolTable);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.lastBytecodeOffset = this.code.length;
        Symbol methodrefSymbol = this.symbolTable.addConstantMethodref(owner, name, descriptor, isInterface);
        if (opcode == 185) {
            this.code.put12(185, methodrefSymbol.index).put11(methodrefSymbol.getArgumentsAndReturnSizes() >> 2, 0);
        } else {
            this.code.put12(opcode, methodrefSymbol.index);
        }
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.frame.execute(opcode, 0, methodrefSymbol, this.symbolTable);
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.lastBytecodeOffset = this.code.length;
        int baseOpcode = opcode >= 200 ? opcode - 33 : opcode;
        boolean nextInsnIsJumpTarget = false;
        if ((label.flags & 4) != 0 && label.bytecodeOffset - this.code.length < Short.MIN_VALUE) {
            throw new JSONException("not supported");
        }
        if (baseOpcode != opcode) {
            this.code.putByte(opcode);
            label.put(this.code, this.code.length - 1, true);
        } else {
            this.code.putByte(baseOpcode);
            label.put(this.code, this.code.length - 1, false);
        }
        if (this.currentBasicBlock != null) {
            Label nextBasicBlock = null;
            this.currentBasicBlock.frame.execute(baseOpcode, 0, null, null);
            label.getCanonicalInstance().flags = (short)(label.getCanonicalInstance().flags | 2);
            this.addSuccessorToCurrentBasicBlock(label);
            if (baseOpcode != 167) {
                nextBasicBlock = new Label();
            }
            if (nextBasicBlock != null) {
                if (nextInsnIsJumpTarget) {
                    nextBasicBlock.flags = (short)(nextBasicBlock.flags | 2);
                }
                this.visitLabel(nextBasicBlock);
            }
            if (baseOpcode == 167) {
                this.endCurrentBasicBlockWithNoSuccessor();
            }
        }
    }

    public void visitLabel(Label label) {
        this.hasAsmInstructions |= label.resolve(this.code.data, this.code.length);
        if ((label.flags & 1) != 0) {
            return;
        }
        if (this.currentBasicBlock != null) {
            if (label.bytecodeOffset == this.currentBasicBlock.bytecodeOffset) {
                this.currentBasicBlock.flags = (short)(this.currentBasicBlock.flags | label.flags & 2);
                label.frame = this.currentBasicBlock.frame;
                return;
            }
            this.addSuccessorToCurrentBasicBlock(label);
        }
        if (this.lastBasicBlock != null) {
            if (label.bytecodeOffset == this.lastBasicBlock.bytecodeOffset) {
                this.lastBasicBlock.flags = (short)(this.lastBasicBlock.flags | label.flags & 2);
                label.frame = this.lastBasicBlock.frame;
                this.currentBasicBlock = this.lastBasicBlock;
                return;
            }
            this.lastBasicBlock.nextBasicBlock = label;
        }
        this.lastBasicBlock = label;
        this.currentBasicBlock = label;
        label.frame = new Frame(label);
    }

    public void visitLdcInsn(String value) {
        int CONSTANT_STRING_TAG = 8;
        this.lastBytecodeOffset = this.code.length;
        Symbol constantSymbol = this.symbolTable.addConstantUtf8Reference(8, value);
        int constantIndex = constantSymbol.index;
        if (constantIndex >= 256) {
            this.code.put12(19, constantIndex);
        } else {
            this.code.put11(18, constantIndex);
        }
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.frame.execute(18, 0, constantSymbol, this.symbolTable);
        }
    }

    public void visitLdcInsn(int value) {
        int CONSTANT_INTEGER_TAG = 3;
        this.lastBytecodeOffset = this.code.length;
        Symbol constantSymbol = this.symbolTable.addConstantIntegerOrFloat(3, value);
        int constantIndex = constantSymbol.index;
        if (constantIndex >= 256) {
            this.code.put12(19, constantIndex);
        } else {
            this.code.put11(18, constantIndex);
        }
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.frame.execute(18, 0, constantSymbol, this.symbolTable);
        }
    }

    public void visitLdcInsn(long value) {
        int CONSTANT_LONG_TAG = 5;
        this.lastBytecodeOffset = this.code.length;
        Symbol constantSymbol = this.symbolTable.addConstantLongOrDouble(5, value);
        int constantIndex = constantSymbol.index;
        this.code.put12(20, constantIndex);
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.frame.execute(18, 0, constantSymbol, this.symbolTable);
        }
    }

    public void visitIincInsn(int var, int increment) {
        this.lastBytecodeOffset = this.code.length;
        if (var > 255 || increment > 127 || increment < -128) {
            this.code.putByte(196).put12(132, var).putShort(increment);
        } else {
            this.code.putByte(132).put11(var, increment);
        }
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.frame.execute(132, var, null, null);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.lastBytecodeOffset = this.code.length;
        this.code.putByte(171).putByteArray(null, 0, (4 - this.code.length % 4) % 4);
        dflt.put(this.code, this.lastBytecodeOffset, true);
        this.code.putInt(labels.length);
        for (int i = 0; i < labels.length; ++i) {
            this.code.putInt(keys[i]);
            labels[i].put(this.code, this.lastBytecodeOffset, true);
        }
        this.visitSwitchInsn(dflt, labels);
    }

    private void visitSwitchInsn(Label dflt, Label[] labels) {
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.frame.execute(171, 0, null, null);
            this.addSuccessorToCurrentBasicBlock(dflt);
            dflt.getCanonicalInstance().flags = (short)(dflt.getCanonicalInstance().flags | 2);
            for (Label label : labels) {
                this.addSuccessorToCurrentBasicBlock(label);
                label.getCanonicalInstance().flags = (short)(label.getCanonicalInstance().flags | 2);
            }
            this.endCurrentBasicBlockWithNoSuccessor();
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.computeAllFrames();
    }

    private void computeAllFrames() {
        Label basicBlock;
        Frame firstFrame = this.firstBasicBlock.frame;
        firstFrame.setInputFrameFromDescriptor(this.symbolTable, this.accessFlags, this.descriptor, this.maxLocals);
        firstFrame.accept(this);
        Label listOfBlocksToProcess = this.firstBasicBlock;
        listOfBlocksToProcess.nextListElement = Label.EMPTY_LIST;
        int maxStackSize = 0;
        while (listOfBlocksToProcess != Label.EMPTY_LIST) {
            basicBlock = listOfBlocksToProcess;
            listOfBlocksToProcess = listOfBlocksToProcess.nextListElement;
            basicBlock.nextListElement = null;
            basicBlock.flags = (short)(basicBlock.flags | 8);
            int maxBlockStackSize = basicBlock.frame.getInputStackSize() + basicBlock.outputStackMax;
            if (maxBlockStackSize > maxStackSize) {
                maxStackSize = maxBlockStackSize;
            }
            Edge outgoingEdge = basicBlock.outgoingEdges;
            while (outgoingEdge != null) {
                Label successorBlock = outgoingEdge.successor.getCanonicalInstance();
                boolean successorBlockChanged = basicBlock.frame.merge(this.symbolTable, successorBlock.frame);
                if (successorBlockChanged && successorBlock.nextListElement == null) {
                    successorBlock.nextListElement = listOfBlocksToProcess;
                    listOfBlocksToProcess = successorBlock;
                }
                outgoingEdge = outgoingEdge.nextEdge;
            }
        }
        basicBlock = this.firstBasicBlock;
        while (basicBlock != null) {
            int startOffset;
            Label nextBasicBlock;
            int endOffset;
            if ((basicBlock.flags & 0xA) == 10) {
                basicBlock.frame.accept(this);
            }
            if ((basicBlock.flags & 8) == 0 && (endOffset = ((nextBasicBlock = basicBlock.nextBasicBlock) == null ? this.code.length : nextBasicBlock.bytecodeOffset) - 1) >= (startOffset = basicBlock.bytecodeOffset)) {
                for (int i = startOffset; i < endOffset; ++i) {
                    this.code.data[i] = 0;
                }
                this.code.data[endOffset] = -65;
                int frameIndex = this.visitFrameStart(startOffset, 0, 1);
                this.currentFrame[frameIndex] = Frame.getAbstractTypeFromInternalName(this.symbolTable, "java/lang/Throwable");
                this.visitFrameEnd();
                maxStackSize = Math.max(maxStackSize, 1);
            }
            basicBlock = basicBlock.nextBasicBlock;
        }
        this.maxStack = maxStackSize;
    }

    public void visitEnd() {
    }

    private void addSuccessorToCurrentBasicBlock(Label successor) {
        this.currentBasicBlock.outgoingEdges = new Edge(successor, this.currentBasicBlock.outgoingEdges);
    }

    private void endCurrentBasicBlockWithNoSuccessor() {
        Label nextBasicBlock = new Label();
        nextBasicBlock.frame = new Frame(nextBasicBlock);
        nextBasicBlock.resolve(this.code.data, this.code.length);
        this.lastBasicBlock.nextBasicBlock = nextBasicBlock;
        this.lastBasicBlock = nextBasicBlock;
        this.currentBasicBlock = null;
    }

    int visitFrameStart(int offset, int numLocal, int numStack) {
        int frameLength = 3 + numLocal + numStack;
        if (this.currentFrame == null || this.currentFrame.length < frameLength) {
            this.currentFrame = new int[frameLength];
        }
        this.currentFrame[0] = offset;
        this.currentFrame[1] = numLocal;
        this.currentFrame[2] = numStack;
        return 3;
    }

    void visitAbstractType(int frameIndex, int abstractType) {
        this.currentFrame[frameIndex] = abstractType;
    }

    void visitFrameEnd() {
        if (this.previousFrame != null) {
            if (this.stackMapTableEntries == null) {
                this.stackMapTableEntries = new ByteVector();
            }
            this.putFrame();
            ++this.stackMapTableNumberOfEntries;
        }
        this.previousFrame = this.currentFrame;
        this.currentFrame = null;
    }

    private void putFrame() {
        int numLocal = this.currentFrame[1];
        int numStack = this.currentFrame[2];
        int offsetDelta = this.stackMapTableNumberOfEntries == 0 ? this.currentFrame[0] : this.currentFrame[0] - this.previousFrame[0] - 1;
        int previousNumlocal = this.previousFrame[1];
        int numLocalDelta = numLocal - previousNumlocal;
        int type = 255;
        if (numStack == 0) {
            switch (numLocalDelta) {
                case -3: 
                case -2: 
                case -1: {
                    type = 248;
                    break;
                }
                case 0: {
                    type = offsetDelta < 64 ? 0 : 251;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    type = 252;
                    break;
                }
            }
        } else if (numLocalDelta == 0 && numStack == 1) {
            int n = type = offsetDelta < 63 ? 64 : 247;
        }
        if (type != 255) {
            int frameIndex = 3;
            for (int i = 0; i < previousNumlocal && i < numLocal; ++i) {
                if (this.currentFrame[frameIndex] != this.previousFrame[frameIndex]) {
                    type = 255;
                    break;
                }
                ++frameIndex;
            }
        }
        switch (type) {
            case 0: {
                this.stackMapTableEntries.putByte(offsetDelta);
                break;
            }
            case 64: {
                this.stackMapTableEntries.putByte(64 + offsetDelta);
                this.putAbstractTypes(3 + numLocal, 4 + numLocal);
                break;
            }
            case 247: {
                this.stackMapTableEntries.putByte(247).putShort(offsetDelta);
                this.putAbstractTypes(3 + numLocal, 4 + numLocal);
                break;
            }
            case 251: {
                this.stackMapTableEntries.putByte(251).putShort(offsetDelta);
                break;
            }
            case 248: {
                this.stackMapTableEntries.putByte(251 + numLocalDelta).putShort(offsetDelta);
                break;
            }
            case 252: {
                this.stackMapTableEntries.putByte(251 + numLocalDelta).putShort(offsetDelta);
                this.putAbstractTypes(3 + previousNumlocal, 3 + numLocal);
                break;
            }
            default: {
                this.stackMapTableEntries.putByte(255).putShort(offsetDelta).putShort(numLocal);
                this.putAbstractTypes(3, 3 + numLocal);
                this.stackMapTableEntries.putShort(numStack);
                this.putAbstractTypes(3 + numLocal, 3 + numLocal + numStack);
            }
        }
    }

    private void putAbstractTypes(int start, int end) {
        for (int i = start; i < end; ++i) {
            Frame.putAbstractType(this.symbolTable, this.currentFrame[i], this.stackMapTableEntries);
        }
    }

    int computeMethodInfoSize() {
        int size = 8;
        if (this.code.length > 0) {
            if (this.code.length > 65535) {
                throw new JSONException("Method too large: " + this.symbolTable.getClassName() + "." + this.name + " " + this.descriptor + ", length " + this.code.length);
            }
            this.symbolTable.addConstantUtf8("Code");
            size += 16 + this.code.length + 2;
            if (this.stackMapTableEntries != null) {
                boolean useStackMapTable = true;
                this.symbolTable.addConstantUtf8(useStackMapTable ? "StackMapTable" : "StackMap");
                size += 8 + this.stackMapTableEntries.length;
            }
        }
        return size;
    }

    void putMethodInfo(ByteVector output) {
        int mask = 0;
        output.putShort(this.accessFlags & ~mask).putShort(this.nameIndex).putShort(this.descriptorIndex);
        int attributeCount = 0;
        if (this.code.length > 0) {
            ++attributeCount;
        }
        output.putShort(attributeCount);
        if (this.code.length > 0) {
            int size = 10 + this.code.length + 2;
            int codeAttributeCount = 0;
            if (this.stackMapTableEntries != null) {
                size += 8 + this.stackMapTableEntries.length;
                ++codeAttributeCount;
            }
            output.putShort(this.symbolTable.addConstantUtf8("Code")).putInt(size).putShort(this.maxStack).putShort(this.maxLocals).putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            output.putShort(0);
            output.putShort(codeAttributeCount);
            if (this.stackMapTableEntries != null) {
                boolean useStackMapTable = true;
                output.putShort(this.symbolTable.addConstantUtf8(useStackMapTable ? "StackMapTable" : "StackMap")).putInt(2 + this.stackMapTableEntries.length).putShort(this.stackMapTableNumberOfEntries).putByteArray(this.stackMapTableEntries.data, 0, this.stackMapTableEntries.length);
            }
        }
    }
}

