/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Collection;

abstract class FieldReaderImpl<T>
implements FieldReader<T> {
    final int ordinal;
    final String fieldName;
    final Class fieldClass;
    final Type fieldType;
    final long fieldNameHash;
    final long features;
    final String format;
    volatile ObjectReader reader;
    volatile JSONPath referenceCache;

    public FieldReaderImpl(String fieldName, Type fieldType) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldClass = TypeUtils.getMapping(fieldType);
        this.fieldNameHash = Fnv.hashCode64(fieldName);
        this.features = 0L;
        this.ordinal = 0;
        this.format = null;
    }

    public FieldReaderImpl(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldClass = fieldClass;
        this.features = features;
        this.fieldNameHash = Fnv.hashCode64(fieldName);
        this.ordinal = ordinal;
        this.format = format;
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.reader != null) {
            return this.reader;
        }
        if (this.format != null && !this.format.isEmpty()) {
            String typeName;
            switch (typeName = this.fieldType.getTypeName()) {
                case "java.sql.Time": {
                    this.reader = JdbcSupport.createTimeReader(this.format);
                    return this.reader;
                }
                case "java.sql.Timestamp": {
                    this.reader = JdbcSupport.createTimestampReader(this.format);
                    return this.reader;
                }
                case "java.sql.Date": {
                    return JdbcSupport.createDateReader(this.format);
                }
            }
        }
        this.reader = jsonReader.getObjectReader(this.fieldType);
        return this.reader;
    }

    @Override
    public int ordinal() {
        return this.ordinal;
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    @Override
    public long getFieldNameHash() {
        return this.fieldNameHash;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public Type getFieldType() {
        return this.fieldType;
    }

    @Override
    public Class getFieldClass() {
        return this.fieldClass;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return this.fieldName;
    }

    @Override
    public void addResolveTask(JSONReader jsonReader, Object object, String reference) {
        JSONPath path = this.referenceCache != null && this.referenceCache.toString().equals(reference) ? this.referenceCache : (this.referenceCache = JSONPath.of(reference));
        jsonReader.addResolveTask(this, object, path);
    }

    public void addResolveTask(JSONReader jsonReader, Collection object, int i, String reference) {
        JSONPath path = this.referenceCache != null && this.referenceCache.toString().equals(reference) ? this.referenceCache : (this.referenceCache = JSONPath.of(reference));
        jsonReader.addResolveTask(object, i, path);
    }
}

