/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public final class FieldReaderListInt64
implements ObjectReader {
    final Class listType;
    final Class instanceType;
    final long instanceTypeHash;

    public FieldReaderListInt64(Class listType, Class instanceType) {
        this.listType = listType;
        this.instanceType = instanceType;
        this.instanceTypeHash = Fnv.hashCode64(TypeUtils.getTypeName(instanceType));
    }

    public Object createInstance() {
        if (this.instanceType == ArrayList.class) {
            return new ArrayList();
        }
        if (this.instanceType == LinkedList.class) {
            return new LinkedList();
        }
        try {
            return this.instanceType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JSONException("create list error, type " + this.instanceType);
        }
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        return null;
    }

    public Object readJSONBObject(JSONReader jsonReader, long features) {
        Collection list;
        if (jsonReader.nextIfNull()) {
            return null;
        }
        Class listType = this.listType;
        ObjectReader objectReader = jsonReader.checkAutoType(listType, this.instanceTypeHash, features);
        if (objectReader != null) {
            listType = objectReader.getObjectClass();
        }
        if (listType == ArrayList.class) {
            list = new ArrayList();
        } else if (listType == JSONArray.class) {
            list = new JSONArray();
        } else if (listType != null && listType != this.listType) {
            try {
                list = (Collection)listType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException("create instance error " + listType, e);
            }
        } else {
            list = (Collection)this.createInstance();
        }
        int entryCnt = jsonReader.startArray();
        for (int i = 0; i < entryCnt; ++i) {
            list.add(jsonReader.readInt64());
        }
        return list;
    }

    public Object readObject(JSONReader jsonReader, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, 0L);
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.isString()) {
            Collection list = (Collection)this.createInstance();
            String str = jsonReader.readString();
            if (str.indexOf(44) != -1) {
                String[] items;
                for (String item : items = str.split(",")) {
                    list.add(Long.parseLong(item));
                }
            } else {
                list.add(Long.parseLong(str));
            }
            jsonReader.nextIfMatch(',');
            return list;
        }
        if (jsonReader.current() != '[') {
            throw new JSONException("format error : " + jsonReader.current());
        }
        jsonReader.next();
        Collection list = (Collection)this.createInstance();
        while (!jsonReader.nextIfMatch(']')) {
            list.add(jsonReader.readInt64());
        }
        jsonReader.nextIfMatch(',');
        return list;
    }
}

