/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderList;
import com.alibaba.fastjson2.reader.FieldReaderObjectMethod;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

final class FieldReaderListStrMethod<T>
extends FieldReaderObjectMethod<T>
implements FieldReaderList<T, Object> {
    final long fieldClassHash;

    FieldReaderListStrMethod(String fieldName, Type fieldType, Method method) {
        super(fieldName, fieldType, method);
        this.fieldClassHash = Fnv.hashCode64(TypeUtils.getTypeName(this.fieldClass));
    }

    @Override
    public Type getItemType() {
        return String.class;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        List value;
        if (jsonReader.isJSONB()) {
            int itemCnt;
            Class listType = this.fieldClass;
            ObjectReader objectReader = jsonReader.checkAutoType(this.fieldClass, this.fieldClassHash, this.features);
            if (objectReader != null) {
                listType = objectReader.getObjectClass();
            }
            if ((itemCnt = jsonReader.startArray()) == -1) {
                value = null;
            } else if (listType == Collection.class || listType == AbstractCollection.class || listType == List.class || listType == AbstractList.class || listType == ArrayList.class) {
                value = new ArrayList(itemCnt);
            } else if (listType == LinkedList.class) {
                value = new LinkedList();
            } else if (listType == JSONArray.class) {
                value = new JSONArray(itemCnt);
            } else {
                try {
                    value = (List)listType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new JSONException("create instance error " + listType, e);
                }
            }
            for (int i = 0; i < itemCnt; ++i) {
                value.add(jsonReader.readString());
            }
        } else if (jsonReader.current() == '[') {
            JSONArray list = this.createList();
            jsonReader.next();
            while (!jsonReader.nextIfMatch(']')) {
                list.add(jsonReader.readString());
                if (!jsonReader.nextIfMatch(',')) continue;
            }
            this.accept(object, list);
            jsonReader.nextIfMatch(',');
            value = list;
        } else {
            throw new JSONException("json format error : " + jsonReader.current());
        }
        try {
            this.method.invoke(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }
}

