/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.util.function.Function;
import java.util.function.Supplier;

final class ObjectReader4<T>
extends ObjectReaderBean<T> {
    final long features;
    final Supplier<T> defaultCreator;
    final Function buildFunction;
    final FieldReader fieldReader0;
    final FieldReader fieldReader1;
    final FieldReader fieldReader2;
    final FieldReader fieldReader3;
    final long hashCode0;
    final long hashCode1;
    final long hashCode2;
    final long hashCode3;
    final long hashCode0LCase;
    final long hashCode1LCase;
    final long hashCode2LCase;
    final long hashCode3LCase;

    ObjectReader4(Class objectClass, long features, Supplier<T> defaultCreator, Function buildFunction, FieldReader fieldReader0, FieldReader fieldReader1, FieldReader fieldReader2, FieldReader fieldReader3) {
        super(objectClass, null);
        this.features = features;
        this.defaultCreator = defaultCreator;
        this.buildFunction = buildFunction;
        this.fieldReader0 = fieldReader0;
        this.fieldReader1 = fieldReader1;
        this.fieldReader2 = fieldReader2;
        this.fieldReader3 = fieldReader3;
        String fieldName0 = fieldReader0.getFieldName();
        String fieldName1 = fieldReader1.getFieldName();
        String fieldName2 = fieldReader2.getFieldName();
        String fieldName3 = fieldReader3.getFieldName();
        this.hashCode0 = Fnv.hashCode64(fieldName0);
        this.hashCode1 = Fnv.hashCode64(fieldName1);
        this.hashCode2 = Fnv.hashCode64(fieldName2);
        this.hashCode3 = Fnv.hashCode64(fieldName3);
        this.hashCode0LCase = Fnv.hashCode64LCase(fieldName0);
        this.hashCode1LCase = Fnv.hashCode64LCase(fieldName1);
        this.hashCode2LCase = Fnv.hashCode64LCase(fieldName2);
        this.hashCode3LCase = Fnv.hashCode64LCase(fieldName3);
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    @Override
    public Function getBuildFunction() {
        return this.buildFunction;
    }

    @Override
    public T createInstance() {
        return this.defaultCreator.get();
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, long features) {
        Object object;
        if (jsonReader.isArray()) {
            int entryCnt = jsonReader.startArray();
            T object2 = this.defaultCreator.get();
            this.fieldReader0.readFieldValue(jsonReader, object2);
            this.fieldReader1.readFieldValue(jsonReader, object2);
            this.fieldReader2.readFieldValue(jsonReader, object2);
            this.fieldReader3.readFieldValue(jsonReader, object2);
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object2);
            }
            return object2;
        }
        ObjectReader autoTypeReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features);
        if (autoTypeReader != null && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, features);
        }
        if (!jsonReader.nextIfMatch((byte)-90)) {
            throw new JSONException("expect object, but " + JSONB.typeName(jsonReader.getType()));
        }
        if (this.defaultCreator != null) {
            object = this.defaultCreator.get();
        } else if (JDKUtils.UNSAFE_SUPPORT && ((features | jsonReader.getContext().getFeatures()) & JSONReader.Feature.FieldBased.mask) != 0L) {
            try {
                object = UnsafeUtils.UNSAFE.allocateInstance(this.objectClass);
            }
            catch (InstantiationException e) {
                throw new JSONException("create instance error", e);
            }
        } else {
            object = null;
        }
        while (!jsonReader.nextIfMatch((byte)-91)) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (hashCode == 0L) continue;
            if (hashCode == this.hashCode0) {
                this.fieldReader0.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode1) {
                this.fieldReader1.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode2) {
                this.fieldReader2.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode3) {
                this.fieldReader3.readFieldValue(jsonReader, object);
                continue;
            }
            if (!jsonReader.isSupportSmartMatch(features | this.features)) {
                jsonReader.skipValue();
                continue;
            }
            long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
            if (nameHashCodeLCase == this.hashCode0LCase) {
                this.fieldReader0.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode1LCase) {
                this.fieldReader1.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode2LCase) {
                this.fieldReader2.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode3LCase) {
                this.fieldReader3.readFieldValue(jsonReader, object);
                continue;
            }
            jsonReader.skipValue();
        }
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public T readObject(JSONReader jsonReader, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, features);
        }
        if (jsonReader.isArray() && jsonReader.isSupportBeanArray()) {
            jsonReader.nextIfMatch('[');
            T object = this.defaultCreator.get();
            this.fieldReader0.readFieldValue(jsonReader, object);
            this.fieldReader1.readFieldValue(jsonReader, object);
            this.fieldReader2.readFieldValue(jsonReader, object);
            this.fieldReader3.readFieldValue(jsonReader, object);
            if (!jsonReader.nextIfMatch(']')) {
                throw new JSONException("array to bean end error, " + jsonReader.current());
            }
            jsonReader.nextIfMatch(',');
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object);
            }
            return object;
        }
        jsonReader.nextIfMatch('{');
        T object = this.defaultCreator.get();
        int i = 0;
        while (!jsonReader.nextIfMatch('}')) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (i == 0 && hashCode == HASH_TYPE) {
                String typeName;
                long typeHash = jsonReader.readTypeHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass)) == null) {
                    throw new JSONException("auotype not support : " + typeName);
                }
                if (autoTypeObjectReader != this) {
                    object = autoTypeObjectReader.readObject(jsonReader, features);
                    break;
                }
            } else if (hashCode == this.hashCode0) {
                this.fieldReader0.readFieldValue(jsonReader, object);
            } else if (hashCode == this.hashCode1) {
                this.fieldReader1.readFieldValue(jsonReader, object);
            } else if (hashCode == this.hashCode2) {
                this.fieldReader2.readFieldValue(jsonReader, object);
            } else if (hashCode == this.hashCode3) {
                this.fieldReader3.readFieldValue(jsonReader, object);
            } else if (!jsonReader.isSupportSmartMatch(features | this.features)) {
                jsonReader.skipValue();
            } else {
                long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                if (nameHashCodeLCase == this.hashCode0LCase) {
                    this.fieldReader0.readFieldValue(jsonReader, object);
                } else if (nameHashCodeLCase == this.hashCode1LCase) {
                    this.fieldReader1.readFieldValue(jsonReader, object);
                } else if (nameHashCodeLCase == this.hashCode2LCase) {
                    this.fieldReader2.readFieldValue(jsonReader, object);
                } else if (nameHashCodeLCase == this.hashCode3LCase) {
                    this.fieldReader3.readFieldValue(jsonReader, object);
                } else {
                    jsonReader.skipValue();
                }
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        if (hashCode == this.hashCode0) {
            return this.fieldReader0;
        }
        if (hashCode == this.hashCode1) {
            return this.fieldReader1;
        }
        if (hashCode == this.hashCode2) {
            return this.fieldReader2;
        }
        if (hashCode == this.hashCode3) {
            return this.fieldReader3;
        }
        return null;
    }
}

