/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.annotation.JSONBuilder;
import com.alibaba.fastjson2.annotation.JSONCreator;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.modules.ObjectReaderAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.FieldReaderListInt64;
import com.alibaba.fastjson2.reader.ObjectArrayReader;
import com.alibaba.fastjson2.reader.ObjectArrayTypedReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderImplAtomicInteger;
import com.alibaba.fastjson2.reader.ObjectReaderImplAtomicLong;
import com.alibaba.fastjson2.reader.ObjectReaderImplAtomicLongArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigDecimal;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigInteger;
import com.alibaba.fastjson2.reader.ObjectReaderImplByte;
import com.alibaba.fastjson2.reader.ObjectReaderImplCharValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplClass;
import com.alibaba.fastjson2.reader.ObjectReaderImplCurrency;
import com.alibaba.fastjson2.reader.ObjectReaderImplInstant;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.reader.ObjectReaderImplListStr;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapString;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.reader.ObjectReaderImplObject;
import com.alibaba.fastjson2.reader.ObjectReaderImplOptionalInt;
import com.alibaba.fastjson2.reader.ObjectReaderImplShort;
import com.alibaba.fastjson2.reader.ObjectReaderImplString;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ObjectReaders;
import com.alibaba.fastjson2.reader.TypeConverts;
import com.alibaba.fastjson2.support.money.MoneySupport;
import com.alibaba.fastjson2.util.ApacheLang3Support;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.GuavaSupport;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.JodaSupport;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ObjectReaderBaseModule
implements ObjectReaderModule {
    final ObjectReaderProvider provider;
    final ReaderAnnotationProcessor annotationProcessor;

    public ObjectReaderBaseModule(ObjectReaderProvider provider) {
        this.provider = provider;
        this.annotationProcessor = new ReaderAnnotationProcessor();
    }

    @Override
    public void init(ObjectReaderProvider provider) {
        provider.registerTypeConvert((Type)((Object)Byte.class), (Type)((Object)BigDecimal.class), TypeConverts.NUMBER_TO_DECIMAL);
        provider.registerTypeConvert((Type)((Object)Short.class), (Type)((Object)BigDecimal.class), TypeConverts.NUMBER_TO_DECIMAL);
        provider.registerTypeConvert((Type)((Object)Integer.class), (Type)((Object)BigDecimal.class), TypeConverts.NUMBER_TO_DECIMAL);
        provider.registerTypeConvert((Type)((Object)Long.class), (Type)((Object)BigDecimal.class), TypeConverts.NUMBER_TO_DECIMAL);
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)BigDecimal.class), TypeConverts.STRING_TO_DECIMAL);
        provider.registerTypeConvert((Type)((Object)Byte.class), (Type)((Object)Integer.class), TypeConverts.NUMBER_TO_INTEGER);
        provider.registerTypeConvert((Type)((Object)Short.class), (Type)((Object)Integer.class), TypeConverts.NUMBER_TO_INTEGER);
        provider.registerTypeConvert((Type)((Object)Long.class), (Type)((Object)Integer.class), TypeConverts.NUMBER_TO_INTEGER);
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Integer.class), TypeConverts.STRING_TO_INTEGER);
        provider.registerTypeConvert((Type)((Object)BigDecimal.class), (Type)((Object)Integer.class), TypeConverts.DECIMAL_TO_INTEGER);
        provider.registerTypeConvert((Type)((Object)Byte.class), Integer.TYPE, TypeConverts.NUMBER_TO_INTEGER_VALUE);
        provider.registerTypeConvert((Type)((Object)Short.class), Integer.TYPE, TypeConverts.NUMBER_TO_INTEGER_VALUE);
        provider.registerTypeConvert((Type)((Object)Integer.class), Integer.TYPE, TypeConverts.NUMBER_TO_INTEGER_VALUE);
        provider.registerTypeConvert((Type)((Object)Long.class), Integer.TYPE, TypeConverts.NUMBER_TO_INTEGER_VALUE);
        provider.registerTypeConvert((Type)((Object)Long.class), Integer.TYPE, TypeConverts.NUMBER_TO_INTEGER_VALUE);
        provider.registerTypeConvert((Type)((Object)Long.class), (Type)((Object)Integer.class), TypeConverts.NUMBER_TO_INTEGER_VALUE);
        provider.registerTypeConvert((Type)((Object)String.class), Integer.TYPE, o -> o == null || "null".equals(o) || "".equals(o) ? 0 : Integer.parseInt((String)o));
        provider.registerTypeConvert((Type)((Object)BigDecimal.class), Integer.TYPE, o -> o == null ? 0 : ((BigDecimal)o).intValueExact());
        provider.registerTypeConvert((Type)((Object)Boolean.class), Integer.TYPE, o -> o == null ? 0 : ((Boolean)o != false ? 1 : 0));
        provider.registerTypeConvert((Type)((Object)Byte.class), Long.TYPE, TypeConverts.NUMBER_TO_LONG);
        provider.registerTypeConvert((Type)((Object)Short.class), Long.TYPE, TypeConverts.NUMBER_TO_LONG);
        provider.registerTypeConvert((Type)((Object)Integer.class), Long.TYPE, TypeConverts.NUMBER_TO_LONG);
        provider.registerTypeConvert((Type)((Object)Long.class), Long.TYPE, TypeConverts.NUMBER_TO_LONG);
        provider.registerTypeConvert((Type)((Object)Integer.class), (Type)((Object)Long.class), TypeConverts.NUMBER_TO_LONG);
        provider.registerTypeConvert((Type)((Object)String.class), Long.TYPE, TypeConverts.STRING_TO_LONG_VALUE);
        provider.registerTypeConvert((Type)((Object)BigDecimal.class), Long.TYPE, o -> o == null ? 0L : ((BigDecimal)o).longValue());
        provider.registerTypeConvert((Type)((Object)Boolean.class), Long.TYPE, o -> o == null ? 0L : ((Boolean)o != false ? 1L : 0L));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Long.class), TypeConverts.STRING_TO_LONG);
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)BigInteger.class), o -> o == null || "null".equals(o) ? null : new BigInteger((String)o));
        provider.registerTypeConvert((Type)((Object)Long.class), (Type)((Object)BigInteger.class), o -> o == null ? null : BigInteger.valueOf((Long)o));
        provider.registerTypeConvert((Type)((Object)Integer.class), (Type)((Object)BigInteger.class), o -> o == null ? null : BigInteger.valueOf(((Integer)o).intValue()));
        provider.registerTypeConvert((Type)((Object)String.class), Character.TYPE, o -> Character.valueOf(((String)o).charAt(0)));
        provider.registerTypeConvert((Type)((Object)Character.class), Character.TYPE, o -> o);
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Character.class), o -> Character.valueOf(((String)o).charAt(0)));
        provider.registerTypeConvert((Type)((Object)String.class), Double.TYPE, o -> o == null || "null".equals(o) || "".equals(o) ? 0.0 : Double.parseDouble((String)o));
        provider.registerTypeConvert((Type)((Object)String.class), Float.TYPE, o -> Float.valueOf(o == null || "null".equals(o) || "".equals(o) ? 0.0f : Float.parseFloat((String)o)));
        provider.registerTypeConvert((Type)((Object)String.class), Short.TYPE, o -> o == null || "null".equals(o) || "".equals(o) ? (short)0 : Short.parseShort((String)o));
        provider.registerTypeConvert((Type)((Object)String.class), Byte.TYPE, o -> o == null || "null".equals(o) || "".equals(o) ? (byte)0 : Byte.parseByte((String)o));
        provider.registerTypeConvert((Type)((Object)String.class), Boolean.TYPE, TypeConverts.STRING_TO_BOOLEAN_VALUE);
        provider.registerTypeConvert((Type)((Object)Boolean.class), Boolean.TYPE, o -> o);
    }

    @Override
    public ReaderAnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    @Override
    public ObjectReader getObjectReader(ObjectReaderProvider provider, Type type) {
        Type[] upperBounds;
        String typeName;
        if (type == String.class || type == CharSequence.class) {
            return ObjectReaderImplString.INSTANCE;
        }
        if (type == Character.TYPE || type == Character.class) {
            return CharacterImpl.INSTANCE;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return BooleanImpl.INSTANCE;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return ObjectReaderImplByte.INSTANCE;
        }
        if (type == Short.TYPE || type == Short.class) {
            return ObjectReaderImplShort.INSTANCE;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return IntegerImpl.INSTANCE;
        }
        if (type == Long.TYPE || type == Long.class) {
            return LongImpl.INSTANCE;
        }
        if (type == Float.TYPE || type == Float.class) {
            return FloatImpl.INSTANCE;
        }
        if (type == Double.TYPE || type == Double.class) {
            return DoubleImpl.INSTANCE;
        }
        if (type == BigInteger.class) {
            return ObjectReaderImplBigInteger.INSTANCE;
        }
        if (type == BigDecimal.class) {
            return ObjectReaderImplBigDecimal.INSTANCE;
        }
        if (type == Number.class) {
            return NumberImpl.INSTANCE;
        }
        if (type == OptionalInt.class) {
            return ObjectReaderImplOptionalInt.INSTANCE;
        }
        if (type == OptionalLong.class) {
            return OptionalLongImpl.INSTANCE;
        }
        if (type == OptionalDouble.class) {
            return OptionalDoubleImpl.INSTANCE;
        }
        if (type == Optional.class) {
            return OptionalImpl.INSTANCE;
        }
        if (type == UUID.class) {
            return UUIDImpl.INSTANCE;
        }
        if (type == URI.class) {
            return URIImpl.INSTANCE;
        }
        if (type == URL.class) {
            return URLImpl.INSTANCE;
        }
        if (type == Class.class) {
            return ObjectReaderImplClass.INSTANCE;
        }
        if (type == Type.class) {
            return new ReflectTypeImpl();
        }
        switch (typeName = type.getTypeName()) {
            case "com.google.common.collect.AbstractMapBasedMultimap$RandomAccessWrappedList": 
            case "com.google.common.collect.AbstractMapBasedMultimap$WrappedSet": {
                return null;
            }
        }
        if (type == Map.class || type == AbstractMap.class) {
            return ObjectReaderImplMap.of(null, (Class)type, 0L);
        }
        if (type == ConcurrentMap.class || type == ConcurrentHashMap.class) {
            return ObjectReaderBaseModule.typedMap((Class)type, ConcurrentHashMap.class, Object.class);
        }
        if (type == ConcurrentNavigableMap.class || type == ConcurrentSkipListMap.class) {
            return ObjectReaderBaseModule.typedMap((Class)type, ConcurrentSkipListMap.class, Object.class);
        }
        if (type == SortedMap.class || type == NavigableMap.class || type == TreeMap.class) {
            return ObjectReaderBaseModule.typedMap((Class)type, TreeMap.class, Object.class);
        }
        if (type == Calendar.class || typeName.equals("javax.xml.datatype.XMLGregorianCalendar")) {
            return CalendarImpl.INSTANCE;
        }
        if (type == Date.class) {
            return UtilDateImpl.INSTANCE;
        }
        if (type == LocalDate.class) {
            return LocalDateImpl.INSTANCE;
        }
        if (type == LocalTime.class) {
            return LocalTimeImpl.INSTANCE;
        }
        if (type == LocalDateTime.class) {
            return LocalDateTimeImpl.INSTANCE;
        }
        if (type == ZonedDateTime.class) {
            return ZonedDateTimeImpl.INSTANCE;
        }
        if (type == Instant.class) {
            return ObjectReaderImplInstant.INSTANCE;
        }
        if (type == Locale.class) {
            return LocaleImpl.INSTANCE;
        }
        if (type == Currency.class) {
            return ObjectReaderImplCurrency.INSTANCE;
        }
        if (type == ZoneId.class) {
            return ZoneIdImpl.INSTANCE;
        }
        if (type == TimeZone.class) {
            return TimeZoneImpl.INSTANCE;
        }
        if (type == char[].class) {
            return ObjectReaderImplCharValueArray.INSTANCE;
        }
        if (type == float[].class) {
            return FloatValueArrayImpl.INSTANCE;
        }
        if (type == double[].class) {
            return DoubleValueArrayImpl.INSTANCE;
        }
        if (type == boolean[].class) {
            return BoolValueArrayImpl.INSTANCE;
        }
        if (type == byte[].class) {
            return Inte8ValueArrayImpl.INSTANCE;
        }
        if (type == short[].class) {
            return Inte16ValueArrayImpl.INSTANCE;
        }
        if (type == int[].class) {
            return ObjectReaderImplInt32ValueArray.INSTANCE;
        }
        if (type == long[].class) {
            return ObjectReaderImplInt64ValueArray.INSTANCE;
        }
        if (type == Byte[].class) {
            return Inte8ArrayImpl.INSTANCE;
        }
        if (type == Short[].class) {
            return Inte16ArrayImpl.INSTANCE;
        }
        if (type == Integer[].class) {
            return ObjectReaderImplInt32Array.INSTANCE;
        }
        if (type == Long[].class) {
            return ObjectReaderImplInt64Array.INSTANCE;
        }
        if (type == Float[].class) {
            return FloatArrayImpl.INSTANCE;
        }
        if (type == Double[].class) {
            return DoubleArrayImpl.INSTANCE;
        }
        if (type == Number[].class) {
            return NumberArrayImpl.INSTANCE;
        }
        if (type == AtomicInteger.class) {
            return ObjectReaderImplAtomicInteger.INSTANCE;
        }
        if (type == AtomicLong.class) {
            return ObjectReaderImplAtomicLong.INSTANCE;
        }
        if (type == AtomicIntegerArray.class) {
            return AtomicIntegerArrayImpl.INSTANCE;
        }
        if (type == AtomicLongArray.class) {
            return ObjectReaderImplAtomicLongArray.INSTANCE;
        }
        if (type == Object[].class) {
            return ObjectArrayReader.INSTANCE;
        }
        if (type == Iterable.class || type == Collection.class || type == List.class || type == AbstractCollection.class || type == AbstractList.class || type == ArrayList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Queue.class || type == Deque.class || type == AbstractSequentialList.class || type == LinkedList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Set.class || type == AbstractSet.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == NavigableSet.class || type == SortedSet.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == ConcurrentLinkedDeque.class || type == ConcurrentLinkedQueue.class || type == ConcurrentSkipListSet.class || type == LinkedHashSet.class || type == HashSet.class || type == TreeSet.class || type == CopyOnWriteArrayList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == ObjectReaderImplList.CLASS_EMPTY_SET || type == ObjectReaderImplList.CLASS_EMPTY_LIST || type == ObjectReaderImplList.CLASS_SINGLETON || type == ObjectReaderImplList.CLASS_SINGLETON_LIST || type == ObjectReaderImplList.CLASS_ARRAYS_LIST || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_COLLECTION || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_LIST || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_SET || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_SORTED_SET || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_NAVIGABLE_SET) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == SingletonSetImpl.TYPE) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Object.class || type == Cloneable.class || type == Closeable.class || type == Serializable.class || type == Comparable.class) {
            return ObjectReaderImplObject.INSTANCE;
        }
        if (type == Map.Entry.class) {
            return new MapEntryImpl(null, null);
        }
        if (type instanceof Class) {
            Class objectClass = (Class)type;
            if (Map.class.isAssignableFrom(objectClass)) {
                return ObjectReaderImplMap.of(null, objectClass, 0L);
            }
            if (List.class.isAssignableFrom(objectClass)) {
                return ObjectReaderImplList.of(objectClass, null, 0L);
            }
            if (objectClass.isArray()) {
                return new ObjectArrayTypedReader(objectClass);
            }
            ObjectReaderCreator creator = JSONFactory.getDefaultObjectReaderProvider().getCreator();
            if (objectClass == StackTraceElement.class) {
                try {
                    Constructor constructor = objectClass.getConstructor(String.class, String.class, String.class, Integer.TYPE);
                    return creator.createObjectReaderNoneDefaultConstrutor(constructor, "className", "methodName", "fileName", "lineNumber");
                }
                catch (Throwable constructor) {
                    // empty catch block
                }
            }
            if (objectClass.isInterface()) {
                BeanInfo beanInfo = new BeanInfo();
                this.annotationProcessor.getBeanInfo(beanInfo, objectClass);
                if (beanInfo.seeAlso != null && beanInfo.seeAlso.length == 0) {
                    return new InterfaceImpl(type);
                }
            }
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length == 2) {
                Type actualTypeParam0 = actualTypeArguments[0];
                Type actualTypeParam1 = actualTypeArguments[1];
                if (rawType == Map.class || rawType == AbstractMap.class || rawType == HashMap.class) {
                    return ObjectReaderBaseModule.typedMap((Class)rawType, HashMap.class, actualTypeParam1);
                }
                if (rawType == ConcurrentMap.class || rawType == ConcurrentHashMap.class) {
                    return ObjectReaderBaseModule.typedMap((Class)rawType, ConcurrentHashMap.class, actualTypeParam1);
                }
                if (rawType == ConcurrentNavigableMap.class || rawType == ConcurrentSkipListMap.class) {
                    return ObjectReaderBaseModule.typedMap((Class)rawType, ConcurrentSkipListMap.class, actualTypeParam1);
                }
                if (rawType == LinkedHashMap.class || rawType == TreeMap.class) {
                    return ObjectReaderBaseModule.typedMap((Class)rawType, (Class)rawType, actualTypeParam1);
                }
                if (rawType == Map.Entry.class) {
                    return new MapEntryImpl(actualTypeArguments[0], actualTypeArguments[1]);
                }
                switch (rawType.getTypeName()) {
                    case "com.google.common.collect.ImmutableMap": 
                    case "com.google.common.collect.RegularImmutableMap": {
                        return new ObjectReaderImplMapTyped((Class)rawType, HashMap.class, actualTypeParam0, actualTypeParam1, 0L, GuavaSupport.immutableMapConverter());
                    }
                    case "com.google.common.collect.SingletonImmutableBiMap": {
                        return new ObjectReaderImplMapTyped((Class)rawType, HashMap.class, actualTypeParam0, actualTypeParam1, 0L, GuavaSupport.singletonBiMapConverter());
                    }
                }
            }
            if (actualTypeArguments.length == 1) {
                Type itemType = actualTypeArguments[0];
                Class<?> itemClass = TypeUtils.getMapping(itemType);
                if (rawType == Iterable.class || rawType == Collection.class || rawType == List.class || rawType == AbstractCollection.class || rawType == AbstractList.class || rawType == ArrayList.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, ArrayList.class);
                    }
                    if (itemClass == Long.class) {
                        return new FieldReaderListInt64((Class)rawType, ArrayList.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == Queue.class || rawType == Deque.class || rawType == AbstractSequentialList.class || rawType == LinkedList.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, LinkedList.class);
                    }
                    if (itemClass == Long.class) {
                        return new FieldReaderListInt64((Class)rawType, LinkedList.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == Set.class || rawType == AbstractSet.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, HashSet.class);
                    }
                    if (itemClass == Long.class) {
                        return new FieldReaderListInt64((Class)rawType, HashSet.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == NavigableSet.class || rawType == SortedSet.class) {
                    if (itemType == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, TreeSet.class);
                    }
                    if (itemClass == Long.class) {
                        return new FieldReaderListInt64((Class)rawType, TreeSet.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == ConcurrentLinkedDeque.class || rawType == ConcurrentLinkedQueue.class || rawType == ConcurrentSkipListSet.class || rawType == LinkedHashSet.class || rawType == HashSet.class || rawType == TreeSet.class || rawType == CopyOnWriteArrayList.class) {
                    if (itemType == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, (Class)rawType);
                    }
                    if (itemClass == Long.class) {
                        return new FieldReaderListInt64((Class)rawType, (Class)rawType);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                switch (rawType.getTypeName()) {
                    case "com.google.common.collect.ImmutableList": {
                        return ObjectReaderImplList.of(type, null, 0L);
                    }
                    case "com.google.common.collect.ImmutableSet": {
                        return ObjectReaderImplList.of(type, null, 0L);
                    }
                }
                if (rawType == Optional.class) {
                    return new OptionalImpl(itemType);
                }
            }
            return null;
        }
        if (type instanceof GenericArrayType) {
            return new GenericArrayImpl(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return this.getObjectReader(provider, upperBounds[0]);
        }
        if (type == ParameterizedType.class) {
            return ObjectReaders.ofReflect(ParameterizedTypeImpl.class);
        }
        switch (typeName) {
            case "java.sql.Time": {
                return JdbcSupport.createTimeReader(null);
            }
            case "java.sql.Timestamp": {
                return JdbcSupport.createTimestampReader(null);
            }
            case "java.sql.Date": {
                return JdbcSupport.createDateReader(null);
            }
            case "org.joda.time.Chronology": {
                return JodaSupport.createChronologyReader((Class)type);
            }
            case "org.joda.time.LocalDate": {
                return JodaSupport.createLocalDateReader((Class)type);
            }
            case "org.joda.time.LocalDateTime": {
                return JodaSupport.createLocalDateTimeReader((Class)type);
            }
            case "javax.money.CurrencyUnit": {
                return MoneySupport.createCurrencyUnitReader();
            }
            case "javax.money.MonetaryAmount": 
            case "javax.money.Money": {
                return MoneySupport.createMonetaryAmountReader();
            }
            case "javax.money.NumberValue": {
                return MoneySupport.createNumberValueReader();
            }
        }
        return null;
    }

    public static ObjectReader typedMap(Class mapType, Class instanceType, Type valueType) {
        if (valueType == String.class) {
            return new ObjectReaderImplMapString(mapType, instanceType, 0L);
        }
        return new ObjectReaderImplMapTyped(mapType, instanceType, null, valueType, 0L, null);
    }

    static class GenericArrayImpl
    implements ObjectReader {
        final Type itemType;
        final Class componentClass;
        ObjectReader itemObjectReader = null;

        public GenericArrayImpl(Type itemType) {
            this.itemType = itemType;
            this.componentClass = TypeUtils.getMapping(itemType);
        }

        public Object createInstance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldReader getFieldReader(long hashCode) {
            return null;
        }

        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt > 0 && this.itemObjectReader == null) {
                this.itemObjectReader = jsonReader.getContext().getObjectReader(this.itemType);
            }
            Object array = Array.newInstance(this.componentClass, entryCnt);
            for (int i = 0; i < entryCnt; ++i) {
                Object item = this.itemObjectReader.readJSONBObject(jsonReader, 0L);
                Array.set(array, i, item);
            }
            return array;
        }

        public Object readObject(JSONReader jsonReader, long features) {
            if (this.itemObjectReader == null) {
                this.itemObjectReader = jsonReader.getContext().getObjectReader(this.itemType);
            }
            if (jsonReader.isJSONB()) {
                return this.readJSONBObject(jsonReader, 0L);
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            char ch = jsonReader.current();
            if (ch == '\"') {
                String str = jsonReader.readString();
                if (str.isEmpty()) {
                    return null;
                }
                throw new JSONException("format error");
            }
            ArrayList list = new ArrayList();
            if (ch != '[') {
                throw new JSONException("format error : " + ch);
            }
            jsonReader.next();
            while (!jsonReader.nextIfMatch(']')) {
                Object item;
                if (this.itemObjectReader != null) {
                    item = this.itemObjectReader.readObject(jsonReader, 0L);
                } else if (this.itemType == String.class) {
                    item = jsonReader.readString();
                } else {
                    throw new JSONException("TODO : " + this.itemType);
                }
                list.add(item);
                if (!jsonReader.nextIfMatch(',')) continue;
            }
            jsonReader.nextIfMatch(',');
            Object array = Array.newInstance(this.componentClass, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }
    }

    static class SingletonSetImpl
    extends PrimitiveImpl {
        static final Class TYPE = Collections.singleton(1).getClass();
        static final SingletonSetImpl INSTANCE = new SingletonSetImpl();

        SingletonSetImpl() {
        }

        @Override
        public Class getObjectClass() {
            return TYPE;
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt != 1) {
                throw new JSONException("input not singleton");
            }
            Object value = jsonReader.read((Type)((Object)Object.class));
            return Collections.singleton(value);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            jsonReader.nextIfMatch('[');
            Object value = jsonReader.readAny();
            if (!jsonReader.nextIfMatch(']')) {
                throw new JSONException("input not singleton");
            }
            jsonReader.nextIfMatch(',');
            return Collections.singleton(value);
        }
    }

    static class EmptyListImpl
    extends PrimitiveImpl {
        static final Class TYPE = Collections.emptyList().getClass();
        static final EmptyListImpl INSTANCE = new EmptyListImpl();

        EmptyListImpl() {
        }

        @Override
        public Object createInstance() {
            return Collections.emptyList();
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt != 0) {
                throw new JSONException("input not empty");
            }
            return this.createInstance();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            jsonReader.nextIfMatch('[');
            if (!jsonReader.nextIfMatch(']')) {
                throw new JSONException("input not empty");
            }
            jsonReader.nextIfMatch(',');
            return this.createInstance();
        }
    }

    static class MapEntryImpl
    extends PrimitiveImpl {
        final Type keyType;
        final Type valueType;
        volatile ObjectReader keyReader;
        volatile ObjectReader valueReader;

        public MapEntryImpl(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            Object value;
            Object key;
            int entryCnt = jsonReader.startArray();
            if (entryCnt != 2) {
                throw new JSONException("entryCnt must be 2, but " + entryCnt);
            }
            if (this.keyType == null) {
                key = jsonReader.readAny();
            } else {
                if (this.keyReader == null) {
                    this.keyReader = jsonReader.getObjectReader(this.keyType);
                }
                key = this.keyReader.readObject(jsonReader, features);
            }
            if (this.valueType == null) {
                value = jsonReader.readAny();
            } else {
                if (this.valueReader == null) {
                    this.valueReader = jsonReader.getObjectReader(this.valueType);
                }
                value = this.valueReader.readObject(jsonReader, features);
            }
            return new AbstractMap.SimpleEntry<Object, Object>(key, value);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            jsonReader.nextIfMatch('{');
            Object key = jsonReader.readAny();
            jsonReader.nextIfMatch(':');
            Object value = jsonReader.readAny();
            jsonReader.nextIfMatch('}');
            jsonReader.nextIfMatch(',');
            return new AbstractMap.SimpleEntry<Object, Object>(key, value);
        }
    }

    static class InterfaceImpl
    extends PrimitiveImpl {
        final Type interfaceType;

        public InterfaceImpl(Type interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            Object value;
            if (jsonReader.nextIfMatch('{')) {
                long hash = jsonReader.readFieldNameHashCode();
                JSONReader.Context context = jsonReader.getContext();
                if (hash == HASH_TYPE && context.isEnable(JSONReader.Feature.SupportAutoType)) {
                    String typeName;
                    long typeHash = jsonReader.readTypeHashCode();
                    ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                    if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                        throw new JSONException("auotype not support : " + typeName);
                    }
                    return autoTypeObjectReader.readObject(jsonReader, 0L);
                }
                return ObjectReaderImplMap.INSTANCE.readObject(jsonReader, 0L);
            }
            switch (jsonReader.current()) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = jsonReader.readNumber();
                    break;
                }
                case '[': {
                    value = jsonReader.readArray();
                    break;
                }
                case '\"': 
                case '\'': {
                    value = jsonReader.readString();
                    break;
                }
                case 'f': 
                case 't': {
                    value = jsonReader.readBoolValue();
                    break;
                }
                case 'n': {
                    jsonReader.readNull();
                    value = null;
                    break;
                }
                default: {
                    throw new JSONException("TODO : " + jsonReader.current());
                }
            }
            return value;
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readAny();
        }
    }

    static class NumberArrayImpl
    extends PrimitiveImpl {
        static final NumberArrayImpl INSTANCE = new NumberArrayImpl();

        NumberArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                Number[] values = new Number[16];
                int size = 0;
                while (!jsonReader.nextIfMatch(']')) {
                    int minCapacity = size + 1;
                    if (minCapacity - values.length > 0) {
                        int oldCapacity = values.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity - minCapacity < 0) {
                            newCapacity = minCapacity;
                        }
                        values = Arrays.copyOf(values, newCapacity);
                    }
                    values[size++] = jsonReader.readNumber();
                }
                jsonReader.nextIfMatch(',');
                return Arrays.copyOf(values, size);
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            Number[] array = new Number[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = jsonReader.readNumber();
            }
            return array;
        }
    }

    static class DoubleArrayImpl
    extends PrimitiveImpl {
        static final DoubleArrayImpl INSTANCE = new DoubleArrayImpl();

        DoubleArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                Double[] values = new Double[16];
                int size = 0;
                while (!jsonReader.nextIfMatch(']')) {
                    int minCapacity = size + 1;
                    if (minCapacity - values.length > 0) {
                        int oldCapacity = values.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity - minCapacity < 0) {
                            newCapacity = minCapacity;
                        }
                        values = Arrays.copyOf(values, newCapacity);
                    }
                    values[size++] = jsonReader.readDouble();
                }
                jsonReader.nextIfMatch(',');
                return Arrays.copyOf(values, size);
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            Double[] array = new Double[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = jsonReader.readDouble();
            }
            return array;
        }
    }

    static class DoubleValueArrayImpl
    extends PrimitiveImpl {
        static final DoubleValueArrayImpl INSTANCE = new DoubleValueArrayImpl();

        DoubleValueArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                double[] values = new double[16];
                int size = 0;
                while (!jsonReader.nextIfMatch(']')) {
                    int minCapacity = size + 1;
                    if (minCapacity - values.length > 0) {
                        int oldCapacity = values.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity - minCapacity < 0) {
                            newCapacity = minCapacity;
                        }
                        values = Arrays.copyOf(values, newCapacity);
                    }
                    values[size++] = jsonReader.readDoubleValue();
                }
                jsonReader.nextIfMatch(',');
                return Arrays.copyOf(values, size);
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            double[] array = new double[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = jsonReader.readDoubleValue();
            }
            return array;
        }
    }

    static class FloatArrayImpl
    extends PrimitiveImpl {
        static final FloatArrayImpl INSTANCE = new FloatArrayImpl();

        FloatArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                Float[] values = new Float[16];
                int size = 0;
                while (!jsonReader.nextIfMatch(']')) {
                    int minCapacity = size + 1;
                    if (minCapacity - values.length > 0) {
                        int oldCapacity = values.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity - minCapacity < 0) {
                            newCapacity = minCapacity;
                        }
                        values = Arrays.copyOf(values, newCapacity);
                    }
                    values[size++] = jsonReader.readFloat();
                }
                jsonReader.nextIfMatch(',');
                return Arrays.copyOf(values, size);
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            Float[] array = new Float[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = jsonReader.readFloat();
            }
            return array;
        }
    }

    static class FloatValueArrayImpl
    extends PrimitiveImpl {
        static final FloatValueArrayImpl INSTANCE = new FloatValueArrayImpl();

        FloatValueArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                float[] values = new float[16];
                int size = 0;
                while (!jsonReader.nextIfMatch(']')) {
                    int minCapacity = size + 1;
                    if (minCapacity - values.length > 0) {
                        int oldCapacity = values.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity - minCapacity < 0) {
                            newCapacity = minCapacity;
                        }
                        values = Arrays.copyOf(values, newCapacity);
                    }
                    values[size++] = jsonReader.readFloatValue();
                }
                jsonReader.nextIfMatch(',');
                return Arrays.copyOf(values, size);
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            float[] array = new float[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = jsonReader.readFloatValue();
            }
            return array;
        }
    }

    static class Inte16ArrayImpl
    extends PrimitiveImpl {
        static final Inte16ArrayImpl INSTANCE = new Inte16ArrayImpl();

        Inte16ArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                Short[] values = new Short[16];
                int size = 0;
                while (!jsonReader.nextIfMatch(']')) {
                    int minCapacity = size + 1;
                    if (minCapacity - values.length > 0) {
                        int oldCapacity = values.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity - minCapacity < 0) {
                            newCapacity = minCapacity;
                        }
                        values = Arrays.copyOf(values, newCapacity);
                    }
                    Integer i = jsonReader.readInt32();
                    values[size++] = i == null ? (short)0 : i.shortValue();
                }
                jsonReader.nextIfMatch(',');
                return Arrays.copyOf(values, size);
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            Short[] array = new Short[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                Integer integer = jsonReader.readInt32();
                array[i] = integer == null ? null : Short.valueOf(integer.shortValue());
            }
            return array;
        }
    }

    static class Inte8ArrayImpl
    extends PrimitiveImpl {
        static final Inte8ArrayImpl INSTANCE = new Inte8ArrayImpl();

        Inte8ArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                Byte[] values = new Byte[16];
                int size = 0;
                while (!jsonReader.nextIfMatch(']')) {
                    int minCapacity = size + 1;
                    if (minCapacity - values.length > 0) {
                        int oldCapacity = values.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity - minCapacity < 0) {
                            newCapacity = minCapacity;
                        }
                        values = Arrays.copyOf(values, newCapacity);
                    }
                    Integer i = jsonReader.readInt32();
                    values[size++] = i == null ? null : Byte.valueOf(i.byteValue());
                }
                jsonReader.nextIfMatch(',');
                return Arrays.copyOf(values, size);
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            Byte[] array = new Byte[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                Integer integer = jsonReader.readInt32();
                array[i] = integer == null ? null : Byte.valueOf(integer.byteValue());
            }
            return array;
        }
    }

    static class Inte16ValueArrayImpl
    extends PrimitiveImpl {
        static final Inte16ValueArrayImpl INSTANCE = new Inte16ValueArrayImpl();

        Inte16ValueArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                short[] values = new short[16];
                int size = 0;
                while (!jsonReader.nextIfMatch(']')) {
                    int minCapacity = size + 1;
                    if (minCapacity - values.length > 0) {
                        int oldCapacity = values.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity - minCapacity < 0) {
                            newCapacity = minCapacity;
                        }
                        values = Arrays.copyOf(values, newCapacity);
                    }
                    values[size++] = (short)jsonReader.readInt32Value();
                }
                jsonReader.nextIfMatch(',');
                return Arrays.copyOf(values, size);
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            short[] array = new short[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = (short)jsonReader.readInt32Value();
            }
            return array;
        }
    }

    static class Inte8ValueArrayImpl
    extends PrimitiveImpl {
        static final Inte8ValueArrayImpl INSTANCE = new Inte8ValueArrayImpl();

        Inte8ValueArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                byte[] values = new byte[16];
                int size = 0;
                while (!jsonReader.nextIfMatch(']')) {
                    int minCapacity = size + 1;
                    if (minCapacity - values.length > 0) {
                        int oldCapacity = values.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity - minCapacity < 0) {
                            newCapacity = minCapacity;
                        }
                        values = Arrays.copyOf(values, newCapacity);
                    }
                    values[size++] = (byte)jsonReader.readInt32Value();
                }
                jsonReader.nextIfMatch(',');
                return Arrays.copyOf(values, size);
            }
            if (jsonReader.isString()) {
                return jsonReader.readBinary();
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            if (jsonReader.isBinary()) {
                return jsonReader.readBinary();
            }
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            byte[] array = new byte[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = (byte)jsonReader.readInt32Value();
            }
            return array;
        }
    }

    static class BoolValueArrayImpl
    extends PrimitiveImpl {
        static final BoolValueArrayImpl INSTANCE = new BoolValueArrayImpl();

        BoolValueArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                boolean[] values = new boolean[16];
                int size = 0;
                while (!jsonReader.nextIfMatch(']')) {
                    int minCapacity = size + 1;
                    if (minCapacity - values.length > 0) {
                        int oldCapacity = values.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity - minCapacity < 0) {
                            newCapacity = minCapacity;
                        }
                        values = Arrays.copyOf(values, newCapacity);
                    }
                    values[size++] = jsonReader.readBoolValue();
                }
                jsonReader.nextIfMatch(',');
                return Arrays.copyOf(values, size);
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            boolean[] array = new boolean[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = jsonReader.readBoolValue();
            }
            return array;
        }
    }

    static class AtomicIntegerArrayImpl
    extends PrimitiveImpl {
        static final AtomicIntegerArrayImpl INSTANCE = new AtomicIntegerArrayImpl();

        AtomicIntegerArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                ArrayList<Integer> values = new ArrayList<Integer>();
                while (!jsonReader.nextIfMatch(']')) {
                    values.add(jsonReader.readInt32());
                }
                jsonReader.nextIfMatch(',');
                AtomicIntegerArray array = new AtomicIntegerArray(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    Integer value = (Integer)values.get(i);
                    if (value == null) continue;
                    array.set(i, value);
                }
                return array;
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            AtomicIntegerArray array = new AtomicIntegerArray(entryCnt);
            for (int i = 0; i < entryCnt; ++i) {
                Integer value = jsonReader.readInt32();
                if (value == null) continue;
                array.set(i, value);
            }
            return array;
        }
    }

    static class LocalDateTimeImpl
    extends PrimitiveImpl {
        static final LocalDateTimeImpl INSTANCE = new LocalDateTimeImpl();

        LocalDateTimeImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readLocalDateTime();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.isInt()) {
                long millis = jsonReader.readInt64Value();
                return new Date(millis);
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            return jsonReader.readLocalDateTime();
        }
    }

    static class TimeZoneImpl
    extends PrimitiveImpl {
        static final TimeZoneImpl INSTANCE = new TimeZoneImpl();

        TimeZoneImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            String strVal = jsonReader.readString();
            if (strVal == null || strVal.isEmpty()) {
                return null;
            }
            return TimeZone.getTimeZone(strVal);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            String strVal = jsonReader.readString();
            if (strVal == null || strVal.isEmpty()) {
                return null;
            }
            return TimeZone.getTimeZone(strVal);
        }
    }

    static class ZoneIdImpl
    extends PrimitiveImpl {
        static final ZoneIdImpl INSTANCE = new ZoneIdImpl();

        ZoneIdImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            String strVal = jsonReader.readString();
            if (strVal == null || strVal.isEmpty()) {
                return null;
            }
            return ZoneId.of(strVal);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            String strVal = jsonReader.readString();
            if (strVal == null || strVal.isEmpty()) {
                return null;
            }
            return ZoneId.of(strVal);
        }
    }

    static class LocaleImpl
    extends PrimitiveImpl {
        static final LocaleImpl INSTANCE = new LocaleImpl();

        LocaleImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            String strVal = jsonReader.readString();
            if (strVal == null || strVal.isEmpty()) {
                return null;
            }
            String[] items = strVal.split("_");
            if (items.length == 1) {
                return new Locale(items[0]);
            }
            if (items.length == 2) {
                return new Locale(items[0], items[1]);
            }
            return new Locale(items[0], items[1], items[2]);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            String strVal = jsonReader.readString();
            if (strVal == null || strVal.isEmpty()) {
                return null;
            }
            String[] items = strVal.split("_");
            if (items.length == 1) {
                return new Locale(items[0]);
            }
            if (items.length == 2) {
                return new Locale(items[0], items[1]);
            }
            return new Locale(items[0], items[1], items[2]);
        }
    }

    static class ZonedDateTimeImpl
    extends PrimitiveImpl {
        static final ZonedDateTimeImpl INSTANCE = new ZonedDateTimeImpl();

        ZonedDateTimeImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readZonedDateTime();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.isInt()) {
                long millis = jsonReader.readInt64Value();
                return new Date(millis);
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            return jsonReader.readZonedDateTime();
        }
    }

    static class LocalTimeImpl
    extends PrimitiveImpl {
        static final LocalTimeImpl INSTANCE = new LocalTimeImpl();

        LocalTimeImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readLocalTime();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readLocalTime();
        }
    }

    static class LocalDateImpl
    extends PrimitiveImpl {
        static final LocalDateImpl INSTANCE = new LocalDateImpl();

        LocalDateImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readLocalDate();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readLocalDate();
        }
    }

    public static class UtilDateImpl
    extends PrimitiveImpl {
        static final UtilDateImpl INSTANCE = new UtilDateImpl(null);
        protected final String format;
        protected volatile SimpleDateFormat formatter;
        protected static final AtomicReferenceFieldUpdater<UtilDateImpl, SimpleDateFormat> FORMATTER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(UtilDateImpl.class, SimpleDateFormat.class, "formatter");

        public UtilDateImpl(String format) {
            this.format = format;
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            if (jsonReader.isInt()) {
                long millis = jsonReader.readInt64Value();
                return new Date(millis);
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            return this.readDate(jsonReader);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.isInt()) {
                long millis = jsonReader.readInt64Value();
                return new Date(millis);
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            return this.readDate(jsonReader);
        }

        private Object readDate(JSONReader jsonReader) {
            Date date;
            if (this.format != null) {
                SimpleDateFormat formatter = FORMATTER_UPDATER.getAndSet(this, null);
                if (formatter == null) {
                    formatter = new SimpleDateFormat(this.format);
                }
                String str = null;
                try {
                    str = jsonReader.readString();
                    date = formatter.parse(str);
                }
                catch (ParseException e) {
                    throw new JSONException("parse date error, format " + this.format + ", input " + str, e);
                }
                finally {
                    FORMATTER_UPDATER.set(this, formatter);
                }
            } else {
                long millis = jsonReader.readMillisFromString();
                date = new Date(millis);
            }
            return date;
        }
    }

    static class CalendarImpl
    extends PrimitiveImpl {
        static final CalendarImpl INSTANCE = new CalendarImpl();

        CalendarImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            if (jsonReader.isInt()) {
                long millis = jsonReader.readInt64Value();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(millis);
                return calendar;
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            long millis = jsonReader.readMillisFromString();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            return calendar;
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.current() == '\"') {
                long millis = jsonReader.readMillisFromString();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(millis);
                return calendar;
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            long millis = jsonReader.readInt64Value();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            return calendar;
        }
    }

    static class ReflectTypeImpl
    extends PrimitiveImpl {
        ReflectTypeImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            String className = jsonReader.readString();
            if (className == null) {
                return null;
            }
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JSONException("read class error " + className, e);
            }
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            String className = jsonReader.readString();
            if (className == null) {
                return null;
            }
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JSONException("read class error " + className, e);
            }
        }
    }

    static class URLImpl
    extends PrimitiveImpl<URL> {
        static final URLImpl INSTANCE = new URLImpl();

        URLImpl() {
        }

        @Override
        public URL readJSONBObject(JSONReader jsonReader, long features) {
            String str = jsonReader.readString();
            if (str == null) {
                return null;
            }
            try {
                return new URL(str);
            }
            catch (MalformedURLException e) {
                throw new JSONException("read URL error", e);
            }
        }

        @Override
        public URL readObject(JSONReader jsonReader, long features) {
            try {
                return new URL(jsonReader.readString());
            }
            catch (MalformedURLException e) {
                throw new JSONException("read URL error", e);
            }
        }
    }

    static class URIImpl
    extends PrimitiveImpl<URI> {
        static final URIImpl INSTANCE = new URIImpl();

        URIImpl() {
        }

        @Override
        public URI readJSONBObject(JSONReader jsonReader, long features) {
            String str = jsonReader.readString();
            if (str == null) {
                return null;
            }
            return URI.create(str);
        }

        @Override
        public URI readObject(JSONReader jsonReader, long features) {
            return URI.create(jsonReader.readString());
        }
    }

    static class UUIDImpl
    extends PrimitiveImpl {
        static final UUIDImpl INSTANCE = new UUIDImpl();

        UUIDImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readUUID();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readUUID();
        }
    }

    static class NumberImpl
    extends PrimitiveImpl {
        static final NumberImpl INSTANCE = new NumberImpl();

        NumberImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readNumber();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readNumber();
        }
    }

    static class DoubleImpl
    extends PrimitiveImpl {
        static final DoubleImpl INSTANCE = new DoubleImpl();

        DoubleImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readDouble();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readDouble();
        }
    }

    static class FloatImpl
    extends PrimitiveImpl {
        static final FloatImpl INSTANCE = new FloatImpl();

        FloatImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readFloat();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readFloat();
        }
    }

    static class LongImpl
    extends PrimitiveImpl<Long> {
        static final LongImpl INSTANCE = new LongImpl();

        LongImpl() {
        }

        @Override
        public Long readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readInt64();
        }

        @Override
        public Long readObject(JSONReader jsonReader, long features) {
            return jsonReader.readInt64();
        }
    }

    static class OptionalImpl
    extends PrimitiveImpl {
        static final OptionalImpl INSTANCE = new OptionalImpl(null);
        final Type itemType;
        ObjectReader itemObjectReader = null;

        public OptionalImpl(Type itemType) {
            this.itemType = itemType;
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            Object value;
            if (this.itemType == null) {
                value = jsonReader.readAny();
            } else {
                if (this.itemObjectReader == null) {
                    this.itemObjectReader = jsonReader.getObjectReader(this.itemType);
                }
                value = this.itemObjectReader.readJSONBObject(jsonReader, 0L);
            }
            if (value == null) {
                return Optional.empty();
            }
            return Optional.of(value);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            Object value;
            if (this.itemType == null) {
                value = jsonReader.readAny();
            } else {
                if (this.itemObjectReader == null) {
                    this.itemObjectReader = jsonReader.getObjectReader(this.itemType);
                }
                value = this.itemObjectReader.readObject(jsonReader, 0L);
            }
            if (value == null) {
                return Optional.empty();
            }
            return Optional.of(value);
        }
    }

    static class OptionalDoubleImpl
    extends PrimitiveImpl {
        static final OptionalDoubleImpl INSTANCE = new OptionalDoubleImpl();

        OptionalDoubleImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            Double value = jsonReader.readDouble();
            if (value == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(value);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            Double value = jsonReader.readDouble();
            if (value == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(value);
        }
    }

    static class OptionalLongImpl
    extends PrimitiveImpl {
        static final OptionalLongImpl INSTANCE = new OptionalLongImpl();

        OptionalLongImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            Long integer = jsonReader.readInt64();
            if (integer == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(integer);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            Long integer = jsonReader.readInt64();
            if (integer == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(integer);
        }
    }

    static class IntegerImpl
    extends PrimitiveImpl {
        static final IntegerImpl INSTANCE = new IntegerImpl();

        IntegerImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readInt32();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readInt32();
        }
    }

    static class BooleanImpl
    extends PrimitiveImpl {
        static final BooleanImpl INSTANCE = new BooleanImpl();

        BooleanImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readBool();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readBool();
        }
    }

    static class CharacterImpl
    extends PrimitiveImpl {
        static final CharacterImpl INSTANCE = new CharacterImpl();

        CharacterImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            String str = jsonReader.readString();
            if (str == null) {
                return null;
            }
            return Character.valueOf(str.charAt(0));
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            String str = jsonReader.readString();
            if (str == null) {
                return null;
            }
            return Character.valueOf(str.charAt(0));
        }
    }

    static abstract class PrimitiveImpl<T>
    implements ObjectReader<T> {
        PrimitiveImpl() {
        }

        @Override
        public T createInstance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldReader getFieldReader(long hashCode) {
            return null;
        }

        @Override
        public abstract T readJSONBObject(JSONReader var1, long var2);
    }

    class ReaderAnnotationProcessor
    implements ObjectReaderAnnotationProcessor {
        ReaderAnnotationProcessor() {
        }

        @Override
        public void getBeanInfo(BeanInfo beanInfo, Class<?> objectClass) {
            Class mixInSource = (Class<ApacheLang3Support.PairMixIn>)ObjectReaderBaseModule.this.provider.mixInCache.get(objectClass);
            if (mixInSource == null) {
                String typeName;
                switch (typeName = objectClass.getName()) {
                    case "org.apache.commons.lang3.tuple.Pair": 
                    case "org.apache.commons.lang3.tuple.ImmutablePair": {
                        mixInSource = ApacheLang3Support.PairMixIn.class;
                        ObjectReaderBaseModule.this.provider.mixIn(objectClass, ApacheLang3Support.PairMixIn.class);
                        break;
                    }
                    case "org.apache.commons.lang3.tuple.Triple": {
                        mixInSource = ApacheLang3Support.TripleMixIn.class;
                        ObjectReaderBaseModule.this.provider.mixIn(objectClass, ApacheLang3Support.TripleMixIn.class);
                        break;
                    }
                }
            }
            if (mixInSource != null && mixInSource != objectClass) {
                this.getBeanInfo(beanInfo, mixInSource.getAnnotation(JSONType.class));
                BeanUtils.staticMethod(mixInSource, method -> {
                    JSONCreator jsonCreator = method.getAnnotation(JSONCreator.class);
                    if (jsonCreator != null) {
                        Method targetMethod = null;
                        try {
                            targetMethod = objectClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (targetMethod != null) {
                            beanInfo.createMethod = targetMethod;
                            String[] createParameterNames = jsonCreator.parameterNames();
                            if (createParameterNames.length != 0) {
                                beanInfo.createParameterNames = createParameterNames;
                            }
                        }
                    }
                });
                BeanUtils.constructor(mixInSource, constructor -> {
                    JSONCreator jsonCreator = constructor.getAnnotation(JSONCreator.class);
                    if (jsonCreator != null) {
                        Constructor targetConstructor = null;
                        try {
                            targetConstructor = objectClass.getDeclaredConstructor(constructor.getParameterTypes());
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (targetConstructor != null) {
                            beanInfo.creatorConstructor = targetConstructor;
                            String[] createParameterNames = jsonCreator.parameterNames();
                            if (createParameterNames.length != 0) {
                                beanInfo.createParameterNames = createParameterNames;
                            }
                        }
                    }
                });
            }
            this.getBeanInfo(beanInfo, objectClass.getAnnotation(JSONType.class));
            BeanUtils.staticMethod(objectClass, method -> {
                JSONCreator jsonCreator = method.getAnnotation(JSONCreator.class);
                if (jsonCreator != null) {
                    beanInfo.createMethod = method;
                    String[] createParameterNames = jsonCreator.parameterNames();
                    if (createParameterNames.length != 0) {
                        beanInfo.createParameterNames = createParameterNames;
                    }
                }
            });
            BeanUtils.constructor(objectClass, constructor -> {
                JSONCreator jsonCreator = constructor.getAnnotation(JSONCreator.class);
                if (jsonCreator != null) {
                    beanInfo.creatorConstructor = constructor;
                    String[] createParameterNames = jsonCreator.parameterNames();
                    if (createParameterNames.length != 0) {
                        beanInfo.createParameterNames = createParameterNames;
                    }
                }
            });
        }

        void getBeanInfo(BeanInfo beanInfo, JSONType jsonType) {
            String typeName;
            String jsonTypeKey;
            if (jsonType == null) {
                return;
            }
            Class<?>[] classes = jsonType.seeAlso();
            if (classes.length != 0) {
                beanInfo.seeAlso = classes;
                beanInfo.seeAlsoNames = new String[classes.length];
                for (int i = 0; i < classes.length; ++i) {
                    Class<?> item = classes[i];
                    BeanInfo beanInfo2 = new BeanInfo();
                    this.getBeanInfo(beanInfo2, item);
                    String typeName2 = beanInfo2.typeName;
                    if (typeName2 == null || typeName2.isEmpty()) {
                        typeName2 = item.getSimpleName();
                    }
                    beanInfo.seeAlsoNames[i] = typeName2;
                }
                beanInfo.readerFeatures |= JSONReader.Feature.SupportAutoType.mask;
            }
            if (!(jsonTypeKey = jsonType.typeKey()).isEmpty()) {
                beanInfo.typeKey = jsonTypeKey;
            }
            if (!(typeName = jsonType.typeName()).isEmpty()) {
                beanInfo.typeName = typeName;
            }
            beanInfo.namingStrategy = jsonType.naming().name();
            for (JSONReader.Feature feature : jsonType.readFeatures()) {
                beanInfo.readerFeatures |= feature.mask;
            }
            Class<?> clazz = jsonType.builder();
            if (clazz != Void.TYPE && clazz != Void.class) {
                beanInfo.builder = clazz;
                JSONBuilder jsonBuilder = clazz.getAnnotation(JSONBuilder.class);
                if (jsonBuilder != null) {
                    String buildMethodName = jsonBuilder.buildMethod();
                    beanInfo.buildMethod = BeanUtils.buildMethod(clazz, buildMethodName);
                    String withPrefix = jsonBuilder.withPrefix();
                    if (!withPrefix.isEmpty()) {
                        beanInfo.builderWithPrefix = withPrefix;
                    }
                }
            }
        }

        @Override
        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Constructor constructor, int paramIndex, Parameter parameter) {
            Class mixInSource = (Class)ObjectReaderBaseModule.this.provider.mixInCache.get(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Constructor mixInConstructor = null;
                try {
                    mixInConstructor = mixInSource.getDeclaredConstructor(constructor.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (mixInConstructor != null) {
                    Parameter mixInParam = mixInConstructor.getParameters()[paramIndex];
                    this.getFieldInfo(fieldInfo, mixInParam.getAnnotation(JSONField.class));
                }
            }
            this.getFieldInfo(fieldInfo, parameter.getAnnotation(JSONField.class));
        }

        @Override
        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method, int paramIndex, Parameter parameter) {
            Class mixInSource = (Class)ObjectReaderBaseModule.this.provider.mixInCache.get(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Executable mixInMethod = null;
                try {
                    mixInMethod = mixInSource.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (mixInMethod != null) {
                    Parameter mixInParam = mixInMethod.getParameters()[paramIndex];
                    this.getFieldInfo(fieldInfo, mixInParam.getAnnotation(JSONField.class));
                }
            }
            this.getFieldInfo(fieldInfo, parameter.getAnnotation(JSONField.class));
        }

        @Override
        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Field field) {
            Class mixInSource = (Class)ObjectReaderBaseModule.this.provider.mixInCache.get(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Field mixInField = null;
                try {
                    mixInField = mixInSource.getDeclaredField(field.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInField != null) {
                    this.getFieldInfo(fieldInfo, mixInSource, mixInField);
                }
            }
            this.getFieldInfo(fieldInfo, field.getAnnotation(JSONField.class));
        }

        @Override
        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method) {
            int modifiers;
            Class mixInSource = (Class)ObjectReaderBaseModule.this.provider.mixInCache.get(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Method mixInMethod = null;
                try {
                    mixInMethod = mixInSource.getDeclaredMethod(method.getName(), method.getParameterTypes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInMethod != null) {
                    this.getFieldInfo(fieldInfo, mixInSource, mixInMethod);
                }
            }
            this.getFieldInfo(fieldInfo, method.getAnnotation(JSONField.class));
            String fieldName = BeanUtils.getterName(method.getName(), null);
            Field declaredField = null;
            try {
                declaredField = objectClass.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (declaredField != null && !Modifier.isPublic(modifiers = declaredField.getModifiers()) && !Modifier.isStatic(modifiers)) {
                this.getFieldInfo(fieldInfo, objectClass, declaredField);
            }
        }

        private void getFieldInfo(FieldInfo fieldInfo, JSONField jsonField) {
            String[] alternateNames;
            String jsonFieldFormat;
            if (jsonField == null) {
                return;
            }
            String jsonFieldName = jsonField.name();
            if (jsonFieldName != null && !jsonFieldName.isEmpty()) {
                fieldInfo.fieldName = jsonFieldName;
            }
            if ((jsonFieldFormat = jsonField.format()) != null && !jsonFieldFormat.isEmpty()) {
                if (jsonFieldFormat.indexOf(84) != -1 && !jsonFieldFormat.contains("'T'")) {
                    jsonFieldFormat = jsonFieldFormat.replaceAll("T", "'T'");
                }
                fieldInfo.format = jsonFieldFormat;
            }
            if ((alternateNames = jsonField.alternateNames()).length != 0) {
                if (fieldInfo.alternateNames == null) {
                    fieldInfo.alternateNames = alternateNames;
                } else {
                    LinkedHashSet nameSet = new LinkedHashSet();
                    for (String alternateName : alternateNames) {
                        nameSet.add(alternateName);
                    }
                    String[] stringArray = fieldInfo.alternateNames;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String alternateName;
                        alternateName = stringArray[i];
                        nameSet.add(alternateName);
                    }
                    fieldInfo.alternateNames = nameSet.toArray(new String[nameSet.size()]);
                }
            }
            if (!fieldInfo.ignore) {
                fieldInfo.ignore = !jsonField.read();
            }
            for (JSONReader.Feature feature : jsonField.readeFeatures()) {
                fieldInfo.features |= feature.mask;
            }
            int ordinal = jsonField.ordinal();
            if (ordinal != 0) {
                fieldInfo.ordinal = ordinal;
            }
        }
    }
}

