/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.Consumer;

public abstract class BeanUtils {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    static ConcurrentMap<Class, Field[]> fieldCache = new ConcurrentHashMap<Class, Field[]>();
    static ConcurrentMap<Class, Map<String, Field>> fieldMapCache = new ConcurrentHashMap<Class, Map<String, Field>>();
    static ConcurrentMap<Class, Field[]> declaredFieldCache = new ConcurrentHashMap<Class, Field[]>();
    static ConcurrentMap<Class, Method[]> methodCache = new ConcurrentHashMap<Class, Method[]>();
    static ConcurrentMap<Class, Constructor[]> constructorCache = new ConcurrentHashMap<Class, Constructor[]>();

    public static void fields(Class objectClass, Consumer<Field> fieldReaders) {
        Field[] fields = (Field[])fieldCache.get(objectClass);
        if (fields == null) {
            fields = objectClass.getFields();
            fieldCache.putIfAbsent(objectClass, fields);
        }
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            fieldReaders.accept(field);
        }
    }

    public static Field getDeclaredField(Class objectClass, String fieldName) {
        Map fieldMap = (Map)fieldMapCache.get(objectClass);
        if (fieldMap == null) {
            HashMap map = new HashMap();
            BeanUtils.declaredFields(objectClass, field -> map.put(field.getName(), field));
            fieldMapCache.putIfAbsent(objectClass, map);
            fieldMap = (Map)fieldMapCache.get(objectClass);
        }
        return (Field)fieldMap.get(fieldName);
    }

    public static void declaredFields(Class objectClass, Consumer<Field> fieldConsumer) {
        int modifiers;
        Field[] fields;
        Class superclass = objectClass.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            BeanUtils.declaredFields(superclass, fieldConsumer);
        }
        if ((fields = (Field[])declaredFieldCache.get(objectClass)) == null) {
            Field[] declaredFields = objectClass.getDeclaredFields();
            boolean allMatch = false;
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers)) continue;
                allMatch = false;
                break;
            }
            if (allMatch) {
                fields = declaredFields;
            } else {
                ArrayList<Field> list = new ArrayList<Field>(declaredFields.length);
                for (int i = 0; i < declaredFields.length; ++i) {
                    Field field = declaredFields[i];
                    int modifiers2 = field.getModifiers();
                    if (Modifier.isStatic(modifiers2)) continue;
                    list.add(field);
                }
                fields = list.toArray(new Field[list.size()]);
            }
            fieldCache.putIfAbsent(objectClass, fields);
        }
        for (Field field : fields) {
            modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            fieldConsumer.accept(field);
        }
    }

    public static void staticMethod(Class objectClass, Consumer<Method> methodConsumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            methodConsumer.accept(method);
        }
    }

    public static Method buildMethod(Class objectClass, String methodName) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || method.getParameterCount() != 0 || !method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static void constructor(Class objectClass, Consumer<Constructor> constructorConsumer) {
        Constructor[] constructors = (Constructor[])constructorCache.get(objectClass);
        if (constructors == null) {
            constructors = objectClass.getDeclaredConstructors();
            constructorCache.putIfAbsent(objectClass, constructors);
        }
        for (Constructor constructor : constructors) {
            constructorConsumer.accept(constructor);
        }
    }

    public static Constructor getDefaultConstructor(Class objectClass) {
        if (objectClass == StackTraceElement.class && JDKUtils.JVM_VERSION >= 9) {
            return null;
        }
        Constructor[] constructors = (Constructor[])constructorCache.get(objectClass);
        if (constructors == null) {
            constructors = objectClass.getDeclaredConstructors();
            constructorCache.putIfAbsent(objectClass, constructors);
        }
        for (Constructor constructor : constructors) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    public static void setters(Class objectClass, Consumer<Method> methodConsumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            String methodName;
            int methodNameLength;
            int mods;
            int paramType = method.getParameterCount();
            if (paramType == 0) {
                String methodName2 = method.getName();
                if (methodName2.length() <= 3 || !methodName2.startsWith("get")) continue;
                Class<?> returnType = method.getReturnType();
                if (returnType == AtomicInteger.class || returnType == AtomicLong.class || returnType == AtomicBoolean.class || returnType == AtomicIntegerArray.class || returnType == AtomicLongArray.class || Collection.class.isAssignableFrom(returnType)) {
                    methodConsumer.accept(method);
                    continue;
                }
            }
            if (paramType != 1 || Modifier.isStatic(mods = method.getModifiers()) || (methodNameLength = (methodName = method.getName()).length()) <= 3 || !methodName.startsWith("set")) continue;
            methodConsumer.accept(method);
        }
    }

    public static void setters(Class objectClass, boolean checkPrefix, Consumer<Method> methodConsumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            String methodName;
            int methodNameLength;
            int mods;
            int paramType = method.getParameterCount();
            if (paramType == 0) {
                String methodName2 = method.getName();
                if (methodName2.length() <= 3 || checkPrefix && !methodName2.startsWith("get")) continue;
                Class<?> returnType = method.getReturnType();
                if (returnType == AtomicInteger.class || returnType == AtomicLong.class || returnType == AtomicBoolean.class || returnType == AtomicIntegerArray.class || returnType == AtomicLongArray.class || Collection.class.isAssignableFrom(returnType)) {
                    methodConsumer.accept(method);
                    continue;
                }
            }
            if (paramType != 1 || Modifier.isStatic(mods = method.getModifiers()) || (methodNameLength = (methodName = method.getName()).length()) <= 3 || checkPrefix && !methodName.startsWith("set")) continue;
            methodConsumer.accept(method);
        }
    }

    public static void getters(Method[] methods, Consumer<Method> methodConsumer) {
        for (Method method : methods) {
            char firstChar;
            boolean nameMatch;
            Class<?> declaringClass;
            Class<?> returnClass;
            int mods;
            int paramType = method.getParameterCount();
            if (paramType != 0 || Modifier.isStatic(mods = method.getModifiers()) || (returnClass = method.getReturnType()) == Void.class || (declaringClass = method.getDeclaringClass()) == Enum.class) continue;
            String methodName = method.getName();
            int methodNameLength = methodName.length();
            if (returnClass == Boolean.TYPE) {
                boolean bl = nameMatch = methodName.startsWith("is") && methodNameLength > 2;
                if (nameMatch) {
                    firstChar = methodName.charAt(2);
                    if (nameMatch && firstChar >= 'a' && firstChar <= 'z' && methodNameLength == 3) {
                        nameMatch = false;
                    }
                }
            } else {
                boolean bl = nameMatch = methodName.startsWith("get") && methodNameLength > 3;
                if (nameMatch) {
                    firstChar = methodName.charAt(3);
                    if (nameMatch && firstChar >= 'a' && firstChar <= 'z' && methodNameLength == 4) {
                        nameMatch = false;
                    }
                }
            }
            if (!nameMatch || returnClass == Class.class && methodName.equals("getClass")) continue;
            methodConsumer.accept(method);
        }
    }

    public static String setterName(String methodName) {
        return BeanUtils.setterName(methodName, null);
    }

    public static String setterName(String methodName, String namingStrategy) {
        int methodNameLength;
        if (namingStrategy == null) {
            namingStrategy = "CamelCase";
        }
        if ((methodNameLength = methodName.length()) <= 3) {
            return methodName;
        }
        switch (namingStrategy) {
            case "CamelCase": {
                char[] chars = new char[methodNameLength - 3];
                methodName.getChars(3, methodNameLength, chars, 0);
                char c0 = chars[0];
                if (c0 >= 'A' && c0 <= 'Z') {
                    chars[0] = (char)(c0 + 32);
                }
                return new String(chars);
            }
            case "SnakeCase": {
                return BeanUtils.snakeCase(methodName, 3);
            }
        }
        throw new JSONException("TODO : " + namingStrategy);
    }

    public static String setterName(String methodName, int prefixLength) {
        boolean c1UCase;
        int methodNameLength = methodName.length();
        char[] chars = new char[methodNameLength - prefixLength];
        methodName.getChars(prefixLength, methodNameLength, chars, 0);
        char c0 = chars[0];
        boolean bl = c1UCase = chars.length > 1 && chars[1] >= 'A' && chars[1] <= 'Z';
        if (c0 >= 'A' && c0 <= 'Z' && !c1UCase) {
            chars[0] = (char)(c0 + 32);
        }
        return new String(chars);
    }

    public static String getterName(String methodName) {
        return BeanUtils.getterName(methodName, null);
    }

    public static String getterName(String methodName, String namingStrategy) {
        if (namingStrategy == null) {
            namingStrategy = "CamelCase";
        }
        int methodNameLength = methodName.length();
        boolean is = methodName.startsWith("is");
        int prefixLength = is ? 2 : 3;
        switch (namingStrategy) {
            case "CamelCase": {
                boolean c1UCase;
                char[] chars = new char[methodNameLength - prefixLength];
                methodName.getChars(is ? 2 : 3, methodNameLength, chars, 0);
                char c0 = chars[0];
                boolean bl = c1UCase = chars.length > 1 && chars[1] >= 'A' && chars[1] <= 'Z';
                if (c0 >= 'A' && c0 <= 'Z' && !c1UCase) {
                    chars[0] = (char)(c0 + 32);
                }
                return new String(chars);
            }
            case "SnakeCase": {
                return BeanUtils.snakeCase(methodName, prefixLength);
            }
        }
        throw new JSONException("TODO : " + namingStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String snakeCase(String methodName, int prefixLength) {
        int methodNameLength = methodName.length();
        char[] buf = TypeUtils.CHARS_UPDATER.getAndSet(TypeUtils.CACHE, null);
        if (buf == null) {
            buf = new char[128];
        }
        try {
            int off = 0;
            for (int i = prefixLength; i < methodNameLength; ++i) {
                char ch = methodName.charAt(i);
                if (ch >= 'A' && ch <= 'Z') {
                    char ch_ucase = (char)(ch + 32);
                    if (i > prefixLength) {
                        buf[off++] = 95;
                    }
                    buf[off++] = ch_ucase;
                    continue;
                }
                buf[off++] = ch;
            }
            String string = new String(buf, 0, off);
            return string;
        }
        finally {
            TypeUtils.CHARS_UPDATER.set(TypeUtils.CACHE, buf);
        }
    }

    public static Type getFieldType(TypeReference type, Class<?> raw, Member field, Type fieldType) {
        Class<?> declaringClass = field.getDeclaringClass();
        while (raw != Object.class) {
            if (declaringClass == raw) {
                return BeanUtils.resolve(type.getType(), declaringClass, fieldType);
            }
            type = TypeReference.get(BeanUtils.resolve(type.getType(), raw, raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return null;
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type ownerType, Type rawType, Type ... typeArguments) {
        return new ParameterizedTypeImpl(ownerType, rawType, typeArguments);
    }

    public static GenericArrayType arrayOf(Type componentType) {
        return new GenericArrayTypeImpl(componentType);
    }

    public static WildcardType subtypeOf(Type bound) {
        Type[] upperBounds = bound instanceof WildcardType ? ((WildcardType)bound).getUpperBounds() : new Type[]{bound};
        return new WildcardTypeImpl(upperBounds, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type bound) {
        Type[] lowerBounds = bound instanceof WildcardType ? ((WildcardType)bound).getLowerBounds() : new Type[]{bound};
        return new WildcardTypeImpl(new Type[]{Object.class}, lowerBounds);
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c.isArray() ? new GenericArrayTypeImpl(BeanUtils.canonicalize(c.getComponentType())) : c;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return new ParameterizedTypeImpl(p.getOwnerType(), p.getRawType(), p.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)type;
            return new GenericArrayTypeImpl(g.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType w = (WildcardType)type;
            return new WildcardTypeImpl(w.getUpperBounds(), w.getLowerBounds());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            BeanUtils.checkArgument(rawType instanceof Class);
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(BeanUtils.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return BeanUtils.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean equals(Type a, Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            return BeanUtils.equal(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
        }
        if (a instanceof GenericArrayType) {
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)a;
            GenericArrayType gb = (GenericArrayType)b;
            return BeanUtils.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (a instanceof WildcardType) {
            if (!(b instanceof WildcardType)) {
                return false;
            }
            WildcardType wa = (WildcardType)a;
            WildcardType wb = (WildcardType)b;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (a instanceof TypeVariable) {
            if (!(b instanceof TypeVariable)) {
                return false;
            }
            TypeVariable va = (TypeVariable)a;
            TypeVariable vb = (TypeVariable)b;
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && va.getName().equals(vb.getName());
        }
        return false;
    }

    static int hashCodeOrZero(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static String typeToString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    static Type getGenericSupertype(Type context, Class<?> rawType, Class<?> toResolve) {
        if (toResolve == rawType) {
            return context;
        }
        if (toResolve.isInterface()) {
            Class<?>[] interfaces = rawType.getInterfaces();
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                if (interfaces[i] == toResolve) {
                    return rawType.getGenericInterfaces()[i];
                }
                if (!toResolve.isAssignableFrom(interfaces[i])) continue;
                return BeanUtils.getGenericSupertype(rawType.getGenericInterfaces()[i], interfaces[i], toResolve);
            }
        }
        if (!rawType.isInterface()) {
            while (rawType != Object.class) {
                Class<?> rawSupertype = rawType.getSuperclass();
                if (rawSupertype == toResolve) {
                    return rawType.getGenericSuperclass();
                }
                if (toResolve.isAssignableFrom(rawSupertype)) {
                    return BeanUtils.getGenericSupertype(rawType.getGenericSuperclass(), rawSupertype, toResolve);
                }
                rawType = rawSupertype;
            }
        }
        return toResolve;
    }

    public static Type resolve(Type context, Class<?> contextRawType, Type toResolve) {
        return BeanUtils.resolve(context, contextRawType, toResolve, new HashMap());
    }

    /*
     * Unable to fully structure code
     */
    private static Type resolve(Type context, Class<?> contextRawType, Type toResolve, Map<TypeVariable<?>, Type> visitedTypeVariables) {
        block8: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            resolving = null;
                            while (toResolve instanceof TypeVariable) {
                                typeVariable = (TypeVariable)toResolve;
                                previouslyResolved = visitedTypeVariables.get(typeVariable);
                                if (previouslyResolved != null) {
                                    return previouslyResolved == Void.TYPE ? toResolve : previouslyResolved;
                                }
                                visitedTypeVariables.put(typeVariable, Void.TYPE);
                                if (resolving == null) {
                                    resolving = typeVariable;
                                }
                                if ((toResolve = BeanUtils.resolveTypeVariable(context, contextRawType, typeVariable)) != typeVariable) continue;
                                break block8;
                            }
                            if (!(toResolve instanceof Class) || !((Class)toResolve).isArray()) break block9;
                            original = (Class)toResolve;
                            componentType = original.getComponentType();
                            toResolve = BeanUtils.equal(componentType, newComponentType = BeanUtils.resolve(context, contextRawType, componentType, visitedTypeVariables)) != false ? original : BeanUtils.arrayOf(newComponentType);
                            break block8;
                        }
                        if (!(toResolve instanceof GenericArrayType)) break block10;
                        original = (GenericArrayType)toResolve;
                        componentType = original.getGenericComponentType();
                        toResolve = BeanUtils.equal(componentType, newComponentType = BeanUtils.resolve(context, contextRawType, componentType, visitedTypeVariables)) != false ? original : BeanUtils.arrayOf(newComponentType);
                        break block8;
                    }
                    if (!(toResolve instanceof ParameterizedType)) break block11;
                    original = (ParameterizedType)toResolve;
                    ownerType = original.getOwnerType();
                    newOwnerType = BeanUtils.resolve(context, contextRawType, ownerType, visitedTypeVariables);
                    changed = BeanUtils.equal(newOwnerType, ownerType) == false;
                    args = original.getActualTypeArguments();
                    length = args.length;
                    for (t = 0; t < length; ++t) {
                        resolvedTypeArgument = BeanUtils.resolve(context, contextRawType, args[t], visitedTypeVariables);
                        if (BeanUtils.equal(resolvedTypeArgument, args[t])) continue;
                        if (!changed) {
                            args = (Type[])args.clone();
                            changed = true;
                        }
                        args[t] = resolvedTypeArgument;
                    }
                    toResolve = changed != false ? BeanUtils.newParameterizedTypeWithOwner(newOwnerType, original.getRawType(), args) : original;
                    break block8;
                }
                if (!(toResolve instanceof WildcardType)) break block8;
                original = (WildcardType)toResolve;
                originalLowerBound = original.getLowerBounds();
                originalUpperBound = original.getUpperBounds();
                if (originalLowerBound.length != 1) break block12;
                lowerBound = BeanUtils.resolve(context, contextRawType, originalLowerBound[0], visitedTypeVariables);
                if (lowerBound == originalLowerBound[0]) ** GOTO lbl-1000
                toResolve = BeanUtils.supertypeOf(lowerBound);
                break block8;
            }
            if (originalUpperBound.length == 1 && (upperBound = BeanUtils.resolve(context, contextRawType, originalUpperBound[0], visitedTypeVariables)) != originalUpperBound[0]) {
                toResolve = BeanUtils.subtypeOf(upperBound);
            } else lbl-1000:
            // 2 sources

            {
                toResolve = original;
            }
        }
        if (resolving != null) {
            visitedTypeVariables.put(resolving, toResolve);
        }
        return toResolve;
    }

    static Type resolveTypeVariable(Type context, Class<?> contextRawType, TypeVariable<?> unknown) {
        Class<?> declaredByRaw = BeanUtils.declaringClassOf(unknown);
        if (declaredByRaw == null) {
            return unknown;
        }
        Type declaredBy = BeanUtils.getGenericSupertype(context, contextRawType, declaredByRaw);
        if (declaredBy instanceof ParameterizedType) {
            int index = BeanUtils.indexOf(declaredByRaw.getTypeParameters(), unknown);
            return ((ParameterizedType)declaredBy).getActualTypeArguments()[index];
        }
        return unknown;
    }

    private static int indexOf(Object[] array, Object toFind) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!toFind.equals(array[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        return genericDeclaration instanceof Class ? (Class)genericDeclaration : null;
    }

    static void checkNotPrimitive(Type type) {
        BeanUtils.checkArgument(!(type instanceof Class) || !((Class)type).isPrimitive());
    }

    static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> T checkNotNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    private static final class WildcardTypeImpl
    implements WildcardType,
    Serializable {
        private final Type upperBound;
        private final Type lowerBound;
        private static final long serialVersionUID = 0L;

        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            BeanUtils.checkArgument(lowerBounds.length <= 1);
            BeanUtils.checkArgument(upperBounds.length == 1);
            if (lowerBounds.length == 1) {
                BeanUtils.checkNotNull(lowerBounds[0]);
                BeanUtils.checkNotPrimitive(lowerBounds[0]);
                BeanUtils.checkArgument(upperBounds[0] == Object.class);
                this.lowerBound = BeanUtils.canonicalize(lowerBounds[0]);
                this.upperBound = Object.class;
            } else {
                BeanUtils.checkNotNull(upperBounds[0]);
                BeanUtils.checkNotPrimitive(upperBounds[0]);
                this.lowerBound = null;
                this.upperBound = BeanUtils.canonicalize(upperBounds[0]);
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public Type[] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = EMPTY_TYPE_ARRAY;
            }
            return typeArray;
        }

        public boolean equals(Object other) {
            return other instanceof WildcardType && BeanUtils.equals(this, (WildcardType)other);
        }

        public int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + BeanUtils.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + BeanUtils.typeToString(this.upperBound);
        }
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType,
    Serializable {
        private final Type componentType;
        private static final long serialVersionUID = 0L;

        public GenericArrayTypeImpl(Type componentType) {
            this.componentType = BeanUtils.canonicalize(componentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object o) {
            return o instanceof GenericArrayType && BeanUtils.equals(this, (GenericArrayType)o);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return BeanUtils.typeToString(this.componentType) + "[]";
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;
        private static final long serialVersionUID = 0L;

        public ParameterizedTypeImpl(Type ownerType, Type rawType, Type ... typeArguments) {
            if (rawType instanceof Class) {
                Class rawTypeAsClass = (Class)rawType;
                boolean isStaticOrTopLevelClass = Modifier.isStatic(rawTypeAsClass.getModifiers()) || rawTypeAsClass.getEnclosingClass() == null;
                BeanUtils.checkArgument(ownerType != null || isStaticOrTopLevelClass);
            }
            this.ownerType = ownerType == null ? null : BeanUtils.canonicalize(ownerType);
            this.rawType = BeanUtils.canonicalize(rawType);
            this.typeArguments = (Type[])typeArguments.clone();
            int length = this.typeArguments.length;
            for (int t = 0; t < length; ++t) {
                BeanUtils.checkNotNull(this.typeArguments[t]);
                BeanUtils.checkNotPrimitive(this.typeArguments[t]);
                this.typeArguments[t] = BeanUtils.canonicalize(this.typeArguments[t]);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object other) {
            return other instanceof ParameterizedType && BeanUtils.equals(this, (ParameterizedType)other);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ BeanUtils.hashCodeOrZero(this.ownerType);
        }

        public String toString() {
            int length = this.typeArguments.length;
            if (length == 0) {
                return BeanUtils.typeToString(this.rawType);
            }
            StringBuilder stringBuilder = new StringBuilder(30 * (length + 1));
            stringBuilder.append(BeanUtils.typeToString(this.rawType)).append("<").append(BeanUtils.typeToString(this.typeArguments[0]));
            for (int i = 1; i < length; ++i) {
                stringBuilder.append(", ").append(BeanUtils.typeToString(this.typeArguments[i]));
            }
            return stringBuilder.append(">").toString();
        }
    }
}

