/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.RyuDouble;
import com.alibaba.fastjson2.util.RyuFloat;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class JSONWriterUTF8
extends JSONWriter {
    static final byte[] REF_PREF = "{\"$ref\":".getBytes(StandardCharsets.US_ASCII);
    private final int cachedIndex = System.identityHashCode(Thread.currentThread()) & 3;
    protected byte[] bytes = JSONFactory.allocateByteArray(this.cachedIndex);

    JSONWriterUTF8(JSONWriter.Context ctx) {
        super(ctx, null, false, StandardCharsets.UTF_8);
    }

    @Override
    public void writeReference(String path) {
        this.lastReference = path;
        this.writeRaw(REF_PREF);
        this.writeString(path);
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 125;
    }

    @Override
    public void writeBase64(byte[] bytes) {
        int i;
        int charsLen = (bytes.length - 1) / 3 + 1 << 2;
        this.ensureCapacity(this.off + charsLen + 2);
        this.bytes[this.off++] = (byte)this.quote;
        int eLen = bytes.length / 3 * 3;
        int s = 0;
        while (s < eLen) {
            i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 18 & 0x3F];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 12 & 0x3F];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 6 & 0x3F];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i & 0x3F];
        }
        int left = bytes.length - eLen;
        if (left > 0) {
            i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytes.length - 1] & 0xFF) << 2 : 0);
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >> 12];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 6 & 0x3F];
            this.bytes[this.off++] = left == 2 ? (int)JSONFactory.CA[i & 0x3F] : 61;
            this.bytes[this.off++] = 61;
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public void writeHex(byte[] bytes) {
        if (bytes == null) {
            this.writeNull();
            return;
        }
        int charsLen = bytes.length * 2 + 3;
        this.ensureCapacity(this.off + charsLen + 2);
        bytes[this.off++] = 120;
        bytes[this.off++] = 39;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int a = b & 0xFF;
            int b0 = a >> 4;
            int b1 = a & 0xF;
            bytes[this.off++] = (byte)(b0 + (b0 < 10 ? 48 : 55));
            bytes[this.off++] = (byte)(b1 + (b1 < 10 ? 48 : 55));
        }
        bytes[this.off++] = 39;
    }

    @Override
    public void close() {
        JSONFactory.releaseByteArray(this.cachedIndex, this.bytes);
    }

    @Override
    public int size() {
        return this.off;
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.off);
    }

    @Override
    public byte[] getBytes(Charset charset) {
        if (charset == StandardCharsets.UTF_8) {
            return Arrays.copyOf(this.bytes, this.off);
        }
        String str = this.toString();
        return str.getBytes(charset);
    }

    @Override
    public int flushTo(OutputStream to) throws IOException {
        int len = this.off;
        to.write(this.bytes, 0, this.off);
        this.off = 0;
        return len;
    }

    @Override
    protected void write0(char c) {
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = (byte)c;
    }

    @Override
    public void writeColon() {
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 58;
    }

    @Override
    public void startObject() {
        ++this.level;
        this.startObject = true;
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 123;
    }

    @Override
    public void endObject() {
        --this.level;
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 125;
        this.startObject = false;
    }

    @Override
    public void writeComma() {
        this.startObject = false;
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 44;
    }

    @Override
    public void startArray() {
        ++this.level;
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 91;
    }

    @Override
    public void endArray() {
        --this.level;
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 93;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void writeString(String str) {
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        chars = JDKUtils.getCharArray(str);
        browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        minCapacity = this.off + chars.length * 3 + 2;
        if (escapeNoneAscii || browserSecure) {
            minCapacity += chars.length * 3;
        }
        if (minCapacity - this.bytes.length > 0) {
            oldCapacity = this.bytes.length;
            newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        i = 0;
        while (i + 8 <= chars.length) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            c4 = chars[i + 4];
            c5 = chars[i + 5];
            c6 = chars[i + 6];
            c7 = chars[i + 7];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c4 == this.quote || c5 == this.quote || c6 == this.quote || c7 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c4 == '\\' || c5 == '\\' || c6 == '\\' || c7 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c4 < ' ' || c5 < ' ' || c6 < ' ' || c7 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f' || c4 > '\u007f' || c5 > '\u007f' || c6 > '\u007f' || c7 > '\u007f' || browserSecure && (c0 == '<' || c0 == '>' || c0 == '(' || c0 == ')' || c1 == '<' || c1 == '>' || c1 == '(' || c1 == ')' || c2 == '<' || c2 == '>' || c2 == '(' || c2 == ')' || c3 == '<' || c3 == '>' || c3 == '(' || c3 == ')' || c4 == '<' || c4 == '>' || c4 == '(' || c4 == ')' || c5 == '<' || c5 == '>' || c5 == '(' || c5 == ')' || c6 == '<' || c6 == '>' || c6 == '(' || c6 == ')' || c7 == '<' || c7 == '>' || c7 == '(' || c7 == ')')) break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.bytes[this.off + 4] = (byte)c4;
            this.bytes[this.off + 5] = (byte)c5;
            this.bytes[this.off + 6] = (byte)c6;
            this.bytes[this.off + 7] = (byte)c7;
            this.off += 8;
            i += 8;
        }
        while (i + 4 <= chars.length) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f' || browserSecure && (c0 == '<' || c0 == '>' || c0 == '(' || c0 == ')' || c1 == '<' || c1 == '>' || c1 == '(' || c1 == ')' || c2 == '<' || c2 == '>' || c2 == '(' || c2 == ')' || c3 == '<' || c3 == '>' || c3 == '(' || c3 == ')')) break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.off += 4;
            i += 4;
        }
        if (i + 2 <= chars.length) {
            c0 = chars[i];
            c1 = chars[i + 1];
            if (c0 != this.quote && c1 != this.quote && c0 != '\\' && c1 != '\\' && c0 >= ' ' && c1 >= ' ' && c0 <= '\u007f' && c1 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')' && c1 != '<' && c1 != '>' && c1 != '(' && c1 != ')')) {
                this.bytes[this.off] = (byte)c0;
                this.bytes[this.off + 1] = (byte)c1;
                this.off += 2;
                i += 2;
            }
        }
        if (i + 1 == chars.length && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')')) {
            this.bytes[this.off++] = (byte)c0;
            this.bytes[this.off++] = (byte)this.quote;
            return;
        }
        while (i < chars.length) {
            block34: {
                block36: {
                    block37: {
                        block39: {
                            block38: {
                                block35: {
                                    block33: {
                                        ch = chars[i];
                                        if (ch < '\u0000' || ch > '\u007f') break block33;
                                        switch (ch) {
                                            case 92: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 92;
                                                break;
                                            }
                                            case 10: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 110;
                                                break;
                                            }
                                            case 13: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 114;
                                                break;
                                            }
                                            case 12: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 102;
                                                break;
                                            }
                                            case 8: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 98;
                                                break;
                                            }
                                            case 9: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 116;
                                                break;
                                            }
                                            case 0: 
                                            case 1: 
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 6: 
                                            case 7: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = (byte)(48 + ch);
                                                break;
                                            }
                                            case 11: 
                                            case 14: 
                                            case 15: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = (byte)(97 + (ch - 10));
                                                break;
                                            }
                                            case 16: 
                                            case 17: 
                                            case 18: 
                                            case 19: 
                                            case 20: 
                                            case 21: 
                                            case 22: 
                                            case 23: 
                                            case 24: 
                                            case 25: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 49;
                                                this.bytes[this.off++] = (byte)(48 + (ch - 16));
                                                break;
                                            }
                                            case 26: 
                                            case 27: 
                                            case 28: 
                                            case 29: 
                                            case 30: 
                                            case 31: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 49;
                                                this.bytes[this.off++] = (byte)(97 + (ch - 26));
                                                break;
                                            }
                                            case 40: 
                                            case 41: 
                                            case 60: 
                                            case 62: {
                                                if (browserSecure) {
                                                    this.bytes[this.off++] = 92;
                                                    this.bytes[this.off++] = 117;
                                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 12 & 15];
                                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 8 & 15];
                                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 4 & 15];
                                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch & 15];
                                                    break;
                                                }
                                                this.bytes[this.off++] = (byte)ch;
                                                break;
                                            }
                                            default: {
                                                if (ch == this.quote) {
                                                    this.bytes[this.off++] = 92;
                                                    this.bytes[this.off++] = (byte)this.quote;
                                                    break;
                                                }
                                                this.bytes[this.off++] = (byte)ch;
                                                break;
                                            }
                                        }
                                        break block34;
                                    }
                                    if (!escapeNoneAscii) break block35;
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 12 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 8 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 4 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch & 15];
                                    break block34;
                                }
                                if (ch < '\ud800' || ch >= '\ue000') break block36;
                                if (ch < '\ud800' || ch >= '\udc00') break block37;
                                if (chars.length - i >= 2) break block38;
                                uc = '\uffffffff';
                                ** GOTO lbl176
                            }
                            d = chars[i + 1];
                            if (d < '\udc00' || d >= '\ue000') break block39;
                            uc = (ch << 10) + d + -56613888;
                            ** GOTO lbl176
                        }
                        this.bytes[this.off++] = 63;
                        break block34;
                    }
                    if (ch >= '\udc00' && ch < '\ue000') {
                        this.bytes[this.off++] = 63;
                    } else {
                        uc = ch;
lbl176:
                        // 3 sources

                        if (uc < '\u0000') {
                            this.bytes[this.off++] = 63;
                        } else {
                            this.bytes[this.off++] = (byte)(240 | uc >> 18);
                            this.bytes[this.off++] = (byte)(128 | uc >> 12 & 63);
                            this.bytes[this.off++] = (byte)(128 | uc >> 6 & 63);
                            this.bytes[this.off++] = (byte)(128 | uc & 63);
                            ++i;
                        }
                    }
                    break block34;
                }
                if (ch > '\u07ff') {
                    this.bytes[this.off++] = (byte)(224 | ch >> 12 & 15);
                    this.bytes[this.off++] = (byte)(128 | ch >> 6 & 63);
                    this.bytes[this.off++] = (byte)(128 | ch >> 0 & 63);
                } else {
                    this.bytes[this.off++] = (byte)(192 | ch >> 6 & 31);
                    this.bytes[this.off++] = (byte)(128 | ch >> 0 & 63);
                }
            }
            ++i;
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void writeString(char[] chars, int offset, int len, boolean quoted) {
        escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        minCapacity = this.off + chars.length * 3 + 2;
        if (escapeNoneAscii) {
            minCapacity += len * 3;
        }
        if (minCapacity - this.bytes.length > 0) {
            oldCapacity = this.bytes.length;
            newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        if (quoted) {
            this.bytes[this.off++] = (byte)this.quote;
        }
        i = 0;
        while (i + 8 <= len) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            c4 = chars[i + 4];
            c5 = chars[i + 5];
            c6 = chars[i + 6];
            c7 = chars[i + 7];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c4 == this.quote || c5 == this.quote || c6 == this.quote || c7 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c4 == '\\' || c5 == '\\' || c6 == '\\' || c7 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c4 < ' ' || c5 < ' ' || c6 < ' ' || c7 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f' || c4 > '\u007f' || c5 > '\u007f' || c6 > '\u007f' || c7 > '\u007f') break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.bytes[this.off + 4] = (byte)c4;
            this.bytes[this.off + 5] = (byte)c5;
            this.bytes[this.off + 6] = (byte)c6;
            this.bytes[this.off + 7] = (byte)c7;
            this.off += 8;
            i += 8;
        }
        while (i + 4 <= len) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f') break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.off += 4;
            i += 4;
        }
        if (i + 2 <= len) {
            c0 = chars[i];
            c1 = chars[i + 1];
            if (c0 != this.quote && c1 != this.quote && c0 != '\\' && c1 != '\\' && c0 >= ' ' && c1 >= ' ' && c0 <= '\u007f' && c1 <= '\u007f') {
                this.bytes[this.off] = (byte)c0;
                this.bytes[this.off + 1] = (byte)c1;
                this.off += 2;
                i += 2;
            }
        }
        if (i + 1 == len && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f') {
            this.bytes[this.off++] = (byte)c0;
            if (quoted) {
                this.bytes[this.off++] = (byte)this.quote;
            }
            return;
        }
        while (i < len) {
            block33: {
                block35: {
                    block36: {
                        block38: {
                            block37: {
                                block34: {
                                    block32: {
                                        ch = chars[i];
                                        if (ch < '\u0000' || ch > '\u007f') break block32;
                                        switch (ch) {
                                            case 92: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 92;
                                                break;
                                            }
                                            case 10: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 110;
                                                break;
                                            }
                                            case 13: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 114;
                                                break;
                                            }
                                            case 12: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 102;
                                                break;
                                            }
                                            case 8: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 98;
                                                break;
                                            }
                                            case 9: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 116;
                                                break;
                                            }
                                            case 0: 
                                            case 1: 
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 6: 
                                            case 7: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = (byte)(48 + ch);
                                                break;
                                            }
                                            case 11: 
                                            case 14: 
                                            case 15: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = (byte)(97 + (ch - 10));
                                                break;
                                            }
                                            case 16: 
                                            case 17: 
                                            case 18: 
                                            case 19: 
                                            case 20: 
                                            case 21: 
                                            case 22: 
                                            case 23: 
                                            case 24: 
                                            case 25: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 49;
                                                this.bytes[this.off++] = (byte)(48 + (ch - 16));
                                                break;
                                            }
                                            case 26: 
                                            case 27: 
                                            case 28: 
                                            case 29: 
                                            case 30: 
                                            case 31: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 49;
                                                this.bytes[this.off++] = (byte)(97 + (ch - 26));
                                                break;
                                            }
                                            default: {
                                                if (ch == this.quote) {
                                                    this.bytes[this.off++] = 92;
                                                    this.bytes[this.off++] = (byte)this.quote;
                                                    break;
                                                }
                                                this.bytes[this.off++] = (byte)ch;
                                                break;
                                            }
                                        }
                                        break block33;
                                    }
                                    if (!escapeNoneAscii) break block34;
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 12 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 8 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 4 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch & 15];
                                    break block33;
                                }
                                if (ch < '\ud800' || ch >= '\ue000') break block35;
                                if (ch < '\ud800' || ch >= '\udc00') break block36;
                                if (chars.length - i >= 2) break block37;
                                uc = '\uffffffff';
                                ** GOTO lbl159
                            }
                            d = chars[i + 1];
                            if (d < '\udc00' || d >= '\ue000') break block38;
                            uc = (ch << 10) + d + -56613888;
                            ** GOTO lbl159
                        }
                        this.bytes[this.off++] = 63;
                        break block33;
                    }
                    if (ch >= '\udc00' && ch < '\ue000') {
                        this.bytes[this.off++] = 63;
                    } else {
                        uc = ch;
lbl159:
                        // 3 sources

                        if (uc < '\u0000') {
                            this.bytes[this.off++] = 63;
                        } else {
                            this.bytes[this.off++] = (byte)(240 | uc >> 18);
                            this.bytes[this.off++] = (byte)(128 | uc >> 12 & 63);
                            this.bytes[this.off++] = (byte)(128 | uc >> 6 & 63);
                            this.bytes[this.off++] = (byte)(128 | uc & 63);
                            ++i;
                        }
                    }
                    break block33;
                }
                if (ch > '\u07ff') {
                    this.bytes[this.off++] = (byte)(224 | ch >> 12 & 15);
                    this.bytes[this.off++] = (byte)(128 | ch >> 6 & 63);
                    this.bytes[this.off++] = (byte)(128 | ch >> 0 & 63);
                } else {
                    this.bytes[this.off++] = (byte)(192 | ch >> 6 & 31);
                    this.bytes[this.off++] = (byte)(128 | ch >> 0 & 63);
                }
            }
            ++i;
        }
        if (quoted) {
            this.bytes[this.off++] = (byte)this.quote;
        }
    }

    @Override
    public void writeChar(char ch) {
        int minCapacity = this.bytes.length + 8;
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        if (ch >= '\u0000' && ch <= '\u007f') {
            switch (ch) {
                case '\\': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 92;
                    break;
                }
                case '\n': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 110;
                    break;
                }
                case '\r': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 114;
                    break;
                }
                case '\f': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 102;
                    break;
                }
                case '\b': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 98;
                    break;
                }
                case '\t': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 116;
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = (byte)(48 + ch);
                    break;
                }
                case '\u000b': 
                case '\u000e': 
                case '\u000f': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = (byte)(97 + (ch - 10));
                    break;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 49;
                    this.bytes[this.off++] = (byte)(48 + (ch - 16));
                    break;
                }
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 49;
                    this.bytes[this.off++] = (byte)(97 + (ch - 26));
                    break;
                }
                default: {
                    if (ch == this.quote) {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = (byte)this.quote;
                        break;
                    }
                    this.bytes[this.off++] = (byte)ch;
                    break;
                }
            }
        } else {
            if (ch >= '\ud800' && ch < '\ue000') {
                throw new JSONException("illegal char " + ch);
            }
            if (ch > '\u07ff') {
                this.bytes[this.off++] = (byte)(0xE0 | ch >> 12 & 0xF);
                this.bytes[this.off++] = (byte)(0x80 | ch >> 6 & 0x3F);
                this.bytes[this.off++] = (byte)(0x80 | ch >> 0 & 0x3F);
            } else {
                this.bytes[this.off++] = (byte)(0xC0 | ch >> 6 & 0x1F);
                this.bytes[this.off++] = (byte)(0x80 | ch >> 0 & 0x3F);
            }
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public void writeUUID(UUID value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        long msb = value.getMostSignificantBits();
        long lsb = value.getLeastSignificantBits();
        this.ensureCapacity(this.off + 38);
        this.bytes[this.off++] = 34;
        JSONWriterUTF8.formatUnsignedLong0(lsb, this.bytes, this.off + 24, 12);
        JSONWriterUTF8.formatUnsignedLong0(lsb >>> 48, this.bytes, this.off + 19, 4);
        JSONWriterUTF8.formatUnsignedLong0(msb, this.bytes, this.off + 14, 4);
        JSONWriterUTF8.formatUnsignedLong0(msb >>> 16, this.bytes, this.off + 9, 4);
        JSONWriterUTF8.formatUnsignedLong0(msb >>> 32, this.bytes, this.off + 0, 8);
        this.bytes[this.off + 23] = 45;
        this.bytes[this.off + 18] = 45;
        this.bytes[this.off + 13] = 45;
        this.bytes[this.off + 8] = 45;
        this.off += 36;
        this.bytes[this.off++] = 34;
    }

    @Override
    public void writeRaw(String str) {
        char[] chars = JDKUtils.getCharArray(str);
        int minCapacity = this.off + chars.length * 3;
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                this.bytes[this.off++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.bytes[this.off++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.bytes[this.off++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.bytes[this.off++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.bytes[this.off++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.bytes[this.off++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    @Override
    public void writeRaw(byte[] bytes) {
        int minCapacity = this.off + bytes.length;
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        System.arraycopy(bytes, 0, this.bytes, this.off, bytes.length);
        this.off += bytes.length;
    }

    @Override
    public void writeNameRaw(byte[] bytes) {
        int minCapacity = this.off + bytes.length + (this.startObject ? 0 : 1);
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.bytes[this.off++] = 44;
        }
        System.arraycopy(bytes, 0, this.bytes, this.off, bytes.length);
        this.off += bytes.length;
    }

    @Override
    public void writeRaw(char ch) {
        if (ch < '\u0000' || ch > '\u0080') {
            throw new JSONException("not support " + ch);
        }
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = (byte)ch;
    }

    @Override
    public void writeRaw(char c0, char c1) {
        if (c0 < '\u0000' || c0 > '\u0080') {
            throw new JSONException("not support " + c0);
        }
        if (c1 < '\u0000' || c1 > '\u0080') {
            throw new JSONException("not support " + c1);
        }
        if (this.off + 1 >= this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 2;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = (byte)c0;
        this.bytes[this.off++] = (byte)c1;
    }

    @Override
    public void writeNameRaw(byte[] bytes, int off, int len) {
        int minCapacity = this.off + len + (this.startObject ? 0 : 1);
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.bytes[this.off++] = 44;
        }
        System.arraycopy(bytes, off, this.bytes, this.off, len);
        this.off += len;
    }

    void ensureCapacity(int minCapacity) {
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
    }

    @Override
    public void writeInt32(int i) {
        int r;
        int q;
        int index;
        int minCapacity;
        int x;
        if ((this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            this.writeString(Integer.toString(i));
            return;
        }
        if (i == Integer.MIN_VALUE) {
            this.writeRaw("-2147483648");
            return;
        }
        int n = x = i < 0 ? -i : i;
        int size = x <= 9 ? 1 : (x <= 99 ? 2 : (x <= 999 ? 3 : (x <= 9999 ? 4 : (x <= 99999 ? 5 : (x <= 999999 ? 6 : (x <= 9999999 ? 7 : (x <= 99999999 ? 8 : (x <= 999999999 ? 9 : 10))))))));
        if (i < 0) {
            ++size;
        }
        if ((minCapacity = this.off + size) - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        int p = index = this.off + size;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            this.bytes[--p] = IOUtils.DigitOnes[r];
            this.bytes[--p] = IOUtils.DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            this.bytes[--p] = IOUtils.digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            this.bytes[--p] = sign;
        }
        this.off += size;
    }

    @Override
    public void writeInt64(long i) {
        int q2;
        int r;
        int index;
        long x;
        boolean writeAsString = false;
        if ((this.context.features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask)) != 0L) {
            writeAsString = true;
        } else if ((this.context.features & JSONWriter.Feature.BrowserCompatible.mask) != 0L && (i > 0x1FFFFFFFFFFFFFL || i < -9007199254740991L)) {
            writeAsString = true;
        }
        if (i == Long.MIN_VALUE) {
            this.writeRaw("-9223372036854775808");
            return;
        }
        long l = x = i < 0L ? -i : i;
        int size = x <= 9L ? 1 : (x <= 99L ? 2 : (x <= 999L ? 3 : (x <= 9999L ? 4 : (x <= 99999L ? 5 : (x <= 999999L ? 6 : (x <= 9999999L ? 7 : (x <= 99999999L ? 8 : (x <= 999999999L ? 9 : (x <= 9999999999L ? 10 : (x <= 99999999999L ? 11 : (x <= 999999999999L ? 12 : (x <= 9999999999999L ? 13 : (x <= 99999999999999L ? 14 : (x <= 999999999999999L ? 15 : (x <= 9999999999999999L ? 16 : (x <= 99999999999999999L ? 17 : (x <= 999999999999999999L ? 18 : 19)))))))))))))))));
        if (i < 0L) {
            ++size;
        }
        int minCapacity = this.off + size;
        if (writeAsString) {
            minCapacity += 2;
        }
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        if (writeAsString) {
            this.bytes[this.off++] = 34;
        }
        int charPos = index = this.off + size;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            this.bytes[--charPos] = IOUtils.DigitOnes[r];
            this.bytes[--charPos] = IOUtils.DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            this.bytes[--charPos] = IOUtils.DigitOnes[r];
            this.bytes[--charPos] = IOUtils.DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            this.bytes[--charPos] = IOUtils.digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            this.bytes[--charPos] = sign;
        }
        this.off += size;
        if (writeAsString) {
            this.bytes[this.off++] = 34;
        }
    }

    @Override
    public void writeFloat(float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            this.writeNull();
            return;
        }
        boolean writeNonStringValueAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 15;
        if (writeNonStringValueAsString) {
            minCapacity += 2;
        }
        this.ensureCapacity(minCapacity);
        if (writeNonStringValueAsString) {
            this.bytes[this.off++] = 34;
        }
        int len = RyuFloat.toString(value, this.bytes, this.off);
        this.off += len;
        if (writeNonStringValueAsString) {
            this.bytes[this.off++] = 34;
        }
    }

    @Override
    public void writeDouble(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            this.writeNull();
            return;
        }
        boolean writeNonStringValueAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 24;
        if (writeNonStringValueAsString) {
            minCapacity += 2;
        }
        this.ensureCapacity(minCapacity);
        if (writeNonStringValueAsString) {
            this.bytes[this.off++] = 34;
        }
        int len = RyuDouble.toString(value, this.bytes, this.off);
        this.off += len;
        if (writeNonStringValueAsString) {
            this.bytes[this.off++] = 34;
        }
    }

    @Override
    public void writeDateTime14(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.ensureCapacity(this.off + 16);
        this.bytes[this.off++] = (byte)this.quote;
        this.bytes[this.off++] = (byte)(year / 1000 + 48);
        this.bytes[this.off++] = (byte)(year / 100 % 10 + 48);
        this.bytes[this.off++] = (byte)(year / 10 % 10 + 48);
        this.bytes[this.off++] = (byte)(year % 10 + 48);
        this.bytes[this.off++] = (byte)(month / 10 + 48);
        this.bytes[this.off++] = (byte)(month % 10 + 48);
        this.bytes[this.off++] = (byte)(dayOfMonth / 10 + 48);
        this.bytes[this.off++] = (byte)(dayOfMonth % 10 + 48);
        this.bytes[this.off++] = (byte)(hour / 10 + 48);
        this.bytes[this.off++] = (byte)(hour % 10 + 48);
        this.bytes[this.off++] = (byte)(minute / 10 + 48);
        this.bytes[this.off++] = (byte)(minute % 10 + 48);
        this.bytes[this.off++] = (byte)(second / 10 + 48);
        this.bytes[this.off++] = (byte)(second % 10 + 48);
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.ensureCapacity(this.off + 21);
        this.bytes[this.off++] = (byte)this.quote;
        this.bytes[this.off++] = (byte)(year / 1000 + 48);
        this.bytes[this.off++] = (byte)(year / 100 % 10 + 48);
        this.bytes[this.off++] = (byte)(year / 10 % 10 + 48);
        this.bytes[this.off++] = (byte)(year % 10 + 48);
        this.bytes[this.off++] = 45;
        this.bytes[this.off++] = (byte)(month / 10 + 48);
        this.bytes[this.off++] = (byte)(month % 10 + 48);
        this.bytes[this.off++] = 45;
        this.bytes[this.off++] = (byte)(dayOfMonth / 10 + 48);
        this.bytes[this.off++] = (byte)(dayOfMonth % 10 + 48);
        this.bytes[this.off++] = 32;
        this.bytes[this.off++] = (byte)(hour / 10 + 48);
        this.bytes[this.off++] = (byte)(hour % 10 + 48);
        this.bytes[this.off++] = 58;
        this.bytes[this.off++] = (byte)(minute / 10 + 48);
        this.bytes[this.off++] = (byte)(minute % 10 + 48);
        this.bytes[this.off++] = 58;
        this.bytes[this.off++] = (byte)(second / 10 + 48);
        this.bytes[this.off++] = (byte)(second % 10 + 48);
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public void writeLocalDate(LocalDate date) {
        int year = date.getYear();
        int month = date.getMonthValue();
        int dayOfMonth = date.getDayOfMonth();
        int yearSize = IOUtils.stringSize(year);
        int len = 8 + yearSize;
        this.ensureCapacity(this.off + len);
        this.bytes[this.off] = (byte)this.quote;
        Arrays.fill(this.bytes, this.off + 1, this.off + len - 1, (byte)48);
        IOUtils.getChars(year, this.off + yearSize + 1, this.bytes);
        this.bytes[this.off + yearSize + 1] = 45;
        IOUtils.getChars(month, this.off + yearSize + 4, this.bytes);
        this.bytes[this.off + yearSize + 4] = 45;
        IOUtils.getChars(dayOfMonth, this.off + yearSize + 7, this.bytes);
        this.bytes[this.off + len - 1] = (byte)this.quote;
        this.off += len;
    }

    @Override
    public void writeLocalDateTime(LocalDateTime dateTime) {
        int small;
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        int dayOfMonth = dateTime.getDayOfMonth();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int second = dateTime.getSecond();
        int nano = dateTime.getNano();
        int yearSize = IOUtils.stringSize(year);
        int len = 17 + yearSize;
        if (nano % 1000000000 == 0) {
            small = 0;
        } else if (nano % 100000000 == 0) {
            len += 2;
            small = nano / 100000000;
        } else if (nano % 10000000 == 0) {
            len += 3;
            small = nano / 10000000;
        } else if (nano % 1000000 == 0) {
            len += 4;
            small = nano / 1000000;
        } else if (nano % 100000 == 0) {
            len += 5;
            small = nano / 100000;
        } else if (nano % 10000 == 0) {
            len += 6;
            small = nano / 10000;
        } else if (nano % 1000 == 0) {
            len += 7;
            small = nano / 1000;
        } else if (nano % 100 == 0) {
            len += 8;
            small = nano / 100;
        } else if (nano % 10 == 0) {
            len += 9;
            small = nano / 10;
        } else {
            len += 10;
            small = nano;
        }
        this.ensureCapacity(this.off + len);
        this.bytes[this.off] = (byte)this.quote;
        Arrays.fill(this.bytes, this.off + 1, this.off + len - 1, (byte)48);
        IOUtils.getChars(year, this.off + yearSize + 1, this.bytes);
        this.bytes[this.off + yearSize + 1] = 45;
        IOUtils.getChars(month, this.off + yearSize + 4, this.bytes);
        this.bytes[this.off + yearSize + 4] = 45;
        IOUtils.getChars(dayOfMonth, this.off + yearSize + 7, this.bytes);
        this.bytes[this.off + yearSize + 7] = 32;
        IOUtils.getChars(hour, this.off + yearSize + 10, this.bytes);
        this.bytes[this.off + yearSize + 10] = 58;
        IOUtils.getChars(minute, this.off + yearSize + 13, this.bytes);
        this.bytes[this.off + yearSize + 13] = 58;
        IOUtils.getChars(second, this.off + yearSize + 16, this.bytes);
        if (small != 0) {
            this.bytes[this.off + yearSize + 16] = 46;
            IOUtils.getChars(small, this.off + len - 1, this.bytes);
        }
        this.bytes[this.off + len - 1] = (byte)this.quote;
        this.off += len;
    }

    @Override
    public void writeDateYYYMMDD8(int year, int month, int dayOfMonth) {
        this.ensureCapacity(this.off + 10);
        this.bytes[this.off] = (byte)this.quote;
        this.bytes[this.off + 1] = (byte)(year / 1000 + 48);
        this.bytes[this.off + 2] = (byte)(year / 100 % 10 + 48);
        this.bytes[this.off + 3] = (byte)(year / 10 % 10 + 48);
        this.bytes[this.off + 4] = (byte)(year % 10 + 48);
        this.bytes[this.off + 5] = (byte)(month / 10 + 48);
        this.bytes[this.off + 6] = (byte)(month % 10 + 48);
        this.bytes[this.off + 7] = (byte)(dayOfMonth / 10 + 48);
        this.bytes[this.off + 8] = (byte)(dayOfMonth % 10 + 48);
        this.bytes[this.off + 9] = (byte)this.quote;
        this.off += 10;
    }

    @Override
    public void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        this.ensureCapacity(this.off + 12);
        this.bytes[this.off] = (byte)this.quote;
        this.bytes[this.off + 1] = (byte)(year / 1000 + 48);
        this.bytes[this.off + 2] = (byte)(year / 100 % 10 + 48);
        this.bytes[this.off + 3] = (byte)(year / 10 % 10 + 48);
        this.bytes[this.off + 4] = (byte)(year % 10 + 48);
        this.bytes[this.off + 5] = 45;
        this.bytes[this.off + 6] = (byte)(month / 10 + 48);
        this.bytes[this.off + 7] = (byte)(month % 10 + 48);
        this.bytes[this.off + 8] = 45;
        this.bytes[this.off + 9] = (byte)(dayOfMonth / 10 + 48);
        this.bytes[this.off + 10] = (byte)(dayOfMonth % 10 + 48);
        this.bytes[this.off + 11] = (byte)this.quote;
        this.off += 12;
    }

    @Override
    public void writeTimeHHMMSS8(int hour, int minute, int second) {
        this.ensureCapacity(this.off + 10);
        this.bytes[this.off] = (byte)this.quote;
        this.bytes[this.off + 1] = (byte)(hour / 10 + 48);
        this.bytes[this.off + 2] = (byte)(hour % 10 + 48);
        this.bytes[this.off + 3] = 58;
        this.bytes[this.off + 4] = (byte)(minute / 10 + 48);
        this.bytes[this.off + 5] = (byte)(minute % 10 + 48);
        this.bytes[this.off + 6] = 58;
        this.bytes[this.off + 7] = (byte)(second / 10 + 48);
        this.bytes[this.off + 8] = (byte)(second % 10 + 48);
        this.bytes[this.off + 9] = (byte)this.quote;
        this.off += 10;
    }

    @Override
    public void writeLocalTime(LocalTime time) {
        int small;
        int hour = time.getHour();
        int minute = time.getMinute();
        int second = time.getSecond();
        int nano = time.getNano();
        int len = 10;
        if (nano % 1000000000 == 0) {
            small = 0;
        } else if (nano % 100000000 == 0) {
            len += 2;
            small = nano / 100000000;
        } else if (nano % 10000000 == 0) {
            len += 3;
            small = nano / 10000000;
        } else if (nano % 1000000 == 0) {
            len += 4;
            small = nano / 1000000;
        } else if (nano % 100000 == 0) {
            len += 5;
            small = nano / 100000;
        } else if (nano % 10000 == 0) {
            len += 6;
            small = nano / 10000;
        } else if (nano % 1000 == 0) {
            len += 7;
            small = nano / 1000;
        } else if (nano % 100 == 0) {
            len += 8;
            small = nano / 100;
        } else if (nano % 10 == 0) {
            len += 9;
            small = nano / 10;
        } else {
            len += 10;
            small = nano;
        }
        this.ensureCapacity(this.off + len);
        this.bytes[this.off] = (byte)this.quote;
        Arrays.fill(this.bytes, this.off + 1, this.off + len - 1, (byte)48);
        IOUtils.getChars(hour, this.off + 3, this.bytes);
        this.bytes[this.off + 3] = 58;
        IOUtils.getChars(minute, this.off + 6, this.bytes);
        this.bytes[this.off + 6] = 58;
        IOUtils.getChars(second, this.off + 9, this.bytes);
        if (small != 0) {
            this.bytes[this.off + 9] = 46;
            IOUtils.getChars(small, this.off + len - 1, this.bytes);
        }
        this.bytes[this.off + len - 1] = (byte)this.quote;
        this.off += len;
    }

    @Override
    public void writeZonedDateTime(ZonedDateTime dateTime) {
        int small;
        int zoneSize;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        int dayOfMonth = dateTime.getDayOfMonth();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int second = dateTime.getSecond();
        int nano = dateTime.getNano();
        String zoneId = dateTime.getZone().getId();
        int len = 17;
        char firstZoneChar = '\u0000';
        if ("UTC".equals(zoneId)) {
            zoneId = "Z";
            zoneSize = 1;
        } else {
            zoneSize = zoneId.length() != 0 && ((firstZoneChar = zoneId.charAt(0)) == '+' || firstZoneChar == '-') ? zoneId.length() : 2 + zoneId.length();
        }
        len += zoneSize;
        int yearSize = IOUtils.stringSize(year);
        len += yearSize;
        if (nano % 1000000000 == 0) {
            small = 0;
        } else if (nano % 100000000 == 0) {
            len += 2;
            small = nano / 100000000;
        } else if (nano % 10000000 == 0) {
            len += 3;
            small = nano / 10000000;
        } else if (nano % 1000000 == 0) {
            len += 4;
            small = nano / 1000000;
        } else if (nano % 100000 == 0) {
            len += 5;
            small = nano / 100000;
        } else if (nano % 10000 == 0) {
            len += 6;
            small = nano / 10000;
        } else if (nano % 1000 == 0) {
            len += 7;
            small = nano / 1000;
        } else if (nano % 100 == 0) {
            len += 8;
            small = nano / 100;
        } else if (nano % 10 == 0) {
            len += 9;
            small = nano / 10;
        } else {
            len += 10;
            small = nano;
        }
        this.ensureCapacity(this.off + len);
        this.bytes[this.off] = (byte)this.quote;
        Arrays.fill(this.bytes, this.off + 1, this.off + len - 1, (byte)48);
        IOUtils.getChars(year, this.off + yearSize + 1, this.bytes);
        this.bytes[this.off + yearSize + 1] = 45;
        IOUtils.getChars(month, this.off + yearSize + 4, this.bytes);
        this.bytes[this.off + yearSize + 4] = 45;
        IOUtils.getChars(dayOfMonth, this.off + yearSize + 7, this.bytes);
        this.bytes[this.off + yearSize + 7] = 84;
        IOUtils.getChars(hour, this.off + yearSize + 10, this.bytes);
        this.bytes[this.off + yearSize + 10] = 58;
        IOUtils.getChars(minute, this.off + yearSize + 13, this.bytes);
        this.bytes[this.off + yearSize + 13] = 58;
        IOUtils.getChars(second, this.off + yearSize + 16, this.bytes);
        if (small != 0) {
            this.bytes[this.off + yearSize + 16] = 46;
            IOUtils.getChars(small, this.off + len - 1 - zoneSize, this.bytes);
        }
        if (zoneSize == 1) {
            this.bytes[this.off + len - 2] = 90;
        } else if (firstZoneChar == '+' || firstZoneChar == '-') {
            zoneId.getBytes(0, zoneId.length(), this.bytes, this.off + len - zoneSize - 1);
        } else {
            this.bytes[this.off + len - zoneSize - 1] = 91;
            zoneId.getBytes(0, zoneId.length(), this.bytes, this.off + len - zoneSize);
            this.bytes[this.off + len - 2] = 93;
        }
        this.bytes[this.off + len - 1] = (byte)this.quote;
        this.off += len;
    }

    @Override
    public void writeBigInt(BigInteger value, long features) {
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        String str = value.toString(10);
        if (((this.context.features | features) & JSONWriter.Feature.BrowserCompatible.mask) != 0L && (value.compareTo(JSONFactory.LOW_BIGINT) < 0 || value.compareTo(JSONFactory.HIGH_BIGINT) > 0)) {
            this.writeString(str);
            return;
        }
        int strlen = str.length();
        int minCapacity = this.off + strlen;
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        str.getBytes(0, strlen, this.bytes, this.off);
        this.off += strlen;
    }

    @Override
    public void writeDateTimeISO8601(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis, int offsetSeconds, boolean timeZone) {
        int millislen;
        int n = millislen = millis == 0 ? 0 : IOUtils.stringSize(millis) + 1;
        millislen = millis == 0 ? 0 : (millis < 10 ? 4 : (millis % 100 == 0 ? 2 : (millis % 10 == 0 ? 3 : 4)));
        int zonelen = timeZone ? (offsetSeconds == 0 ? 1 : 6) : 0;
        int offset = offsetSeconds / 3600;
        int len = 21 + millislen + zonelen;
        this.ensureCapacity(this.off + len);
        this.bytes[this.off] = 34;
        this.bytes[this.off + 1] = (byte)(year / 1000 + 48);
        this.bytes[this.off + 2] = (byte)(year / 100 % 10 + 48);
        this.bytes[this.off + 3] = (byte)(year / 10 % 10 + 48);
        this.bytes[this.off + 4] = (byte)(year % 10 + 48);
        this.bytes[this.off + 5] = 45;
        this.bytes[this.off + 6] = (byte)(month / 10 + 48);
        this.bytes[this.off + 7] = (byte)(month % 10 + 48);
        this.bytes[this.off + 8] = 45;
        this.bytes[this.off + 9] = (byte)(dayOfMonth / 10 + 48);
        this.bytes[this.off + 10] = (byte)(dayOfMonth % 10 + 48);
        this.bytes[this.off + 11] = timeZone ? 84 : 32;
        this.bytes[this.off + 12] = (byte)(hour / 10 + 48);
        this.bytes[this.off + 13] = (byte)(hour % 10 + 48);
        this.bytes[this.off + 14] = 58;
        this.bytes[this.off + 15] = (byte)(minute / 10 + 48);
        this.bytes[this.off + 16] = (byte)(minute % 10 + 48);
        this.bytes[this.off + 17] = 58;
        this.bytes[this.off + 18] = (byte)(second / 10 + 48);
        this.bytes[this.off + 19] = (byte)(second % 10 + 48);
        if (millislen > 0) {
            this.bytes[this.off + 20] = 46;
            Arrays.fill(this.bytes, this.off + 21, this.off + 20 + millislen, (byte)48);
            if (millis < 10) {
                IOUtils.getChars(millis, this.off + 20 + millislen, this.bytes);
            } else if (millis % 100 == 0) {
                IOUtils.getChars(millis / 100, this.off + 20 + millislen, this.bytes);
            } else if (millis % 10 == 0) {
                IOUtils.getChars(millis / 10, this.off + 20 + millislen, this.bytes);
            } else {
                IOUtils.getChars(millis, this.off + 20 + millislen, this.bytes);
            }
        }
        if (timeZone) {
            if (offsetSeconds == 0) {
                this.bytes[this.off + 20 + millislen] = 90;
            } else {
                int offsetAbs = Math.abs(offset);
                this.bytes[this.off + 20 + millislen] = offset >= 0 ? 43 : 45;
                this.bytes[this.off + 20 + millislen + 1] = 48;
                IOUtils.getChars(offsetAbs, this.off + 20 + millislen + 3, this.bytes);
                this.bytes[this.off + 20 + millislen + 3] = 58;
                this.bytes[this.off + 20 + millislen + 4] = 48;
                int offsetMinutes = (offsetSeconds - offset * 3600) / 60;
                if (offsetMinutes < 0) {
                    offsetMinutes = -offsetMinutes;
                }
                IOUtils.getChars(offsetMinutes, this.off + 20 + millislen + zonelen, this.bytes);
            }
        }
        this.bytes[this.off + len - 1] = 34;
        this.off += len;
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        String str = value.toString();
        if ((this.context.features & JSONWriter.Feature.BrowserCompatible.mask) != 0L && (value.compareTo(JSONFactory.LOW) < 0 || value.compareTo(JSONFactory.HIGH) > 0)) {
            int strlen = str.length();
            this.ensureCapacity(this.off + strlen + 2);
            this.bytes[this.off++] = 34;
            str.getBytes(0, strlen, this.bytes, this.off);
            this.off += strlen;
            this.bytes[this.off++] = 34;
        } else {
            int strlen = str.length();
            this.ensureCapacity(this.off + strlen);
            str.getBytes(0, strlen, this.bytes, this.off);
            this.off += strlen;
        }
    }

    @Override
    public void writeNameRaw(char[] chars) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void writeNameRaw(char[] bytes, int offset, int len) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final void write(JSONObject map) {
        if (map == null) {
            this.writeNull();
            return;
        }
        long NONE_DIRECT_FEATURES = JSONWriter.Feature.ReferenceDetection.mask | JSONWriter.Feature.PrettyFormat.mask | JSONWriter.Feature.NotWriteEmptyArray.mask | JSONWriter.Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(map.getClass());
            objectWriter.write(this, map, null, null, 0L);
            return;
        }
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 123;
        boolean first = true;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next;
            Object value;
            if (!first) {
                if (this.off == this.bytes.length) {
                    int oldCapacity = this.bytes.length;
                    int newCapacity = oldCapacity + (oldCapacity >> 1);
                    int minCapacity = this.off + 1;
                    if (newCapacity - minCapacity < 0) {
                        newCapacity = minCapacity;
                    }
                    if (newCapacity - this.maxArraySize > 0) {
                        throw new OutOfMemoryError();
                    }
                    this.bytes = Arrays.copyOf(this.bytes, newCapacity);
                }
                this.bytes[this.off++] = 44;
            }
            if ((value = (next = it.next()).getValue()) == null && (this.context.features & JSONWriter.Feature.WriteMapNullValue.mask) == 0L) continue;
            first = false;
            this.writeString((String)next.getKey());
            if (this.off == this.bytes.length) {
                int oldCapacity = this.bytes.length;
                int newCapacity = oldCapacity + (oldCapacity >> 1);
                int minCapacity = this.off + 1;
                if (newCapacity - minCapacity < 0) {
                    newCapacity = minCapacity;
                }
                if (newCapacity - this.maxArraySize > 0) {
                    throw new OutOfMemoryError();
                }
                this.bytes = Arrays.copyOf(this.bytes, newCapacity);
            }
            this.bytes[this.off++] = 58;
            if (value == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = value.getClass();
            if (valueClass == String.class) {
                this.writeString((String)value);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)value);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)value);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)value);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)value);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)value);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)value);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, value, null, null, 0L);
        }
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 125;
    }

    @Override
    public final void write(List array) {
        if (array == null) {
            this.writeArrayNull();
            return;
        }
        long NONE_DIRECT_FEATURES = JSONWriter.Feature.ReferenceDetection.mask | JSONWriter.Feature.PrettyFormat.mask | JSONWriter.Feature.NotWriteEmptyArray.mask | JSONWriter.Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(array.getClass());
            objectWriter.write(this, array, null, null, 0L);
            return;
        }
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 91;
        boolean first = true;
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            if (!first) {
                if (this.off == this.bytes.length) {
                    int oldCapacity = this.bytes.length;
                    int newCapacity = oldCapacity + (oldCapacity >> 1);
                    int minCapacity = this.off + 1;
                    if (newCapacity - minCapacity < 0) {
                        newCapacity = minCapacity;
                    }
                    if (newCapacity - this.maxArraySize > 0) {
                        throw new OutOfMemoryError();
                    }
                    this.bytes = Arrays.copyOf(this.bytes, newCapacity);
                }
                this.bytes[this.off++] = 44;
            }
            first = false;
            Object value = array.get(i);
            if (value == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = value.getClass();
            if (valueClass == String.class) {
                this.writeString((String)value);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)value);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)value);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)value);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)value);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)value);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)value);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, value, null, null, 0L);
        }
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 93;
    }

    public String toString() {
        return new String(this.bytes, 0, this.off, StandardCharsets.UTF_8);
    }

    static void formatUnsignedLong0(long val, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int radix = 16;
        int mask = radix - 1;
        do {
            buf[--charPos] = (byte)DIGITS[(int)val & mask];
            val >>>= 4;
        } while (charPos > offset);
    }

    @Override
    public int flushTo(OutputStream out, Charset charset) throws IOException {
        if (charset != null && charset != StandardCharsets.UTF_8) {
            throw new JSONException("UnsupportedOperation");
        }
        if (this.off == 0) {
            return 0;
        }
        int len = this.off;
        out.write(this.bytes, 0, this.off);
        this.off = 0;
        return len;
    }
}

