/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import com.alibaba.fastjson2.reader.FieldReaderReadOnly;
import com.alibaba.fastjson2.schema.JSONSchema;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;

final class FieldReaderAtomicBooleanFieldReadOnly<T>
extends FieldReaderImpl<T>
implements FieldReaderReadOnly<T> {
    final Field field;

    FieldReaderAtomicBooleanFieldReadOnly(String fieldName, Class fieldClass, int ordinal, String format, AtomicBoolean defaultValue, JSONSchema schema, Field field) {
        super(fieldName, fieldClass, fieldClass, ordinal, 0L, format, null, defaultValue, schema);
        this.field = field;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public void accept(T object, Object value) {
        if (value == null) {
            return;
        }
        try {
            AtomicBoolean atomic = (AtomicBoolean)this.field.get(object);
            atomic.set((Boolean)value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Boolean value = jsonReader.readBool();
        this.accept(object, value);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readBool();
    }

    @Override
    public String toString() {
        return this.field.getName();
    }
}

