/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import com.alibaba.fastjson2.reader.FieldReaderObject;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Locale;

class FieldReaderObjectMethod<T>
extends FieldReaderImpl<T>
implements FieldReaderObject<T, Object> {
    final Method method;
    ObjectReader fieldObjectReader;

    FieldReaderObjectMethod(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema, Method method) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, schema);
        this.method = method;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public void accept(T object, Object value) {
        if (value == null && (this.features & JSONReader.Feature.IgnoreSetNullValue.mask) != 0L) {
            return;
        }
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        try {
            this.method.invoke(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error, " + this.getClass().getName(), e);
        }
    }

    @Override
    public String toString() {
        if (this.method != null) {
            return this.method.getName();
        }
        return this.fieldName;
    }

    @Override
    public ObjectReader getFieldObjectReader(JSONReader.Context context) {
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = context.getObjectReader(this.fieldType);
        }
        return this.fieldObjectReader;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Object value;
        ObjectReader formattedObjectReader;
        ObjectReader objectReader = this.fieldObjectReader != null ? this.fieldObjectReader : ((formattedObjectReader = FieldReaderObject.createFormattedObjectReader(this.fieldType, this.fieldClass, this.format, this.locale)) != null ? (this.fieldObjectReader = formattedObjectReader) : (this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType)));
        if (jsonReader.isReference()) {
            String reference = jsonReader.readReference();
            if ("..".equals(reference)) {
                this.accept(object, object);
            } else {
                this.addResolveTask(jsonReader, object, reference);
            }
            return;
        }
        try {
            value = jsonReader.isJSONB() ? objectReader.readJSONBObject(jsonReader, this.features) : objectReader.readObject(jsonReader, this.features);
        }
        catch (JSONException ex) {
            throw new JSONException("read field error : " + this.fieldName, ex);
        }
        this.accept(object, value);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        return jsonReader.isJSONB() ? this.fieldObjectReader.readJSONBObject(jsonReader, this.features) : this.fieldObjectReader.readObject(jsonReader, this.features);
    }
}

